/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.relational;

import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.ValidationException;
import org.hibernate.metamodel.relational.Datatype;
import org.hibernate.metamodel.relational.SimpleValue;
import org.hibernate.metamodel.relational.TableSpecification;
import org.hibernate.metamodel.relational.Value;
import org.jboss.logging.Logger;

public abstract class AbstractSimpleValue
implements SimpleValue {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, AbstractSimpleValue.class.getName());
    private final TableSpecification table;
    private final int position;
    private Datatype datatype;

    protected AbstractSimpleValue(TableSpecification table, int position) {
        this.table = table;
        this.position = position;
    }

    @Override
    public TableSpecification getTable() {
        return this.table;
    }

    public int getPosition() {
        return this.position;
    }

    @Override
    public Datatype getDatatype() {
        return this.datatype;
    }

    @Override
    public void setDatatype(Datatype datatype) {
        LOG.debugf("setting datatype for column %s : %s", (Object)this.toLoggableString(), (Object)datatype);
        if (this.datatype != null && !this.datatype.equals(datatype)) {
            LOG.debugf("overriding previous datatype : %s", (Object)this.datatype);
        }
        this.datatype = datatype;
    }

    @Override
    public void validateJdbcTypes(Value.JdbcCodes typeCodes) {
        if (this.datatype.getTypeCode() != typeCodes.nextJdbcCde()) {
            throw new ValidationException("Mismatched types");
        }
    }
}

