/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.domain;

import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.internal.util.ValueHolder;

public class JavaType {
    private final String name;
    private final ValueHolder<Class<?>> classReference;

    public JavaType(final String name, final ClassLoaderService classLoaderService) {
        this.name = name;
        this.classReference = new ValueHolder<1>(new ValueHolder.DeferredInitializer<Class<?>>(){

            @Override
            public Class<?> initialize() {
                return classLoaderService.classForName(name);
            }
        });
    }

    public JavaType(Class<?> theClass) {
        this.name = theClass.getName();
        this.classReference = new ValueHolder(theClass);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getClassReference() {
        return this.classReference.getValue();
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

