/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.work.tasks;

import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlElement;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.tasks.RunDeviceScriptTask;
import org.hibernate.Hibernate;
import org.quartz.JobKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
public class RunDeviceGroupScriptTask
extends Task {
    private static Logger logger = LoggerFactory.getLogger(RunDeviceGroupScriptTask.class);
    private DeviceGroup deviceGroup;
    private String script;
    private String deviceDriver;

    public RunDeviceGroupScriptTask() {
    }

    public RunDeviceGroupScriptTask(DeviceGroup group, String script, DeviceDriver driver, String comments, String author) {
        super(comments, group.getName(), author);
        this.deviceGroup = group;
        this.script = script;
        this.deviceDriver = driver.getName();
    }

    @Override
    @XmlElement
    @Transient
    public String getTaskDescription() {
        return "Group script execution";
    }

    @Override
    public void prepare() {
        Hibernate.initialize(this.getDeviceGroup());
        Hibernate.initialize(this.getDeviceGroup().getCachedDevices());
    }

    @Override
    public void run() {
        logger.debug("Starting run script task for group {}.", (Object)this.getDeviceGroup().getId());
        Set<Device> devices = this.getDeviceGroup().getCachedDevices();
        logger.debug("{} devices in the group.", (Object)devices.size());
        String comment = String.format("Started due to group %s script task", this.getDeviceGroup().getName());
        DeviceDriver driver = DeviceDriver.getDriverByName(this.deviceDriver);
        if (driver == null) {
            logger.error("No such device driver {}.", (Object)this.deviceDriver);
            this.error("Unknown device driver.");
            this.status = Task.Status.FAILURE;
            return;
        }
        for (Device device : devices) {
            this.info(String.format("Starting run script task for device %s.", device.getName()));
            RunDeviceScriptTask task = new RunDeviceScriptTask(device, this.script, driver, comment, this.author);
            try {
                TaskManager.addTask(task);
            }
            catch (Exception e) {
                logger.error("Error while scheduling the individual snapshot task.", e);
                this.error("Error while scheduling the task.");
            }
        }
        logger.debug("Everything went fine.");
        this.status = Task.Status.SUCCESS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    public DeviceGroup getDeviceGroup() {
        return this.deviceGroup;
    }

    public void setDeviceGroup(DeviceGroup deviceGroup) {
        this.deviceGroup = deviceGroup;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RunDeviceGroupScriptTask task = (RunDeviceGroupScriptTask)super.clone();
        task.setDeviceGroup(this.deviceGroup);
        return task;
    }

    @Column(length=10000000)
    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getDeviceDriver() {
        return this.deviceDriver;
    }

    public void setDeviceDriver(String deviceDriver) {
        this.deviceDriver = deviceDriver;
    }

    @Override
    @Transient
    public JobKey getIdentity() {
        return new JobKey(String.format("Task_%d", this.getId()), String.format("RunDeviceGroupScript_%d", this.getDeviceGroup().getId()));
    }
}

