/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Priority;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import onl.netfishers.netshot.Database;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.TaskManager;
import onl.netfishers.netshot.aaa.Radius;
import onl.netfishers.netshot.aaa.User;
import onl.netfishers.netshot.compliance.CheckResult;
import onl.netfishers.netshot.compliance.Exemption;
import onl.netfishers.netshot.compliance.HardwareRule;
import onl.netfishers.netshot.compliance.Policy;
import onl.netfishers.netshot.compliance.Rule;
import onl.netfishers.netshot.compliance.SoftwareRule;
import onl.netfishers.netshot.compliance.rules.JavaScriptRule;
import onl.netfishers.netshot.compliance.rules.TextRule;
import onl.netfishers.netshot.device.Config;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.device.Domain;
import onl.netfishers.netshot.device.DynamicDeviceGroup;
import onl.netfishers.netshot.device.Finder;
import onl.netfishers.netshot.device.Module;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.NetworkInterface;
import onl.netfishers.netshot.device.StaticDeviceGroup;
import onl.netfishers.netshot.device.attribute.AttributeDefinition;
import onl.netfishers.netshot.device.attribute.ConfigAttribute;
import onl.netfishers.netshot.device.attribute.ConfigBinaryFileAttribute;
import onl.netfishers.netshot.device.attribute.ConfigLongTextAttribute;
import onl.netfishers.netshot.device.credentials.DeviceCliAccount;
import onl.netfishers.netshot.device.credentials.DeviceCredentialSet;
import onl.netfishers.netshot.device.credentials.DeviceSnmpCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv3Community;
import onl.netfishers.netshot.device.credentials.DeviceSshKeyAccount;
import onl.netfishers.netshot.diagnostic.Diagnostic;
import onl.netfishers.netshot.diagnostic.DiagnosticResult;
import onl.netfishers.netshot.diagnostic.JavaScriptDiagnostic;
import onl.netfishers.netshot.diagnostic.SimpleDiagnostic;
import onl.netfishers.netshot.work.DebugLog;
import onl.netfishers.netshot.work.Task;
import onl.netfishers.netshot.work.TaskLogger;
import onl.netfishers.netshot.work.tasks.CheckComplianceTask;
import onl.netfishers.netshot.work.tasks.CheckGroupComplianceTask;
import onl.netfishers.netshot.work.tasks.CheckGroupSoftwareTask;
import onl.netfishers.netshot.work.tasks.DeviceJsScript;
import onl.netfishers.netshot.work.tasks.DiscoverDeviceTypeTask;
import onl.netfishers.netshot.work.tasks.PurgeDatabaseTask;
import onl.netfishers.netshot.work.tasks.RunDeviceGroupScriptTask;
import onl.netfishers.netshot.work.tasks.RunDeviceScriptTask;
import onl.netfishers.netshot.work.tasks.RunDiagnosticsTask;
import onl.netfishers.netshot.work.tasks.RunGroupDiagnosticsTask;
import onl.netfishers.netshot.work.tasks.ScanSubnetsTask;
import onl.netfishers.netshot.work.tasks.TakeGroupSnapshotTask;
import onl.netfishers.netshot.work.tasks.TakeSnapshotTask;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.servlet.Registration;
import org.glassfish.grizzly.servlet.ServletRegistration;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.RolesAllowedDynamicFeature;
import org.glassfish.jersey.servlet.ServletContainer;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

@Path(value="/")
@DenyAll
public class RestService
extends Thread {
    private static final String DEVICELIST_BASEQUERY = "select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status ";
    private static Logger logger = LoggerFactory.getLogger(RestService.class);
    private static RestService nsRestService;
    private String httpStaticPath;
    private String httpApiPath;
    private String httpBaseUrl;
    private String httpSslKeystoreFile;
    private String httpSslKeystorePass;
    private int httpBasePort;

    public static void init() {
        nsRestService = new RestService();
        nsRestService.setUncaughtExceptionHandler(Netshot.exceptionHandler);
        nsRestService.start();
    }

    public RestService() {
        this.setName("REST Service");
        this.httpStaticPath = Netshot.getConfig("netshot.http.staticpath", "/");
        this.httpApiPath = Netshot.getConfig("netshot.http.apipath", "/api");
        this.httpBaseUrl = Netshot.getConfig("netshot.http.baseurl", "http://localhost:8443");
        this.httpSslKeystoreFile = Netshot.getConfig("netshot.http.ssl.keystore.file", "netshot.jks");
        this.httpSslKeystorePass = Netshot.getConfig("netshot.http.ssl.keystore.pass", "netshotpass");
        this.httpBasePort = 8443;
        try {
            this.httpBasePort = Integer.parseInt(Netshot.getConfig("netshot.http.baseport", Integer.toString(this.httpBasePort)));
        }
        catch (Exception e) {
            logger.warn("Unable to understand the HTTP base port configuration, using {}.", (Object)this.httpBasePort);
        }
    }

    @Override
    public void run() {
        logger.info("Starting the Web/REST service thread.");
        try {
            SSLContextConfigurator sslContext = new SSLContextConfigurator();
            sslContext.setKeyStoreFile(this.httpSslKeystoreFile);
            sslContext.setKeyStorePass(this.httpSslKeystorePass);
            sslContext.createSSLContext(true);
            SSLEngineConfigurator sslConfig = new SSLEngineConfigurator(sslContext).setClientMode(false).setNeedClientAuth(false).setWantClientAuth(false);
            URI url = UriBuilder.fromUri(this.httpBaseUrl).port(this.httpBasePort).build(new Object[0]);
            HttpServer server = GrizzlyHttpServerFactory.createHttpServer(url, (GrizzlyHttpContainer)null, true, sslConfig, false);
            WebappContext context = new WebappContext("GrizzlyContext", this.httpApiPath);
            ServletRegistration.Dynamic registration = context.addServlet("Jersey", ServletContainer.class);
            ((Registration)((Object)registration)).setInitParameter("javax.ws.rs.Application", NetshotWebApplication.class.getName());
            ((ServletRegistration)registration).addMapping(this.httpApiPath);
            context.deploy(server);
            CLStaticHttpHandler staticHandler = new CLStaticHttpHandler(Netshot.class.getClassLoader(), "/www/");
            server.getServerConfiguration().addHttpHandler((HttpHandler)staticHandler, this.httpStaticPath);
            server.start();
            RestService restService = this;
            synchronized (restService) {
                while (true) {
                    this.wait();
                }
            }
        }
        catch (Exception e) {
            logger.error(MarkerFactory.getMarker("FATAL"), "Fatal error with the REST service.", e);
            throw new RuntimeException("Error with the REST service, see logs for more details.");
        }
    }

    @GET
    @Path(value="domains")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsDomain> getDomains() throws WebApplicationException {
        logger.debug("REST request, domains.");
        try (Session session = Database.getSession();){
            List domains = session.createCriteria(Domain.class).list();
            ArrayList<RsDomain> rsDomains = new ArrayList<RsDomain>();
            for (Domain domain : domains) {
                rsDomains.add(new RsDomain(domain));
            }
            ArrayList<RsDomain> arrayList = rsDomains;
            return arrayList;
        }
    }

    @POST
    @Path(value="domains")
    @RolesAllowed(value={"admin"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public RsDomain addDomain(RsDomain newDomain) throws WebApplicationException {
        logger.debug("REST request, add a domain");
        String name = newDomain.getName().trim();
        if (name.isEmpty()) {
            logger.warn("User posted an empty domain name.");
            throw new NetshotBadRequestException("Invalid domain name.", 112);
        }
        String description = newDomain.getDescription().trim();
        try {
            Network4Address v4Address = new Network4Address(newDomain.getIpAddress());
            Network6Address v6Address = new Network6Address("::");
            if (!v4Address.isNormalUnicast()) {
                logger.warn("User posted an invalid IP address.");
                throw new NetshotBadRequestException("Invalid IP address", 100);
            }
            Domain domain = new Domain(name, description, v4Address, v6Address);
            try (Session session = Database.getSession();){
                session.beginTransaction();
                session.save(domain);
                session.getTransaction().commit();
            }
            return new RsDomain(domain);
        }
        catch (UnknownHostException e) {
            logger.warn("User posted an invalid IP address.");
            throw new NetshotBadRequestException("Malformed IP address", 101);
        }
    }

    @PUT
    @Path(value="domains/{id}")
    @RolesAllowed(value={"admin"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public RsDomain setDomain(@PathParam(value="id") Long id, RsDomain rsDomain) throws WebApplicationException {
        Domain domain;
        Network4Address v4Address;
        logger.debug("REST request, edit domain {}.", (Object)id);
        String name = rsDomain.getName().trim();
        if (name.isEmpty()) {
            logger.warn("User posted an invalid domain name.");
            throw new NetshotBadRequestException("Invalid domain name.", 112);
        }
        String description = rsDomain.getDescription().trim();
        try {
            v4Address = new Network4Address(rsDomain.getIpAddress());
            if (!v4Address.isNormalUnicast()) {
                logger.warn("User posted an invalid IP address");
                throw new NetshotBadRequestException("Invalid IP address", 100);
            }
        }
        catch (UnknownHostException e) {
            logger.warn("Invalid IP address.", e);
            throw new NetshotBadRequestException("Malformed IP address", 101);
        }
        try (Session session = Database.getSession();){
            session.beginTransaction();
            domain = (Domain)session.load(Domain.class, (Serializable)id);
            domain.setName(name);
            domain.setDescription(description);
            domain.setServer4Address(v4Address);
            session.update(domain);
            session.getTransaction().commit();
        }
        return new RsDomain(domain);
    }

    @DELETE
    @Path(value="domains/{id}")
    @RolesAllowed(value={"admin"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteDomain(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete domain {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            Domain domain = (Domain)session.load(Domain.class, (Serializable)id);
            session.delete(domain);
            session.getTransaction().commit();
        }
    }

    @GET
    @Path(value="devices/{id}/interfaces")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<NetworkInterface> getDeviceInterfaces(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get device {} interfaces.", (Object)id);
        try (Session session = Database.getSession();){
            List deviceInterfaces;
            List list = deviceInterfaces = session.createQuery("from NetworkInterface AS networkInterface left join fetch networkInterface.ip4Addresses left join fetch networkInterface.ip6Addresses where device = :device").setLong("device", (long)id).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).list();
            return list;
        }
    }

    @GET
    @Path(value="devices/{id}/modules")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<Module> getDeviceModules(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get device {} modules.", (Object)id);
        try (Session session = Database.getSession();){
            List deviceModules;
            List list = deviceModules = session.createQuery("from Module m where device = :device").setLong("device", (long)id).list();
            return list;
        }
    }

    @GET
    @Path(value="devices/{id}/tasks")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<Task> getDeviceTasks(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get device {} tasks.", (Object)id);
        try (Session session = Database.getSession();){
            int max = 20;
            Class[] taskTypes = new Class[]{CheckComplianceTask.class, DiscoverDeviceTypeTask.class, TakeSnapshotTask.class, RunDeviceScriptTask.class, RunDiagnosticsTask.class};
            Criterion[] restrictions = new Criterion[]{Restrictions.eq("t.device.id", id), Restrictions.eq("t.deviceId", id), Restrictions.eq("t.device.id", id), Restrictions.eq("t.device.id", id), Restrictions.eq("t.device.id", id)};
            ArrayList tasks = new ArrayList();
            for (int i = 0; i < taskTypes.length; ++i) {
                List typeTasks = session.createCriteria(taskTypes[i], "t").add(restrictions[i]).list();
                tasks.addAll(typeTasks);
            }
            Collections.sort(tasks, new Comparator<Task>(){

                private int getPriority(Task.Status status) {
                    switch (status) {
                        case RUNNING: {
                            return 1;
                        }
                        case WAITING: {
                            return 2;
                        }
                        case SCHEDULED: {
                            return 3;
                        }
                        case NEW: {
                            return 4;
                        }
                    }
                    return 10;
                }

                private Date getSignificantDate(Task t) {
                    if (t.getExecutionDate() == null) {
                        return t.getChangeDate();
                    }
                    return t.getExecutionDate();
                }

                @Override
                public int compare(Task o1, Task o2) {
                    int statusDiff = Integer.compare(this.getPriority(o1.getStatus()), this.getPriority(o2.getStatus()));
                    if (statusDiff == 0) {
                        Date d1 = this.getSignificantDate(o1);
                        Date d2 = this.getSignificantDate(o2);
                        if (d1 == null) {
                            if (d2 == null) {
                                return 0;
                            }
                            return -1;
                        }
                        if (d2 == null) {
                            return 1;
                        }
                        return d2.compareTo(d1);
                    }
                    return statusDiff;
                }
            });
            List<Task> list = tasks.subList(0, 20 > tasks.size() ? tasks.size() : 20);
            return list;
        }
    }

    @GET
    @Path(value="devices/{id}/configs")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<Config> getDeviceConfigs(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get device {} configs.", (Object)id);
        try (Session session = Database.getSession();){
            List deviceConfigs;
            session.enableFilter("lightAttributesOnly");
            List list = deviceConfigs = session.createQuery("from Config c left join fetch c.attributes ca where c.device = :device").setLong("device", (long)id).list();
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="configs/{id}/{item}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/octet-stream"})
    public Response getDeviceConfigPlain(@PathParam(value="id") Long id, @PathParam(value="item") String item) throws WebApplicationException {
        logger.debug("REST request, get device {} config {}.", (Object)id, (Object)item);
        try (Session session = Database.getSession();){
            Config config = (Config)session.get(Config.class, (Serializable)id);
            if (config == null) {
                logger.warn("Unable to find the config object.");
                throw new WebApplicationException("Unable to find the configuration set", Response.Status.NOT_FOUND);
            }
            Iterator<ConfigAttribute> iterator = config.getAttributes().iterator();
            while (iterator.hasNext()) {
                ConfigAttribute attribute = iterator.next();
                if (attribute.getName().equals(item)) {
                    if (attribute instanceof ConfigLongTextAttribute) {
                        Object formatter2;
                        String text = ((ConfigLongTextAttribute)attribute).getLongText().getText();
                        if (text == null) {
                            throw new WebApplicationException("Configuration item not available", Response.Status.BAD_REQUEST);
                        }
                        String fileName = "config.cfg";
                        try {
                            formatter2 = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
                            fileName = String.format("%s_%s_%s.cfg", config.getDevice().getName(), attribute.getName(), ((DateFormat)formatter2).format(config.getChangeDate()));
                        }
                        catch (Exception formatter2) {
                            // empty catch block
                        }
                        formatter2 = Response.ok(text).header("Content-Disposition", String.format("attachment; filename=\"%s\"", fileName)).build();
                        return formatter2;
                    }
                    if (attribute instanceof ConfigBinaryFileAttribute) {
                        ConfigBinaryFileAttribute fileAttribute = (ConfigBinaryFileAttribute)attribute;
                        File file = fileAttribute.getFileName();
                        String fileName = fileAttribute.getOriginalName();
                        if (fileName == null) {
                            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
                            fileName = String.format("%s_%s_%s.dat", config.getDevice().getName(), attribute.getName(), formatter.format(config.getChangeDate()));
                        }
                        Response response = Response.ok((Object)file, "application/octet-stream").header("Content-Disposition", String.format("attachment; filename=\"%s\"", fileName)).build();
                        return response;
                    }
                }
            }
            throw new WebApplicationException("Invalid configuration item", Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Path(value="configs/{id1}/vs/{id2}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json"})
    public RsConfigDiff getDeviceConfigDiff(@PathParam(value="id1") Long id1, @PathParam(value="id2") Long id2) {
        logger.debug("REST request, get device config diff, id {} and {}.", (Object)id1, (Object)id2);
        Session session = Database.getSession();
        Config config1 = null;
        Config config2 = null;
        try {
            DeviceDriver driver2;
            DeviceDriver driver1;
            config2 = (Config)session.get(Config.class, (Serializable)id2);
            if (config2 != null && id1 == 0L) {
                config1 = (Config)session.createQuery("from Config c where c.device = :device and c.changeDate < :date2 order by c.changeDate desc").setEntity("device", (Object)config2.getDevice()).setTimestamp("date2", config2.getChangeDate()).setMaxResults(1).uniqueResult();
                if (config1 == null) {
                    config1 = new Config(config2.getDevice());
                }
            } else {
                config1 = (Config)session.get(Config.class, (Serializable)id1);
            }
            if (config1 == null || config2 == null) {
                logger.error("Non existing config, {} or {}.", (Object)id1, (Object)id2);
                throw new NetshotBadRequestException("Unable to fetch the configs", 20);
            }
            try {
                driver1 = config1.getDevice().getDeviceDriver();
                driver2 = config2.getDevice().getDeviceDriver();
            }
            catch (Device.MissingDeviceDriverException e) {
                logger.error("Missing driver.");
                throw new NetshotBadRequestException("Missing driver", 20);
            }
            if (!driver1.equals(driver2)) {
                logger.error("Incompatible configurations, {} and {} (different drivers).", (Object)id1, (Object)id2);
                throw new NetshotBadRequestException("Incompatible configurations", 144);
            }
            RsConfigDiff configDiffs = new RsConfigDiff(config1.getChangeDate(), config2.getChangeDate());
            Map<String, ConfigAttribute> attributes1 = config1.getAttributeMap();
            Map<String, ConfigAttribute> attributes2 = config2.getAttributeMap();
            for (AttributeDefinition definition : driver1.getAttributes()) {
                if (!definition.isComparable()) continue;
                ConfigAttribute attribute1 = attributes1.get(definition.getName());
                ConfigAttribute attribute2 = attributes2.get(definition.getName());
                String text1 = attribute1 == null ? "" : attribute1.getAsText();
                String text2 = attribute2 == null ? "" : attribute2.getAsText();
                List<String> lines1 = Arrays.asList(text1.replace("\r", "").split("\n"));
                List<String> lines2 = Arrays.asList(text2.replace("\r", "").split("\n"));
                Patch<String> patch = DiffUtils.diff(lines1, lines2);
                for (Delta<String> delta : patch.getDeltas()) {
                    configDiffs.addDelta(definition.getTitle(), new RsConfigDelta(delta, lines1));
                }
            }
            RsConfigDiff rsConfigDiff = configDiffs;
            return rsConfigDiff;
        }
        catch (HibernateException e) {
            logger.error("Unable to fetch the configs", e);
            throw new NetshotBadRequestException("Unable to fetch the configs", 20);
        }
        finally {
            session.close();
        }
    }

    @GET
    @Path(value="devices/{id}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public Device getDevice(@PathParam(value="id") Long id) throws WebApplicationException {
        Device device;
        logger.debug("REST request, device {}.", (Object)id);
        try (Session session = Database.getSession();){
            device = (Device)session.createQuery("from Device d left join fetch d.credentialSets cs left join fetch d.ownerGroups g left join fetch d.complianceCheckResults left join fetch d.attributes where d.id = :id").setLong("id", (long)id).uniqueResult();
            if (device == null) {
                throw new NetshotBadRequestException("Can't find this device", 142);
            }
            device.setMgmtDomain(Database.unproxy(device.getMgmtDomain()));
            device.setEolModule(Database.unproxy(device.getEolModule()));
            device.setEosModule(Database.unproxy(device.getEosModule()));
            if (device.getSpecificCredentialSet() != null) {
                DeviceCredentialSet credentialSet = Database.unproxy(device.getSpecificCredentialSet());
                if (DeviceCliAccount.class.isInstance(credentialSet)) {
                    ((DeviceCliAccount)credentialSet).setPassword("=");
                    ((DeviceCliAccount)credentialSet).setSuperPassword("=");
                }
                device.setSpecificCredentialSet(credentialSet);
            }
        }
        return device;
    }

    @GET
    @Path(value="devices")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsLightDevice> getDevices() throws WebApplicationException {
        logger.debug("REST request, devices.");
        try (Session session = Database.getSession();){
            List devices;
            List list = devices = session.createQuery("select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status from Device d").setResultTransformer(Transformers.aliasToBean(RsLightDevice.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="devicetypes")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<DeviceDriver> getDeviceTypes() throws WebApplicationException {
        logger.debug("REST request, device types.");
        ArrayList<DeviceDriver> deviceTypes = new ArrayList<DeviceDriver>();
        deviceTypes.addAll(DeviceDriver.getAllDrivers());
        return deviceTypes;
    }

    @GET
    @Path(value="refresheddevicetypes")
    @RolesAllowed(value={"admin"})
    @Produces(value={"application/json", "application/xml"})
    public List<DeviceDriver> getDeviceTypesAndRefresh() throws WebApplicationException {
        logger.debug("REST request, refresh and get device types.");
        try {
            DeviceDriver.refreshDrivers();
        }
        catch (Exception e) {
            logger.error("Error in REST service while refreshing the device types.", e);
        }
        return this.getDeviceTypes();
    }

    @GET
    @Path(value="devicefamilies")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsDeviceFamily> getDeviceFamilies() throws WebApplicationException {
        logger.debug("REST request, device families.");
        try (Session session = Database.getSession();){
            List deviceFamilies;
            List list = deviceFamilies = session.createQuery("select distinct d.driver as driver, d.family as deviceFamily from Device d").setResultTransformer(Transformers.aliasToBean(RsDeviceFamily.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="partnumbers")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsPartNumber> getPartNumbers() throws WebApplicationException {
        logger.debug("REST request, dpart numbers.");
        try (Session session = Database.getSession();){
            List partNumbers;
            List list = partNumbers = session.createQuery("select distinct m.partNumber as partNumber from Module m").setResultTransformer(Transformers.aliasToBean(RsPartNumber.class)).list();
            return list;
        }
    }

    @POST
    @Path(value="devices")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Task addDevice(@Context HttpServletRequest request, RsNewDevice device) throws WebApplicationException {
        TakeSnapshotTask task;
        List knownCommunities;
        Domain domain;
        Network4Address deviceAddress;
        logger.debug("REST request, new device.");
        try {
            deviceAddress = new Network4Address(device.getIpAddress());
            if (!deviceAddress.isNormalUnicast()) {
                logger.warn("User posted an invalid IP address (not normal unicast).");
                throw new NetshotBadRequestException("Invalid IP address", 100);
            }
        }
        catch (UnknownHostException e) {
            logger.warn("User posted an invalid IP address.");
            throw new NetshotBadRequestException("Malformed IP address", 101);
        }
        Network4Address connectAddress = null;
        if (device.getConnectIpAddress() != null && !device.getConnectIpAddress().equals("")) {
            try {
                connectAddress = new Network4Address(device.getConnectIpAddress());
                if (!deviceAddress.isNormalUnicast()) {
                    logger.warn("User posted an invalid connect IP address (not normal unicast).");
                    throw new NetshotBadRequestException("Invalid connect IP address", 100);
                }
            }
            catch (UnknownHostException e) {
                logger.warn("User posted an invalid IP address.");
                throw new NetshotBadRequestException("Malformed connect IP address", 101);
            }
        }
        Integer sshPort = null;
        if (device.getSshPort() != null && !"".equals(device.getSshPort())) {
            try {
                int port = Integer.parseInt(device.getSshPort());
                if (port < 1 || port > 65535) {
                    throw new Exception();
                }
                sshPort = port;
            }
            catch (Exception e) {
                throw new NetshotBadRequestException("Invalid SSH port", 102);
            }
        }
        Integer telnetPort = null;
        if (device.getTelnetPort() != null && !"".equals(device.getTelnetPort())) {
            try {
                int port = Integer.parseInt(device.getTelnetPort());
                if (port < 1 || port > 65535) {
                    throw new Exception();
                }
                telnetPort = port;
            }
            catch (Exception e) {
                throw new NetshotBadRequestException("Invalid Telnet port", 102);
            }
        }
        try (Session session = Database.getSession();){
            logger.debug("Looking for an existing device with this IP address.");
            Device duplicate = (Device)session.createQuery("from Device d where d.mgmtAddress.address = :ip").setInteger("ip", deviceAddress.getIntAddress()).uniqueResult();
            if (duplicate != null) {
                logger.error("Device {} is already present with this IP address.", (Object)duplicate.getId());
                throw new NetshotBadRequestException(String.format("The device '%s' already exists with this IP address.", duplicate.getName()), 140);
            }
            domain = (Domain)session.load(Domain.class, (Serializable)Long.valueOf(device.getDomainId()));
            knownCommunities = session.createQuery("from DeviceSnmpCommunity c where (mgmtDomain = :domain or mgmtDomain is null) and (not (c.deviceSpecific = :true))").setEntity("domain", (Object)domain).setBoolean("true", true).list();
            if (knownCommunities.size() == 0 && device.isAutoDiscover()) {
                logger.error("No available SNMP community");
                throw new NetshotBadRequestException("There is no known SNMP community in the database to poll the device.", 133);
            }
        }
        User user = (User)request.getSession().getAttribute("user");
        if (device.isAutoDiscover()) {
            try {
                DiscoverDeviceTypeTask task2 = new DiscoverDeviceTypeTask(deviceAddress, domain, String.format("Device added by %s", user.getUsername()), user.getUsername());
                task2.setComments(String.format("Autodiscover device %s", deviceAddress.getIp()));
                for (DeviceCredentialSet credentialSet : knownCommunities) {
                    task2.addCredentialSet(credentialSet);
                }
                TaskManager.addTask(task2);
                return task2;
            }
            catch (SchedulerException e) {
                logger.error("Unable to schedule the discovery task.", e);
                throw new NetshotBadRequestException("Unable to schedule the task", 30);
            }
            catch (HibernateException e) {
                logger.error("Error while adding the discovery task.", e);
                throw new NetshotBadRequestException("Database error", 20);
            }
        }
        DeviceDriver driver = DeviceDriver.getDriverByName(device.getDeviceType());
        if (driver == null) {
            logger.warn("Invalid posted device driver.");
            throw new NetshotBadRequestException("Invalid device type.", 150);
        }
        session = Database.getSession();
        Device newDevice = null;
        try {
            session.beginTransaction();
            newDevice = new Device(driver.getName(), deviceAddress, domain, user.getUsername());
            if (connectAddress != null) {
                newDevice.setConnectAddress(connectAddress);
            }
            if (sshPort != null) {
                newDevice.setSshPort(sshPort);
            }
            if (telnetPort != null) {
                newDevice.setTelnetPort(telnetPort);
            }
            if (device.getSpecificCredentialSet() != null && device.getSpecificCredentialSet() instanceof DeviceCliAccount) {
                device.getSpecificCredentialSet().setName(DeviceCredentialSet.generateSpecificName());
                device.getSpecificCredentialSet().setDeviceSpecific(true);
                session.save(device.getSpecificCredentialSet());
                newDevice.setSpecificCredentialSet(device.getSpecificCredentialSet());
                newDevice.setAutoTryCredentials(false);
            }
            session.save(newDevice);
            task = new TakeSnapshotTask(newDevice, "Initial snapshot after device creation", user.getUsername(), true, false, false);
            session.save(task);
            session.getTransaction().commit();
        }
        catch (Exception e) {
            session.getTransaction().rollback();
            logger.error("Error while creating the device", e);
            throw new NetshotBadRequestException("Database error", 20);
        }
        finally {
            session.close();
        }
        if (newDevice != null) {
            DynamicDeviceGroup.refreshAllGroups(newDevice);
        }
        try {
            TaskManager.addTask(task);
            return task;
        }
        catch (HibernateException e) {
            logger.error("Unable to add the task.", e);
            throw new NetshotBadRequestException("Unable to add the task to the database.", 20);
        }
        catch (SchedulerException e) {
            logger.error("Unable to schedule the task.", e);
            throw new NetshotBadRequestException("Unable to schedule the task.", 30);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="devices/{id}")
    @RolesAllowed(value={"readwrite"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteDevice(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete device {}.", (Object)id);
        try (Session session = Database.getSession();){
            ArrayList<File> toDeleteFiles = new ArrayList<File>();
            List attributes = session.createQuery("from ConfigBinaryFileAttribute cfa where cfa.config.device.id = :id").setLong("id", (long)id).list();
            for (ConfigBinaryFileAttribute attribute : attributes) {
                toDeleteFiles.add(attribute.getFileName());
            }
            session.beginTransaction();
            Device device = (Device)session.load(Device.class, (Serializable)id);
            for (DeviceGroup group : device.getOwnerGroups()) {
                group.deleteCachedDevice(device);
            }
            session.delete(device);
            session.getTransaction().commit();
            for (File toDeleteFile : toDeleteFiles) {
                try {
                    toDeleteFile.delete();
                }
                catch (Exception e) {
                    logger.error("Error while removing binary file {}", (Object)toDeleteFile, (Object)e);
                }
            }
        }
    }

    @PUT
    @Path(value="devices/{id}")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Device setDevice(@Context HttpServletRequest request, @PathParam(value="id") Long id, RsDevice rsDevice) throws WebApplicationException {
        Device device;
        logger.debug("REST request, edit device {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            device = (Device)session.load(Device.class, (Serializable)id);
            if (rsDevice.isEnabled() != null) {
                if (rsDevice.isEnabled().booleanValue()) {
                    device.setStatus(Device.Status.INPRODUCTION);
                } else {
                    device.setStatus(Device.Status.DISABLED);
                }
            }
            if (rsDevice.getIpAddress() != null) {
                Network4Address v4Address = new Network4Address(rsDevice.getIpAddress());
                if (!v4Address.isNormalUnicast()) {
                    session.getTransaction().rollback();
                    throw new NetshotBadRequestException("Invalid IP address", 100);
                }
                device.setMgmtAddress(v4Address);
            }
            if (rsDevice.getConnectIpAddress() != null) {
                if ("".equals(rsDevice.getConnectIpAddress())) {
                    device.setConnectAddress(null);
                } else {
                    Network4Address v4ConnectAddress = new Network4Address(rsDevice.getConnectIpAddress());
                    if (!v4ConnectAddress.isNormalUnicast() && !v4ConnectAddress.isLoopback()) {
                        session.getTransaction().rollback();
                        throw new NetshotBadRequestException("Invalid Connect IP address", 100);
                    }
                    device.setConnectAddress(v4ConnectAddress);
                }
            }
            if (rsDevice.getSshPort() != null) {
                if ("".equals(rsDevice.getSshPort())) {
                    device.setSshPort(0);
                } else {
                    try {
                        int port = Integer.parseInt(rsDevice.getSshPort());
                        if (port < 1 || port > 65535) {
                            throw new Exception();
                        }
                        device.setSshPort(port);
                    }
                    catch (Exception e) {
                        session.getTransaction().rollback();
                        throw new NetshotBadRequestException("Invalid SSH port", 102);
                    }
                }
            }
            if (rsDevice.getTelnetPort() != null) {
                if ("".equals(rsDevice.getTelnetPort())) {
                    device.setTelnetPort(0);
                } else {
                    try {
                        int port = Integer.parseInt(rsDevice.getTelnetPort());
                        if (port < 1 || port > 65535) {
                            throw new Exception();
                        }
                        device.setTelnetPort(port);
                    }
                    catch (Exception e) {
                        session.getTransaction().rollback();
                        throw new NetshotBadRequestException("Invalid Telnet port", 102);
                    }
                }
            }
            if (rsDevice.getComments() != null) {
                device.setComments(rsDevice.getComments());
            }
            if (rsDevice.getCredentialSetIds() != null) {
                if (rsDevice.getClearCredentialSetIds() == null) {
                    device.clearCredentialSets();
                } else {
                    Iterator<DeviceCredentialSet> csIterator = device.getCredentialSets().iterator();
                    while (csIterator.hasNext()) {
                        if (!rsDevice.getClearCredentialSetIds().contains(csIterator.next().getId())) continue;
                        csIterator.remove();
                    }
                }
                for (Long credentialSetId : rsDevice.getCredentialSetIds()) {
                    try {
                        DeviceCredentialSet credentialSet = (DeviceCredentialSet)session.load(DeviceCredentialSet.class, (Serializable)credentialSetId);
                        device.addCredentialSet(credentialSet);
                    }
                    catch (ObjectNotFoundException e) {
                        logger.error("Non existing credential set {}.", (Object)credentialSetId);
                    }
                }
            }
            if (rsDevice.isAutoTryCredentials() != null) {
                device.setAutoTryCredentials(rsDevice.isAutoTryCredentials());
            }
            DeviceCredentialSet rsCredentialSet = rsDevice.getSpecificCredentialSet();
            DeviceCredentialSet credentialSet = device.getSpecificCredentialSet();
            if (rsCredentialSet == null) {
                if (credentialSet != null) {
                    session.delete(credentialSet);
                    device.setSpecificCredentialSet(null);
                }
            } else if (DeviceCliAccount.class.isInstance(rsCredentialSet)) {
                if (credentialSet != null && !credentialSet.getClass().equals(rsCredentialSet.getClass())) {
                    session.delete(credentialSet);
                    credentialSet = null;
                }
                if (credentialSet == null) {
                    credentialSet = rsCredentialSet;
                    credentialSet.setDeviceSpecific(true);
                    credentialSet.setName(DeviceCredentialSet.generateSpecificName());
                    session.save(credentialSet);
                    device.setSpecificCredentialSet(credentialSet);
                } else {
                    DeviceCliAccount cliAccount = (DeviceCliAccount)credentialSet;
                    DeviceCliAccount rsCliAccount = (DeviceCliAccount)rsCredentialSet;
                    cliAccount.setUsername(rsCliAccount.getUsername());
                    if (!rsCliAccount.getPassword().equals("=")) {
                        cliAccount.setPassword(rsCliAccount.getPassword());
                    }
                    if (!rsCliAccount.getSuperPassword().equals("=")) {
                        cliAccount.setSuperPassword(rsCliAccount.getSuperPassword());
                    }
                    if (DeviceSshKeyAccount.class.isInstance(credentialSet)) {
                        ((DeviceSshKeyAccount)cliAccount).setPublicKey(((DeviceSshKeyAccount)rsCliAccount).getPublicKey());
                        ((DeviceSshKeyAccount)cliAccount).setPrivateKey(((DeviceSshKeyAccount)rsCliAccount).getPrivateKey());
                    }
                }
            }
            if (rsDevice.getMgmtDomain() != null) {
                Domain domain = (Domain)session.load(Domain.class, (Serializable)rsDevice.getMgmtDomain());
                device.setMgmtDomain(domain);
            }
            session.update(device);
            session.getTransaction().commit();
        }
        DynamicDeviceGroup.refreshAllGroups(device);
        return this.getDevice(id);
    }

    @GET
    @Path(value="tasks/{id}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public Task getTask(@PathParam(value="id") Long id) {
        logger.debug("REST request, get task {}", (Object)id);
        try (Session session = Database.getSession();){
            Task task;
            Task task2 = task = (Task)session.get(Task.class, (Serializable)id);
            return task2;
        }
    }

    @GET
    @Path(value="tasks/{id}/debuglog")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/octet-stream"})
    public Response getTaskDebugLog(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get task {} debug log.", (Object)id);
        try (Session session = Database.getSession();){
            Task task = (Task)session.get(Task.class, (Serializable)id);
            DebugLog log = task.getDebugLog();
            String text = log == null ? "" : log.getText();
            String fileName = String.format("debug_%d.log", id);
            Response response = Response.ok(text).header("Content-Disposition", "attachment; filename=" + fileName).build();
            return response;
        }
    }

    @GET
    @Path(value="tasks")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<Task> getTasks() {
        logger.debug("REST request, get tasks.");
        try (Session session = Database.getSession();){
            List tasks;
            List list = tasks = session.createQuery("from Task t order by t.id desc").list();
            return list;
        }
    }

    @GET
    @Path(value="credentialsets")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<DeviceCredentialSet> getCredentialSets() throws WebApplicationException {
        List credentialSets;
        logger.debug("REST request, get credentials.");
        try (Session session = Database.getSession();){
            credentialSets = session.createQuery("select cs from DeviceCredentialSet cs where not (cs.deviceSpecific = :true)").setBoolean("true", true).list();
        }
        for (DeviceCredentialSet credentialSet : credentialSets) {
            if (!DeviceCliAccount.class.isInstance(credentialSet)) continue;
            ((DeviceCliAccount)credentialSet).setPassword("=");
            ((DeviceCliAccount)credentialSet).setSuperPassword("=");
        }
        return credentialSets;
    }

    @DELETE
    @Path(value="credentialsets/{id}")
    @RolesAllowed(value={"admin"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteCredentialSet(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete credentials {}", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            DeviceCredentialSet credentialSet = (DeviceCredentialSet)session.load(DeviceCredentialSet.class, (Serializable)id);
            if (credentialSet.isDeviceSpecific()) {
                throw new NetshotBadRequestException("Can't delete a device-specific credential set.", 130);
            }
            session.delete(credentialSet);
            session.getTransaction().commit();
        }
    }

    @POST
    @Path(value="credentialsets")
    @RolesAllowed(value={"admin"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public void addCredentialSet(DeviceCredentialSet credentialSet) throws WebApplicationException {
        logger.debug("REST request, add credentials.");
        if (credentialSet.getName() == null || credentialSet.getName().trim().equals("")) {
            logger.error("Invalid credential set name.");
            throw new NetshotBadRequestException("Invalid name for the credential set", 134);
        }
        try (Session session = Database.getSession();){
            session.beginTransaction();
            if (credentialSet.getMgmtDomain() != null) {
                credentialSet.setMgmtDomain((Domain)session.load(Domain.class, (Serializable)Long.valueOf(credentialSet.getMgmtDomain().getId())));
            }
            credentialSet.setDeviceSpecific(false);
            session.save(credentialSet);
            session.getTransaction().commit();
        }
    }

    @PUT
    @Path(value="credentialsets/{id}")
    @RolesAllowed(value={"admin"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public DeviceCredentialSet setCredentialSet(@PathParam(value="id") Long id, DeviceCredentialSet rsCredentialSet) throws WebApplicationException {
        DeviceCredentialSet credentialSet;
        logger.debug("REST request, edit credentials {}", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            credentialSet = (DeviceCredentialSet)session.get(rsCredentialSet.getClass(), (Serializable)id);
            if (credentialSet == null) {
                logger.error("Unable to find the credential set {}.", (Object)id);
                throw new NetshotBadRequestException("Unable to find the credential set.", 133);
            }
            if (!credentialSet.getClass().equals(rsCredentialSet.getClass())) {
                logger.error("Wrong posted credential type for credential set {}.", (Object)id);
                throw new NetshotBadRequestException("The posted credential type doesn't match the existing one.", 132);
            }
            if (rsCredentialSet.getMgmtDomain() == null) {
                credentialSet.setMgmtDomain(null);
            } else {
                credentialSet.setMgmtDomain((Domain)session.load(Domain.class, (Serializable)Long.valueOf(rsCredentialSet.getMgmtDomain().getId())));
            }
            credentialSet.setName(rsCredentialSet.getName());
            if (DeviceCliAccount.class.isInstance(credentialSet)) {
                DeviceCliAccount cliAccount = (DeviceCliAccount)credentialSet;
                DeviceCliAccount rsCliAccount = (DeviceCliAccount)rsCredentialSet;
                cliAccount.setUsername(rsCliAccount.getUsername());
                if (!rsCliAccount.getPassword().equals("=")) {
                    cliAccount.setPassword(rsCliAccount.getPassword());
                }
                if (!rsCliAccount.getSuperPassword().equals("=")) {
                    cliAccount.setSuperPassword(rsCliAccount.getSuperPassword());
                }
                if (DeviceSshKeyAccount.class.isInstance(credentialSet)) {
                    ((DeviceSshKeyAccount)cliAccount).setPublicKey(((DeviceSshKeyAccount)rsCliAccount).getPublicKey());
                    ((DeviceSshKeyAccount)cliAccount).setPrivateKey(((DeviceSshKeyAccount)rsCliAccount).getPrivateKey());
                }
            } else if (DeviceSnmpv3Community.class.isInstance(credentialSet)) {
                ((DeviceSnmpv3Community)credentialSet).setUsername(((DeviceSnmpv3Community)rsCredentialSet).getUsername());
                ((DeviceSnmpv3Community)credentialSet).setAuthType(((DeviceSnmpv3Community)rsCredentialSet).getAuthType());
                ((DeviceSnmpv3Community)credentialSet).setAuthKey(((DeviceSnmpv3Community)rsCredentialSet).getAuthKey());
                ((DeviceSnmpv3Community)credentialSet).setPrivType(((DeviceSnmpv3Community)rsCredentialSet).getPrivType());
                ((DeviceSnmpv3Community)credentialSet).setPrivKey(((DeviceSnmpv3Community)rsCredentialSet).getPrivKey());
            } else if (DeviceSnmpCommunity.class.isInstance(credentialSet)) {
                ((DeviceSnmpCommunity)credentialSet).setCommunity(((DeviceSnmpCommunity)rsCredentialSet).getCommunity());
            }
            session.update(credentialSet);
            session.getTransaction().commit();
        }
        return credentialSet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="devices/search")
    @RolesAllowed(value={"readonly"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public RsSearchResults searchDevices(RsSearchCriteria criteria) throws WebApplicationException {
        logger.debug("REST request, search devices, query '{}', driver '{}'.", (Object)criteria.getQuery(), (Object)criteria.getDriver());
        DeviceDriver driver = DeviceDriver.getDriverByName(criteria.getDriver());
        try {
            Finder finder = new Finder(criteria.getQuery(), driver);
            try (Session session = Database.getSession();){
                Query query = session.createQuery(DEVICELIST_BASEQUERY + finder.getHql());
                finder.setVariables(query);
                List devices = query.setResultTransformer(Transformers.aliasToBean(RsLightDevice.class)).list();
                RsSearchResults results = new RsSearchResults();
                results.setDevices(devices);
                results.setQuery(finder.getFormattedQuery());
                RsSearchResults rsSearchResults = results;
                return rsSearchResults;
            }
        }
        catch (Finder.Expression.FinderParseException e) {
            logger.warn("User's query is invalid.", e);
            throw new NetshotBadRequestException("Invalid search string. " + e.getMessage(), 151);
        }
    }

    @POST
    @Path(value="groups")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public DeviceGroup addGroup(DeviceGroup deviceGroup) throws WebApplicationException {
        logger.debug("REST request, add group.");
        String name = deviceGroup.getName().trim();
        if (name.isEmpty()) {
            logger.warn("User posted an empty group name.");
            throw new NetshotBadRequestException("Invalid group name.", 160);
        }
        deviceGroup.setName(name);
        deviceGroup.setId(0L);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            session.save(deviceGroup);
            session.getTransaction().commit();
        }
        return deviceGroup;
    }

    @GET
    @Path(value="groups")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<DeviceGroup> getGroups() throws WebApplicationException {
        logger.debug("REST request, get groups.");
        try (Session session = Database.getSession();){
            List deviceGroups;
            List list = deviceGroups = session.createCriteria(DeviceGroup.class).list();
            return list;
        }
    }

    @DELETE
    @Path(value="groups/{id}")
    @RolesAllowed(value={"readwrite"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteGroup(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete group {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            DeviceGroup deviceGroup = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)id);
            for (Policy policy : deviceGroup.getAppliedPolicies()) {
                policy.setTargetGroup(null);
                session.save(policy);
            }
            session.delete(deviceGroup);
            session.getTransaction().commit();
        }
    }

    @PUT
    @Path(value="groups/{id}")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public DeviceGroup setGroup(@PathParam(value="id") Long id, RsDeviceGroup rsGroup) throws WebApplicationException {
        logger.debug("REST request, edit group {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            DeviceGroup group = (DeviceGroup)session.get(DeviceGroup.class, (Serializable)id);
            if (group == null) {
                logger.error("Unable to find the group {} to be edited.", (Object)id);
                throw new NetshotBadRequestException("Unable to find this group.", 164);
            }
            if (group instanceof StaticDeviceGroup) {
                StaticDeviceGroup staticGroup = (StaticDeviceGroup)group;
                HashSet<Device> devices = new HashSet<Device>();
                for (Long deviceId : rsGroup.getStaticDevices()) {
                    Device device = (Device)session.load(Device.class, (Serializable)deviceId);
                    devices.add(device);
                }
                staticGroup.updateCachedDevices(devices);
            } else if (group instanceof DynamicDeviceGroup) {
                DynamicDeviceGroup dynamicGroup = (DynamicDeviceGroup)group;
                dynamicGroup.setDriver(rsGroup.getDriver());
                dynamicGroup.setQuery(rsGroup.getQuery());
                try {
                    dynamicGroup.refreshCache(session);
                }
                catch (Finder.Expression.FinderParseException e) {
                    throw new NetshotBadRequestException("Invalid query for the group definition.", 165);
                }
            } else {
                throw new NetshotBadRequestException("Unknown group type.", 162);
            }
            group.setFolder(rsGroup.getFolder());
            group.setHiddenFromReports(rsGroup.isHiddenFromReports());
            session.update(group);
            session.getTransaction().commit();
            DeviceGroup deviceGroup = group;
            return deviceGroup;
        }
    }

    @GET
    @Path(value="devices/group/{id}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsLightDevice> getGroupDevices(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get devices from group {}.", (Object)id);
        try (Session session = Database.getSession();){
            List devices;
            DeviceGroup group = (DeviceGroup)session.get(DeviceGroup.class, (Serializable)id);
            if (group == null) {
                logger.error("Unable to find the group {}.", (Object)id);
                throw new NetshotBadRequestException("Can't find this group", 164);
            }
            Query query = session.createQuery("select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status from Device d join d.ownerGroups g where g.id = :id").setLong("id", (long)id);
            List list = devices = query.setResultTransformer(Transformers.aliasToBean(RsLightDevice.class)).list();
            return list;
        }
    }

    @PUT
    @Path(value="tasks/{id}")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Task setTask(@PathParam(value="id") Long id, RsTask rsTask) throws WebApplicationException {
        logger.debug("REST request, edit task {}.", (Object)id);
        Task task = null;
        try (Session session = Database.getSession();){
            task = (Task)session.get(Task.class, (Serializable)id);
        }
        if (task == null) {
            logger.error("Unable to find the task {}.", (Object)id);
            throw new NetshotBadRequestException("Unable to find the task.", 120);
        }
        if (rsTask.isCancelled()) {
            if (task.getStatus() != Task.Status.SCHEDULED) {
                logger.error("User is trying to cancel task {} not in SCHEDULE state.", (Object)id);
                throw new NetshotBadRequestException("The task isn't in 'SCHEDULED' state.", 121);
            }
            try {
                TaskManager.cancelTask(task, "Task manually cancelled by user.");
            }
            catch (Exception e) {
                logger.error("Unable to cancel the task {}.", (Object)id, (Object)e);
                throw new NetshotBadRequestException("Cannot cancel the task.", 122);
            }
        }
        return task;
    }

    @POST
    @Path(value="tasks/search")
    @RolesAllowed(value={"readonly"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public List<Task> searchTasks(RsTaskCriteria criteria) throws WebApplicationException {
        logger.debug("REST request, search for tasks.");
        try (Session session = Database.getSession();){
            List tasks;
            Criteria c = session.createCriteria(Task.class);
            Task.Status status = null;
            try {
                if (!"ANY".equals(criteria.getStatus())) {
                    status = Task.Status.valueOf(criteria.getStatus());
                    c.add(Property.forName("status").eq((Object)status));
                }
            }
            catch (Exception e) {
                logger.warn("Invalid status {}.", (Object)criteria.getStatus());
            }
            Calendar min = Calendar.getInstance();
            min.setTime(criteria.getDay());
            min.set(11, 0);
            min.set(12, 0);
            min.set(13, 0);
            min.set(14, 0);
            Calendar max = (Calendar)min.clone();
            max.add(5, 1);
            if (status == Task.Status.SUCCESS || status == Task.Status.FAILURE) {
                c.add(Property.forName("executionDate").between(min.getTime(), max.getTime()));
            } else if (status == Task.Status.CANCELLED) {
                c.add(Property.forName("changeDate").between(min.getTime(), max.getTime()));
            } else if (status == null) {
                c.add(Restrictions.or(Property.forName("status").eq((Object)Task.Status.RUNNING), Property.forName("status").eq((Object)Task.Status.SCHEDULED), Property.forName("executionDate").between(min.getTime(), max.getTime()), Restrictions.and(Property.forName("executionDate").isNull(), Property.forName("changeDate").between(min.getTime(), max.getTime()))));
            }
            c.addOrder(Property.forName("id").desc());
            List list = tasks = c.list();
            return list;
        }
    }

    @POST
    @Path(value="tasks")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Task addTask(@Context HttpServletRequest request, @Context SecurityContext securityContext, RsTask rsTask) throws WebApplicationException {
        Task task;
        logger.debug("REST request, add task.");
        User user = (User)request.getSession().getAttribute("user");
        String userName = "";
        try {
            userName = user.getUsername();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rsTask.getType().equals("TakeSnapshotTask")) {
            Device device;
            logger.trace("Adding a TakeSnapshotTask");
            try (Session session = Database.getSession();){
                device = (Device)session.get(Device.class, (Serializable)rsTask.getDevice());
                if (device == null) {
                    logger.error("Unable to find the device {}.", (Object)rsTask.getDevice());
                    throw new NetshotBadRequestException("Unable to find the device.", 142);
                }
            }
            task = new TakeSnapshotTask(device, rsTask.getComments(), userName, false, rsTask.isDontRunDiagnostics(), rsTask.isDontCheckCompliance());
        } else if (rsTask.getType().equals("RunDeviceScriptTask")) {
            Device device;
            if (!securityContext.isUserInRole("executereadwrite")) {
                throw new NetshotNotAuthorizedException("Insufficient permissions to run scripts on devices.", 0);
            }
            logger.trace("Adding a RunDeviceScriptTask");
            DeviceDriver driver = DeviceDriver.getDriverByName(rsTask.getDriver());
            if (driver == null) {
                logger.error("Unknown device driver {}.", (Object)rsTask.getType());
                throw new NetshotBadRequestException("Unknown device driver.", 142);
            }
            if (rsTask.getScript() == null) {
                logger.error("The script can't be empty.");
                throw new NetshotBadRequestException("The script can't be empty.", 142);
            }
            try (Session session = Database.getSession();){
                device = (Device)session.get(Device.class, (Serializable)rsTask.getDevice());
                if (device == null) {
                    logger.error("Unable to find the device {}.", (Object)rsTask.getDevice());
                    throw new NetshotBadRequestException("Unable to find the device.", 142);
                }
            }
            task = new RunDeviceScriptTask(device, rsTask.getScript(), driver, rsTask.getComments(), userName);
        } else {
            if (rsTask.getType().equals("RunDeviceGroupScriptTask")) {
                logger.trace("Adding a RunDeviceGroupScriptTask");
                DeviceDriver driver = DeviceDriver.getDriverByName(rsTask.getDriver());
                if (driver == null) {
                    logger.error("Unknown device driver {}.", (Object)rsTask.getType());
                    throw new NetshotBadRequestException("Unknown device driver.", 142);
                }
                if (rsTask.getScript() == null) {
                    logger.error("The script can't be empty.");
                    throw new NetshotBadRequestException("The script can't be empty.", 142);
                }
                try (Session session = Database.getSession();){
                    DeviceGroup group = (DeviceGroup)session.get(DeviceGroup.class, (Serializable)rsTask.getGroup());
                    if (group == null) {
                        logger.error("Unable to find the group {}.", (Object)rsTask.getGroup());
                        throw new NetshotBadRequestException("Unable to find the group.", 164);
                    }
                    task = new RunDeviceGroupScriptTask(group, rsTask.getScript(), driver, rsTask.getComments(), userName);
                }
            }
            if (rsTask.getType().equals("CheckComplianceTask")) {
                Device device;
                logger.trace("Adding a CheckComplianceTask");
                try (Session session = Database.getSession();){
                    device = (Device)session.get(Device.class, (Serializable)rsTask.getDevice());
                    if (device == null) {
                        logger.error("Unable to find the device {}.", (Object)rsTask.getDevice());
                        throw new NetshotBadRequestException("Unable to find the device.", 142);
                    }
                }
                task = new CheckComplianceTask(device, rsTask.getComments(), userName);
            } else {
                if (rsTask.getType().equals("TakeGroupSnapshotTask")) {
                    logger.trace("Adding a TakeGroupSnapshotTask");
                    try (Session session = Database.getSession();){
                        DeviceGroup group = (DeviceGroup)session.get(DeviceGroup.class, (Serializable)rsTask.getGroup());
                        if (group == null) {
                            logger.error("Unable to find the group {}.", (Object)rsTask.getGroup());
                            throw new NetshotBadRequestException("Unable to find the group.", 164);
                        }
                        task = new TakeGroupSnapshotTask(group, rsTask.getComments(), userName, rsTask.getLimitToOutofdateDeviceHours(), rsTask.isDontRunDiagnostics(), rsTask.isDontCheckCompliance());
                    }
                }
                if (rsTask.getType().equals("CheckGroupComplianceTask")) {
                    logger.trace("Adding a CheckGroupComplianceTask");
                    try (Session session = Database.getSession();){
                        DeviceGroup group = (DeviceGroup)session.get(DeviceGroup.class, (Serializable)rsTask.getGroup());
                        if (group == null) {
                            logger.error("Unable to find the group {}.", (Object)rsTask.getGroup());
                            throw new NetshotBadRequestException("Unable to find the group.", 164);
                        }
                        task = new CheckGroupComplianceTask(group, rsTask.getComments(), userName);
                    }
                }
                if (rsTask.getType().equals("CheckGroupSoftwareTask")) {
                    logger.trace("Adding a CheckGroupSoftwareTask");
                    try (Session session = Database.getSession();){
                        DeviceGroup group = (DeviceGroup)session.get(DeviceGroup.class, (Serializable)rsTask.getGroup());
                        if (group == null) {
                            logger.error("Unable to find the group {}.", (Object)rsTask.getGroup());
                            throw new NetshotBadRequestException("Unable to find the group.", 164);
                        }
                        task = new CheckGroupSoftwareTask(group, rsTask.getComments(), userName);
                    }
                }
                if (rsTask.getType().equals("RunGroupDiagnosticsTask")) {
                    logger.trace("Adding a RunGroupDiagnosticsTask");
                    try (Session session = Database.getSession();){
                        DeviceGroup group = (DeviceGroup)session.get(DeviceGroup.class, (Serializable)rsTask.getGroup());
                        if (group == null) {
                            logger.error("Unable to find the group {}.", (Object)rsTask.getGroup());
                            throw new NetshotBadRequestException("Unable to find the group.", 164);
                        }
                        task = new RunGroupDiagnosticsTask(group, rsTask.getComments(), userName, rsTask.isDontCheckCompliance());
                    }
                }
                if (rsTask.getType().equals("ScanSubnetsTask")) {
                    Domain domain;
                    logger.trace("Adding a ScanSubnetsTask");
                    HashSet<Network4Address> subnets = new HashSet<Network4Address>();
                    String[] rsSubnets = rsTask.getSubnets().split("(\r\n|\n|;| |,)");
                    Pattern pattern = Pattern.compile("^(?<ip>[0-9\\.]+)(/(?<mask>[0-9]+))?$");
                    for (String rsSubnet : rsSubnets) {
                        Network4Address subnet;
                        Matcher matcher = pattern.matcher(rsSubnet);
                        if (!matcher.find()) {
                            logger.warn("User posted an invalid subnet '{}'.", (Object)rsSubnet);
                            throw new NetshotBadRequestException(String.format("Invalid subnet '%s'.", rsSubnet), 170);
                        }
                        try {
                            int mask = 32;
                            if (matcher.group("mask") != null) {
                                mask = Integer.parseInt(matcher.group("mask"));
                            }
                            subnet = new Network4Address(matcher.group("ip"), mask);
                            subnets.add(subnet);
                        }
                        catch (Exception e) {
                            logger.warn("User posted an invalid subnet '{}'.", (Object)rsSubnet, (Object)e);
                            throw new NetshotBadRequestException(String.format("Invalid subnet '%s'.", rsSubnet), 170);
                        }
                        if (subnet.getPrefixLength() >= 22 && subnet.getPrefixLength() <= 32) continue;
                        logger.warn("User posted an invalid prefix length {}.", (Object)subnet.getPrefix());
                        throw new NetshotBadRequestException(String.format("Invalid prefix length for '%s'.", rsSubnet), 171);
                    }
                    if (subnets.size() == 0) {
                        logger.warn("User posted an invalid subnet list '{}'.", (Object)rsTask.getSubnets());
                        throw new NetshotBadRequestException(String.format("Invalid subnet list '%s'.", rsTask.getSubnets()), 170);
                    }
                    if (rsTask.getDomain() == 0L) {
                        logger.error("Domain {} is invalid (0).", (Object)rsTask.getDomain());
                        throw new NetshotBadRequestException("Invalid domain", 110);
                    }
                    try (Session session = Database.getSession();){
                        domain = (Domain)session.load(Domain.class, (Serializable)rsTask.getDomain());
                    }
                    StringBuffer target = new StringBuffer();
                    target.append("{");
                    for (Network4Address subnet : subnets) {
                        if (target.length() > 1) {
                            target.append(", ");
                        }
                        target.append(subnet.getPrefix());
                    }
                    target.append("}");
                    task = new ScanSubnetsTask(subnets, domain, rsTask.getComments(), target.toString(), userName);
                } else if (rsTask.getType().equals("PurgeDatabaseTask")) {
                    logger.trace("Adding a PurgeDatabaseTask");
                    if (rsTask.getDaysToPurge() < 2) {
                        logger.error(String.format("Invalid number of days %d for the PurgeDatabaseTask task.", rsTask.getDaysToPurge()));
                        throw new NetshotBadRequestException("Invalid number of days.", 120);
                    }
                    int configDays = rsTask.getConfigDaysToPurge();
                    int configSize = rsTask.getConfigSizeToPurge();
                    int configKeepDays = rsTask.getConfigKeepDays();
                    if (configDays == -1) {
                        configSize = 0;
                        configKeepDays = 0;
                    } else {
                        if (configDays <= 3) {
                            logger.error("The number of days of configurations to purge must be greater than 3.");
                            throw new NetshotBadRequestException("The number of days of configurations to purge must be greater than 3.", 120);
                        }
                        if (configSize < 0) {
                            logger.error("The configuration size limit can't be negative.");
                            throw new NetshotBadRequestException("The limit on the configuration size can't be negative.", 120);
                        }
                        if (configKeepDays < 0) {
                            logger.error("The interval of days between configurations to keep can't be negative.");
                            throw new NetshotBadRequestException("The number of days of configurations to purge can't be negative.", 120);
                        }
                        if (configDays <= configKeepDays) {
                            logger.error("The number of days of configurations to purge must be greater than the number of days between two successive configurations to keep.");
                            throw new NetshotBadRequestException("The number of days of configurations to purge must be greater than the number of days between two successive configurations to keep.", 120);
                        }
                    }
                    task = new PurgeDatabaseTask(rsTask.getComments(), userName, rsTask.getDaysToPurge(), configDays, configSize, configKeepDays);
                } else if (rsTask.getType().equals("RunDiagnosticsTask")) {
                    Device device;
                    logger.trace("Adding a RunDiagnosticsTask");
                    try (Session session = Database.getSession();){
                        device = (Device)session.get(Device.class, (Serializable)rsTask.getDevice());
                        if (device == null) {
                            logger.error("Unable to find the device {}.", (Object)rsTask.getDevice());
                            throw new NetshotBadRequestException("Unable to find the device.", 142);
                        }
                    }
                    task = new RunDiagnosticsTask(device, rsTask.getComments(), userName, rsTask.isDontCheckCompliance());
                } else {
                    logger.error("User posted an invalid task type '{}'.", (Object)rsTask.getType());
                    throw new NetshotBadRequestException("Invalid task type.", 120);
                }
            }
        }
        if (rsTask.getScheduleReference() != null) {
            task.setDebugEnabled(rsTask.isDebugEnabled());
            task.setScheduleReference(rsTask.getScheduleReference());
            task.setScheduleType(rsTask.getScheduleType());
            if (task.getScheduleType() == Task.ScheduleType.AT) {
                Calendar inOneMinute = Calendar.getInstance();
                inOneMinute.add(12, 1);
                if (task.getScheduleReference().before(inOneMinute.getTime())) {
                    logger.error("The schedule for the task occurs in less than one minute ({} vs {}).", (Object)task.getScheduleReference(), (Object)inOneMinute.getTime());
                    throw new NetshotBadRequestException("The schedule occurs in the past.", 120);
                }
            }
        }
        try {
            TaskManager.addTask(task);
        }
        catch (HibernateException e) {
            logger.error("Unable to add the task.", e);
            throw new NetshotBadRequestException("Unable to add the task to the database.", 20);
        }
        catch (SchedulerException e) {
            logger.error("Unable to schedule the task.", e);
            throw new NetshotBadRequestException("Unable to schedule the task.", 30);
        }
        return task;
    }

    @POST
    @Path(value="changes")
    @RolesAllowed(value={"readonly"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsConfigChange> getChanges(RsChangeCriteria criteria) throws WebApplicationException {
        logger.debug("REST request, config changes.");
        try (Session session = Database.getSession();){
            List changes;
            List list = changes = session.createQuery("select c.id as newId, c.changeDate as newChangeDate, c.device.id as deviceId, c.author as author, c.device.name as deviceName from Config c where c.changeDate >= :start and c.changeDate <= :end").setTimestamp("start", criteria.fromDate).setTimestamp("end", criteria.toDate).setResultTransformer(Transformers.aliasToBean(RsConfigChange.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="policies")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<Policy> getPolicies() throws WebApplicationException {
        logger.debug("REST request, get policies.");
        try (Session session = Database.getSession();){
            List policies;
            List list = policies = session.createQuery("from Policy p left join fetch p.targetGroup").list();
            return list;
        }
    }

    @GET
    @Path(value="rules/policy/{id}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<Rule> getPolicyRules(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get rules for policy {}.", (Object)id);
        try (Session session = Database.getSession();){
            Policy policy = (Policy)session.load(Policy.class, (Serializable)id);
            if (policy == null) {
                logger.error("Invalid policy.");
                throw new NetshotBadRequestException("Invalid policy", 181);
            }
            ArrayList<Rule> rules = new ArrayList<Rule>();
            rules.addAll(policy.getRules());
            ArrayList<Rule> arrayList = rules;
            return arrayList;
        }
    }

    @POST
    @Path(value="policies")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Policy addPolicy(RsPolicy rsPolicy) throws WebApplicationException {
        Policy policy;
        logger.debug("REST request, add policy.");
        String name = rsPolicy.getName().trim();
        if (name.isEmpty()) {
            logger.warn("User posted an empty policy name.");
            throw new NetshotBadRequestException("Invalid policy name.", 180);
        }
        try (Session session = Database.getSession();){
            session.beginTransaction();
            DeviceGroup group = null;
            if (rsPolicy.getGroup() != -1L) {
                group = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)Long.valueOf(rsPolicy.getGroup()));
            }
            policy = new Policy(name, group);
            session.save(policy);
            session.getTransaction().commit();
        }
        return policy;
    }

    @DELETE
    @Path(value="policies/{id}")
    @RolesAllowed(value={"readwrite"})
    @Produces(value={"application/json", "application/xml"})
    public void deletePolicy(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete policy {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            Policy policy = (Policy)session.load(Policy.class, (Serializable)id);
            session.delete(policy);
            session.getTransaction().commit();
        }
    }

    @PUT
    @Path(value="policies/{id}")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Policy setPolicy(@PathParam(value="id") Long id, RsPolicy rsPolicy) throws WebApplicationException {
        logger.debug("REST request, edit policy {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            Policy policy = (Policy)session.get(Policy.class, (Serializable)id);
            if (policy == null) {
                logger.error("Unable to find the policy {} to be edited.", (Object)id);
                throw new NetshotBadRequestException("Unable to find this policy.", 181);
            }
            String name = rsPolicy.getName().trim();
            if (name.isEmpty()) {
                logger.warn("User posted an empty policy name.");
                throw new NetshotBadRequestException("Invalid policy name.", 180);
            }
            policy.setName(name);
            if (policy.getTargetGroup() != null && policy.getTargetGroup().getId() != rsPolicy.getGroup()) {
                session.createQuery("delete CheckResult cr where cr.key.rule in (select r from Rule r where r.policy = :id)").setLong("id", policy.getId()).executeUpdate();
            }
            DeviceGroup group = null;
            if (rsPolicy.getGroup() != -1L) {
                group = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)Long.valueOf(rsPolicy.getGroup()));
            }
            policy.setTargetGroup(group);
            session.update(policy);
            session.getTransaction().commit();
            Policy policy2 = policy;
            return policy2;
        }
    }

    @POST
    @Path(value="rules")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Rule addRule(RsRule rsRule) throws WebApplicationException {
        logger.debug("REST request, add rule.");
        if (rsRule.getName() == null || rsRule.getName().trim().isEmpty()) {
            logger.warn("User posted an empty rule name.");
            throw new NetshotBadRequestException("Invalid rule name.", 190);
        }
        String name = rsRule.getName().trim();
        try (Session session = Database.getSession();){
            session.beginTransaction();
            Policy policy = (Policy)session.load(Policy.class, (Serializable)rsRule.getPolicy());
            Rule rule = ".TextRule".equals(rsRule.getType()) ? new TextRule(name, policy) : new JavaScriptRule(name, policy);
            session.save(rule);
            session.getTransaction().commit();
            Rule rule2 = rule;
            return rule2;
        }
    }

    @PUT
    @Path(value="rules/{id}")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Rule setRule(@PathParam(value="id") Long id, RsRule rsRule) throws WebApplicationException {
        logger.debug("REST request, edit rule {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            Rule rule = (Rule)session.get(Rule.class, (Serializable)id);
            if (rule == null) {
                logger.error("Unable to find the rule {} to be edited.", (Object)id);
                throw new NetshotBadRequestException("Unable to find this rule.", 191);
            }
            if (rsRule.getName() != null) {
                String name = rsRule.getName().trim();
                if (name.isEmpty()) {
                    logger.warn("User posted an empty rule name.");
                    throw new NetshotBadRequestException("Invalid rule name.", 190);
                }
                rule.setName(name);
            }
            rule.setEnabled(rsRule.isEnabled());
            HashMap<Long, Date> postedExemptions = new HashMap<Long, Date>();
            postedExemptions.putAll(rsRule.getExemptions());
            Iterator<Exemption> i = rule.getExemptions().iterator();
            while (i.hasNext()) {
                Exemption exemption = i.next();
                Long l = exemption.getDevice().getId();
                if (postedExemptions.containsKey(l)) {
                    exemption.setExpirationDate((Date)postedExemptions.get(l));
                    postedExemptions.remove(l);
                    continue;
                }
                i.remove();
            }
            for (Map.Entry entry : postedExemptions.entrySet()) {
                Device device = (Device)session.load(Device.class, (Serializable)entry.getKey());
                Exemption exemption = new Exemption(rule, device, (Date)entry.getValue());
                rule.addExemption(exemption);
            }
            if (rule instanceof JavaScriptRule) {
                if (rsRule.getScript() != null) {
                    String script = rsRule.getScript().trim();
                    ((JavaScriptRule)rule).setScript(script);
                }
            } else if (rule instanceof TextRule) {
                if (rsRule.getText() != null) {
                    ((TextRule)rule).setText(rsRule.getText());
                }
                if (rsRule.isRegExp() != null) {
                    ((TextRule)rule).setRegExp(rsRule.isRegExp());
                }
                if (rsRule.getContext() != null) {
                    ((TextRule)rule).setContext(rsRule.getContext());
                }
                if (rsRule.getField() != null) {
                    ((TextRule)rule).setField(rsRule.getField());
                }
                if (rsRule.getDriver() != null) {
                    ((TextRule)rule).setDeviceDriver(rsRule.getDriver());
                }
                if (rsRule.isInvert() != null) {
                    ((TextRule)rule).setInvert(rsRule.isInvert());
                }
                if (rsRule.isMatchAll() != null) {
                    ((TextRule)rule).setMatchAll(rsRule.isMatchAll());
                }
                if (rsRule.isAnyBlock() != null) {
                    ((TextRule)rule).setAnyBlock(rsRule.isAnyBlock());
                }
            }
            session.update(rule);
            session.getTransaction().commit();
            Rule rule2 = rule;
            return rule2;
        }
    }

    @DELETE
    @Path(value="rules/{id}")
    @RolesAllowed(value={"readwrite"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteRule(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete rule {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            Rule rule = (Rule)session.load(Rule.class, (Serializable)id);
            session.delete(rule);
            session.getTransaction().commit();
        }
    }

    @POST
    @Path(value="rules/test")
    @RolesAllowed(value={"readonly"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public RsRuleTestResult testRule(RsRuleTest rsRule) throws WebApplicationException {
        logger.debug("REST request, rule test.");
        try (Session session = Database.getSession();){
            Rule rule;
            Device device = (Device)session.createQuery("from Device d join fetch d.lastConfig where d.id = :id").setLong("id", rsRule.getDevice()).uniqueResult();
            if (device == null) {
                logger.warn("Unable to find the device {}.", (Object)rsRule.getDevice());
                throw new NetshotBadRequestException("Unable to find the device.", 142);
            }
            if (".TextRule".equals(rsRule.getType())) {
                TextRule txRule = new TextRule("TEST", null);
                txRule.setDeviceDriver(rsRule.getDriver());
                txRule.setField(rsRule.getField());
                txRule.setInvert(rsRule.isInvert());
                txRule.setContext(rsRule.getContext());
                txRule.setRegExp(rsRule.isRegExp());
                txRule.setText(rsRule.getText());
                txRule.setAnyBlock(rsRule.isAnyBlock());
                txRule.setMatchAll(rsRule.isMatchAll());
                rule = txRule;
            } else {
                JavaScriptRule jsRule = new JavaScriptRule("TEST", null);
                jsRule.setScript(rsRule.getScript());
                rule = jsRule;
            }
            RsRuleTestResult result = new RsRuleTestResult();
            final StringBuffer log = new StringBuffer();
            TaskLogger taskLogger = new TaskLogger(){

                @Override
                public void warn(String message) {
                    log.append(String.format("[WARN] %s\n", message));
                }

                @Override
                public void trace(String message) {
                    log.append(String.format("[TRACE] %s\n", message));
                }

                @Override
                public void info(String message) {
                    log.append(String.format("[INFO] %s\n", message));
                }

                @Override
                public void error(String message) {
                    log.append(String.format("[ERROR] %s\n", message));
                }

                @Override
                public void debug(String message) {
                    log.append(String.format("[DEBUG] %s\n", message));
                }
            };
            rule.setEnabled(true);
            ((Rule)rule).check(device, session, taskLogger);
            result.setResult(rule.getCheckResults().iterator().next().getResult());
            result.setScriptError(log.toString());
            RsRuleTestResult rsRuleTestResult = result;
            return rsRuleTestResult;
        }
    }

    @GET
    @Path(value="devices/rule/{id}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsLightExemptedDevice> getExemptedDevices(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get exemptions for rule {}.", (Object)id);
        try (Session session = Database.getSession();){
            List exemptions;
            List list = exemptions = session.createQuery("select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status , e.expirationDate as expirationDate from Exemption e join e.key.device d where e.key.rule.id = :id").setLong("id", (long)id).setResultTransformer(Transformers.aliasToBean(RsLightExemptedDevice.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="devices/{id}/complianceresults")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsDeviceRule> getDeviceComplianceResults(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get compliance results for device {}.", (Object)id);
        try (Session session = Database.getSession();){
            List rules;
            List list = rules = session.createQuery("select r.id as id, r.name as ruleName, p.name as policyName, cr.result as result, cr.checkDate as checkDate, cr.comment as comment, e.expirationDate as expirationDate from Rule r join r.policy p join p.targetGroup g join g.cachedDevices d1 with d1.id = :id left join r.checkResults cr with cr.key.device.id = :id left join r.exemptions e with e.key.device.id = :id").setLong("id", (long)id).setResultTransformer(Transformers.aliasToBean(RsDeviceRule.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="reports/last7dayschangesbyday")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsConfigChangeNumberByDateStat> getLast7DaysChangesByDayStats(@QueryParam(value="tz") String jsTimeZone) throws WebApplicationException {
        logger.debug("REST request, get last 7 day changes by day stats.");
        Session session = Database.getSession();
        TimeZone timeZone = TimeZone.getDefault();
        try {
            timeZone = TimeZone.getTimeZone(jsTimeZone);
        }
        catch (Exception e) {
            logger.warn("Unable to parse timezone '{}'", (Object)jsTimeZone);
        }
        Calendar today = Calendar.getInstance(timeZone);
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        try {
            ArrayList<RsConfigChangeNumberByDateStat> stats = new ArrayList<RsConfigChangeNumberByDateStat>();
            for (int d = 7; d > 0; --d) {
                Calendar dayStart = (Calendar)today.clone();
                Calendar dayEnd = (Calendar)today.clone();
                dayStart.add(5, -d + 1);
                dayEnd.add(5, -d + 2);
                Long changeCount = (Long)session.createQuery("select count(*) from Config c where c.changeDate >= :dayStart and c.changeDate < :dayEnd").setTimestamp("dayStart", dayStart.getTime()).setTimestamp("dayEnd", dayEnd.getTime()).uniqueResult();
                stats.add(new RsConfigChangeNumberByDateStat(changeCount == null ? 0L : changeCount, dayStart.getTime()));
            }
            ArrayList<RsConfigChangeNumberByDateStat> arrayList = stats;
            return arrayList;
        }
        catch (HibernateException e) {
            logger.error("Unable to get the stats.", e);
            throw new NetshotBadRequestException("Unable to get the stats", 20);
        }
        finally {
            session.close();
        }
    }

    @GET
    @Path(value="reports/groupconfigcompliancestats")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsGroupConfigComplianceStat> getGroupConfigComplianceStats(@QueryParam(value="domain") Set<Long> domains, @QueryParam(value="group") Set<Long> deviceGroups, @QueryParam(value="policy") Set<Long> policies) throws WebApplicationException {
        logger.debug("REST request, group config compliance stats.");
        try (Session session = Database.getSession();){
            List stats;
            String domainFilter = "";
            if (domains.size() > 0) {
                domainFilter = " d.mgmtDomain.id in (:domainIds) and";
            }
            String ccrFilter = "";
            if (policies.size() > 0) {
                ccrFilter = " rule.policy.id in (:policyIds) and";
            }
            String groupFilter = "";
            if (deviceGroups.size() > 0) {
                groupFilter = " g.id in (:groupIds) and";
            }
            Query query = session.createQuery("select g.id as groupId, g.name as groupName, (select count(d) from g.cachedDevices d where" + domainFilter + " d.status = :enabled and (select count(ccr.result) from d.complianceCheckResults ccr join ccr.key.rule rule where" + ccrFilter + " ccr.result = :nonConforming) = 0) as compliantDeviceCount, (select count(d) from g.cachedDevices d where" + domainFilter + " d.status = :enabled) as deviceCount from DeviceGroup g where" + groupFilter + " g.hiddenFromReports <> true").setParameter("nonConforming", (Object)CheckResult.ResultOption.NONCONFORMING).setParameter("enabled", (Object)Device.Status.INPRODUCTION);
            if (domains.size() > 0) {
                query.setParameterList("domainIds", domains);
            }
            if (policies.size() > 0) {
                query.setParameterList("policyIds", policies);
            }
            if (deviceGroups.size() > 0) {
                query.setParameterList("groupIds", deviceGroups);
            }
            List list = stats = query.setResultTransformer(Transformers.aliasToBean(RsGroupConfigComplianceStat.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="reports/hardwaresupportstats")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsHardwareSupportStat> getHardwareSupportStats() throws WebApplicationException {
        logger.debug("REST request, hardware support stats.");
        try (Session session = Database.getSession();){
            List eosStats = session.createQuery("select count(d) as deviceCount, d.eosDate AS eoxDate from Device d where d.status = :enabled group by d.eosDate").setParameter("enabled", (Object)Device.Status.INPRODUCTION).setResultTransformer(Transformers.aliasToBean(RsHardwareSupportEoSStat.class)).list();
            List eolStats = session.createQuery("select count(d) as deviceCount, d.eolDate AS eoxDate from Device d where d.status = :enabled group by d.eolDate").setParameter("enabled", (Object)Device.Status.INPRODUCTION).setResultTransformer(Transformers.aliasToBean(RsHardwareSupportEoLStat.class)).list();
            ArrayList<RsHardwareSupportStat> stats = new ArrayList<RsHardwareSupportStat>();
            stats.addAll(eosStats);
            stats.addAll(eolStats);
            ArrayList<RsHardwareSupportStat> arrayList = stats;
            return arrayList;
        }
    }

    @GET
    @Path(value="reports/groupsoftwarecompliancestats")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsGroupSoftwareComplianceStat> getGroupSoftwareComplianceStats(@QueryParam(value="domain") Set<Long> domains) throws WebApplicationException {
        logger.debug("REST request, group software compliance stats.");
        try (Session session = Database.getSession();){
            List stats;
            String domainFilter = "";
            if (domains.size() > 0) {
                domainFilter = " and d.mgmtDomain.id in (:domainIds)";
            }
            Query query = session.createQuery("select g.id as groupId, g.name as groupName, (select count(d) from g.cachedDevices d where d.status = :enabled and d.softwareLevel = :gold" + domainFilter + ") as goldDeviceCount, (select count(d) from g.cachedDevices d where d.status = :enabled and d.softwareLevel = :silver" + domainFilter + ") as silverDeviceCount, (select count(d) from g.cachedDevices d where d.status = :enabled and d.softwareLevel = :bronze" + domainFilter + ") as bronzeDeviceCount, (select count(d) from g.cachedDevices d where d.status = :enabled" + domainFilter + ") as deviceCount from DeviceGroup g where g.hiddenFromReports <> true").setParameter("gold", (Object)SoftwareRule.ConformanceLevel.GOLD).setParameter("silver", (Object)SoftwareRule.ConformanceLevel.SILVER).setParameter("bronze", (Object)SoftwareRule.ConformanceLevel.BRONZE).setParameter("enabled", (Object)Device.Status.INPRODUCTION);
            if (domains.size() > 0) {
                query.setParameterList("domainIds", domains);
            }
            List list = stats = query.setResultTransformer(Transformers.aliasToBean(RsGroupSoftwareComplianceStat.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="reports/groupconfignoncompliantdevices/{id}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsLightPolicyRuleDevice> getGroupConfigNonCompliantDevices(@PathParam(value="id") Long id, @QueryParam(value="domain") Set<Long> domains, @QueryParam(value="policy") Set<Long> policies) throws WebApplicationException {
        logger.debug("REST request, group config non compliant devices.");
        try (Session session = Database.getSession();){
            List devices;
            String domainFilter = "";
            if (domains.size() > 0) {
                domainFilter = " and d.mgmtDomain.id in (:domainIds)";
            }
            String policyFilter = "";
            if (policies.size() > 0) {
                policyFilter = " and p.id in (:policyIds)";
            }
            Query query = session.createQuery("select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status , p.name as policyName, r.name as ruleName, ccr.checkDate as checkDate, ccr.result as result from Device d join d.ownerGroups g join d.complianceCheckResults ccr join ccr.key.rule r join r.policy p where g.id = :id and ccr.result = :nonConforming and d.status = :enabled" + domainFilter + policyFilter).setLong("id", (long)id).setParameter("nonConforming", (Object)CheckResult.ResultOption.NONCONFORMING).setParameter("enabled", (Object)Device.Status.INPRODUCTION);
            if (domains.size() > 0) {
                query.setParameterList("domainIds", domains);
            }
            if (policies.size() > 0) {
                query.setParameterList("policyIds", policies);
            }
            List list = devices = query.setResultTransformer(Transformers.aliasToBean(RsLightPolicyRuleDevice.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="reports/hardwaresupportdevices/{type}/{date}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsLightDevice> getHardwareStatusDevices(@PathParam(value="type") String type, @PathParam(value="date") Long date) throws WebApplicationException {
        logger.debug("REST request, EoX devices by type and date.");
        if (!type.equals("eol") && !type.equals("eos")) {
            logger.error("Invalid requested EoX type.");
            throw new NetshotBadRequestException("Unable to get the stats", 20);
        }
        Date eoxDate = new Date(date);
        try (Session session = Database.getSession();){
            List devices;
            if (date == 0L) {
                List devices2;
                List list = devices2 = session.createQuery("select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status from Device d where d." + type + "Date is null and d.status = :enabled").setParameter("enabled", (Object)Device.Status.INPRODUCTION).setResultTransformer(Transformers.aliasToBean(RsLightDevice.class)).list();
                return list;
            }
            List list = devices = session.createQuery("select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status from Device d where date(d." + type + "Date) = :eoxDate and d.status = :enabled").setDate("eoxDate", eoxDate).setParameter("enabled", (Object)Device.Status.INPRODUCTION).setResultTransformer(Transformers.aliasToBean(RsLightDevice.class)).list();
            return list;
        }
    }

    @GET
    @Path(value="hardwarerules")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<HardwareRule> getHardwareRules() throws WebApplicationException {
        logger.debug("REST request, hardware rules.");
        try (Session session = Database.getSession();){
            List rules;
            List list = rules = session.createQuery("from HardwareRule r left join fetch r.targetGroup g").list();
            return list;
        }
    }

    @POST
    @Path(value="hardwarerules")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public HardwareRule addHardwareRule(RsHardwareRule rsRule) throws WebApplicationException {
        HardwareRule rule;
        logger.debug("REST request, add hardware rule.");
        try (Session session = Database.getSession();){
            String driver;
            session.beginTransaction();
            DeviceGroup group = null;
            if (rsRule.getGroup() != -1L) {
                group = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)Long.valueOf(rsRule.getGroup()));
            }
            if (DeviceDriver.getDriverByName(driver = rsRule.getDriver()) == null) {
                driver = null;
            }
            rule = new HardwareRule(driver, group, rsRule.getFamily(), rsRule.isFamilyRegExp(), rsRule.getPartNumber(), rsRule.isPartNumberRegExp(), rsRule.getEndOfSale(), rsRule.getEndOfLife());
            session.save(rule);
            session.getTransaction().commit();
        }
        return rule;
    }

    @DELETE
    @Path(value="hardwarerules/{id}")
    @RolesAllowed(value={"readwrite"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteHardwareRule(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete hardware rule {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            HardwareRule rule = (HardwareRule)session.load(HardwareRule.class, (Serializable)id);
            session.delete(rule);
            session.getTransaction().commit();
        }
    }

    @PUT
    @Path(value="hardwarerules/{id}")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public HardwareRule setHardwareRule(@PathParam(value="id") Long id, RsHardwareRule rsRule) throws WebApplicationException {
        logger.debug("REST request, edit hardware rule {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            HardwareRule rule = (HardwareRule)session.get(HardwareRule.class, (Serializable)id);
            if (rule == null) {
                logger.error("Unable to find the rule {} to be edited.", (Object)id);
                throw new NetshotBadRequestException("Unable to find this rule.", 191);
            }
            String driver = rsRule.getDriver();
            if (DeviceDriver.getDriverByName(driver) == null) {
                driver = null;
            }
            rule.setDriver(driver);
            DeviceGroup group = null;
            if (rsRule.getGroup() != -1L) {
                group = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)Long.valueOf(rsRule.getGroup()));
            }
            rule.setTargetGroup(group);
            rule.setFamily(rsRule.getFamily());
            rule.setFamilyRegExp(rsRule.isFamilyRegExp());
            rule.setEndOfLife(rsRule.getEndOfLife());
            rule.setEndOfSale(rsRule.getEndOfSale());
            rule.setPartNumber(rsRule.getPartNumber());
            rule.setPartNumberRegExp(rsRule.isPartNumberRegExp());
            session.update(rule);
            session.getTransaction().commit();
            HardwareRule hardwareRule = rule;
            return hardwareRule;
        }
    }

    @GET
    @Path(value="softwarerules")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<SoftwareRule> getSoftwareRules() throws WebApplicationException {
        logger.debug("REST request, software rules.");
        try (Session session = Database.getSession();){
            List rules;
            List list = rules = session.createQuery("from SoftwareRule r left join fetch r.targetGroup g").list();
            return list;
        }
    }

    @POST
    @Path(value="softwarerules")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public SoftwareRule addSoftwareRule(RsSoftwareRule rsRule) throws WebApplicationException {
        SoftwareRule rule;
        logger.debug("REST request, add software rule.");
        try (Session session = Database.getSession();){
            String driver;
            session.beginTransaction();
            DeviceGroup group = null;
            if (rsRule.getGroup() != -1L) {
                group = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)Long.valueOf(rsRule.getGroup()));
            }
            if (DeviceDriver.getDriverByName(driver = rsRule.getDriver()) == null) {
                driver = null;
            }
            rule = new SoftwareRule(rsRule.getPriority(), group, driver, rsRule.getFamily(), rsRule.isFamilyRegExp(), rsRule.getVersion(), rsRule.isVersionRegExp(), rsRule.getPartNumber(), rsRule.isPartNumberRegExp(), rsRule.getLevel());
            session.save(rule);
            session.getTransaction().commit();
        }
        return rule;
    }

    @DELETE
    @Path(value="softwarerules/{id}")
    @RolesAllowed(value={"readwrite"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteSoftwareRule(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete software rule {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            SoftwareRule rule = (SoftwareRule)session.load(SoftwareRule.class, (Serializable)id);
            session.delete(rule);
            session.getTransaction().commit();
        }
    }

    @PUT
    @Path(value="softwarerules/{id}")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public SoftwareRule setSoftwareRule(@PathParam(value="id") Long id, RsSoftwareRule rsRule) throws WebApplicationException {
        logger.debug("REST request, edit software rule {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            SoftwareRule rule = (SoftwareRule)session.get(SoftwareRule.class, (Serializable)id);
            if (rule == null) {
                logger.error("Unable to find the rule {} to be edited.", (Object)id);
                throw new NetshotBadRequestException("Unable to find this rule.", 191);
            }
            String driver = rsRule.getDriver();
            if (DeviceDriver.getDriverByName(driver) == null) {
                driver = null;
            }
            rule.setDriver(driver);
            DeviceGroup group = null;
            if (rsRule.getGroup() != -1L) {
                group = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)Long.valueOf(rsRule.getGroup()));
            }
            rule.setTargetGroup(group);
            rule.setFamily(rsRule.getFamily());
            rule.setFamilyRegExp(rsRule.isFamilyRegExp());
            rule.setVersion(rsRule.getVersion());
            rule.setVersionRegExp(rsRule.isVersionRegExp());
            rule.setPartNumber(rsRule.getPartNumber());
            rule.setPartNumberRegExp(rsRule.isPartNumberRegExp());
            rule.setPriority(rsRule.getPriority());
            rule.setLevel(rsRule.getLevel());
            session.update(rule);
            session.getTransaction().commit();
            SoftwareRule softwareRule = rule;
            return softwareRule;
        }
    }

    @GET
    @Path(value="reports/groupdevicesbysoftwarelevel/{id}/{level}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsLightSoftwareLevelDevice> getGroupDevicesBySoftwareLevel(@PathParam(value="id") Long id, @PathParam(value="level") String level, @QueryParam(value="domain") Set<Long> domains) throws WebApplicationException {
        logger.debug("REST request, group {} devices by software level {}.", (Object)id, (Object)level);
        Session session = Database.getSession();
        SoftwareRule.ConformanceLevel filterLevel = SoftwareRule.ConformanceLevel.UNKNOWN;
        for (SoftwareRule.ConformanceLevel l : SoftwareRule.ConformanceLevel.values()) {
            if (!l.toString().equalsIgnoreCase(level)) continue;
            filterLevel = l;
            break;
        }
        try {
            List devices;
            String domainFilter = "";
            if (domains.size() > 0) {
                domainFilter = " and d.mgmtDomain.id in (:domainIds)";
            }
            Query query = session.createQuery("select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status , d.softwareLevel as softwareLevel from Device d join d.ownerGroups g where g.id = :id and d.softwareLevel = :level and d.status = :enabled" + domainFilter).setLong("id", (long)id).setParameter("level", (Object)filterLevel).setParameter("enabled", (Object)Device.Status.INPRODUCTION);
            if (domains.size() > 0) {
                query.setParameterList("domainIds", domains);
            }
            List list = devices = query.setResultTransformer(Transformers.aliasToBean(RsLightSoftwareLevelDevice.class)).list();
            return list;
        }
        catch (HibernateException e) {
            logger.error("Unable to get the devices.", e);
            throw new NetshotBadRequestException("Unable to get the stats", 20);
        }
        finally {
            session.close();
        }
    }

    @GET
    @Path(value="reports/accessfailuredevices")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<RsLightAccessFailureDevice> getAccessFailureDevices(@QueryParam(value="days") Integer days, @QueryParam(value="domain") Set<Long> domains) throws WebApplicationException {
        logger.debug("REST request, devices without successful snapshot over the last {} days.", (Object)days);
        if (days == null || days < 1) {
            logger.warn("Invalid number of days {} to find the unreachable devices, using 3.", (Object)days);
            days = 3;
        }
        try (Session session = Database.getSession();){
            Calendar when = Calendar.getInstance();
            when.add(5, -days.intValue());
            String domainFilter = "";
            if (domains.size() > 0) {
                domainFilter = " and d.mgmtDomain.id in (:domainIds)";
            }
            Query query = session.createQuery("select d.id as id, d.name as name, d.family as family, d.mgmtAddress as mgmtAddress, d.status as status , (select max(t.executionDate) from TakeSnapshotTask t where t.device = d and t.status = :success) as lastSuccess, (select max(t.executionDate) from TakeSnapshotTask t where t.device = d and t.status = :failure) as lastFailure from Device d where d.status = :enabled" + domainFilter).setParameter("success", (Object)Task.Status.SUCCESS).setParameter("failure", (Object)Task.Status.FAILURE).setParameter("enabled", (Object)Device.Status.INPRODUCTION);
            if (domainFilter.length() > 0) {
                query.setParameterList("domainIds", domains);
            }
            List devices = query.setResultTransformer(Transformers.aliasToBean(RsLightAccessFailureDevice.class)).list();
            Iterator d = devices.iterator();
            while (d.hasNext()) {
                RsLightAccessFailureDevice device = (RsLightAccessFailureDevice)d.next();
                if (device.getLastSuccess() == null || !device.getLastSuccess().after(when.getTime())) continue;
                d.remove();
            }
            List list = devices;
            return list;
        }
    }

    @DELETE
    @Path(value="user/{id}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public void logout(@Context HttpServletRequest request) throws WebApplicationException {
        logger.debug("REST logout request.");
        User sessionUser = (User)request.getSession().getAttribute("user");
        HttpSession httpSession = request.getSession();
        httpSession.invalidate();
        Netshot.aaaLogger.warn("User {} has logged out.", (Object)sessionUser.getUsername());
    }

    @PUT
    @Path(value="user/{id}")
    @RolesAllowed(value={"readonly"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public User setPassword(@Context HttpServletRequest request, RsLogin rsLogin) throws WebApplicationException {
        logger.debug("REST password change request, username {}.", (Object)rsLogin.getUsername());
        User sessionUser = (User)request.getSession().getAttribute("user");
        Netshot.aaaLogger.warn("Password change request via REST by user {} for user {}.", (Object)sessionUser.getUsername(), (Object)rsLogin.getUsername());
        try (Session session = Database.getSession();){
            session.beginTransaction();
            User user = (User)session.bySimpleNaturalId(User.class).load(rsLogin.getUsername());
            if (user == null || !user.getUsername().equals(sessionUser.getUsername()) || !user.isLocal()) {
                throw new NetshotBadRequestException("Invalid user.", 200);
            }
            if (!user.checkPassword(rsLogin.getPassword())) {
                throw new NetshotBadRequestException("Invalid current password.", 200);
            }
            String newPassword = rsLogin.getNewPassword();
            if (newPassword.equals("")) {
                throw new NetshotBadRequestException("The password cannot be empty.", 200);
            }
            user.setPassword(newPassword);
            session.save(user);
            session.getTransaction().commit();
            Netshot.aaaLogger.warn("Password successfully changed by user {} for user {}.", (Object)sessionUser.getUsername(), (Object)rsLogin.getUsername());
            User user2 = sessionUser;
            return user2;
        }
    }

    @POST
    @PermitAll
    @Path(value="user")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public User login(@Context HttpServletRequest request, RsLogin rsLogin) throws WebApplicationException {
        HttpSession httpSession;
        logger.debug("REST authentication request, username {}.", (Object)rsLogin.getUsername());
        Netshot.aaaLogger.info("REST authentication request, username {}.", (Object)rsLogin.getUsername());
        User user = null;
        try (Session session = Database.getSession();){
            user = (User)session.bySimpleNaturalId(User.class).load(rsLogin.getUsername());
        }
        if (user != null && user.isLocal()) {
            if (user.checkPassword(rsLogin.getPassword())) {
                Netshot.aaaLogger.info("Local authentication success for user {}.", (Object)rsLogin.getUsername());
            } else {
                Netshot.aaaLogger.warn("Local authentication failure for user {}.", (Object)rsLogin.getUsername());
                user = null;
            }
        } else {
            User remoteUser = Radius.authenticate(rsLogin.getUsername(), rsLogin.getPassword());
            if (remoteUser != null && user != null) {
                remoteUser.setLevel(user.getLevel());
                Netshot.aaaLogger.info("Remote authentication success for user {}.", (Object)rsLogin.getUsername());
            } else {
                Netshot.aaaLogger.warn("Remote authentication failure for user {}.", (Object)rsLogin.getUsername());
            }
            user = remoteUser;
        }
        if (user != null) {
            httpSession = request.getSession();
            httpSession.setAttribute("user", user);
            httpSession.setMaxInactiveInterval(User.MAX_IDLE_TIME);
            return user;
        }
        httpSession = request.getSession();
        httpSession.invalidate();
        throw new NetshotAuthenticationRequiredException();
    }

    @GET
    @RolesAllowed(value={"readonly"})
    @Path(value="user")
    @Produces(value={"application/json", "application/xml"})
    public User getUser(@Context HttpServletRequest request) throws WebApplicationException {
        User user = (User)request.getSession().getAttribute("user");
        return user;
    }

    @GET
    @Path(value="/users")
    @RolesAllowed(value={"admin"})
    @Produces(value={"application/json", "application/xml"})
    public List<User> getUsers() throws WebApplicationException {
        logger.debug("REST request, get user list.");
        try (Session session = Database.getSession();){
            List users;
            List list = users = session.createCriteria(User.class).list();
            return list;
        }
    }

    @POST
    @Path(value="users")
    @RolesAllowed(value={"admin"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public User addUser(RsUser rsUser) {
        logger.debug("REST request, add user");
        String username = rsUser.getUsername();
        if (username == null || username.trim().isEmpty()) {
            logger.warn("User posted an empty user name.");
            throw new NetshotBadRequestException("Invalid user name.", 202);
        }
        username = username.trim();
        String password = rsUser.getPassword();
        if (rsUser.isLocal()) {
            if (password == null || password.equals("")) {
                logger.warn("User tries to create a local account without password.");
                throw new NetshotBadRequestException("Please set a password.", 203);
            }
        } else {
            password = "";
        }
        User user = new User(username, rsUser.isLocal(), password);
        user.setLevel(rsUser.level);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            session.save(user);
            session.getTransaction().commit();
            User user2 = user;
            return user2;
        }
    }

    @PUT
    @Path(value="users/{id}")
    @RolesAllowed(value={"admin"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public User setUser(@PathParam(value="id") Long id, RsUser rsUser) throws WebApplicationException {
        logger.debug("REST request, edit user {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            User user = (User)session.get(User.class, (Serializable)id);
            if (user == null) {
                logger.error("Unable to find the user {} to be edited.", (Object)id);
                throw new NetshotBadRequestException("Unable to find this user.", 200);
            }
            String username = rsUser.getUsername();
            if (username == null || username.trim().isEmpty()) {
                logger.warn("User posted an empty user name.");
                throw new NetshotBadRequestException("Invalid user name.", 202);
            }
            username = username.trim();
            user.setUsername(username);
            user.setLevel(rsUser.getLevel());
            if (rsUser.isLocal()) {
                if (rsUser.getPassword() != null && !rsUser.getPassword().equals("-")) {
                    user.setPassword(rsUser.getPassword());
                }
                if (user.getHashedPassword().equals("")) {
                    logger.error("The password cannot be empty for user {}.", (Object)id);
                    throw new NetshotBadRequestException("You must set a password.", 203);
                }
            } else {
                user.setPassword("");
            }
            user.setLocal(rsUser.isLocal());
            session.update(user);
            session.getTransaction().commit();
            User user2 = user;
            return user2;
        }
    }

    @DELETE
    @Path(value="users/{id}")
    @RolesAllowed(value={"admin"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteUser(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete user {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            User user = (User)session.load(User.class, (Serializable)id);
            session.delete(user);
            session.getTransaction().commit();
        }
    }

    @GET
    @Path(value="reports/export")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"})
    public Response getDataXLSX(@Context HttpServletRequest request, @DefaultValue(value="-1") @QueryParam(value="group") long group, @QueryParam(value="domain") Set<Long> domains, @DefaultValue(value="false") @QueryParam(value="interfaces") boolean exportInterfaces, @DefaultValue(value="false") @QueryParam(value="inventory") boolean exportInventory, @DefaultValue(value="false") @QueryParam(value="locations") boolean exportLocations, @DefaultValue(value="xlsx") @QueryParam(value="format") String fileFormat) throws WebApplicationException {
        logger.debug("REST request, export data.");
        User user = (User)request.getSession().getAttribute("user");
        if (fileFormat.compareToIgnoreCase("xlsx") == 0) {
            String fileName = String.format("netshot-export_%s.xlsx", new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()));
            try (Session session = Database.getSession();){
                SXSSFWorkbook workBook = new SXSSFWorkbook(100);
                CreationHelper createHelper = workBook.getCreationHelper();
                CellStyle datetimeCellStyle = workBook.createCellStyle();
                datetimeCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-mm-dd hh:mm"));
                CellStyle dateCellStyle = workBook.createCellStyle();
                dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-mm-dd"));
                Sheet summarySheet = workBook.createSheet("Summary");
                Row row = summarySheet.createRow(0);
                row.createCell(0).setCellValue("Netshot version");
                row.createCell(1).setCellValue("0.14.0");
                row = summarySheet.createRow(1);
                row.createCell(0).setCellValue("Exported by");
                row.createCell(1).setCellValue(user.getName());
                row = summarySheet.createRow(2);
                row.createCell(0).setCellValue("Date and time");
                Cell cell = row.createCell(1);
                cell.setCellValue(new Date());
                cell.setCellStyle(datetimeCellStyle);
                Criteria criteria = session.createCriteria(Device.class);
                criteria.setFetchMode("mgmtDomain", FetchMode.SELECT);
                criteria.setFetchMode("specificCredentialSet", FetchMode.SELECT);
                row = summarySheet.createRow(4);
                row.createCell(0).setCellValue("Selected Domain");
                if (domains.size() == 0) {
                    row.createCell(1).setCellValue("Any");
                } else {
                    List deviceDomains = session.createQuery("select d from Domain d where d.id in (:domainIds)").setParameterList("domainIds", domains).list();
                    ArrayList<String> domainNames = new ArrayList<String>();
                    for (Object deviceDomain : deviceDomains) {
                        domainNames.add(String.format("%s (%d)", ((Domain)deviceDomain).getName(), ((Domain)deviceDomain).getId()));
                    }
                    row.createCell(1).setCellValue(String.join((CharSequence)", ", domainNames));
                    criteria.createCriteria("mgmtDomain", "md");
                    criteria.add(Restrictions.in("md.id", domains));
                }
                row = summarySheet.createRow(5);
                row.createCell(0).setCellValue("Selected Group");
                if (group == -1L) {
                    row.createCell(1).setCellValue("Any");
                } else {
                    DeviceGroup deviceGroup = (DeviceGroup)session.get(DeviceGroup.class, (Serializable)Long.valueOf(group));
                    row.createCell(1).setCellValue(deviceGroup.getName());
                    criteria.createCriteria("ownerGroups", "g");
                    criteria.add(Restrictions.eq("g.id", group));
                }
                Sheet deviceSheet = workBook.createSheet("Devices");
                ((SXSSFSheet)deviceSheet).setRandomAccessWindowSize(100);
                row = deviceSheet.createRow(0);
                row.createCell(0).setCellValue("ID");
                row.createCell(1).setCellValue("Name");
                row.createCell(2).setCellValue("Management IP");
                row.createCell(3).setCellValue("Domain");
                row.createCell(4).setCellValue("Network Class");
                row.createCell(5).setCellValue("Family");
                row.createCell(6).setCellValue("Creation");
                row.createCell(7).setCellValue("Last Change");
                row.createCell(8).setCellValue("Software");
                row.createCell(9).setCellValue("End of Sale Date");
                row.createCell(10).setCellValue("End Of Life Date");
                if (exportLocations) {
                    row.createCell(11).setCellValue("Location");
                    row.createCell(12).setCellValue("Contact");
                }
                int yDevice = 1;
                List devices = criteria.list();
                for (Device device : devices) {
                    row = deviceSheet.createRow(yDevice++);
                    row.createCell(0).setCellValue(device.getId());
                    row.createCell(1).setCellValue(device.getName());
                    row.createCell(2).setCellValue(device.getMgmtAddress().getIp());
                    row.createCell(3).setCellValue(device.getMgmtDomain().getName());
                    row.createCell(4).setCellValue(device.getNetworkClass().toString());
                    row.createCell(5).setCellValue(device.getFamily());
                    cell = row.createCell(6);
                    cell.setCellValue(device.getCreatedDate());
                    cell.setCellStyle(datetimeCellStyle);
                    cell = row.createCell(7);
                    cell.setCellValue(device.getChangeDate());
                    cell.setCellStyle(datetimeCellStyle);
                    row.createCell(8).setCellValue(device.getSoftwareVersion());
                    if (device.getEosDate() != null) {
                        cell = row.createCell(9);
                        cell.setCellValue(device.getEosDate());
                        cell.setCellStyle(dateCellStyle);
                    }
                    if (device.getEolDate() != null) {
                        cell = row.createCell(10);
                        cell.setCellValue(device.getEolDate());
                        cell.setCellStyle(dateCellStyle);
                    }
                    if (!exportLocations) continue;
                    row.createCell(11).setCellValue(device.getLocation());
                    row.createCell(12).setCellValue(device.getContact());
                }
                if (exportInterfaces) {
                    Sheet interfaceSheet = workBook.createSheet("Interfaces");
                    ((SXSSFSheet)interfaceSheet).setRandomAccessWindowSize(100);
                    row = interfaceSheet.createRow(0);
                    row.createCell(0).setCellValue("Device ID");
                    row.createCell(1).setCellValue("Virtual Device");
                    row.createCell(2).setCellValue("Name");
                    row.createCell(3).setCellValue("Description");
                    row.createCell(4).setCellValue("VRF");
                    row.createCell(5).setCellValue("MAC Address");
                    row.createCell(6).setCellValue("Enabled");
                    row.createCell(7).setCellValue("Level 3");
                    row.createCell(8).setCellValue("IP Address");
                    row.createCell(9).setCellValue("Mask Length");
                    row.createCell(10).setCellValue("Usage");
                    int yInterface = 1;
                    for (Device device : devices) {
                        for (NetworkInterface networkInterface : device.getNetworkInterfaces()) {
                            if (networkInterface.getIpAddresses().size() == 0) {
                                row = interfaceSheet.createRow(yInterface++);
                                row.createCell(0).setCellValue(device.getId());
                                row.createCell(1).setCellValue(networkInterface.getVirtualDevice());
                                row.createCell(2).setCellValue(networkInterface.getInterfaceName());
                                row.createCell(3).setCellValue(networkInterface.getDescription());
                                row.createCell(4).setCellValue(networkInterface.getVrfInstance());
                                row.createCell(5).setCellValue(networkInterface.getMacAddress());
                                row.createCell(6).setCellValue(networkInterface.isEnabled());
                                row.createCell(7).setCellValue(networkInterface.isLevel3());
                                row.createCell(8).setCellValue("");
                                row.createCell(9).setCellValue("");
                                row.createCell(10).setCellValue("");
                            }
                            for (NetworkAddress address : networkInterface.getIpAddresses()) {
                                row = interfaceSheet.createRow(yInterface++);
                                row.createCell(0).setCellValue(device.getId());
                                row.createCell(1).setCellValue(networkInterface.getVirtualDevice());
                                row.createCell(2).setCellValue(networkInterface.getInterfaceName());
                                row.createCell(3).setCellValue(networkInterface.getDescription());
                                row.createCell(4).setCellValue(networkInterface.getVrfInstance());
                                row.createCell(5).setCellValue(networkInterface.getMacAddress());
                                row.createCell(6).setCellValue(networkInterface.isEnabled());
                                row.createCell(7).setCellValue(networkInterface.isLevel3());
                                row.createCell(8).setCellValue(address.getIp());
                                row.createCell(9).setCellValue(address.getPrefixLength());
                                row.createCell(10).setCellValue(address.getAddressUsage() == null ? "" : address.getAddressUsage().toString());
                            }
                        }
                    }
                }
                if (exportInventory) {
                    Sheet inventorySheet = workBook.createSheet("Inventory");
                    ((SXSSFSheet)inventorySheet).setRandomAccessWindowSize(100);
                    row = inventorySheet.createRow(0);
                    row.createCell(0).setCellValue("Device ID");
                    row.createCell(1).setCellValue("Slot");
                    row.createCell(2).setCellValue("Part Number");
                    row.createCell(3).setCellValue("Serial Number");
                    int yInventory = 1;
                    for (Device device : devices) {
                        for (Module module : device.getModules()) {
                            row = inventorySheet.createRow(yInventory++);
                            row.createCell(0).setCellValue(device.getId());
                            row.createCell(1).setCellValue(module.getSlot());
                            row.createCell(2).setCellValue(module.getPartNumber());
                            row.createCell(3).setCellValue(module.getSerialNumber());
                        }
                    }
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                workBook.write(output);
                workBook.close();
                Response response = Response.ok(output.toByteArray()).header("Content-Disposition", "attachment; filename=" + fileName).build();
                return response;
            }
        }
        logger.warn("Invalid requested file format.");
        throw new WebApplicationException("The requested file format is invalid or not supported.", Response.Status.BAD_REQUEST);
    }

    @POST
    @Path(value="scripts")
    @RolesAllowed(value={"readwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public DeviceJsScript addScript(@Context HttpServletRequest request, DeviceJsScript rsScript) throws WebApplicationException {
        logger.debug("REST request, add device script.");
        DeviceDriver driver = DeviceDriver.getDriverByName(rsScript.getDeviceDriver());
        if (driver == null) {
            logger.warn("Invalid driver name.");
            throw new NetshotBadRequestException("Invalid driver name.", 220);
        }
        if (rsScript.getName() == null || rsScript.getName().trim().equals("")) {
            logger.warn("Invalid script name.");
            throw new NetshotBadRequestException("Invalid script name.", 220);
        }
        if (rsScript.getScript() == null) {
            logger.warn("Invalid script.");
            throw new NetshotBadRequestException("The script content can't be empty.", 220);
        }
        try {
            User user = (User)request.getSession().getAttribute("user");
            rsScript.setAuthor(user.getUsername());
        }
        catch (Exception user) {
            // empty catch block
        }
        rsScript.setId(0L);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            session.save(rsScript);
            session.getTransaction().commit();
            DeviceJsScript deviceJsScript = rsScript;
            return deviceJsScript;
        }
    }

    @DELETE
    @Path(value="scripts/{id}")
    @RolesAllowed(value={"readwrite"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteScript(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete script {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            DeviceJsScript script = (DeviceJsScript)session.load(DeviceJsScript.class, (Serializable)id);
            session.delete(script);
            session.getTransaction().commit();
        }
    }

    @GET
    @Path(value="scripts/{id}")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public DeviceJsScript getScript(@PathParam(value="id") Long id) {
        logger.debug("REST request, get script {}", (Object)id);
        try (Session session = Database.getSession();){
            DeviceJsScript script;
            DeviceJsScript deviceJsScript = script = (DeviceJsScript)session.get(DeviceJsScript.class, (Serializable)id);
            return deviceJsScript;
        }
    }

    @GET
    @Path(value="scripts")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<DeviceJsScript> getScripts() {
        logger.debug("REST request, get scripts.");
        try (Session session = Database.getSession();){
            List scripts = session.createQuery("from DeviceJsScript s").list();
            for (DeviceJsScript script : scripts) {
                script.setScript(null);
            }
            List list = scripts;
            return list;
        }
    }

    @GET
    @Path(value="diagnostics")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<Diagnostic> getDiagnostics() throws WebApplicationException {
        logger.debug("REST request, get diagnotics.");
        try (Session session = Database.getSession();){
            List diagnostics;
            List list = diagnostics = session.createQuery("select d from Diagnostic d left join fetch d.targetGroup").list();
            return list;
        }
    }

    @POST
    @Path(value="diagnostics")
    @RolesAllowed(value={"executereadwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Diagnostic addDiagnostic(RsDiagnostic rsDiagnostic) throws WebApplicationException {
        Diagnostic diagnostic;
        AttributeDefinition.AttributeType resultType;
        logger.debug("REST request, add diagnostic");
        String name = rsDiagnostic.getName().trim();
        if (name.isEmpty()) {
            logger.warn("User posted an empty diagnostic name.");
            throw new NetshotBadRequestException("Invalid diagnostic name.", 230);
        }
        if (name.contains("\"")) {
            logger.warn("Double-quotes are not allowed in the diagnostic name.");
            throw new NetshotBadRequestException("Double-quotes are not allowed in the name.", 230);
        }
        try {
            resultType = AttributeDefinition.AttributeType.valueOf(rsDiagnostic.getResultType());
        }
        catch (Exception e) {
            throw new NetshotBadRequestException("Invalid diagnostic result type.", 233);
        }
        try (Session session = Database.getSession();){
            session.beginTransaction();
            DeviceGroup group = null;
            if (rsDiagnostic.getTargetGroup() != -1L) {
                group = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)Long.valueOf(rsDiagnostic.getTargetGroup()));
            }
            if (".JavaScriptDiagnostic".equals(rsDiagnostic.getType())) {
                if (rsDiagnostic.getScript() == null || rsDiagnostic.getScript().trim() == "") {
                    throw new NetshotBadRequestException("Invalid diagnostic script", 233);
                }
                diagnostic = new JavaScriptDiagnostic(name, rsDiagnostic.isEnabled(), group, resultType, rsDiagnostic.getScript());
            } else if (".SimpleDiagnostic".equals(rsDiagnostic.getType())) {
                if (rsDiagnostic.getCliMode() == null || rsDiagnostic.getCliMode().trim() == "") {
                    throw new NetshotBadRequestException("The CLI mode must be provided.", 233);
                }
                if (rsDiagnostic.getCommand() == null || rsDiagnostic.getCommand().trim() == "") {
                    throw new NetshotBadRequestException("The command cannot be empty.", 233);
                }
                diagnostic = new SimpleDiagnostic(name, rsDiagnostic.isEnabled(), group, resultType, rsDiagnostic.getDeviceDriver(), rsDiagnostic.getCliMode(), rsDiagnostic.getCommand(), rsDiagnostic.getModifierPattern(), rsDiagnostic.getModifierReplacement());
            } else {
                throw new NetshotBadRequestException("Invalid diagnostic type.", 232);
            }
            session.save(diagnostic);
            session.getTransaction().commit();
        }
        return diagnostic;
    }

    @PUT
    @Path(value="diagnostics/{id}")
    @RolesAllowed(value={"executereadwrite"})
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Diagnostic setDiagnostic(@PathParam(value="id") Long id, RsDiagnostic rsDiagnostic) throws WebApplicationException {
        logger.debug("REST request, edit diagnostic {}.", (Object)id);
        try (Session session = Database.getSession();){
            AttributeDefinition.AttributeType resultType;
            session.beginTransaction();
            Diagnostic diagnostic = (Diagnostic)session.get(Diagnostic.class, (Serializable)id);
            if (diagnostic == null) {
                logger.error("Unable to find the diagnostic {} to be edited.", (Object)id);
                throw new NetshotBadRequestException("Unable to find this diagnostic.", 233);
            }
            String name = rsDiagnostic.getName().trim();
            if (name.isEmpty()) {
                logger.warn("User posted an empty diagnostic name.");
                throw new NetshotBadRequestException("Invalid diagnostic name.", 230);
            }
            if (name.contains("\"")) {
                logger.warn("Double-quotes are not allowed in the diagnostic name.");
                throw new NetshotBadRequestException("Double-quotes are not allowed in the name.", 230);
            }
            try {
                resultType = AttributeDefinition.AttributeType.valueOf(rsDiagnostic.getResultType());
            }
            catch (Exception e) {
                throw new NetshotBadRequestException("Invalid diagnostic result type.", 233);
            }
            diagnostic.setName(name);
            if (diagnostic.getTargetGroup() != null && diagnostic.getTargetGroup().getId() != rsDiagnostic.getTargetGroup()) {
                session.createQuery("delete DiagnosticResult dr where dr.diagnostic.id = :id").setLong("id", diagnostic.getId()).executeUpdate();
            }
            DeviceGroup group = null;
            if (rsDiagnostic.getTargetGroup() != -1L) {
                group = (DeviceGroup)session.load(DeviceGroup.class, (Serializable)Long.valueOf(rsDiagnostic.getTargetGroup()));
            }
            diagnostic.setTargetGroup(group);
            diagnostic.setResultType(resultType);
            diagnostic.setEnabled(rsDiagnostic.isEnabled());
            if (diagnostic instanceof JavaScriptDiagnostic) {
                if (!".JavaScriptDiagnostic".equals(rsDiagnostic.getType())) {
                    throw new NetshotBadRequestException("Incompatible posted diagnostic.", 234);
                }
                if (rsDiagnostic.getScript() == null || rsDiagnostic.getScript().trim() == "") {
                    throw new NetshotBadRequestException("Invalid diagnostic script", 233);
                }
                ((JavaScriptDiagnostic)diagnostic).setScript(rsDiagnostic.getScript());
            } else if (diagnostic instanceof SimpleDiagnostic) {
                if (!".SimpleDiagnostic".equals(rsDiagnostic.getType())) {
                    throw new NetshotBadRequestException("Incompatible posted diagnostic.", 234);
                }
                if (rsDiagnostic.getCliMode() == null || rsDiagnostic.getCliMode().trim() == "") {
                    throw new NetshotBadRequestException("The CLI mode must be provided.", 233);
                }
                if (rsDiagnostic.getCommand() == null || rsDiagnostic.getCommand().trim() == "") {
                    throw new NetshotBadRequestException("The command cannot be empty.", 233);
                }
                SimpleDiagnostic simpleDiagnostic = (SimpleDiagnostic)diagnostic;
                simpleDiagnostic.setDeviceDriver(rsDiagnostic.getDeviceDriver());
                simpleDiagnostic.setCliMode(rsDiagnostic.getCliMode());
                simpleDiagnostic.setCommand(rsDiagnostic.getCommand());
                simpleDiagnostic.setModifierPattern(rsDiagnostic.getModifierPattern());
                simpleDiagnostic.setModifierReplacement(rsDiagnostic.getModifierReplacement());
            }
            session.update(diagnostic);
            session.getTransaction().commit();
            Diagnostic diagnostic2 = diagnostic;
            return diagnostic2;
        }
    }

    @DELETE
    @Path(value="diagnostics/{id}")
    @RolesAllowed(value={"executereadwrite"})
    @Produces(value={"application/json", "application/xml"})
    public void deleteDiagnostic(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, delete diagnostic {}.", (Object)id);
        try (Session session = Database.getSession();){
            session.beginTransaction();
            Diagnostic diagnostic = (Diagnostic)session.load(Diagnostic.class, (Serializable)id);
            session.delete(diagnostic);
            session.getTransaction().commit();
        }
    }

    @GET
    @Path(value="devices/{id}/diagnosticresults")
    @RolesAllowed(value={"readonly"})
    @Produces(value={"application/json", "application/xml"})
    public List<DiagnosticResult> getDeviceDiagnosticResults(@PathParam(value="id") Long id) throws WebApplicationException {
        logger.debug("REST request, get diagnostic results for device {}.", (Object)id);
        try (Session session = Database.getSession();){
            List results;
            List list = results = session.createQuery("from DiagnosticResult dr where dr.device.id = :id").setLong("id", (long)id).list();
            return list;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsDiagnostic {
        private long id = 0L;
        private String name = "";
        private long targetGroup = 0L;
        private boolean enabled = false;
        private String resultType;
        private String type;
        private String script;
        private String deviceDriver;
        private String cliMode;
        private String command;
        private String modifierPattern;
        private String modifierReplacement;

        @XmlElement
        public String getDeviceDriver() {
            return this.deviceDriver;
        }

        public void setDeviceDriver(String deviceDriver) {
            this.deviceDriver = deviceDriver;
        }

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public long getTargetGroup() {
            return this.targetGroup;
        }

        public void setTargetGroup(long targetGroup) {
            this.targetGroup = targetGroup;
        }

        @XmlElement
        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @XmlElement
        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        @XmlElement
        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        @XmlElement
        public String getModifierPattern() {
            return this.modifierPattern;
        }

        public void setModifierPattern(String modifierPattern) {
            this.modifierPattern = modifierPattern;
        }

        @XmlElement
        public String getModifierReplacement() {
            return this.modifierReplacement;
        }

        public void setModifierReplacement(String modifierReplacement) {
            this.modifierReplacement = modifierReplacement;
        }

        @XmlElement
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @XmlElement
        public String getCliMode() {
            return this.cliMode;
        }

        public void setCliMode(String cliMode) {
            this.cliMode = cliMode;
        }

        @XmlElement
        public String getResultType() {
            return this.resultType;
        }

        public void setResultType(String resultType) {
            this.resultType = resultType;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsUser {
        private long id;
        private String username;
        private String password;
        private int level;
        private boolean local;

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        @XmlElement
        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        @XmlElement
        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        @XmlElement
        public boolean isLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsLogin {
        private String username;
        private String password;
        private String newPassword = "";

        @XmlElement
        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        @XmlElement
        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        @XmlElement
        public String getNewPassword() {
            return this.newPassword;
        }

        public void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsLightAccessFailureDevice
    extends RsLightDevice {
        private Date lastSuccess;
        private Date lastFailure;

        @XmlElement
        public Date getLastSuccess() {
            return this.lastSuccess;
        }

        public void setLastSuccess(Date lastSuccess) {
            this.lastSuccess = lastSuccess;
        }

        @XmlElement
        public Date getLastFailure() {
            return this.lastFailure;
        }

        public void setLastFailure(Date lastFailure) {
            this.lastFailure = lastFailure;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsLightSoftwareLevelDevice
    extends RsLightDevice {
        private SoftwareRule.ConformanceLevel softwareLevel;

        @XmlElement
        public SoftwareRule.ConformanceLevel getSoftwareLevel() {
            return this.softwareLevel;
        }

        public void setSoftwareLevel(SoftwareRule.ConformanceLevel level) {
            this.softwareLevel = level;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsSoftwareRule {
        private long id;
        private long group = -1L;
        private String driver = "";
        private String version = "";
        private boolean versionRegExp = false;
        private String family = "";
        private boolean familyRegExp = false;
        private String partNumber = "";
        private boolean partNumberRegExp = false;
        private SoftwareRule.ConformanceLevel level = SoftwareRule.ConformanceLevel.GOLD;
        private double priority = -1.0;

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public long getGroup() {
            return this.group;
        }

        public void setGroup(long group) {
            this.group = group;
        }

        @XmlElement
        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        @XmlElement
        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        @XmlElement
        public String getFamily() {
            return this.family;
        }

        public void setFamily(String family) {
            this.family = family;
        }

        @XmlElement
        public SoftwareRule.ConformanceLevel getLevel() {
            return this.level;
        }

        public void setLevel(SoftwareRule.ConformanceLevel level) {
            this.level = level;
        }

        @XmlElement
        public double getPriority() {
            return this.priority;
        }

        public void setPriority(double priority) {
            this.priority = priority;
        }

        @XmlElement
        public boolean isVersionRegExp() {
            return this.versionRegExp;
        }

        public void setVersionRegExp(boolean versionRegExp) {
            this.versionRegExp = versionRegExp;
        }

        @XmlElement
        public boolean isFamilyRegExp() {
            return this.familyRegExp;
        }

        public void setFamilyRegExp(boolean familyRegExp) {
            this.familyRegExp = familyRegExp;
        }

        @XmlElement
        public String getPartNumber() {
            return this.partNumber;
        }

        public void setPartNumber(String partNumber) {
            this.partNumber = partNumber;
        }

        @XmlElement
        public boolean isPartNumberRegExp() {
            return this.partNumberRegExp;
        }

        public void setPartNumberRegExp(boolean partNumberRegExp) {
            this.partNumberRegExp = partNumberRegExp;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsHardwareRule {
        private long id;
        private long group = -1L;
        private String driver = "";
        private String partNumber = "";
        private boolean partNumberRegExp = false;
        private String family = "";
        private boolean familyRegExp = false;
        private Date endOfSale = null;
        private Date endOfLife = null;

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public long getGroup() {
            return this.group;
        }

        public void setGroup(long group) {
            this.group = group;
        }

        @XmlElement
        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        @XmlElement
        public String getPartNumber() {
            return this.partNumber;
        }

        public void setPartNumber(String partNumber) {
            this.partNumber = partNumber;
        }

        @XmlElement
        public boolean isPartNumberRegExp() {
            return this.partNumberRegExp;
        }

        public void setPartNumberRegExp(boolean partNumberRegExp) {
            this.partNumberRegExp = partNumberRegExp;
        }

        @XmlElement
        public String getFamily() {
            return this.family;
        }

        public void setFamily(String family) {
            this.family = family;
        }

        @XmlElement
        public boolean isFamilyRegExp() {
            return this.familyRegExp;
        }

        public void setFamilyRegExp(boolean familyRegExp) {
            this.familyRegExp = familyRegExp;
        }

        @XmlElement(nillable=true)
        public Date getEndOfSale() {
            return this.endOfSale;
        }

        public void setEndOfSale(Date endOfSale) {
            this.endOfSale = endOfSale;
        }

        @XmlElement(nillable=true)
        public Date getEndOfLife() {
            return this.endOfLife;
        }

        public void setEndOfLife(Date endOfLife) {
            this.endOfLife = endOfLife;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsLightPolicyRuleDevice
    extends RsLightDevice {
        private String ruleName;
        private String policyName;
        private Date checkDate;
        private CheckResult.ResultOption result;

        @XmlElement
        public String getRuleName() {
            return this.ruleName;
        }

        @XmlElement
        public String getPolicyName() {
            return this.policyName;
        }

        @XmlElement
        public Date getCheckDate() {
            return this.checkDate;
        }

        @XmlElement
        public CheckResult.ResultOption getResult() {
            return this.result;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public void setCheckDate(Date checkDate) {
            this.checkDate = checkDate;
        }

        public void setResult(CheckResult.ResultOption result) {
            this.result = result;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsGroupSoftwareComplianceStat {
        private long groupId;
        private String groupName;
        private long goldDeviceCount;
        private long silverDeviceCount;
        private long bronzeDeviceCount;
        private long deviceCount;

        @XmlElement
        public long getGroupId() {
            return this.groupId;
        }

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        @XmlElement
        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @XmlElement
        public long getGoldDeviceCount() {
            return this.goldDeviceCount;
        }

        public void setGoldDeviceCount(long goldDeviceCount) {
            this.goldDeviceCount = goldDeviceCount;
        }

        @XmlElement
        public long getSilverDeviceCount() {
            return this.silverDeviceCount;
        }

        public void setSilverDeviceCount(long silverDeviceCount) {
            this.silverDeviceCount = silverDeviceCount;
        }

        @XmlElement
        public long getBronzeDeviceCount() {
            return this.bronzeDeviceCount;
        }

        public void setBronzeDeviceCount(long bronzeDeviceCount) {
            this.bronzeDeviceCount = bronzeDeviceCount;
        }

        @XmlElement
        public long getDeviceCount() {
            return this.deviceCount;
        }

        public void setDeviceCount(long deviceCount) {
            this.deviceCount = deviceCount;
        }
    }

    @XmlType
    public static class RsHardwareSupportEoLStat
    extends RsHardwareSupportStat {
    }

    @XmlType
    public static class RsHardwareSupportEoSStat
    extends RsHardwareSupportStat {
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    @JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY, property="type")
    public static abstract class RsHardwareSupportStat {
        private Date eoxDate;
        private long deviceCount;

        @XmlElement
        public Date getEoxDate() {
            return this.eoxDate;
        }

        public void setEoxDate(Date date) {
            this.eoxDate = date;
        }

        @XmlElement
        public long getDeviceCount() {
            return this.deviceCount;
        }

        public void setDeviceCount(long deviceCount) {
            this.deviceCount = deviceCount;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsGroupConfigComplianceStat {
        private long groupId;
        private String groupName;
        private long compliantDeviceCount;
        private long deviceCount;

        @XmlElement
        public long getGroupId() {
            return this.groupId;
        }

        public void setGroupId(long groupId) {
            this.groupId = groupId;
        }

        @XmlElement
        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @XmlElement
        public long getCompliantDeviceCount() {
            return this.compliantDeviceCount;
        }

        public void setCompliantDeviceCount(long compliantCount) {
            this.compliantDeviceCount = compliantCount;
        }

        @XmlElement
        public long getDeviceCount() {
            return this.deviceCount;
        }

        public void setDeviceCount(long deviceCount) {
            this.deviceCount = deviceCount;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsConfigChangeNumberByDateStat {
        private long changeCount;
        private Date changeDay;

        public RsConfigChangeNumberByDateStat(long changeCount, Date changeDay) {
            this.changeCount = changeCount;
            this.changeDay = changeDay;
        }

        @XmlElement
        public long getChangeCount() {
            return this.changeCount;
        }

        public void setChangeCount(long changes) {
            this.changeCount = changes;
        }

        @XmlElement
        public Date getChangeDay() {
            return this.changeDay;
        }

        public void setChangeDay(Date date) {
            this.changeDay = date;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsDeviceRule {
        private long id = 0L;
        private String ruleName = "";
        private String policyName = "";
        private CheckResult.ResultOption result;
        private String comment = "";
        private Date checkDate;
        private Date expirationDate;

        @XmlElement
        public Long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @XmlElement
        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @XmlElement
        public CheckResult.ResultOption getResult() {
            return this.result;
        }

        public void setResult(CheckResult.ResultOption result) {
            this.result = result;
        }

        @XmlElement
        public Date getCheckDate() {
            return this.checkDate;
        }

        public void setCheckDate(Date checkDate) {
            this.checkDate = checkDate;
        }

        @XmlElement
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
        }

        @XmlElement
        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsLightExemptedDevice
    extends RsLightDevice {
        private Date expirationDate;

        @XmlElement
        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public void setExpirationDate(Date expirationDate) {
            this.expirationDate = expirationDate;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsRuleTestResult {
        private CheckResult.ResultOption result;
        private String scriptError;

        @XmlElement
        public CheckResult.ResultOption getResult() {
            return this.result;
        }

        public void setResult(CheckResult.ResultOption result) {
            this.result = result;
        }

        @XmlElement
        public String getScriptError() {
            return this.scriptError;
        }

        public void setScriptError(String scriptError) {
            this.scriptError = scriptError;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsRuleTest
    extends RsRule {
        private long device = 0L;

        @XmlElement
        public long getDevice() {
            return this.device;
        }

        public void setDevice(long device) {
            this.device = device;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsRule {
        private long id = 0L;
        private String name = null;
        private String type = "";
        private String script = null;
        private long policy = 0L;
        private boolean enabled = false;
        private Map<Long, Date> exemptions = new HashMap<Long, Date>();
        private String text = null;
        private Boolean regExp;
        private String context = null;
        private String driver = null;
        private String field = null;
        private Boolean anyBlock;
        private Boolean matchAll;
        private Boolean invert;

        @XmlElement
        public Long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @XmlElement
        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        @XmlElement
        public Long getPolicy() {
            return this.policy;
        }

        @XmlElement
        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPolicy(long policy) {
            this.policy = policy;
        }

        @XmlElement
        public Map<Long, Date> getExemptions() {
            return this.exemptions;
        }

        public void setExemptions(Map<Long, Date> exemptions) {
            this.exemptions = exemptions;
        }

        @XmlElement
        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        @XmlElement
        public Boolean isRegExp() {
            return this.regExp;
        }

        public void setRegExp(Boolean regExp) {
            this.regExp = regExp;
        }

        @XmlElement
        public String getContext() {
            return this.context;
        }

        public void setContext(String context) {
            this.context = context;
        }

        @XmlElement
        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        @XmlElement
        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        @XmlElement
        public Boolean isInvert() {
            return this.invert;
        }

        public void setInvert(Boolean invert) {
            this.invert = invert;
        }

        @XmlElement
        public Boolean isAnyBlock() {
            return this.anyBlock;
        }

        public void setAnyBlock(Boolean anyBlock) {
            this.anyBlock = anyBlock;
        }

        @XmlElement
        public Boolean isMatchAll() {
            return this.matchAll;
        }

        public void setMatchAll(Boolean matchAll) {
            this.matchAll = matchAll;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsPolicy {
        private long id = 0L;
        private String name = "";
        private long group = 0L;

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public long getGroup() {
            return this.group;
        }

        public void setGroup(long group) {
            this.group = group;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsChangeCriteria {
        private Date fromDate;
        private Date toDate = new Date();

        public RsChangeCriteria() {
            Calendar c = Calendar.getInstance();
            c.setTime(this.toDate);
            c.add(5, -1);
            this.fromDate = c.getTime();
        }

        @XmlElement
        public Date getFromDate() {
            return this.fromDate;
        }

        public void setFromDate(Date fromDate) {
            this.fromDate = fromDate;
        }

        @XmlElement
        public Date getToDate() {
            return this.toDate;
        }

        public void setToDate(Date toDate) {
            this.toDate = toDate;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsConfigChange {
        private String deviceName;
        private long deviceId;
        private Date oldChangeDate;
        private Date newChangeDate;
        private String author;
        private long oldId = 0L;
        private long newId = 0L;

        @XmlElement
        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @XmlElement
        public long getDeviceId() {
            return this.deviceId;
        }

        public void setDeviceId(long deviceId) {
            this.deviceId = deviceId;
        }

        @XmlElement
        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        @XmlElement
        public Date getOldChangeDate() {
            return this.oldChangeDate;
        }

        public void setOldChangeDate(Date oldChangeDate) {
            this.oldChangeDate = oldChangeDate;
        }

        @XmlElement
        public Date getNewChangeDate() {
            return this.newChangeDate;
        }

        public void setNewChangeDate(Date newChangeDate) {
            this.newChangeDate = newChangeDate;
        }

        @XmlElement
        public long getOldId() {
            return this.oldId;
        }

        public void setOldId(long oldId) {
            this.oldId = oldId;
        }

        @XmlElement
        public long getNewId() {
            return this.newId;
        }

        public void setNewId(long newId) {
            this.newId = newId;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsTaskCriteria {
        private String status = "";
        private Date day = new Date();

        @XmlElement
        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        @XmlElement
        public Date getDay() {
            return this.day;
        }

        public void setDay(Date day) {
            this.day = day;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsTask {
        private long id;
        private boolean cancelled = false;
        private String type = "";
        private Long group = new Long(0L);
        private Long device = new Long(0L);
        private Long domain = new Long(0L);
        private String subnets = "";
        private String ipAddresses = "";
        private Date scheduleReference = new Date();
        private Task.ScheduleType scheduleType = Task.ScheduleType.ASAP;
        private String comments = "";
        private int limitToOutofdateDeviceHours = -1;
        private int daysToPurge = 90;
        private int configDaysToPurge = -1;
        private int configSizeToPurge = 0;
        private int configKeepDays = 0;
        private String script = "";
        private String driver;
        private boolean debugEnabled = false;
        private boolean dontRunDiagnostics = false;
        private boolean dontCheckCompliance = false;

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        @XmlElement
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @XmlElement
        public Long getGroup() {
            return this.group;
        }

        public void setGroup(Long group) {
            this.group = group;
        }

        @XmlElement
        public Long getDevice() {
            return this.device;
        }

        public void setDevice(Long device) {
            this.device = device;
        }

        @XmlElement
        public String getSubnets() {
            return this.subnets;
        }

        public void setSubnets(String subnet) {
            this.subnets = subnet;
        }

        @XmlElement
        public Date getScheduleReference() {
            return this.scheduleReference;
        }

        public void setScheduleReference(Date scheduleReference) {
            this.scheduleReference = scheduleReference;
        }

        @XmlElement
        public Task.ScheduleType getScheduleType() {
            return this.scheduleType;
        }

        public void setScheduleType(Task.ScheduleType scheduleType) {
            this.scheduleType = scheduleType;
        }

        @XmlElement
        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        @XmlElement
        public Long getDomain() {
            return this.domain;
        }

        public void setDomain(Long domain) {
            this.domain = domain;
        }

        public String getIpAddresses() {
            return this.ipAddresses;
        }

        public void setIpAddresses(String ipAddresses) {
            this.ipAddresses = ipAddresses;
        }

        @XmlElement
        public int getLimitToOutofdateDeviceHours() {
            return this.limitToOutofdateDeviceHours;
        }

        public void setLimitToOutofdateDeviceHours(int limitToOutofdateDeviceHours) {
            this.limitToOutofdateDeviceHours = limitToOutofdateDeviceHours;
        }

        @XmlElement
        public int getDaysToPurge() {
            return this.daysToPurge;
        }

        public void setDaysToPurge(int days) {
            this.daysToPurge = days;
        }

        @XmlElement
        public String getScript() {
            return this.script;
        }

        public void setScript(String script) {
            this.script = script;
        }

        @XmlElement
        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        @XmlElement
        public int getConfigDaysToPurge() {
            return this.configDaysToPurge;
        }

        public void setConfigDaysToPurge(int configDaysToPurge) {
            this.configDaysToPurge = configDaysToPurge;
        }

        @XmlElement
        public int getConfigSizeToPurge() {
            return this.configSizeToPurge;
        }

        public void setConfigSizeToPurge(int configSizeToPurge) {
            this.configSizeToPurge = configSizeToPurge;
        }

        @XmlElement
        public int getConfigKeepDays() {
            return this.configKeepDays;
        }

        public void setConfigKeepDays(int configKeepDays) {
            this.configKeepDays = configKeepDays;
        }

        @XmlElement
        public boolean isDebugEnabled() {
            return this.debugEnabled;
        }

        public void setDebugEnabled(boolean debugEnabled) {
            this.debugEnabled = debugEnabled;
        }

        @XmlElement
        public boolean isDontRunDiagnostics() {
            return this.dontRunDiagnostics;
        }

        public void setDontRunDiagnostics(boolean dontRunDiagnostics) {
            this.dontRunDiagnostics = dontRunDiagnostics;
        }

        @XmlElement
        public boolean isDontCheckCompliance() {
            return this.dontCheckCompliance;
        }

        public void setDontCheckCompliance(boolean dontCheckCompliance) {
            this.dontCheckCompliance = dontCheckCompliance;
        }
    }

    @XmlRootElement(name="group")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsDeviceGroup {
        private long id = -1L;
        private String type;
        private List<Long> staticDevices = new ArrayList<Long>();
        private String driver;
        private String query;
        private String folder = "";
        private boolean hiddenFromReports = false;

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @XmlElement
        public List<Long> getStaticDevices() {
            return this.staticDevices;
        }

        public void setStaticDevices(List<Long> staticDevices) {
            this.staticDevices = staticDevices;
        }

        @XmlElement
        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        @XmlElement
        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        @XmlElement
        public String getFolder() {
            return this.folder;
        }

        public void setFolder(String folder) {
            this.folder = folder;
        }

        @XmlElement
        public boolean isHiddenFromReports() {
            return this.hiddenFromReports;
        }

        public void setHiddenFromReports(boolean hiddenFromReports) {
            this.hiddenFromReports = hiddenFromReports;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsSearchResults {
        private String query;
        private List<RsLightDevice> devices;

        @XmlElement
        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        @XmlElement
        public List<RsLightDevice> getDevices() {
            return this.devices;
        }

        public void setDevices(List<RsLightDevice> devices) {
            this.devices = devices;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsSearchCriteria {
        private String driver;
        private String query;

        @XmlElement
        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        @XmlElement
        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }
    }

    @XmlRootElement(name="device")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsDevice {
        private long id = -1L;
        private Boolean enabled = null;
        private String comments = null;
        private String ipAddress = null;
        private String connectIpAddress = null;
        private String sshPort;
        private String telnetPort;
        private Boolean autoTryCredentials = null;
        private List<Long> credentialSetIds = null;
        private List<Long> clearCredentialSetIds = null;
        private Long mgmtDomain = null;
        private DeviceCredentialSet specificCredentialSet = null;

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        @XmlElement
        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @XmlElement
        public Boolean isAutoTryCredentials() {
            return this.autoTryCredentials;
        }

        public void setAutoTryCredentials(Boolean autoTryCredentials) {
            this.autoTryCredentials = autoTryCredentials;
        }

        @XmlElement
        public List<Long> getCredentialSetIds() {
            return this.credentialSetIds;
        }

        public void setCredentialSetIds(List<Long> credentialSetIds) {
            this.credentialSetIds = credentialSetIds;
        }

        @XmlElement
        public Boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @XmlElement
        public Long getMgmtDomain() {
            return this.mgmtDomain;
        }

        public void setMgmtDomain(Long mgmtDomain) {
            this.mgmtDomain = mgmtDomain;
        }

        @XmlElement
        public List<Long> getClearCredentialSetIds() {
            return this.clearCredentialSetIds;
        }

        public void setClearCredentialSetIds(List<Long> clearCredentialSetIds) {
            this.clearCredentialSetIds = clearCredentialSetIds;
        }

        @XmlElement
        public String getConnectIpAddress() {
            return this.connectIpAddress;
        }

        public void setConnectIpAddress(String connectIpAddress) {
            this.connectIpAddress = connectIpAddress;
        }

        @XmlElement
        public String getSshPort() {
            return this.sshPort;
        }

        public void setSshPort(String sshPort) {
            this.sshPort = sshPort;
        }

        @XmlElement
        public String getTelnetPort() {
            return this.telnetPort;
        }

        public void setTelnetPort(String telnetPort) {
            this.telnetPort = telnetPort;
        }

        @XmlElement
        public DeviceCredentialSet getSpecificCredentialSet() {
            return this.specificCredentialSet;
        }

        public void setSpecificCredentialSet(DeviceCredentialSet specificCredentialSet) {
            this.specificCredentialSet = specificCredentialSet;
        }
    }

    @XmlRootElement(name="device")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsNewDevice {
        private boolean autoDiscover = true;
        private long autoDiscoveryTask = 0L;
        private String ipAddress = "";
        private long domainId = -1L;
        private String name = "";
        private String deviceType = "";
        private String connectIpAddress = null;
        private String sshPort;
        private String telnetPort;
        private DeviceCredentialSet specificCredentialSet;

        @XmlElement
        public boolean isAutoDiscover() {
            return this.autoDiscover;
        }

        public void setAutoDiscover(boolean autoDiscover) {
            this.autoDiscover = autoDiscover;
        }

        @XmlElement
        public long getAutoDiscoveryTask() {
            return this.autoDiscoveryTask;
        }

        public void setAutoDiscoveryTask(long autoDiscoveryTask) {
            this.autoDiscoveryTask = autoDiscoveryTask;
        }

        @XmlElement
        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @XmlElement
        public long getDomainId() {
            return this.domainId;
        }

        public void setDomainId(long domainId) {
            this.domainId = domainId;
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public String getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        @XmlElement
        public String getConnectIpAddress() {
            return this.connectIpAddress;
        }

        public void setConnectIpAddress(String connectIpAddress) {
            this.connectIpAddress = connectIpAddress;
        }

        @XmlElement
        public String getSshPort() {
            return this.sshPort;
        }

        public void setSshPort(String sshPort) {
            this.sshPort = sshPort;
        }

        @XmlElement
        public String getTelnetPort() {
            return this.telnetPort;
        }

        public void setTelnetPort(String telnetPort) {
            this.telnetPort = telnetPort;
        }

        @XmlElement
        public DeviceCredentialSet getSpecificCredentialSet() {
            return this.specificCredentialSet;
        }

        public void setSpecificCredentialSet(DeviceCredentialSet specificCredentialSet) {
            this.specificCredentialSet = specificCredentialSet;
        }
    }

    @XmlRootElement(name="partNumber")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsPartNumber {
        private String partNumber;

        @XmlElement
        public String getPartNumber() {
            return this.partNumber;
        }

        public void setPartNumber(String partNumber) {
            this.partNumber = partNumber;
        }
    }

    @XmlRootElement(name="deviceType")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsDeviceFamily {
        private String driver;
        private String deviceFamily;

        @XmlElement
        public String getDriver() {
            return this.driver;
        }

        public void setDriver(String driver) {
            this.driver = driver;
        }

        @XmlElement
        public String getDeviceFamily() {
            return this.deviceFamily;
        }

        public void setDeviceFamily(String deviceFamily) {
            this.deviceFamily = deviceFamily;
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsLightDevice {
        private long id;
        private String name;
        private String family;
        private Network4Address mgmtAddress;
        private Device.Status status;

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public String getFamily() {
            return this.family;
        }

        public void setFamily(String family) {
            this.family = family;
        }

        @XmlElement
        public Network4Address getMgmtAddress() {
            return this.mgmtAddress;
        }

        public void setMgmtAddress(Network4Address mgmtAddress) {
            this.mgmtAddress = mgmtAddress;
        }

        @XmlElement
        public Device.Status getStatus() {
            return this.status;
        }

        public void setStatus(Device.Status status) {
            this.status = status;
        }
    }

    @XmlRootElement
    public static class RsConfigDelta {
        private String item;
        private Type diffType;
        private int originalPosition;
        private int revisedPosition;
        private List<String> originalLines;
        private List<String> revisedLines;
        private List<String> preContext;
        private List<String> postContext;

        public RsConfigDelta(Delta<String> delta, List<String> context) {
            switch (delta.getType()) {
                case INSERT: {
                    this.diffType = Type.INSERT;
                    break;
                }
                case DELETE: {
                    this.diffType = Type.DELETE;
                    break;
                }
                default: {
                    this.diffType = Type.CHANGE;
                }
            }
            this.originalPosition = delta.getOriginal().getPosition();
            this.originalLines = delta.getOriginal().getLines();
            this.revisedPosition = delta.getRevised().getPosition();
            this.revisedLines = delta.getRevised().getLines();
            this.preContext = context.subList(Math.max(this.originalPosition - 3, 0), this.originalPosition);
            this.postContext = context.subList(Math.min(this.originalPosition + this.originalLines.size(), context.size() - 1), Math.min(this.originalPosition + this.originalLines.size() + 3, context.size() - 1));
        }

        @XmlElement
        public Type getDiffType() {
            return this.diffType;
        }

        @XmlElement
        public int getOriginalPosition() {
            return this.originalPosition;
        }

        @XmlElement
        public int getRevisedPosition() {
            return this.revisedPosition;
        }

        @XmlElement
        public List<String> getOriginalLines() {
            return this.originalLines;
        }

        @XmlElement
        public List<String> getRevisedLines() {
            return this.revisedLines;
        }

        @XmlElement
        public String getItem() {
            return this.item;
        }

        @XmlElement
        public List<String> getPreContext() {
            return this.preContext;
        }

        @XmlElement
        public List<String> getPostContext() {
            return this.postContext;
        }

        public static enum Type {
            CHANGE,
            DELETE,
            INSERT;

        }
    }

    @XmlRootElement
    public static class RsConfigDiff {
        private Date originalDate;
        private Date revisedDate;
        private Map<String, List<RsConfigDelta>> deltas = new HashMap<String, List<RsConfigDelta>>();

        public RsConfigDiff(Date originalDate, Date revisedDate) {
            this.originalDate = originalDate;
            this.revisedDate = revisedDate;
        }

        public void addDelta(String item, RsConfigDelta delta) {
            if (!this.deltas.containsKey(item)) {
                this.deltas.put(item, new ArrayList());
            }
            this.deltas.get(item).add(delta);
        }

        @XmlElement
        public Date getOriginalDate() {
            return this.originalDate;
        }

        @XmlElement
        public Date getRevisedDate() {
            return this.revisedDate;
        }

        @XmlElement
        public Map<String, List<RsConfigDelta>> getDeltas() {
            return this.deltas;
        }
    }

    @XmlRootElement(name="domain")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsDomain {
        private long id = -1L;
        private String name = "";
        private String description = "";
        private String ipAddress = "";

        @XmlElement
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @XmlElement
        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @XmlElement
        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @XmlElement
        public String getIpAddress() {
            return this.ipAddress;
        }

        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        public RsDomain() {
        }

        public RsDomain(Domain domain) {
            this.id = domain.getId();
            this.name = domain.getName();
            this.description = domain.getDescription();
            this.ipAddress = domain.getServer4Address().getIp();
        }
    }

    public static class NetshotNotAuthorizedException
    extends WebApplicationException {
        private static final long serialVersionUID = -453816975689585686L;

        public NetshotNotAuthorizedException(String message, int errorCode) {
            super(Response.status(Response.Status.FORBIDDEN).entity(new RsErrorBean(message, errorCode)).build());
        }
    }

    public static class NetshotBadRequestException
    extends WebApplicationException {
        public static final int NETSHOT_DATABASE_ACCESS_ERROR = 20;
        public static final int NETSHOT_INVALID_IP_ADDRESS = 100;
        public static final int NETSHOT_MALFORMED_IP_ADDRESS = 101;
        public static final int NETSHOT_INVALID_PORT = 102;
        public static final int NETSHOT_INVALID_DOMAIN = 110;
        public static final int NETSHOT_DUPLICATE_DOMAIN = 111;
        public static final int NETSHOT_INVALID_DOMAIN_NAME = 112;
        public static final int NETSHOT_USED_DOMAIN = 113;
        public static final int NETSHOT_INVALID_TASK = 120;
        public static final int NETSHOT_TASK_NOT_CANCELLABLE = 121;
        public static final int NETSHOT_TASK_CANCEL_ERROR = 122;
        public static final int NETSHOT_USED_CREDENTIALS = 130;
        public static final int NETSHOT_DUPLICATE_CREDENTIALS = 131;
        public static final int NETSHOT_INVALID_CREDENTIALS_TYPE = 132;
        public static final int NETSHOT_CREDENTIALS_NOTFOUND = 133;
        public static final int NETSHOT_INVALID_CREDENTIALS_NAME = 134;
        public static final int NETSHOT_SCHEDULE_ERROR = 30;
        public static final int NETSHOT_DUPLICATE_DEVICE = 140;
        public static final int NETSHOT_USED_DEVICE = 141;
        public static final int NETSHOT_INVALID_DEVICE = 142;
        public static final int NETSHOT_INVALID_CONFIG = 143;
        public static final int NETSHOT_INCOMPATIBLE_CONFIGS = 144;
        public static final int NETSHOT_INVALID_DEVICE_CLASSNAME = 150;
        public static final int NETSHOT_INVALID_SEARCH_STRING = 151;
        public static final int NETSHOT_INVALID_GROUP_NAME = 160;
        public static final int NETSHOT_DUPLICATE_GROUP = 161;
        public static final int NETSHOT_INCOMPATIBLE_GROUP_TYPE = 162;
        public static final int NETSHOT_INVALID_DEVICE_IN_STATICGROUP = 163;
        public static final int NETSHOT_INVALID_GROUP = 164;
        public static final int NETSHOT_INVALID_DYNAMICGROUP_QUERY = 165;
        public static final int NETSHOT_INVALID_SUBNET = 170;
        public static final int NETSHOT_SCAN_SUBNET_TOO_BIG = 171;
        public static final int NETSHOT_INVALID_POLICY_NAME = 180;
        public static final int NETSHOT_INVALID_POLICY = 181;
        public static final int NETSHOT_DUPLICATE_POLICY = 182;
        public static final int NETSHOT_INVALID_RULE_NAME = 190;
        public static final int NETSHOT_INVALID_RULE = 191;
        public static final int NETSHOT_DUPLICATE_RULE = 192;
        public static final int NETSHOT_INVALID_USER = 200;
        public static final int NETSHOT_DUPLICATE_USER = 201;
        public static final int NETSHOT_INVALID_USER_NAME = 202;
        public static final int NETSHOT_INVALID_PASSWORD = 203;
        public static final int NETSHOT_INVALID_SCRIPT = 220;
        public static final int NETSHOT_UNKNOWN_SCRIPT = 221;
        public static final int NETSHOT_DUPLICATE_SCRIPT = 222;
        public static final int NETSHOT_INVALID_DIAGNOSTIC_NAME = 230;
        public static final int NETSHOT_DUPLICATE_DIAGNOSTIC = 231;
        public static final int NETSHOT_INVALID_DIAGNOSTIC_TYPE = 232;
        public static final int NETSHOT_INVALID_DIAGNOSTIC = 233;
        public static final int NETSHOT_INCOMPATIBLE_DIAGNOSTIC = 234;
        private static final long serialVersionUID = -4538169756895835186L;

        public NetshotBadRequestException(String message, int errorCode) {
            super(Response.status(Response.Status.BAD_REQUEST).entity(new RsErrorBean(message, errorCode)).build());
        }
    }

    public static class NetshotAuthenticationRequiredException
    extends WebApplicationException {
        private static final long serialVersionUID = -2463854660543944995L;

        public NetshotAuthenticationRequiredException() {
            super(Response.status(Response.Status.UNAUTHORIZED).build());
        }
    }

    @XmlRootElement(name="error")
    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class RsErrorBean {
        private String errorMsg;
        private int errorCode;

        public RsErrorBean() {
        }

        public RsErrorBean(String errorMsg, int errorCode) {
            this.errorMsg = errorMsg;
            this.errorCode = errorCode;
        }

        @XmlElement
        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        @XmlElement
        public int getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }
    }

    public static class NetshotWebApplication
    extends ResourceConfig {
        public NetshotWebApplication() {
            this.registerClasses(RestService.class, SecurityFilter.class);
            this.register((Class)NetshotExceptionMapper.class);
            this.register((Class)RolesAllowedDynamicFeature.class);
            this.property("jersey.config.server.response.setStatusOverSendError", "true");
            this.property("jersey.config.server.application.name", "Plumber");
            this.register((Class)JacksonFeature.class);
        }
    }

    public static class NetshotExceptionMapper
    implements ExceptionMapper<Throwable> {
        @Override
        public Response toResponse(Throwable t) {
            if (!(t instanceof ForbiddenException)) {
                if (t instanceof NetshotAuthenticationRequiredException) {
                    logger.info("Authentication required.", t);
                } else {
                    logger.error("Uncaught exception thrown by REST service", t);
                }
            }
            if (t instanceof WebApplicationException) {
                return ((WebApplicationException)t).getResponse();
            }
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Priority(value=2000)
    @PreMatching
    private static class SecurityFilter
    implements ContainerRequestFilter {
        @Context
        private HttpServletRequest httpRequest;
        @Inject
        Provider<UriInfo> uriInfo;

        private SecurityFilter() {
        }

        @Override
        public void filter(ContainerRequestContext requestContext) throws IOException {
            User user = (User)this.httpRequest.getSession().getAttribute("user");
            Netshot.aaaLogger.info("HTTP Request {} by user {}.", (Object)requestContext.getUriInfo().getRequestUri(), (Object)(user == null ? "<null>" : user.getUsername()));
            requestContext.setSecurityContext(new Authorizer(user));
        }

        private class Authorizer
        implements SecurityContext {
            private User user;

            public Authorizer(User user) {
                this.user = user;
            }

            @Override
            public boolean isUserInRole(String role) {
                boolean result = this.user != null && ("admin".equals(role) && this.user.getLevel() >= 1000 || "executereadwrite".equals(role) && this.user.getLevel() >= 500 || "readwrite".equals(role) && this.user.getLevel() >= 100 || "readonly".equals(role) && this.user.getLevel() >= 10);
                Netshot.aaaLogger.debug("Role {} requested for user {}: result {}.", role, this.user == null ? "<null>" : this.user.getUsername(), result);
                return result;
            }

            @Override
            public boolean isSecure() {
                return "https".equals(SecurityFilter.this.uriInfo.get().getRequestUri().getScheme());
            }

            @Override
            public Principal getUserPrincipal() {
                return this.user;
            }

            @Override
            public String getAuthenticationScheme() {
                return "FORM";
            }
        }
    }
}

