/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.googlejavaformat.java.CommandLineOptions;
import java.util.Iterator;
import java.util.List;

final class CommandLineOptionsParser {
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');

    CommandLineOptionsParser() {
    }

    static CommandLineOptions parse(Iterable<String> options) {
        CommandLineOptions.Builder optionsBuilder = CommandLineOptions.builder();
        Iterator<String> it = options.iterator();
        block38: while (it.hasNext()) {
            String value;
            String flag;
            String option = it.next();
            if (!option.startsWith("-")) {
                optionsBuilder.filesBuilder().add((Object)option).addAll(it);
                break;
            }
            int idx = option.indexOf(61);
            if (idx >= 0) {
                flag = option.substring(0, idx);
                value = option.substring(idx + 1, option.length());
            } else {
                flag = option;
                value = null;
            }
            switch (flag) {
                case "-i": 
                case "-r": 
                case "-replace": 
                case "--replace": {
                    optionsBuilder.inPlace(true);
                    continue block38;
                }
                case "--lines": 
                case "-lines": 
                case "--line": 
                case "-line": {
                    CommandLineOptionsParser.parseRangeSet(optionsBuilder.linesBuilder(), CommandLineOptionsParser.getValue(flag, it, value));
                    continue block38;
                }
                case "--offset": 
                case "-offset": {
                    optionsBuilder.offsetsBuilder().add((Object)CommandLineOptionsParser.parseInteger(it, flag, value));
                    continue block38;
                }
                case "--length": 
                case "-length": {
                    optionsBuilder.lengthsBuilder().add((Object)CommandLineOptionsParser.parseInteger(it, flag, value));
                    continue block38;
                }
                case "--aosp": 
                case "-aosp": 
                case "-a": {
                    optionsBuilder.aosp(true);
                    continue block38;
                }
                case "--version": 
                case "-version": 
                case "-v": {
                    optionsBuilder.version(true);
                    continue block38;
                }
                case "--help": 
                case "-help": 
                case "-h": {
                    optionsBuilder.help(true);
                    continue block38;
                }
                case "--fix-imports-only": {
                    optionsBuilder.fixImportsOnly(true);
                    continue block38;
                }
                case "--experimental-remove-javadoc-only-imports": {
                    optionsBuilder.removeJavadocOnlyImports(true);
                    continue block38;
                }
                case "-": {
                    optionsBuilder.stdin(true);
                    continue block38;
                }
            }
            throw new IllegalArgumentException("unexpected flag: " + flag);
        }
        return optionsBuilder.build();
    }

    private static Integer parseInteger(Iterator<String> it, String flag, String value) {
        try {
            return Integer.valueOf(CommandLineOptionsParser.getValue(flag, it, value));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("invalid integer value for %s: %s", flag, value), e);
        }
    }

    private static String getValue(String flag, Iterator<String> it, String value) {
        if (value != null) {
            return value;
        }
        if (!it.hasNext()) {
            throw new IllegalArgumentException("required value was not provided for: " + flag);
        }
        return it.next();
    }

    private static void parseRangeSet(ImmutableRangeSet.Builder<Integer> result, String ranges) {
        for (String range : COMMA_SPLITTER.split((CharSequence)ranges)) {
            result.add(CommandLineOptionsParser.parseRange(range));
        }
    }

    private static Range<Integer> parseRange(String arg) {
        List args = COLON_SPLITTER.splitToList((CharSequence)arg);
        switch (args.size()) {
            case 1: {
                int line = Integer.parseInt((String)args.get(0)) - 1;
                return Range.closedOpen((Comparable)Integer.valueOf(line), (Comparable)Integer.valueOf(line + 1));
            }
            case 2: {
                int line0 = Integer.parseInt((String)args.get(0)) - 1;
                int line1 = Integer.parseInt((String)args.get(1)) - 1;
                return Range.closedOpen((Comparable)Integer.valueOf(line0), (Comparable)Integer.valueOf(line1 + 1));
            }
        }
        throw new IllegalArgumentException(arg);
    }
}

