/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.pipeline;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.logstash.plugins.pipeline.PipelineInput;
import org.logstash.plugins.pipeline.PipelineOutput;

public class AddressState {
    private final String address;
    private final Set<PipelineOutput> outputs = ConcurrentHashMap.newKeySet();
    private volatile PipelineInput input = null;

    AddressState(String address) {
        this.address = address;
    }

    public boolean addOutput(PipelineOutput output) {
        return this.outputs.add(output);
    }

    public boolean removeOutput(PipelineOutput output) {
        return this.outputs.remove(output);
    }

    public PipelineInput getInput() {
        return this.input;
    }

    public synchronized boolean assignInputIfMissing(PipelineInput newInput) {
        if (this.input == null) {
            this.input = newInput;
            return true;
        }
        return this.input == newInput;
    }

    public synchronized boolean unassignInput(PipelineInput unsubscribingInput) {
        if (this.input != unsubscribingInput) {
            return false;
        }
        this.input = null;
        return true;
    }

    public boolean isRunning() {
        return this.input != null && this.input.isRunning();
    }

    public boolean isEmpty() {
        return this.input == null && this.outputs.isEmpty();
    }

    boolean hasOutput(PipelineOutput output) {
        return this.outputs.contains(output);
    }

    public Set<PipelineOutput> getOutputs() {
        return this.outputs;
    }
}

