/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.pipeline;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.witness.MetricSerializer;
import org.logstash.instrument.witness.SerializableWitness;

@JsonSerialize(using=Serializer.class)
public final class EventsWitness
implements SerializableWitness {
    private LongCounter filtered = new LongCounter("filtered");
    private LongCounter out = new LongCounter("out");
    private LongCounter in = new LongCounter("in");
    private LongCounter duration = new LongCounter("duration_in_millis");
    private LongCounter queuePushDuration = new LongCounter("queue_push_duration_in_millis");
    private static final String KEY = "events";
    private final Snitch snitch = new Snitch(this);

    public void duration(long durationToAdd) {
        this.duration.increment(durationToAdd);
    }

    public void filtered() {
        this.filtered.increment();
    }

    public void filtered(long count) {
        this.filtered.increment(count);
    }

    public void forgetAll() {
        this.filtered.reset();
        this.out.reset();
        this.in.reset();
        this.duration.reset();
        this.queuePushDuration.reset();
    }

    public void in() {
        this.in.increment();
    }

    public void in(long count) {
        this.in.increment(count);
    }

    public void out() {
        this.out.increment();
    }

    public void out(long count) {
        this.out.increment(count);
    }

    public Snitch snitch() {
        return this.snitch;
    }

    public void queuePushDuration(long durationToAdd) {
        this.queuePushDuration.increment(durationToAdd);
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen);
    }

    public static final class Snitch {
        private final EventsWitness witness;

        private Snitch(EventsWitness witness) {
            this.witness = witness;
        }

        public long duration() {
            return this.witness.duration.getValue();
        }

        public long filtered() {
            return this.witness.filtered.getValue();
        }

        public long in() {
            return this.witness.in.getValue();
        }

        public long out() {
            return this.witness.out.getValue();
        }

        public long queuePushDuration() {
            return this.witness.queuePushDuration.getValue();
        }
    }

    public static final class Serializer
    extends StdSerializer<EventsWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(EventsWitness.class);
        }

        private Serializer(Class<EventsWitness> t) {
            super(t);
        }

        public void serialize(EventsWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen);
            gen.writeEndObject();
        }

        static void innerSerialize(EventsWitness witness, JsonGenerator gen) throws IOException {
            gen.writeObjectFieldStart(EventsWitness.KEY);
            MetricSerializer<Metric<Long>> longSerializer = MetricSerializer.Get.longSerializer(gen);
            longSerializer.serialize(witness.duration);
            longSerializer.serialize(witness.in);
            longSerializer.serialize(witness.out);
            longSerializer.serialize(witness.filtered);
            longSerializer.serialize(witness.queuePushDuration);
            gen.writeEndObject();
        }
    }
}

