/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.witness.configuration;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.logstash.instrument.metrics.Metric;
import org.logstash.instrument.metrics.gauge.BooleanGauge;
import org.logstash.instrument.metrics.gauge.NumberGauge;
import org.logstash.instrument.metrics.gauge.TextGauge;
import org.logstash.instrument.witness.MetricSerializer;
import org.logstash.instrument.witness.SerializableWitness;

@JsonSerialize(using=Serializer.class)
public final class ConfigWitness
implements SerializableWitness {
    private final BooleanGauge deadLetterQueueEnabled = new BooleanGauge("dead_letter_queue_enabled");
    private final BooleanGauge configReloadAutomatic = new BooleanGauge("config_reload_automatic");
    private final NumberGauge batchSize = new NumberGauge("batch_size");
    private final NumberGauge workers = new NumberGauge("workers");
    private final NumberGauge batchDelay = new NumberGauge("batch_delay");
    private final NumberGauge configReloadInterval = new NumberGauge("config_reload_interval");
    private final TextGauge deadLetterQueuePath = new TextGauge("dead_letter_queue_path");
    private final Snitch snitch = new Snitch(this);
    private static final String KEY = "config";

    public void batchDelay(long delay) {
        this.batchDelay.set(delay);
    }

    public void batchSize(long size) {
        this.batchSize.set(size);
    }

    public void configReloadAutomatic(boolean isAuto) {
        this.configReloadAutomatic.set(isAuto);
    }

    public void configReloadInterval(long interval) {
        this.configReloadInterval.set(interval);
    }

    public void deadLetterQueueEnabled(boolean enabled) {
        this.deadLetterQueueEnabled.set(enabled);
    }

    public void deadLetterQueuePath(String path) {
        this.deadLetterQueuePath.set(path);
    }

    public void workers(long workers) {
        this.workers.set(workers);
    }

    public Snitch snitch() {
        return this.snitch;
    }

    @Override
    public void genJson(JsonGenerator gen, SerializerProvider provider) throws IOException {
        Serializer.innerSerialize(this, gen);
    }

    public static final class Snitch {
        private final ConfigWitness witness;

        private Snitch(ConfigWitness witness) {
            this.witness = witness;
        }

        public Number batchDelay() {
            return (Number)this.witness.batchDelay.getValue();
        }

        public Number batchSize() {
            return (Number)this.witness.batchSize.getValue();
        }

        public boolean configReloadAutomatic() {
            Boolean reload = (Boolean)this.witness.configReloadAutomatic.getValue();
            return reload == null ? false : reload;
        }

        public Number configReloadInterval() {
            return (Number)this.witness.configReloadInterval.getValue();
        }

        public boolean deadLetterQueueEnabled() {
            Boolean enabled = (Boolean)this.witness.deadLetterQueueEnabled.getValue();
            return enabled == null ? false : enabled;
        }

        public String deadLetterQueuePath() {
            return (String)this.witness.deadLetterQueuePath.getValue();
        }

        public Number workers() {
            return (Number)this.witness.workers.getValue();
        }
    }

    public static final class Serializer
    extends StdSerializer<ConfigWitness> {
        private static final long serialVersionUID = 1L;

        public Serializer() {
            this(ConfigWitness.class);
        }

        private Serializer(Class<ConfigWitness> t) {
            super(t);
        }

        public void serialize(ConfigWitness witness, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeStartObject();
            Serializer.innerSerialize(witness, gen);
            gen.writeEndObject();
        }

        static void innerSerialize(ConfigWitness witness, JsonGenerator gen) throws IOException {
            gen.writeObjectFieldStart(ConfigWitness.KEY);
            MetricSerializer<Metric<Number>> numberSerializer = MetricSerializer.Get.numberSerializer(gen);
            MetricSerializer<Metric<Boolean>> booleanSerializer = MetricSerializer.Get.booleanSerializer(gen);
            MetricSerializer<Metric<String>> stringSerializer = MetricSerializer.Get.stringSerializer(gen);
            numberSerializer.serialize(witness.batchSize);
            numberSerializer.serialize(witness.workers);
            numberSerializer.serialize(witness.batchDelay);
            numberSerializer.serialize(witness.configReloadInterval);
            booleanSerializer.serialize(witness.configReloadAutomatic);
            booleanSerializer.serialize(witness.deadLetterQueueEnabled);
            stringSerializer.serialize(witness.deadLetterQueuePath);
            gen.writeEndObject();
        }
    }
}

