/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.logstash.common.Util;
import org.logstash.config.ir.Hashable;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.PluginDefinition;
import org.logstash.config.ir.graph.Graph;
import org.logstash.config.ir.graph.PluginVertex;
import org.logstash.config.ir.graph.QueueVertex;
import org.logstash.config.ir.graph.Vertex;

public final class PipelineIR
implements Hashable {
    private final String uniqueHash;
    private final Graph graph;
    private final QueueVertex queue;
    private final String originalSource;

    public Graph getGraph() {
        return this.graph;
    }

    public QueueVertex getQueue() {
        return this.queue;
    }

    public PipelineIR(Graph inputSection, Graph filterSection, Graph outputSection) throws InvalidIRException {
        this(inputSection, filterSection, outputSection, null);
    }

    public PipelineIR(Graph inputSection, Graph filterSection, Graph outputSection, String originalSource) throws InvalidIRException {
        this.originalSource = originalSource;
        Graph tempGraph = inputSection.copy();
        this.queue = new QueueVertex();
        tempGraph = tempGraph.chain(this.queue);
        tempGraph = tempGraph.chain(filterSection);
        this.graph = tempGraph.chain(outputSection);
        this.graph.validate();
        this.uniqueHash = this.getOriginalSource() != null && !this.getOriginalSource().matches("^\\s+$") ? Util.digest(this.getOriginalSource()) : this.graph.uniqueHash();
    }

    public String getOriginalSource() {
        return this.originalSource;
    }

    public List<Vertex> getPostQueue() {
        return this.graph.getSortedVerticesAfter(this.queue);
    }

    public List<PluginVertex> getInputPluginVertices() {
        return this.getPluginVertices(PluginDefinition.Type.INPUT);
    }

    public List<PluginVertex> getFilterPluginVertices() {
        return this.getPluginVertices(PluginDefinition.Type.FILTER);
    }

    public List<PluginVertex> getOutputPluginVertices() {
        return this.getPluginVertices(PluginDefinition.Type.OUTPUT);
    }

    public String toString() {
        String summary = String.format("[Pipeline] Inputs: %d Filters: %d Outputs %d", this.getInputPluginVertices().size(), this.getFilterPluginVertices().size(), this.getOutputPluginVertices().size());
        return summary + "\n" + this.graph.toString();
    }

    public Stream<PluginVertex> pluginVertices(PluginDefinition.Type type) {
        return this.pluginVertices().filter(v -> v.getPluginDefinition().getType().equals((Object)type));
    }

    public List<PluginVertex> getPluginVertices(PluginDefinition.Type type) {
        return this.pluginVertices(type).collect(Collectors.toList());
    }

    public List<PluginVertex> getPluginVertices() {
        return this.pluginVertices().collect(Collectors.toList());
    }

    public Stream<PluginVertex> pluginVertices() {
        return this.graph.vertices().filter(v -> v instanceof PluginVertex).map(v -> (PluginVertex)v);
    }

    @Override
    public String uniqueHash() {
        return this.uniqueHash;
    }
}

