/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import com.microsoft.azure.eventhubs.impl.SchedulerProvider;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;

final class Timer {
    final SchedulerProvider schedulerProvider;

    public Timer(SchedulerProvider schedulerProvider) {
        this.schedulerProvider = schedulerProvider;
    }

    public CompletableFuture<?> schedule(Runnable runnable, Duration runAfter) {
        ScheduledTask scheduledTask = new ScheduledTask(runnable);
        CompletableFuture<?> taskHandle = scheduledTask.getScheduledFuture();
        try {
            this.schedulerProvider.getReactorScheduler().invoke((int)runAfter.toMillis(), scheduledTask);
        }
        catch (IOException | RejectedExecutionException e) {
            taskHandle.completeExceptionally(e);
        }
        return taskHandle;
    }

    static final class ScheduledTask
    extends DispatchHandler {
        final CompletableFuture<?> scheduledFuture;
        final Runnable runnable;

        public ScheduledTask(Runnable runnable) {
            this.runnable = runnable;
            this.scheduledFuture = new CompletableFuture();
        }

        @Override
        public void onEvent() {
            if (!this.scheduledFuture.isCancelled()) {
                try {
                    this.runnable.run();
                    this.scheduledFuture.complete(null);
                }
                catch (Exception exception) {
                    this.scheduledFuture.completeExceptionally(exception);
                }
            }
        }

        public CompletableFuture<?> getScheduledFuture() {
            return this.scheduledFuture;
        }
    }
}

