/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.IllegalConnectionStringFormatException;
import com.microsoft.azure.eventhubs.impl.MessagingFactory;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ConnectionStringBuilder {
    static final String endpointFormat = "sb://%s.%s";
    static final String hostnameFormat = "sb://%s";
    static final String defaultDomainName = "servicebus.windows.net";
    static final String HostnameConfigName = "Hostname";
    static final String EndpointConfigName = "Endpoint";
    static final String EntityPathConfigName = "EntityPath";
    static final String OperationTimeoutConfigName = "OperationTimeout";
    static final String KeyValueSeparator = "=";
    static final String KeyValuePairDelimiter = ";";
    static final String SharedAccessKeyNameConfigName = "SharedAccessKeyName";
    static final String SharedAccessKeyConfigName = "SharedAccessKey";
    static final String SharedAccessSignatureConfigName = "SharedAccessSignature";
    private static final String AllKeyEnumerateRegex = "(Hostname|Endpoint|SharedAccessKeyName|SharedAccessKey|SharedAccessSignature|EntityPath|OperationTimeout|)";
    private static final String KeysWithDelimitersRegex = ";(Hostname|Endpoint|SharedAccessKeyName|SharedAccessKey|SharedAccessSignature|EntityPath|OperationTimeout|)=";
    private URI endpoint;
    private String eventHubName;
    private String sharedAccessKeyName;
    private String sharedAccessKey;
    private String sharedAccessSignature;
    private Duration operationTimeout;

    public ConnectionStringBuilder() {
    }

    public ConnectionStringBuilder(String connectionString) {
        this.parseConnectionString(connectionString);
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public ConnectionStringBuilder setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public ConnectionStringBuilder setEndpoint(String namespaceName, String domainName) {
        try {
            this.endpoint = new URI(String.format(Locale.US, endpointFormat, namespaceName, domainName));
        }
        catch (URISyntaxException exception) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Invalid namespace name: %s", namespaceName), exception);
        }
        return this;
    }

    public ConnectionStringBuilder setNamespaceName(String namespaceName) {
        return this.setEndpoint(namespaceName, defaultDomainName);
    }

    public String getEventHubName() {
        return this.eventHubName;
    }

    public ConnectionStringBuilder setEventHubName(String eventHubName) {
        this.eventHubName = eventHubName;
        return this;
    }

    public String getSasKey() {
        return this.sharedAccessKey;
    }

    public ConnectionStringBuilder setSasKey(String sasKey) {
        this.sharedAccessKey = sasKey;
        return this;
    }

    public String getSasKeyName() {
        return this.sharedAccessKeyName;
    }

    public ConnectionStringBuilder setSasKeyName(String sasKeyName) {
        this.sharedAccessKeyName = sasKeyName;
        return this;
    }

    public String getSharedAccessSignature() {
        return this.sharedAccessSignature;
    }

    public ConnectionStringBuilder setSharedAccessSignature(String sharedAccessSignature) {
        this.sharedAccessSignature = sharedAccessSignature;
        return this;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout == null ? MessagingFactory.DefaultOperationTimeout : this.operationTimeout;
    }

    public ConnectionStringBuilder setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    public String toString() {
        StringBuilder connectionStringBuilder = new StringBuilder();
        if (this.endpoint != null) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", EndpointConfigName, KeyValueSeparator, this.endpoint.toString(), KeyValuePairDelimiter));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.eventHubName)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", EntityPathConfigName, KeyValueSeparator, this.eventHubName, KeyValuePairDelimiter));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKeyName)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SharedAccessKeyNameConfigName, KeyValueSeparator, this.sharedAccessKeyName, KeyValuePairDelimiter));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessKey)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SharedAccessKeyConfigName, KeyValueSeparator, this.sharedAccessKey, KeyValuePairDelimiter));
        }
        if (!StringUtil.isNullOrWhiteSpace(this.sharedAccessSignature)) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", SharedAccessSignatureConfigName, KeyValueSeparator, this.sharedAccessSignature, KeyValuePairDelimiter));
        }
        if (this.operationTimeout != null) {
            connectionStringBuilder.append(String.format(Locale.US, "%s%s%s%s", OperationTimeoutConfigName, KeyValueSeparator, this.operationTimeout.toString(), KeyValuePairDelimiter));
        }
        connectionStringBuilder.deleteCharAt(connectionStringBuilder.length() - 1);
        return connectionStringBuilder.toString();
    }

    private void parseConnectionString(String connectionString) {
        if (StringUtil.isNullOrWhiteSpace(connectionString)) {
            throw new IllegalConnectionStringFormatException("connectionString cannot be empty");
        }
        String connection = KeyValuePairDelimiter + connectionString;
        Pattern keyValuePattern = Pattern.compile(KeysWithDelimitersRegex, 2);
        String[] values = keyValuePattern.split(connection);
        Matcher keys = keyValuePattern.matcher(connection);
        if (values == null || values.length <= 1 || keys.groupCount() == 0) {
            throw new IllegalConnectionStringFormatException("Connection String cannot be parsed.");
        }
        if (!StringUtil.isNullOrWhiteSpace(values[0])) {
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Cannot parse part of ConnectionString: %s", values[0]));
        }
        int valueIndex = 0;
        while (keys.find()) {
            String key = keys.group();
            key = key.substring(1, key.length() - 1);
            if (values.length < ++valueIndex + 1) {
                throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Value for the connection string parameter name: %s, not found", key));
            }
            if (key.equalsIgnoreCase(EndpointConfigName)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", EndpointConfigName, HostnameConfigName));
                }
                try {
                    this.endpoint = new URI(values[valueIndex]);
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be in format scheme://fullyQualifiedServiceBusNamespaceEndpointName", EndpointConfigName), exception);
                }
            }
            if (key.equalsIgnoreCase(HostnameConfigName)) {
                if (this.endpoint != null) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Multiple %s and/or %s detected. Make sure only one is defined", EndpointConfigName, HostnameConfigName));
                }
                try {
                    this.endpoint = new URI(String.format(Locale.US, hostnameFormat, values[valueIndex]));
                    continue;
                }
                catch (URISyntaxException exception) {
                    throw new IllegalConnectionStringFormatException(String.format(Locale.US, "%s should be a fully quantified host name address", HostnameConfigName), exception);
                }
            }
            if (key.equalsIgnoreCase(SharedAccessKeyNameConfigName)) {
                this.sharedAccessKeyName = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SharedAccessKeyConfigName)) {
                this.sharedAccessKey = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(SharedAccessSignatureConfigName)) {
                this.sharedAccessSignature = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(EntityPathConfigName)) {
                this.eventHubName = values[valueIndex];
                continue;
            }
            if (key.equalsIgnoreCase(OperationTimeoutConfigName)) {
                try {
                    this.operationTimeout = Duration.parse(values[valueIndex]);
                    continue;
                }
                catch (DateTimeParseException exception) {
                    throw new IllegalConnectionStringFormatException("Invalid value specified for property 'Duration' in the ConnectionString.", exception);
                }
            }
            throw new IllegalConnectionStringFormatException(String.format(Locale.US, "Illegal connection string parameter name: %s", key));
        }
    }
}

