/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

final class SeekableByteChannelImpl
extends AbstractInterruptibleChannel
implements ReadableByteChannel,
SeekableByteChannel {
    private final ByteArrayInputStream in;
    private final int mark;
    private final int count;
    private int truncatedBy = 0;
    static final boolean USABLE;
    private static final Field posField;
    private static final Field countField;
    private static final Field markField;

    SeekableByteChannelImpl(ByteArrayInputStream in) {
        this.in = in;
        this.mark = SeekableByteChannelImpl.mark(in);
        this.count = SeekableByteChannelImpl.count(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(ByteBuffer target) throws IOException {
        int available = this.in.available() - this.truncatedBy;
        if (available <= 0) {
            return 0;
        }
        int maxToRead = target.remaining();
        int readCount = 0;
        if (maxToRead > available) {
            maxToRead = available;
        }
        byte[] readBytes = new byte[maxToRead];
        try {
            this.begin();
            readCount = this.in.read(readBytes);
            this.end(readCount >= 0);
        }
        catch (Throwable throwable) {
            this.end(readCount >= 0);
            throw throwable;
        }
        if (readCount > 0) {
            target.put(readBytes, 0, readCount);
        }
        return readCount;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.in.close();
    }

    @Override
    public long position() {
        return SeekableByteChannelImpl.pos(this.in) - this.mark;
    }

    @Override
    public synchronized SeekableByteChannel position(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("negative new position: " + newPosition);
        }
        if (newPosition > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("can not set new position: " + newPosition + " too big!");
        }
        this.in.reset();
        if (newPosition > 0L) {
            this.in.skip(newPosition);
        }
        return this;
    }

    @Override
    public long size() {
        return Math.max(this.count - this.truncatedBy, 0);
    }

    @Override
    public SeekableByteChannel truncate(long size2) throws IOException {
        if (size2 < 0L) {
            throw new IllegalArgumentException("negative truncate size given: " + size2);
        }
        int s2 = Math.min((int)this.size(), size2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)size2);
        this.truncatedBy += s2;
        return this;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException("write not supported");
    }

    private static int pos(ByteArrayInputStream in) {
        return SeekableByteChannelImpl.readIntField(in, posField);
    }

    private static int count(ByteArrayInputStream in) {
        return SeekableByteChannelImpl.readIntField(in, countField);
    }

    private static int mark(ByteArrayInputStream in) {
        return SeekableByteChannelImpl.readIntField(in, markField);
    }

    private static int readIntField(ByteArrayInputStream self2, Field field2) {
        try {
            return field2.getInt(self2);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static Field accessibleField(String name2) {
        try {
            Field field2 = ByteArrayInputStream.class.getDeclaredField(name2);
            field2.setAccessible(true);
            return field2;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    static {
        posField = SeekableByteChannelImpl.accessibleField("pos");
        if (posField != null) {
            countField = SeekableByteChannelImpl.accessibleField("count");
            markField = SeekableByteChannelImpl.accessibleField("mark");
            USABLE = true;
        } else {
            markField = null;
            countField = null;
            USABLE = false;
        }
    }
}

