/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.InputStream;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOInputStream
extends InputStream {
    private final IRubyObject io;
    private final InputStream in;
    private final IRubyObject numOne;
    private static final CallSite readAdapter = MethodIndex.getFunctionalCallSite("read");
    private static final CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    public IOInputStream(IRubyObject io2) {
        if (!io2.respondsTo("read")) {
            throw new IllegalArgumentException("Object: " + io2 + " is not a legal argument to this wrapper, cause it doesn't respond to \"read\".");
        }
        this.io = io2;
        this.in = io2 instanceof RubyIO && !((RubyIO)io2).isClosed() && ((RubyIO)io2).isBuiltin("read") ? ((RubyIO)io2).getInStream() : null;
        this.numOne = RubyFixnum.one(this.io.getRuntime());
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        } else if (this.io.respondsTo("close")) {
            closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.in != null) {
            return this.in.available();
        }
        return 0;
    }

    @Override
    public int read() throws IOException {
        if (this.in != null) {
            return this.in.read();
        }
        IRubyObject readValue = readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, this.numOne);
        int returnValue = -1;
        if (!readValue.isNil()) {
            returnValue = readValue.convertToString().getByteList().get(0) & 0xFF;
        }
        return returnValue;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        if (this.in != null) {
            return this.in.read(b2, 0, b2.length);
        }
        IRubyObject readValue = readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, (IRubyObject)this.io.getRuntime().newFixnum(b2.length));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = readValue.convertToString().getByteList();
            System.arraycopy(str.getUnsafeBytes(), str.getBegin(), b2, 0, str.getRealSize());
            returnValue = str.getRealSize();
        }
        return returnValue;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.in != null) {
            return this.in.read(b2, off, len);
        }
        IRubyObject readValue = readAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, this.io, (IRubyObject)this.io.getRuntime().newFixnum(len));
        int returnValue = -1;
        if (!readValue.isNil()) {
            ByteList str = readValue.convertToString().getByteList();
            System.arraycopy(str.getUnsafeBytes(), str.getBegin(), b2, off, str.getRealSize());
            returnValue = str.getRealSize();
        }
        return returnValue;
    }
}

