/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.invokers.RubyToJavaInvoker;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.javasupport.proxy.JavaProxyClassFactory;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;

@JRubyClass(name={"Java::JavaProxyConstructor"})
public class JavaProxyConstructor
extends JavaProxyReflectionObject
implements ParameterTypes {
    private final Constructor<?> proxyConstructor;
    private final Class<?>[] actualParameterTypes;
    private final boolean actualVarArgs;
    private final JavaProxyClass declaringProxyClass;

    public static RubyClass createJavaProxyConstructorClass(Ruby runtime, RubyModule Java2) {
        RubyClass JavaProxyConstructor2 = Java2.defineClassUnder("JavaProxyConstructor", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(runtime, JavaProxyConstructor2);
        JavaProxyConstructor2.defineAnnotatedMethods(JavaProxyConstructor.class);
        return JavaProxyConstructor2;
    }

    JavaProxyConstructor(Ruby runtime, JavaProxyClass proxyClass, Constructor<?> constructor2) {
        super(runtime, runtime.getJavaSupport().getJavaProxyConstructorClass());
        this.declaringProxyClass = proxyClass;
        this.proxyConstructor = constructor2;
        Class[] parameterTypes = constructor2.getParameterTypes();
        this.actualParameterTypes = ArraySupport.newCopy(parameterTypes, parameterTypes.length - 1);
        this.actualVarArgs = JavaProxyClassFactory.isVarArgs(this.proxyConstructor);
    }

    @Override
    public final Class<?>[] getParameterTypes() {
        return this.actualParameterTypes;
    }

    @Override
    public final Class<?>[] getExceptionTypes() {
        return this.proxyConstructor.getExceptionTypes();
    }

    @Override
    public final boolean isVarArgs() {
        return this.actualVarArgs;
    }

    @JRubyMethod(name={"declaring_class"})
    public JavaProxyClass getDeclaringClass() {
        return this.declaringProxyClass;
    }

    public final Object newInstance(Object[] args2, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        int len = args2.length;
        if (len != this.actualParameterTypes.length) {
            throw new IllegalArgumentException("wrong number of parameters");
        }
        return this.newInstanceImpl(ArraySupport.newCopy(args2, len + 1), handler);
    }

    final Object newInstanceImpl(Object[] argsPlus1, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        argsPlus1[argsPlus1.length - 1] = handler;
        return this.proxyConstructor.newInstance(argsPlus1);
    }

    @JRubyMethod
    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.getArity());
    }

    @Override
    public final int getArity() {
        return this.getParameterTypes().length;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaProxyConstructor && this.proxyConstructor == ((JavaProxyConstructor)other).proxyConstructor;
    }

    @Override
    public int hashCode() {
        return this.proxyConstructor.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyString inspect() {
        StringBuilder str = new StringBuilder();
        str.append("#<");
        str.append(this.getDeclaringClass().nameOnInspection());
        JavaCallable.inspectParameterTypes(str, this);
        str.append('>');
        return RubyString.newString(this.getRuntime(), str);
    }

    @Override
    public String toString() {
        return this.inspect().toString();
    }

    @JRubyMethod
    public final RubyArray argument_types() {
        return this.toRubyArray(this.getParameterTypes());
    }

    @JRubyMethod(rest=true)
    public RubyObject new_instance2(IRubyObject[] args2, Block unusedBlock) {
        Ruby runtime = this.getRuntime();
        Arity.checkArgumentCount(runtime, args2, 2, 2);
        IRubyObject self2 = args2[0];
        Object[] convertedArgs = this.convertArguments((RubyArray)args2[1]);
        MethodInvocationHandler handler = new MethodInvocationHandler(runtime, self2);
        try {
            return JavaObject.wrap(runtime, this.newInstance(convertedArgs, handler));
        }
        catch (Exception ex) {
            throw JavaProxyConstructor.mapInstantiationException(runtime, ex);
        }
    }

    public JavaObject newInstance(IRubyObject self2, Object[] args2) throws RaiseException {
        Ruby runtime = this.getRuntime();
        MethodInvocationHandler handler = new MethodInvocationHandler(runtime, self2);
        try {
            return JavaObject.wrap(runtime, this.newInstance(args2, handler));
        }
        catch (Throwable ex) {
            throw JavaProxyConstructor.mapInstantiationException(runtime, ex);
        }
    }

    public final JavaObject newInstance(IRubyObject self2, IRubyObject[] args2) throws RaiseException {
        Ruby runtime = this.getRuntime();
        Object[] javaArgsPlus1 = RubyToJavaInvoker.convertArguments((ParameterTypes)this, args2, 1);
        MethodInvocationHandler handler = new MethodInvocationHandler(runtime, self2);
        try {
            return JavaObject.wrap(runtime, this.newInstanceImpl(javaArgsPlus1, handler));
        }
        catch (Throwable ex) {
            throw JavaProxyConstructor.mapInstantiationException(runtime, ex);
        }
    }

    public final JavaObject newInstance(IRubyObject self2, IRubyObject arg0) throws RaiseException {
        Ruby runtime = this.getRuntime();
        Object[] javaArgsPlus1 = RubyToJavaInvoker.convertArguments((ParameterTypes)this, arg0, 1);
        MethodInvocationHandler handler = new MethodInvocationHandler(runtime, self2);
        try {
            return JavaObject.wrap(runtime, this.newInstanceImpl(javaArgsPlus1, handler));
        }
        catch (Throwable ex) {
            throw JavaProxyConstructor.mapInstantiationException(runtime, ex);
        }
    }

    private static RaiseException mapInstantiationException(Ruby runtime, Throwable e) {
        Throwable cause2 = e;
        while (cause2.getCause() != null) {
            cause2 = cause2.getCause();
        }
        String MSG = "Constructor invocation failed: ";
        String msg = cause2.getLocalizedMessage();
        msg = msg == null ? "Constructor invocation failed: " + e.getClass().getName() : "Constructor invocation failed: " + msg;
        RaiseException ex = runtime.newArgumentError(msg);
        ex.initCause(e);
        throw ex;
    }

    @JRubyMethod(required=1, optional=1)
    public RubyObject new_instance(IRubyObject[] args2, Block block) {
        Ruby runtime = this.getRuntime();
        int last2 = Arity.checkArgumentCount(runtime, args2, 1, 2) - 1;
        RubyProc proc2 = args2[last2] instanceof RubyProc ? (RubyProc)args2[last2] : runtime.newProc(Block.Type.PROC, block);
        Object[] convertedArgs = this.convertArguments((RubyArray)args2[0]);
        ProcInvocationHandler handler = new ProcInvocationHandler(runtime, proc2);
        try {
            return JavaObject.wrap(runtime, this.newInstance(convertedArgs, handler));
        }
        catch (Exception e) {
            RaiseException ex = runtime.newArgumentError("Constructor invocation failed: " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    private Object[] convertArguments(RubyArray arguments) {
        int argsSize = arguments.size();
        Object[] args2 = new Object[argsSize];
        Class<?>[] parameterTypes = this.getParameterTypes();
        for (int i2 = 0; i2 < argsSize; ++i2) {
            args2[i2] = arguments.eltInternal(i2).toJava(parameterTypes[i2]);
        }
        return args2;
    }

    private static final class ProcInvocationHandler
    implements JavaProxyInvocationHandler {
        private final Ruby runtime;
        private final RubyProc proc;

        ProcInvocationHandler(Ruby runtime, RubyProc proc2) {
            this.runtime = runtime;
            this.proc = proc2;
        }

        @Override
        public IRubyObject getOrig() {
            return null;
        }

        public final Ruby getRuntime() {
            return this.runtime;
        }

        @Override
        public Object invoke(Object proxy2, JavaProxyMethod method, Object[] nargs) throws Throwable {
            int length2 = nargs == null ? 0 : nargs.length;
            IRubyObject[] rubyArgs = new IRubyObject[length2 + 2];
            rubyArgs[0] = JavaObject.wrap(this.runtime, proxy2);
            rubyArgs[1] = method;
            for (int i2 = 0; i2 < length2; ++i2) {
                rubyArgs[i2 + 2] = JavaUtil.convertJavaToRuby(this.runtime, nargs[i2]);
            }
            IRubyObject procResult = this.proc.call(this.runtime.getCurrentContext(), rubyArgs);
            return procResult.toJava(method.getReturnType());
        }
    }

    private static final class MethodInvocationHandler
    implements JavaProxyInvocationHandler {
        private final Ruby runtime;
        private final IRubyObject self;

        MethodInvocationHandler(Ruby runtime, IRubyObject self2) {
            this.runtime = runtime;
            this.self = self2;
        }

        @Override
        public IRubyObject getOrig() {
            return this.self;
        }

        public final Ruby getRuntime() {
            return this.runtime;
        }

        @Override
        public Object invoke(Object proxy2, JavaProxyMethod proxyMethod, Object[] nargs) throws Throwable {
            RubyClass metaClass = this.self.getMetaClass();
            String name2 = proxyMethod.getName();
            DynamicMethod method = metaClass.searchMethod(name2);
            IRubyObject result2 = this.invokeRuby(method, proxyMethod, metaClass, name2, nargs);
            Class<?> returnType = proxyMethod.getReturnType();
            return returnType == Void.TYPE ? null : result2.toJava(returnType);
        }

        private IRubyObject invokeRuby(DynamicMethod method, JavaProxyMethod proxyMethod, RubyClass metaClass, String name2, Object[] nargs) {
            IRubyObject[] newArgs = new IRubyObject[nargs.length];
            int i2 = nargs.length;
            while (--i2 >= 0) {
                newArgs[i2] = JavaUtil.convertJavaToUsableRubyObject(this.runtime, nargs[i2]);
            }
            int arity2 = method.getArity().getValue();
            if (arity2 < 0 || arity2 == newArgs.length) {
                ThreadContext context = this.runtime.getCurrentContext();
                return method.call(context, this.self, (RubyModule)metaClass, name2, newArgs);
            }
            if (proxyMethod.hasSuperImplementation()) {
                ThreadContext context = this.runtime.getCurrentContext();
                RubyClass superClass = metaClass.getSuperClass();
                return Helpers.invokeAs(context, superClass, this.self, name2, newArgs, Block.NULL_BLOCK);
            }
            throw this.runtime.newArgumentError(newArgs.length, arity2);
        }
    }
}

