/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as tslib_1 from "tslib";
import { EmbeddableFactory } from 'ui/embeddable';
import { getVisualizeLoader } from 'ui/visualize/loader';
import { VisualizeEmbeddable } from './visualize_embeddable';
import { DisabledLabEmbeddable } from './disabled_lab_embeddable';
var VisualizeEmbeddableFactory = /** @class */ (function (_super) {
    tslib_1.__extends(VisualizeEmbeddableFactory, _super);
    function VisualizeEmbeddableFactory(savedVisualizations, config) {
        var _this = _super.call(this, { name: 'visualization' }) || this;
        _this.config = config;
        _this.savedVisualizations = savedVisualizations;
        return _this;
    }
    VisualizeEmbeddableFactory.prototype.getEditPath = function (panelId) {
        return this.savedVisualizations.urlFor(panelId);
    };
    /**
     *
     * @param {Object} panelMetadata. Currently just passing in panelState but it's more than we need, so we should
     * decouple this to only include data given to us from the embeddable when it's added to the dashboard. Generally
     * will be just the object id, but could be anything depending on the plugin.
     * @param {function} onEmbeddableStateChanged
     * @return {Promise.<{ metadata, onContainerStateChanged, render, destroy }>}
     */
    VisualizeEmbeddableFactory.prototype.create = function (panelMetadata, onEmbeddableStateChanged) {
        var _this = this;
        var visId = panelMetadata.id;
        var editUrl = this.getEditPath(visId);
        var waitFor = [
            getVisualizeLoader(),
            this.savedVisualizations.get(visId),
        ];
        return Promise.all(waitFor).then(function (_a) {
            var _b = tslib_1.__read(_a, 2), loader = _b[0], savedObject = _b[1];
            var isLabsEnabled = _this.config.get('visualize:enableLabs');
            if (!isLabsEnabled && savedObject.vis.type.stage === 'experimental') {
                return new DisabledLabEmbeddable(savedObject.title);
            }
            else {
                return new VisualizeEmbeddable({
                    onEmbeddableStateChanged: onEmbeddableStateChanged,
                    savedVisualization: savedObject,
                    editUrl: editUrl,
                    loader: loader,
                });
            }
        });
    };
    return VisualizeEmbeddableFactory;
}(EmbeddableFactory));
export { VisualizeEmbeddableFactory };
