/*
tinymath @ 1.1.0
License: Apache-2.0
Built: 2018-12-04T20:01:50.154Z
*/
(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
	typeof define === 'function' && define.amd ? define(['exports'], factory) :
	(factory((global.tinymath = {})));
}(this, (function (exports) { 'use strict';

/**
 * Access nested property values at any depth with a simple expression.
 *
 * @module object-get
 * @typicalname objectGet
 * @example
 * ```js
 * const objectGet = require('object-get')
 *
 * const colour = objectGet(mammal, 'fur.appearance.colour')
 * const text = objectGet(el, 'children[2].children[1].children[1].textContent')
 * ```
 *
 * Helps avoid long logical expressions like:
 *
 * ```js
 * const colour = mammal && mammal.fur && mammal.fur.appearance && mammal.fur.appearance.colour
 * ```
 */
var objectGet_1 = objectGet;

/**
 * Returns the value at the given property.
 *
 * @param {object} - the input object
 * @param {string} - the property accessor expression. 
 * @returns {*}
 * @alias module:object-get
 * @example
 * > objectGet({ animal: 'cow' }, 'animal')
 * 'cow'
 *
 * > objectGet({ animal: { mood: 'lazy' } }, 'animal')
 * { mood: 'lazy' }
 *
 * > objectGet({ animal: { mood: 'lazy' } }, 'animal.mood')
 * 'lazy'
 *
 * > objectGet({ animal: { mood: 'lazy' } }, 'animal.email')
 * undefined
 */
function objectGet (object, expression) {
  if (!(object && expression)) throw new Error('both object and expression args are required')
  return expression.trim().split('.').reduce(function (prev, curr) {
    var arr = curr.match(/(.*?)\[(.*?)\]/);
    if (arr) {
      return prev && prev[arr[1]][arr[2]]
    } else {
      return prev && prev[curr]
    }
  }, object)
}

/*
 * Generated by PEG.js 0.10.0.
 *
 * http://pegjs.org/
 */

function peg$subclass(child, parent) {
  function ctor() {
    this.constructor = child;
  }
  ctor.prototype = parent.prototype;
  child.prototype = new ctor();
}

function peg$SyntaxError(message, expected, found, location) {
  this.message = message;
  this.expected = expected;
  this.found = found;
  this.location = location;
  this.name = "SyntaxError";

  if (typeof Error.captureStackTrace === "function") {
    Error.captureStackTrace(this, peg$SyntaxError);
  }
}

peg$subclass(peg$SyntaxError, Error);

peg$SyntaxError.buildMessage = function (expected, found) {
  var DESCRIBE_EXPECTATION_FNS = {
    literal: function literal(expectation) {
      return "\"" + literalEscape(expectation.text) + "\"";
    },

    "class": function _class(expectation) {
      var escapedParts = "",
          i;

      for (i = 0; i < expectation.parts.length; i++) {
        escapedParts += expectation.parts[i] instanceof Array ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1]) : classEscape(expectation.parts[i]);
      }

      return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
    },

    any: function any(expectation) {
      return "any character";
    },

    end: function end(expectation) {
      return "end of input";
    },

    other: function other(expectation) {
      return expectation.description;
    }
  };

  function hex(ch) {
    return ch.charCodeAt(0).toString(16).toUpperCase();
  }

  function literalEscape(s) {
    return s.replace(/\\/g, '\\\\').replace(/"/g, '\\"').replace(/\0/g, '\\0').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/[\x00-\x0F]/g, function (ch) {
      return '\\x0' + hex(ch);
    }).replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
      return '\\x' + hex(ch);
    });
  }

  function classEscape(s) {
    return s.replace(/\\/g, '\\\\').replace(/\]/g, '\\]').replace(/\^/g, '\\^').replace(/-/g, '\\-').replace(/\0/g, '\\0').replace(/\t/g, '\\t').replace(/\n/g, '\\n').replace(/\r/g, '\\r').replace(/[\x00-\x0F]/g, function (ch) {
      return '\\x0' + hex(ch);
    }).replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) {
      return '\\x' + hex(ch);
    });
  }

  function describeExpectation(expectation) {
    return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
  }

  function describeExpected(expected) {
    var descriptions = new Array(expected.length),
        i,
        j;

    for (i = 0; i < expected.length; i++) {
      descriptions[i] = describeExpectation(expected[i]);
    }

    descriptions.sort();

    if (descriptions.length > 0) {
      for (i = 1, j = 1; i < descriptions.length; i++) {
        if (descriptions[i - 1] !== descriptions[i]) {
          descriptions[j] = descriptions[i];
          j++;
        }
      }
      descriptions.length = j;
    }

    switch (descriptions.length) {
      case 1:
        return descriptions[0];

      case 2:
        return descriptions[0] + " or " + descriptions[1];

      default:
        return descriptions.slice(0, -1).join(", ") + ", or " + descriptions[descriptions.length - 1];
    }
  }

  function describeFound(found) {
    return found ? "\"" + literalEscape(found) + "\"" : "end of input";
  }

  return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
};

function peg$parse(input, options) {
  options = options !== void 0 ? options : {};

  var peg$FAILED = {},
      peg$startRuleFunctions = { start: peg$parsestart },
      peg$startRuleFunction = peg$parsestart,
      peg$c0 = peg$otherExpectation("whitespace"),
      peg$c1 = /^[ \t\n\r]/,
      peg$c2 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false),
      peg$c3 = /^[ ]/,
      peg$c4 = peg$classExpectation([" "], false, false),
      peg$c5 = /^["']/,
      peg$c6 = peg$classExpectation(["\"", "'"], false, false),
      peg$c7 = /^[A-Za-z_@.[\]\-]/,
      peg$c8 = peg$classExpectation([["A", "Z"], ["a", "z"], "_", "@", ".", "[", "]", "-"], false, false),
      peg$c9 = /^[0-9A-Za-z._@[\]\-]/,
      peg$c10 = peg$classExpectation([["0", "9"], ["A", "Z"], ["a", "z"], ".", "_", "@", "[", "]", "-"], false, false),
      peg$c11 = peg$otherExpectation("literal"),
      peg$c12 = function peg$c12(literal) {
    return literal;
  },
      peg$c13 = function peg$c13(first, rest) {
    // We can open this up later. Strict for now.
    return first + rest.join('');
  },
      peg$c14 = function peg$c14(first, mid) {
    return first + mid.map(function (m) {
      return m[0].join('') + m[1].join('');
    }).join('');
  },
      peg$c15 = "+",
      peg$c16 = peg$literalExpectation("+", false),
      peg$c17 = "-",
      peg$c18 = peg$literalExpectation("-", false),
      peg$c19 = function peg$c19(left, rest) {
    return rest.reduce(function (acc, curr) {
      return {
        name: curr[0] === '+' ? 'add' : 'subtract',
        args: [acc, curr[1]]
      };
    }, left);
  },
      peg$c20 = "*",
      peg$c21 = peg$literalExpectation("*", false),
      peg$c22 = "/",
      peg$c23 = peg$literalExpectation("/", false),
      peg$c24 = function peg$c24(left, rest) {
    return rest.reduce(function (acc, curr) {
      return {
        name: curr[0] === '*' ? 'multiply' : 'divide',
        args: [acc, curr[1]]
      };
    }, left);
  },
      peg$c25 = "(",
      peg$c26 = peg$literalExpectation("(", false),
      peg$c27 = ")",
      peg$c28 = peg$literalExpectation(")", false),
      peg$c29 = function peg$c29(expr) {
    return expr;
  },
      peg$c30 = peg$otherExpectation("arguments"),
      peg$c31 = ",",
      peg$c32 = peg$literalExpectation(",", false),
      peg$c33 = function peg$c33(first, arg) {
    return arg;
  },
      peg$c34 = function peg$c34(first, rest) {
    return [first].concat(rest);
  },
      peg$c35 = peg$otherExpectation("function"),
      peg$c36 = /^[a-z]/,
      peg$c37 = peg$classExpectation([["a", "z"]], false, false),
      peg$c38 = function peg$c38(name, args) {
    return { name: name.join(''), args: args || [] };
  },
      peg$c39 = peg$otherExpectation("number"),
      peg$c40 = function peg$c40() {
    return parseFloat(text());
  },
      peg$c41 = /^[eE]/,
      peg$c42 = peg$classExpectation(["e", "E"], false, false),
      peg$c43 = peg$otherExpectation("exponent"),
      peg$c44 = ".",
      peg$c45 = peg$literalExpectation(".", false),
      peg$c46 = "0",
      peg$c47 = peg$literalExpectation("0", false),
      peg$c48 = /^[1-9]/,
      peg$c49 = peg$classExpectation([["1", "9"]], false, false),
      peg$c50 = /^[0-9]/,
      peg$c51 = peg$classExpectation([["0", "9"]], false, false),
      peg$currPos = 0,
      peg$savedPos = 0,
      peg$posDetailsCache = [{ line: 1, column: 1 }],
      peg$maxFailPos = 0,
      peg$maxFailExpected = [],
      peg$silentFails = 0,
      peg$result;

  if ("startRule" in options) {
    if (!(options.startRule in peg$startRuleFunctions)) {
      throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
    }

    peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
  }

  function text() {
    return input.substring(peg$savedPos, peg$currPos);
  }

  function peg$literalExpectation(text, ignoreCase) {
    return { type: "literal", text: text, ignoreCase: ignoreCase };
  }

  function peg$classExpectation(parts, inverted, ignoreCase) {
    return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
  }

  function peg$endExpectation() {
    return { type: "end" };
  }

  function peg$otherExpectation(description) {
    return { type: "other", description: description };
  }

  function peg$computePosDetails(pos) {
    var details = peg$posDetailsCache[pos],
        p;

    if (details) {
      return details;
    } else {
      p = pos - 1;
      while (!peg$posDetailsCache[p]) {
        p--;
      }

      details = peg$posDetailsCache[p];
      details = {
        line: details.line,
        column: details.column
      };

      while (p < pos) {
        if (input.charCodeAt(p) === 10) {
          details.line++;
          details.column = 1;
        } else {
          details.column++;
        }

        p++;
      }

      peg$posDetailsCache[pos] = details;
      return details;
    }
  }

  function peg$computeLocation(startPos, endPos) {
    var startPosDetails = peg$computePosDetails(startPos),
        endPosDetails = peg$computePosDetails(endPos);

    return {
      start: {
        offset: startPos,
        line: startPosDetails.line,
        column: startPosDetails.column
      },
      end: {
        offset: endPos,
        line: endPosDetails.line,
        column: endPosDetails.column
      }
    };
  }

  function peg$fail(expected) {
    if (peg$currPos < peg$maxFailPos) {
      return;
    }

    if (peg$currPos > peg$maxFailPos) {
      peg$maxFailPos = peg$currPos;
      peg$maxFailExpected = [];
    }

    peg$maxFailExpected.push(expected);
  }

  function peg$buildStructuredError(expected, found, location) {
    return new peg$SyntaxError(peg$SyntaxError.buildMessage(expected, found), expected, found, location);
  }

  function peg$parsestart() {
    var s0;

    s0 = peg$parseAddSubtract();

    return s0;
  }

  function peg$parse_() {
    var s0, s1;

    peg$silentFails++;
    s0 = [];
    if (peg$c1.test(input.charAt(peg$currPos))) {
      s1 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c2);
      }
    }
    while (s1 !== peg$FAILED) {
      s0.push(s1);
      if (peg$c1.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$c2);
        }
      }
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c0);
      }
    }

    return s0;
  }

  function peg$parseSpace() {
    var s0;

    if (peg$c3.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c4);
      }
    }

    return s0;
  }

  function peg$parseQuote() {
    var s0;

    if (peg$c5.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c6);
      }
    }

    return s0;
  }

  function peg$parseStartChar() {
    var s0;

    if (peg$c7.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c8);
      }
    }

    return s0;
  }

  function peg$parseValidChar() {
    var s0;

    if (peg$c9.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c10);
      }
    }

    return s0;
  }

  function peg$parseLiteral() {
    var s0, s1, s2, s3;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseNumber();
      if (s2 === peg$FAILED) {
        s2 = peg$parseVariableWithQuote();
        if (s2 === peg$FAILED) {
          s2 = peg$parseVariable();
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c12(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c11);
      }
    }

    return s0;
  }

  function peg$parseVariable() {
    var s0, s1, s2, s3, s4;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseStartChar();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseValidChar();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseValidChar();
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c13(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseVariableWithQuote() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseQuote();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseStartChar();
        if (s3 !== peg$FAILED) {
          s4 = [];
          s5 = peg$currPos;
          s6 = [];
          s7 = peg$parseSpace();
          while (s7 !== peg$FAILED) {
            s6.push(s7);
            s7 = peg$parseSpace();
          }
          if (s6 !== peg$FAILED) {
            s7 = [];
            s8 = peg$parseValidChar();
            if (s8 !== peg$FAILED) {
              while (s8 !== peg$FAILED) {
                s7.push(s8);
                s8 = peg$parseValidChar();
              }
            } else {
              s7 = peg$FAILED;
            }
            if (s7 !== peg$FAILED) {
              s6 = [s6, s7];
              s5 = s6;
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          } else {
            peg$currPos = s5;
            s5 = peg$FAILED;
          }
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$currPos;
            s6 = [];
            s7 = peg$parseSpace();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseSpace();
            }
            if (s6 !== peg$FAILED) {
              s7 = [];
              s8 = peg$parseValidChar();
              if (s8 !== peg$FAILED) {
                while (s8 !== peg$FAILED) {
                  s7.push(s8);
                  s8 = peg$parseValidChar();
                }
              } else {
                s7 = peg$FAILED;
              }
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseQuote();
            if (s5 !== peg$FAILED) {
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c14(s3, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseAddSubtract() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseMultiplyDivide();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 43) {
          s5 = peg$c15;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$c16);
          }
        }
        if (s5 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 45) {
            s5 = peg$c17;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$c18);
            }
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseMultiplyDivide();
          if (s6 !== peg$FAILED) {
            s5 = [s5, s6];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 43) {
            s5 = peg$c15;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$c16);
            }
          }
          if (s5 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 45) {
              s5 = peg$c17;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$c18);
              }
            }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseMultiplyDivide();
            if (s6 !== peg$FAILED) {
              s5 = [s5, s6];
              s4 = s5;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c19(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseMultiplyDivide() {
    var s0, s1, s2, s3, s4, s5, s6;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseFactor();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 42) {
          s5 = peg$c20;
          peg$currPos++;
        } else {
          s5 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$c21);
          }
        }
        if (s5 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 47) {
            s5 = peg$c22;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$c23);
            }
          }
        }
        if (s5 !== peg$FAILED) {
          s6 = peg$parseFactor();
          if (s6 !== peg$FAILED) {
            s5 = [s5, s6];
            s4 = s5;
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 42) {
            s5 = peg$c20;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$c21);
            }
          }
          if (s5 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 47) {
              s5 = peg$c22;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$c23);
              }
            }
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseFactor();
            if (s6 !== peg$FAILED) {
              s5 = [s5, s6];
              s4 = s5;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c24(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseFactor() {
    var s0;

    s0 = peg$parseGroup();
    if (s0 === peg$FAILED) {
      s0 = peg$parseFunction();
      if (s0 === peg$FAILED) {
        s0 = peg$parseLiteral();
      }
    }

    return s0;
  }

  function peg$parseGroup() {
    var s0, s1, s2, s3, s4, s5, s6, s7;

    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 40) {
        s2 = peg$c25;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$c26);
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parse_();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseAddSubtract();
          if (s4 !== peg$FAILED) {
            s5 = peg$parse_();
            if (s5 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s6 = peg$c27;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) {
                  peg$fail(peg$c28);
                }
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parse_();
                if (s7 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c29(s4);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseArguments() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = peg$parseAddSubtract();
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$currPos;
        s5 = peg$parse_();
        if (s5 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 44) {
            s6 = peg$c31;
            peg$currPos++;
          } else {
            s6 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$c32);
            }
          }
          if (s6 !== peg$FAILED) {
            s7 = peg$parse_();
            if (s7 !== peg$FAILED) {
              s8 = peg$parseAddSubtract();
              if (s8 !== peg$FAILED) {
                peg$savedPos = s4;
                s5 = peg$c33(s2, s8);
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        } else {
          peg$currPos = s4;
          s4 = peg$FAILED;
        }
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$currPos;
          s5 = peg$parse_();
          if (s5 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s6 = peg$c31;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$c32);
              }
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parse_();
              if (s7 !== peg$FAILED) {
                s8 = peg$parseAddSubtract();
                if (s8 !== peg$FAILED) {
                  peg$savedPos = s4;
                  s5 = peg$c33(s2, s8);
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c31;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) {
                peg$fail(peg$c32);
              }
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c34(s2, s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c30);
      }
    }

    return s0;
  }

  function peg$parseFunction() {
    var s0, s1, s2, s3, s4, s5, s6, s7, s8;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parse_();
    if (s1 !== peg$FAILED) {
      s2 = [];
      if (peg$c36.test(input.charAt(peg$currPos))) {
        s3 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s3 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$c37);
        }
      }
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$c36.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) {
              peg$fail(peg$c37);
            }
          }
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 40) {
          s3 = peg$c25;
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) {
            peg$fail(peg$c26);
          }
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parse_();
          if (s4 !== peg$FAILED) {
            s5 = peg$parseArguments();
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parse_();
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s7 = peg$c27;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) {
                    peg$fail(peg$c28);
                  }
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parse_();
                  if (s8 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c38(s2, s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c35);
      }
    }

    return s0;
  }

  function peg$parseNumber() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 45) {
      s1 = peg$c17;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c18);
      }
    }
    if (s1 === peg$FAILED) {
      s1 = null;
    }
    if (s1 !== peg$FAILED) {
      s2 = peg$parseInteger();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseFraction();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseExp();
          if (s4 === peg$FAILED) {
            s4 = null;
          }
          if (s4 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c40();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c39);
      }
    }

    return s0;
  }

  function peg$parseE() {
    var s0;

    if (peg$c41.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c42);
      }
    }

    return s0;
  }

  function peg$parseExp() {
    var s0, s1, s2, s3, s4;

    peg$silentFails++;
    s0 = peg$currPos;
    s1 = peg$parseE();
    if (s1 !== peg$FAILED) {
      if (input.charCodeAt(peg$currPos) === 45) {
        s2 = peg$c17;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$c18);
        }
      }
      if (s2 === peg$FAILED) {
        s2 = null;
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseDigit();
        if (s4 !== peg$FAILED) {
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseDigit();
          }
        } else {
          s3 = peg$FAILED;
        }
        if (s3 !== peg$FAILED) {
          s1 = [s1, s2, s3];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }
    peg$silentFails--;
    if (s0 === peg$FAILED) {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c43);
      }
    }

    return s0;
  }

  function peg$parseFraction() {
    var s0, s1, s2, s3;

    s0 = peg$currPos;
    if (input.charCodeAt(peg$currPos) === 46) {
      s1 = peg$c44;
      peg$currPos++;
    } else {
      s1 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c45);
      }
    }
    if (s1 !== peg$FAILED) {
      s2 = [];
      s3 = peg$parseDigit();
      if (s3 !== peg$FAILED) {
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseDigit();
        }
      } else {
        s2 = peg$FAILED;
      }
      if (s2 !== peg$FAILED) {
        s1 = [s1, s2];
        s0 = s1;
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    } else {
      peg$currPos = s0;
      s0 = peg$FAILED;
    }

    return s0;
  }

  function peg$parseInteger() {
    var s0, s1, s2, s3;

    if (input.charCodeAt(peg$currPos) === 48) {
      s0 = peg$c46;
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c47);
      }
    }
    if (s0 === peg$FAILED) {
      s0 = peg$currPos;
      if (peg$c48.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) {
          peg$fail(peg$c49);
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseDigit();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseDigit();
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
    }

    return s0;
  }

  function peg$parseDigit() {
    var s0;

    if (peg$c50.test(input.charAt(peg$currPos))) {
      s0 = input.charAt(peg$currPos);
      peg$currPos++;
    } else {
      s0 = peg$FAILED;
      if (peg$silentFails === 0) {
        peg$fail(peg$c51);
      }
    }

    return s0;
  }

  peg$result = peg$startRuleFunction();

  if (peg$result !== peg$FAILED && peg$currPos === input.length) {
    return peg$result;
  } else {
    if (peg$result !== peg$FAILED && peg$currPos < input.length) {
      peg$fail(peg$endExpectation());
    }

    throw peg$buildStructuredError(peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1) : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
  }
}

var grammar = {
  SyntaxError: peg$SyntaxError,
  parse: peg$parse
};
var grammar_1 = grammar.parse;

/**
 * Calculates the absolute value of a number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} The absolute value of `a`. Returns an array with the the absolute values of each element if `a` is an array.
 *
 * @example
 * abs(-1) // returns 1
 * abs(2) // returns 2
 * abs([-1 , -2, 3, -4]) // returns [1, 2, 3, 4]
 */

function abs(a) {
  if (Array.isArray(a)) {
    return a.map(function (a) {
      return Math.abs(a);
    });
  }
  return Math.abs(a);
}

/**
 * Calculates the sum of one or more numbers/arrays passed into the function. If at least one array of numbers is passed into the function, the function will calculate the sum by index.
 * @param {...(number|number[])} args one or more numbers or arrays of numbers
 * @return {(number|number[])} The sum of all numbers in `args` if `args` contains only numbers. Returns an array of sums of the elements at each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
 * @throws `'Array length mismatch'` if `args` contains arrays of different lengths
 * @example
 * add(1, 2, 3) // returns 6
 * add([10, 20, 30, 40], 10, 20, 30) // returns [70, 80, 90, 100]
 * add([1, 2], 3, [4, 5], 6) // returns [(1 + 3 + 4 + 6), (2 + 3 + 5 + 6)] = [14, 16]
 */

function add() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args.length === 1) {
    if (Array.isArray(args[0])) return args[0].reduce(function (result, current) {
      return result + current;
    });
    return args[0];
  }

  return args.reduce(function (result, current) {
    if (Array.isArray(result) && Array.isArray(current)) {
      if (current.length !== result.length) throw new Error('Array length mismatch');
      return result.map(function (val, i) {
        return val + current[i];
      });
    }
    if (Array.isArray(result)) return result.map(function (val) {
      return val + current;
    });
    if (Array.isArray(current)) return current.map(function (val) {
      return val + result;
    });
    return result + current;
  });
}

/**
 * Calculates the cube root of a number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} The cube root of `a`. Returns an array with the the cube roots of each element if `a` is an array.
 *
 * @example
 * cbrt(-27) // returns -3
 * cbrt(94) // returns 4.546835943776344
 * cbrt([27, 64, 125]) // returns [3, 4, 5]
 */

function cbrt(a) {
  if (Array.isArray(a)) {
    return a.map(function (a) {
      return Math.cbrt(a);
    });
  }
  return Math.cbrt(a);
}

/**
 * Calculates the ceiling of a number, i.e. rounds a number towards positive infinity. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} The ceiling of `a`. Returns an array with the the ceilings of each element if `a` is an array.
 *
 * @example
 * ceil(1.2) // returns 2
 * ceil(-1.8) // returns -1
 * ceil([1.1, 2.2, 3.3]) // returns [2, 3, 4]
 */

function ceil(a) {
  if (Array.isArray(a)) {
    return a.map(function (a) {
      return Math.ceil(a);
    });
  }
  return Math.ceil(a);
}

var findClamp = function findClamp(a, min, max) {
  if (min > max) throw new Error('Min must be less than max');
  return Math.min(Math.max(a, min), max);
};

/**
 * Restricts value to a given range and returns closed available value. If only min is provided, values are restricted to only a lower bound.
 * @param {...(number|number[])} a one or more numbers or arrays of numbers
 * @param {(number|number[])} min The minimum value this function will return.
 * @param {(number|number[])} max The maximum value this function will return.
 * @return {(number|number[])} The closest value between `min` (inclusive) and `max` (inclusive). Returns an array with values greater than or equal to `min` and less than or equal to `max` (if provided) at each index.
 * @throws `'Array length mismatch'` if `a`, `min`, and/or `max` are arrays of different lengths
 * @throws `'Min must be less than max'` if `max` is less than `min`
 * @throws `'Missing minimum value. You may want to use the 'max' function instead'` if min is not provided
 * @throws `'Missing maximum value. You may want to use the 'min' function instead'` if max is not provided
 *
 * @example
 * clamp(1, 2, 3) // returns 2
 * clamp([10, 20, 30, 40], 15, 25) // returns [15, 20, 25, 25]
 * clamp(10, [15, 2, 4, 20], 25) // returns [15, 10, 10, 20]
 * clamp(35, 10, [20, 30, 40, 50]) // returns [20, 30, 35, 35]
 * clamp([1, 9], 3, [4, 5]) // returns [clamp([1, 3, 4]), clamp([9, 3, 5])] = [3, 5]
 */

function clamp(a, min, max) {
  if (max === null) throw new Error("Missing maximum value. You may want to use the 'min' function instead");
  if (min === null) throw new Error("Missing minimum value. You may want to use the 'max' function instead");

  if (Array.isArray(max)) {
    if (Array.isArray(a) && Array.isArray(min)) {
      if (a.length !== max.length || a.length !== min.length) throw new Error('Array length mismatch');
      return max.map(function (max, i) {
        return findClamp(a[i], min[i], max);
      });
    }

    if (Array.isArray(a)) {
      if (a.length !== max.length) throw new Error('Array length mismatch');
      return max.map(function (max, i) {
        return findClamp(a[i], min, max);
      });
    }

    if (Array.isArray(min)) {
      if (min.length !== max.length) throw new Error('Array length mismatch');
      return max.map(function (max, i) {
        return findClamp(a, min[i], max);
      });
    }

    return max.map(function (max) {
      return findClamp(a, min, max);
    });
  }

  if (Array.isArray(a) && Array.isArray(min)) {
    if (a.length !== min.length) throw new Error('Array length mismatch');
    return a.map(function (a, i) {
      return findClamp(a, min[i]);
    });
  }

  if (Array.isArray(a)) {
    return a.map(function (a) {
      return findClamp(a, min, max);
    });
  }

  if (Array.isArray(min)) {
    return min.map(function (min) {
      return findClamp(a, min, max);
    });
  }

  return findClamp(a, min, max);
}

/**
 * Returns the length of an array. Alias for count
 * @param {any[]} a array of any values
 * @return {(number)} The length of the array. Returns 1 if `a` is not an array.
 * @throws `'Must pass an array'` if `a` is not an array
 * @example
 * size([]) // returns 0
 * size([-1, -2, -3, -4]) // returns 4
 * size(100) // returns 1
 */

function size(a) {
  if (Array.isArray(a)) return a.length;
  throw new Error('Must pass an array');
}

size.skipNumberValidation = true;

/**
 * Returns the length of an array. Alias for size
 * @param {any[]} a array of any values
 * @return {(number)} The length of the array. Returns 1 if `a` is not an array.
 * @throws `'Must pass an array'` if `a` is not an array
 * @example
 * count([]) // returns 0
 * count([-1, -2, -3, -4]) // returns 4
 * count(100) // returns 1
 */

function count(a) {
  return size(a);
}

count.skipNumberValidation = true;

/**
 * Calculates the cube root of a number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @param {(number)} b the power that `a` is raised to
 * @return {(number|number[])} `a` raised to the power of `b`. Returns an array with the each element raised to the power of `b` if `a` is an array.
 * @throws `'Missing exponent'` if `b` is not provided
 * @example
 * pow(2,3) // returns 8
 * pow([1, 2, 3], 4) // returns [1, 16, 81]
 */

function pow(a, b) {
  if (b == null) throw new Error('Missing exponent');
  if (Array.isArray(a)) {
    return a.map(function (a) {
      return Math.pow(a, b);
    });
  }
  return Math.pow(a, b);
}

/**
 * Calculates the cube of a number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} The cube of `a`. Returns an array with the the cubes of each element if `a` is an array.
 *
 * @example
 * cube(-3) // returns -27
 * cube([3, 4, 5]) // returns [27, 64, 125]
 */

function cube(a) {
  return pow(a, 3);
}

/**
 * Divides two numbers. If at least one array of numbers is passed into the function, the function will be applied index-wise to each element.
 * @param {(number|number[])} a dividend, a number or an array of numbers
 * @param {(number|number[])} b divisor, a number or an array of numbers, `b` != 0
 * @return {(number|number[])} The quotient of `a` and `b` if both are numbers. Returns an array with the quotients applied index-wise to each element if `a` or `b` is an array.
 * @throws `'Array length mismatch'` if `a` and `b` are arrays with different lengths
 * - `'Cannot divide by 0'` if `b` equals 0 or contains 0
 * @example
 * divide(6, 3) // returns 2
 * divide([10, 20, 30, 40], 10) // returns [1, 2, 3, 4]
 * divide(10, [1, 2, 5, 10]) // returns [10, 5, 2, 1]
 * divide([14, 42, 65, 108], [2, 7, 5, 12]) // returns [7, 6, 13, 9]
 */

function divide(a, b) {
  if (Array.isArray(a) && Array.isArray(b)) {
    if (a.length !== b.length) throw new Error('Array length mismatch');
    return a.map(function (val, i) {
      if (b[i] === 0) throw new Error('Cannot divide by 0');
      return val / b[i];
    });
  }
  if (Array.isArray(b)) return b.map(function (b) {
    return a / b;
  });
  if (b === 0) throw new Error('Cannot divide by 0');
  if (Array.isArray(a)) return a.map(function (a) {
    return a / b;
  });
  return a / b;
}

/**
 * Calculates _e^x_ where _e_ is Euler's number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} `e^a`. Returns an array with the values of `e^x` evaluated where `x` is each element of `a` if `a` is an array.
 *
 * @example
 * exp(2) // returns e^2 = 7.3890560989306495
 * exp([1, 2, 3]) // returns [e^1, e^2, e^3] = [2.718281828459045, 7.3890560989306495, 20.085536923187668]
 */

function exp(a) {
  if (Array.isArray(a)) {
    return a.map(function (a) {
      return Math.exp(a);
    });
  }
  return Math.exp(a);
}

/**
 * Returns the first element of an array. If anything other than an array is passed in, the input is returned.
 * @param {any[]} a array of any values
 * @return {*} The first element of `a`. Returns `a` if `a` is not an array.
 *
 * @example
 * first(2) // returns 2
 * first([1, 2, 3]) // returns 1
 */

function first(a) {
  if (Array.isArray(a)) {
    return a[0];
  }
  return a;
}

first.skipNumberValidation = true;

var fixer = function fixer(a) {
  if (a > 0) {
    return Math.floor(a);
  }
  return Math.ceil(a);
};

/**
 * Calculates the fix of a number, i.e. rounds a number towards 0. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} The fix of `a`. Returns an array with the the fixes for each element if `a` is an array.
 *
 * @example
 * fix(1.2) // returns 1
 * fix(-1.8) // returns -1
 * fix([1.8, 2.9, -3.7, -4.6]) // returns [1, 2, -3, -4]
 */

function fix(a) {
  if (Array.isArray(a)) {
    return a.map(function (a) {
      return fixer(a);
    });
  }
  return fixer(a);
}

/**
 * Calculates the floor of a number, i.e. rounds a number towards negative infinity. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} The floor of `a`. Returns an array with the the floor of each element if `a` is an array.
 *
 * @example
 * floor(1.8) // returns 1
 * floor(-1.2) // returns -2
 * floor([1.7, 2.8, 3.9]) // returns [1, 2, 3]
 */

function floor(a) {
  if (Array.isArray(a)) {
    return a.map(function (a) {
      return Math.floor(a);
    });
  }
  return Math.floor(a);
}

/**
 * Returns the last element of an array. If anything other than an array is passed in, the input is returned.
 * @param {any[]} a array of any values
 * @return {*} The last element of `a`. Returns `a` if `a` is not an array.
 *
 * @example
 * last(2) // returns 2
 * last([1, 2, 3]) // returns 3
 */

function last(a) {
  if (Array.isArray(a)) {
    return a[a.length - 1];
  }
  return a;
}

last.skipNumberValidation = true;

var changeOfBase = function changeOfBase(a, b) {
  return Math.log(a) / Math.log(b);
};

/**
 * Calculates the logarithm of a number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers, `a` must be greater than 0
 * @param {{number}} b (optional) base for the logarithm. If not provided a value, the default base is e, and the natural log is calculated.
 * @return {(number|number[])} The logarithm of `a`. Returns an array with the the logarithms of each element if `a` is an array.
 * @throws `'Base out of range'` if `b` <= 0
 * - 'Must be greater than 0' if `a` > 0
 * @example
 * log(1) // returns 0
 * log(64, 8) // returns 2
 * log(42, 5) // returns 2.322344707681546
 * log([2, 4, 8, 16, 32], 2) // returns [1, 2, 3, 4, 5]
 */

function log(a) {
  var b = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Math.E;

  if (b <= 0) throw new Error('Base out of range');

  if (Array.isArray(a)) {
    return a.map(function (a) {
      if (a < 0) throw new Error('Must be greater than 0');
      return changeOfBase(a, b);
    });
  }
  if (a < 0) throw new Error('Must be greater than 0');
  return changeOfBase(a, b);
}

/**
 * Calculates the logarithm base 10 of a number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers, `a` must be greater than 0
 * @return {(number|number[])} The logarithm of `a`. Returns an array with the the logarithms base 10 of each element if `a` is an array.
 * @throws `'Must be greater than 0'` if `a` < 0
 * @example
 * log(10) // returns 1
 * log(100) // returns 2
 * log(80) // returns 1.9030899869919433
 * log([10, 100, 1000, 10000, 100000]) // returns [1, 2, 3, 4, 5]
 */

function log10(a) {
  return log(a, 10);
}

/**
 * Finds the maximum value of one of more numbers/arrays of numbers into the function. If at least one array of numbers is passed into the function, the function will find the maximum by index.
 * @param {...(number|number[])} args one or more numbers or arrays of numbers
 * @return {(number|number[])} The maximum value of all numbers if `args` contains only numbers. Returns an array with the the maximum values at each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
 * @throws `'Array length mismatch'` if `args` contains arrays of different lengths
 * @example
 * max(1, 2, 3) // returns 3
 * max([10, 20, 30, 40], 15) // returns [15, 20, 30, 40]
 * max([1, 9], 4, [3, 5]) // returns [max([1, 4, 3]), max([9, 4, 5])] = [4, 9]
 */

function max() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args.length === 1) {
    if (Array.isArray(args[0])) return args[0].reduce(function (result, current) {
      return Math.max(result, current);
    });
    return args[0];
  }

  return args.reduce(function (result, current) {
    if (Array.isArray(result) && Array.isArray(current)) {
      if (current.length !== result.length) throw new Error('Array length mismatch');
      return result.map(function (val, i) {
        return Math.max(val, current[i]);
      });
    }
    if (Array.isArray(result)) return result.map(function (val) {
      return Math.max(val, current);
    });
    if (Array.isArray(current)) return current.map(function (val) {
      return Math.max(val, result);
    });
    return Math.max(result, current);
  });
}

/**
 * Finds the mean value of one of more numbers/arrays of numbers into the function. If at least one array of numbers is passed into the function, the function will find the mean by index.
 * @param {...(number|number[])} args one or more numbers or arrays of numbers
 * @return {(number|number[])} The mean value of all numbers if `args` contains only numbers. Returns an array with the the mean values of each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
 *
 * @example
 * mean(1, 2, 3) // returns 2
 * mean([10, 20, 30, 40], 20) // returns [15, 20, 25, 30]
 * mean([1, 9], 5, [3, 4]) // returns [mean([1, 5, 3]), mean([9, 5, 4])] = [3, 6]
 */

function mean() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args.length === 1) {
    if (Array.isArray(args[0])) return add(args[0]) / args[0].length;
    return args[0];
  }
  var sum = add.apply(undefined, args);

  if (Array.isArray(sum)) {
    return sum.map(function (val) {
      return val / args.length;
    });
  }

  return sum / args.length;
}

/**
 * Transposes a 2D array, i.e. turns the rows into columns and vice versa. Scalar values are also included in the transpose.
 * @param {any[][]} args an array or an array that contains arrays
 * @param {number} index index of the first array element in args
 * @return {any[][]} transpose of args
 * @throws `'Array length mismatch'` if `args` contains arrays of different lengths
 * @example
 * transpose([[1,2], [3,4], [5,6]], 0) // returns [[1, 3, 5], [2, 4, 6]]
 * transpose([10, 20, [10, 20, 30, 40], 30], 2) // returns [[10, 20, 10, 30], [10, 20, 20, 30], [10, 20, 30, 30], [10, 20, 40, 30]]
 * transpose([4, [1, 9], [3, 5]], 1) // returns [[4, 1, 3], [4, 9, 5]]
 */

function transpose(args, index) {
  var len = args[index].length;
  return args[index].map(function (col, i) {
    return args.map(function (row) {
      if (Array.isArray(row)) {
        if (row.length !== len) throw new Error('Array length mismatch');
        return row[i];
      }
      return row;
    });
  });
}

var findMedian = function findMedian(a) {
  var len = a.length;
  var half = Math.floor(len / 2);

  a.sort(function (a, b) {
    return a > b;
  });

  if (len % 2 === 0) {
    return (a[half] + a[half - 1]) / 2;
  }

  return a[half];
};

/**
 * Finds the median value(s) of one of more numbers/arrays of numbers into the function. If at least one array of numbers is passed into the function, the function will find the median by index.
 * @param {...(number|number[])} args one or more numbers or arrays of numbers
 * @return {(number|number[])} The median value of all numbers if `args` contains only numbers. Returns an array with the the median values of each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
 *
 * @example
 * median(1, 1, 2, 3) // returns 1.5
 * median(1, 1, 2, 2, 3) // returns 2
 * median([10, 20, 30, 40], 10, 20, 30) // returns [15, 20, 25, 25]
 * median([1, 9], 2, 4, [3, 5]) // returns [median([1, 2, 4, 3]), median([9, 2, 4, 5])] = [2.5, 4.5]
 */

function median() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args.length === 1) {
    if (Array.isArray(args[0])) return findMedian(args[0]);
    return args[0];
  }

  var firstArray = args.findIndex(function (element) {
    return Array.isArray(element);
  });
  if (firstArray !== -1) {
    var result = transpose(args, firstArray);
    return result.map(function (val) {
      return findMedian(val);
    });
  }
  return findMedian(args);
}

/**
 * Finds the minimum value of one of more numbers/arrays of numbers into the function. If at least one array of numbers is passed into the function, the function will find the minimum by index.
 * @param {...(number|number[])} args one or more numbers or arrays of numbers
 * @return {(number|number[])} The minimum value of all numbers if `args` contains only numbers. Returns an array with the the minimum values of each index, including all scalar numbers in `args` in the calculation at each index if `a` is an array.
 * @throws `'Array length mismatch'` if `args` contains arrays of different lengths
 * @example
 * min(1, 2, 3) // returns 1
 * min([10, 20, 30, 40], 25) // returns [10, 20, 25, 25]
 * min([1, 9], 4, [3, 5]) // returns [min([1, 4, 3]), min([9, 4, 5])] = [1, 4]
 */

function min() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args.length === 1) {
    if (Array.isArray(args[0])) return args[0].reduce(function (result, current) {
      return Math.min(result, current);
    });
    return args[0];
  }

  return args.reduce(function (result, current) {
    if (Array.isArray(result) && Array.isArray(current)) {
      if (current.length !== result.length) throw new Error('Array length mismatch');
      return result.map(function (val, i) {
        return Math.min(val, current[i]);
      });
    }
    if (Array.isArray(result)) return result.map(function (val) {
      return Math.min(val, current);
    });
    if (Array.isArray(current)) return current.map(function (val) {
      return Math.min(val, result);
    });
    return Math.min(result, current);
  });
}

/**
 * Remainder after dividing two numbers. If at least one array of numbers is passed into the function, the function will be applied index-wise to each element.
 * @param {(number|number[])} a dividend, a number or an array of numbers
 * @param {(number|number[])} b divisor, a number or an array of numbers, `b` != 0
 * @return {(number|number[])} The remainder of `a` divided by `b` if both are numbers. Returns an array with the the remainders applied index-wise to each element if `a` or `b` is an array.
 * @throws `'Array length mismatch'` if `a` and `b` are arrays with different lengths
 * - `'Cannot divide by 0'` if `b` equals 0 or contains 0
 * @example
 * mod(10, 7) // returns 3
 * mod([11, 22, 33, 44], 10) // returns [1, 2, 3, 4]
 * mod(100, [3, 7, 11, 23]) // returns [1, 2, 1, 8]
 * mod([14, 42, 65, 108], [5, 4, 14, 2]) // returns [5, 2, 9, 0]
 */

function mod(a, b) {
  if (Array.isArray(a) && Array.isArray(b)) {
    if (a.length !== b.length) throw new Error('Array length mismatch');
    return a.map(function (val, i) {
      if (b[i] === 0) throw new Error('Cannot divide by 0');
      return val % b[i];
    });
  }
  if (Array.isArray(b)) return b.map(function (b) {
    return a % b;
  });
  if (b === 0) throw new Error('Cannot divide by 0');
  if (Array.isArray(a)) return a.map(function (a) {
    return a % b;
  });
  return a % b;
}

var findMode = function findMode(a) {
  var maxFreq = 0;
  var mapping = {};

  a.map(function (val) {
    if (mapping[val] === undefined) {
      mapping[val] = 0;
    }
    mapping[val] += 1;
    if (mapping[val] > maxFreq) {
      maxFreq = mapping[val];
    }
  });

  return Object.keys(mapping).filter(function (key) {
    return mapping[key] === maxFreq;
  }).map(function (val) {
    return parseFloat(val);
  }).sort(function (a, b) {
    return a - b;
  });
};

/**
 * Finds the mode value(s) of one of more numbers/arrays of numbers into the function. If at least one array of numbers is passed into the function, the function will find the mode by index.
 * @param {...(number|number[])} args one or more numbers or arrays of numbers
 * @return {(number[]|number[][])} An array mode value(s) of all numbers if `args` contains only numbers. Returns an array of arrays with mode value(s) of each index, including all scalar numbers in `args` in the calculation at each index  if `args` contains at least one array.
 *
 * @example
 * mode(1, 1, 2, 3) // returns [1]
 * mode(1, 1, 2, 2, 3) // returns [1,2]
 * mode([10, 20, 30, 40], 10, 20, 30) // returns [[10], [20], [30], [10, 20, 30, 40]]
 * mode([1, 9], 1, 4, [3, 5]) // returns [mode([1, 1, 4, 3]), mode([9, 1, 4, 5])] = [[1], [4, 5, 9]]
 */

function mode() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  if (args.length === 1) {
    if (Array.isArray(args[0])) return findMode(args[0]);
    return args[0];
  }

  var firstArray = args.findIndex(function (element) {
    return Array.isArray(element);
  });
  if (firstArray !== -1) {
    var result = transpose(args, firstArray);
    return result.map(function (val) {
      return findMode(val);
    });
  }
  return findMode(args);
}

/**
 * Multiplies two numbers. If at least one array of numbers is passed into the function, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @param {(number|number[])} b a number or an array of numbers
 * @return {(number|number[])} The product of `a` and `b` if both are numbers. Returns an array with the the products applied index-wise to each element if `a` or `b` is an array.
 * @throws `'Array length mismatch'` if `a` and `b` are arrays with different lengths
 * @example
 * multiply(6, 3) // returns 18
 * multiply([10, 20, 30, 40], 10) // returns [100, 200, 300, 400]
 * multiply(10, [1, 2, 5, 10]) // returns [10, 20, 50, 100]
 * multiply([1, 2, 3, 4], [2, 7, 5, 12]) // returns [2, 14, 15, 48]
 */

function multiply() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return args.reduce(function (result, current) {
    if (Array.isArray(result) && Array.isArray(current)) {
      if (current.length !== result.length) throw new Error('Array length mismatch');
      return result.map(function (val, i) {
        return val * current[i];
      });
    }
    if (Array.isArray(result)) return result.map(function (val) {
      return val * current;
    });
    if (Array.isArray(current)) return current.map(function (val) {
      return val * result;
    });
    return result * current;
  });
}

/**
 * Generates a random number within the given range where the lower bound is inclusive and the upper bound is exclusive. If no numbers are passed in, it will return a number between 0 and 1. If only one number is passed in, it will return .
 * @param {number} a (optional) must be greater than 0 if `b` is not provided
 * @param {number} b (optional) must be greater
 * @return {number} A random number between 0 and 1 if no numbers are passed in. Returns a random number between 0 and `a` if only one number is passed in. Returns a random number between `a` and `b` if two numbers are passed in.
 * @throws `'Min is be greater than max'` if `a` < 0 when only `a` is passed in or if `a` > `b` when both `a` and `b` are passed in
 * @example
 * random() // returns a random number between 0 (inclusive) and 1 (exclusive)
 * random(10) // returns a random number between 0 (inclusive) and 10 (exclusive)
 * random(-10,10) // returns a random number between -10 (inclusive) and 10 (exclusive)
 */

function random(a, b) {
  if (a == null) return Math.random();

  // a: max, generate random number between 0 and a
  if (b == null) {
    if (a < 0) throw new Error("Min is greater than max");
    return Math.random() * a;
  }

  // a: min, b: max, generate random number between a and b
  if (a > b) throw new Error("Min is greater than max");
  return Math.random() * (b - a) + a;
}

/**
 * Subtracts two numbers. If at least one array of numbers is passed into the function, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @param {(number|number[])} b a number or an array of numbers
 * @return {(number|number[])} The difference of `a` and `b` if both are numbers or an array of differences applied index-wise to each element.
 * @throws `'Array length mismatch'` if `a` and `b` are arrays with different lengths
 * @example
 * subtract(6, 3) // returns 3
 * subtract([10, 20, 30, 40], 10) // returns [0, 10, 20, 30]
 * subtract(10, [1, 2, 5, 10]) // returns [9, 8, 5, 0]
 * subtract([14, 42, 65, 108], [2, 7, 5, 12]) // returns [12, 35, 52, 96]
 */

function subtract(a, b) {
  if (Array.isArray(a) && Array.isArray(b)) {
    if (a.length !== b.length) throw new Error('Array length mismatch');
    return a.map(function (val, i) {
      return val - b[i];
    });
  }
  if (Array.isArray(a)) return a.map(function (a) {
    return a - b;
  });
  if (Array.isArray(b)) return b.map(function (b) {
    return a - b;
  });
  return a - b;
}

/**
 * Finds the range of one of more numbers/arrays of numbers into the function. If at least one array of numbers is passed into the function, the function will find the range by index.
 * @param {...(number|number[])} args one or more numbers or arrays of numbers
 * @return {(number|number[])} The range value of all numbers if `args` contains only numbers. Returns an array with the the range values at each index, including all scalar numbers in `args` in the calculation at each index if `args` contains at least one array.
 *
 * @example
 * range(1, 2, 3) // returns 2
 * range([10, 20, 30, 40], 15) // returns [5, 5, 15, 25]
 * range([1, 9], 4, [3, 5]) // returns [range([1, 4, 3]), range([9, 4, 5])] = [3, 5]
 */

function range() {
  return subtract(max.apply(undefined, arguments), min.apply(undefined, arguments));
}

var rounder = function rounder(a, b) {
  return Math.round(a * Math.pow(10, b)) / Math.pow(10, b);
};

/**
 * Rounds a number towards the nearest integer by default or decimal place if specified. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @param {(number)} b (optional) number of decimal places, default value: 0
 * @return {(number|number[])} The rounded value of `a`. Returns an array with the the rounded values of each element if `a` is an array.
 *
 * @example
 * round(1.2) // returns 2
 * round(-10.51) // returns -11
 * round(-10.1, 2) // returns -10.1
 * round(10.93745987, 4) // returns 10.9375
 * round([2.9234, 5.1234, 3.5234, 4.49234324], 2) // returns [2.92, 5.12, 3.52, 4.49]
 */

function round(a) {
  var b = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  if (Array.isArray(a)) {
    return a.map(function (a) {
      return rounder(a, b);
    });
  }
  return rounder(a, b);
}

/**
 * Calculates the square root of a number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} The square root of `a`. Returns an array with the the square roots of each element if `a` is an array.
 * @throws `'Unable find the square root of a negative number'` if `a` < 0
 * @example
 * sqrt(9) // returns 3
 * sqrt(30) //5.477225575051661
 * sqrt([9, 16, 25]) // returns [3, 4, 5]
 */

function sqrt(a) {
  if (Array.isArray(a)) {
    return a.map(function (a) {
      if (a < 0) throw new Error('Unable find the square root of a negative number');
      return Math.sqrt(a);
    });
  }

  if (a < 0) throw new Error('Unable find the square root of a negative number');
  return Math.sqrt(a);
}

/**
 * Calculates the square of a number. For arrays, the function will be applied index-wise to each element.
 * @param {(number|number[])} a a number or an array of numbers
 * @return {(number|number[])} The square of `a`. Returns an array with the the squares of each element if `a` is an array.
 *
 * @example
 * square(-3) // returns 9
 * square([3, 4, 5]) // returns [9, 16, 25]
 */

function square(a) {
  return pow(a, 2);
}

var findSum = function findSum(total, current) {
  return total + current;
};

/**
 * Calculates the sum of one or more numbers/arrays passed into the function. If at least one array is passed, the function will sum up one or more numbers/arrays of numbers and distinct values of an array. Sum accepts arrays of different lengths.
 * @param {...(number|number[])} args one or more numbers or arrays of numbers
 * @return {number} The sum of one or more numbers/arrays of numbers including distinct values in arrays
 *
 * @example
 * sum(1, 2, 3) // returns 6
 * sum([10, 20, 30, 40], 10, 20, 30) // returns 160
 * sum([1, 2], 3, [4, 5], 6) // returns sum(1, 2, 3, 4, 5, 6) = 21
 * sum([10, 20, 30, 40], 10, [1, 2, 3], 22) // returns sum(10, 20, 30, 40, 10, 1, 2, 3, 22) = 138
 */

function sum() {
  for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return args.reduce(function (total, current) {
    if (Array.isArray(current)) {
      return total + current.reduce(findSum, 0);
    }
    return total + current;
  }, 0);
}

/**
 * Counts the number of unique values in an array
 * @param {any[]} a array of any values
 * @return {number} The number of unique values in the array. Returns 1 if `a` is not an array.
 *
 * @example
 * unique(100) // returns 1
 * unique([]) // returns 0
 * unique([1, 2, 3, 4]) // returns 4
 * unique([1, 2, 3, 4, 2, 2, 2, 3, 4, 2, 4, 5, 2, 1, 4, 2]) // returns 5
 */

function unique(a) {
  if (Array.isArray(a)) {
    return a.filter(function (val, i) {
      return a.indexOf(val) === i;
    }).length;
  }
  return 1;
}

unique.skipNumberValidation = true;

var functions = {
  abs: abs,
  add: add,
  cbrt: cbrt,
  ceil: ceil,
  clamp: clamp,
  count: count,
  cube: cube,
  divide: divide,
  exp: exp,
  first: first,
  fix: fix,
  floor: floor,
  last: last,
  log: log,
  log10: log10,
  max: max,
  mean: mean,
  median: median,
  min: min,
  mod: mod,
  mode: mode,
  multiply: multiply,
  pow: pow,
  random: random,
  range: range,
  round: round,
  size: size,
  sqrt: sqrt,
  square: square,
  subtract: subtract,
  sum: sum,
  unique: unique
};

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};

var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

function parse$$1(input, options) {
  if (input == null) {
    throw new Error('Missing expression');
  }

  if (typeof input !== 'string') {
    throw new Error('Expression must be a string');
  }

  try {
    return grammar_1(input, options);
  } catch (e) {
    throw new Error('Failed to parse expression. ' + e.message);
  }
}

function evaluate(expression) {
  var scope = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var injectedFunctions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  scope = scope || {};
  return interpret(parse$$1(expression), scope, injectedFunctions);
}

function interpret(node, scope, injectedFunctions) {
  var functions$$1 = Object.assign({}, functions, injectedFunctions); // eslint-disable-line
  return exec(node);

  function exec(node) {
    var type = getType(node);

    if (type === 'function') return invoke(node);

    if (type === 'string') {
      var val = getValue(scope, node);
      if (typeof val === 'undefined') throw new Error('Unknown variable: ' + node);
      return val;
    }

    return node; // Can only be a number at this point
  }

  function invoke(node) {
    var name = node.name,
        args = node.args;

    var fn = functions$$1[name];
    if (!fn) throw new Error('No such function: ' + name);
    var execOutput = args.map(exec);
    if (fn.skipNumberValidation || isOperable(execOutput)) return fn.apply(undefined, toConsumableArray(execOutput));
    return NaN;
  }
}

function getValue(scope, node) {
  // attempt to read value from nested object first, check for exact match if value is undefined
  var val = objectGet_1(scope, node);
  return typeof val !== 'undefined' ? val : scope[node];
}

function getType(x) {
  var type = typeof x === 'undefined' ? 'undefined' : _typeof(x);
  if (type === 'object') {
    var keys = Object.keys(x);
    if (keys.length !== 2 || !x.name || !x.args) throw new Error('Invalid AST object');
    return 'function';
  }
  if (type === 'string' || type === 'number') return type;
  throw new Error('Unknown AST property type: ' + type);
}

function isOperable(args) {
  return args.every(function (arg) {
    if (Array.isArray(arg)) return isOperable(arg);
    return typeof arg === 'number' && !isNaN(arg);
  });
}

exports.parse = parse$$1;
exports.evaluate = evaluate;
exports.interpret = interpret;

Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=tinymath.js.map
