/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.ReflectionUtil;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

abstract class SSLSocketUtil {
    private static final Method getHandshakeSession;
    private static final Method getSSLParameters;

    SSLSocketUtil() {
    }

    static BCExtendedSSLSession importHandshakeSession(SSLSocket sSLSocket) {
        if (sSLSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sSLSocket)).getBCHandshakeSession();
        }
        if (null != sSLSocket && null != getHandshakeSession) {
            try {
                SSLSession sSLSession = (SSLSession)ReflectionUtil.invokeGetter(sSLSocket, getHandshakeSession);
                if (null != sSLSession) {
                    return SSLSessionUtil.importSSLSession(sSLSession);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLSocket sSLSocket) {
        if (sSLSocket instanceof BCSSLSocket) {
            return ((BCSSLSocket)((Object)sSLSocket)).getParameters();
        }
        if (null != sSLSocket && null != getSSLParameters) {
            try {
                SSLParameters sSLParameters = (SSLParameters)ReflectionUtil.invokeGetter(sSLSocket, getSSLParameters);
                if (null != sSLParameters) {
                    return SSLParametersUtil.importSSLParameters(sSLParameters);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        Method[] methodArray = ReflectionUtil.getMethods("javax.net.ssl.SSLSocket");
        getHandshakeSession = ReflectionUtil.findMethod(methodArray, "getHandshakeSession");
        getSSLParameters = ReflectionUtil.findMethod(methodArray, "getSSLParameters");
    }
}

