/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.persistence;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubySymbol;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.persistence.IRPersistenceValues;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;
import org.jruby.util.KeyValuePair;

public class IRReader
implements IRPersistenceValues {
    public static IRScope load(IRManager manager, final IRReaderDecoder file2) throws IOException {
        IRScope scope;
        int version = file2.decodeIntRaw();
        if (version != 1) {
            throw new IOException("Trying to read incompatible persistence format (version found: " + version + ", version expected: " + 1);
        }
        int headersOffset = file2.decodeIntRaw();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("header_offset = " + headersOffset);
        }
        int poolOffset = file2.decodeIntRaw();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("pool_offset = " + headersOffset);
        }
        file2.seek(headersOffset);
        int scopesToRead = file2.decodeInt();
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("scopes to read = " + scopesToRead);
        }
        KeyValuePair[] scopes = new KeyValuePair[scopesToRead];
        for (int i2 = 0; i2 < scopesToRead; ++i2) {
            scopes[i2] = IRReader.decodeScopeHeader(manager, file2);
        }
        for (KeyValuePair pair : scopes) {
            scope = (IRScope)pair.getKey();
            final int instructionsOffset = (Integer)pair.getValue();
            scope.allocateInterpreterContext(new Callable<List<Instr>>(){

                @Override
                public List<Instr> call() {
                    return file2.decodeInstructionsAt(scope, instructionsOffset);
                }
            });
        }
        for (KeyValuePair pair : scopes) {
            scope = (IRScope)pair.getKey();
            scope.computeScopeFlags();
        }
        return (IRScope)scopes[0].getKey();
    }

    private static KeyValuePair<IRScope, Integer> decodeScopeHeader(IRManager manager, IRReaderDecoder decoder) {
        if (RubyInstanceConfig.IR_READING_DEBUG) {
            System.out.println("DECODING SCOPE HEADER");
        }
        IRScopeType type2 = decoder.decodeIRScopeType();
        int line = decoder.decodeInt();
        int tempVarsCount = decoder.decodeInt();
        int nextLabelInt = decoder.decodeInt();
        boolean isEND = false;
        if (type2 == IRScopeType.CLOSURE) {
            isEND = decoder.decodeBoolean();
        }
        Signature signature = type2 == IRScopeType.CLOSURE || type2 == IRScopeType.FOR ? Signature.decode(decoder.decodeLong()) : Signature.OPTIONAL;
        String file2 = null;
        ByteList name2 = null;
        IRScope parent = null;
        if (type2 == IRScopeType.SCRIPT_BODY) {
            file2 = decoder.decodeString();
        } else {
            name2 = decoder.decodeByteList();
            parent = type2 != IRScopeType.SCRIPT_BODY ? decoder.decodeScope() : null;
        }
        StaticScope parentScope = parent == null ? null : parent.getStaticScope();
        StaticScope staticScope = IRReader.decodeStaticScope(decoder, parentScope);
        IRScope scope = IRReader.createScope(manager, type2, name2, file2, line, parent, signature, staticScope);
        if (scope instanceof IRClosure && isEND) {
            ((IRClosure)scope).setIsEND();
        }
        scope.setTemporaryVariableCount(tempVarsCount);
        scope.setNextLabelIndex(nextLabelInt);
        scope.setLocalVariables(IRReader.decodeScopeLocalVariables(decoder, scope));
        decoder.addScope(scope);
        int instructionsOffset = decoder.decodeInt();
        return new KeyValuePair<IRScope, Integer>(scope, instructionsOffset);
    }

    private static Map<RubySymbol, LocalVariable> decodeScopeLocalVariables(IRReaderDecoder decoder, IRScope scope) {
        int size2 = decoder.decodeInt();
        HashMap<RubySymbol, LocalVariable> localVariables = new HashMap<RubySymbol, LocalVariable>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            RubySymbol name2 = scope.getManager().getRuntime().newSymbol(decoder.decodeByteList());
            int offset2 = decoder.decodeInt();
            localVariables.put(name2, scope instanceof IRClosure ? new ClosureLocalVariable(name2, 0, offset2) : new LocalVariable(name2, 0, offset2));
        }
        return localVariables;
    }

    private static StaticScope decodeStaticScope(IRReaderDecoder decoder, StaticScope parentScope) {
        StaticScope scope = StaticScopeFactory.newStaticScope(parentScope, decoder.decodeStaticScopeType(), decoder.decodeStringArray(), decoder.decodeInt());
        scope.setSignature(decoder.decodeSignature());
        return scope;
    }

    public static IRScope createScope(IRManager manager, IRScopeType type2, ByteList byteName, String file2, int line, IRScope lexicalParent, Signature signature, StaticScope staticScope) {
        Ruby runtime2 = manager.getRuntime();
        switch (type2) {
            case CLASS_BODY: {
                return new IRClassBody(manager, lexicalParent, byteName, line, staticScope, false);
            }
            case METACLASS_BODY: {
                return new IRMetaClassBody(manager, lexicalParent, manager.getMetaClassName().getBytes(), line, staticScope);
            }
            case INSTANCE_METHOD: {
                return new IRMethod(manager, lexicalParent, null, byteName, true, line, staticScope, false);
            }
            case CLASS_METHOD: {
                return new IRMethod(manager, lexicalParent, null, byteName, false, line, staticScope, false);
            }
            case MODULE_BODY: {
                return new IRModuleBody(manager, lexicalParent, byteName, line, staticScope, false);
            }
            case SCRIPT_BODY: {
                return new IRScriptBody(manager, file2, staticScope);
            }
            case FOR: {
                return new IRFor(manager, lexicalParent, line, staticScope, signature);
            }
            case CLOSURE: {
                return new IRClosure(manager, lexicalParent, line, staticScope, signature);
            }
            case EVAL_SCRIPT: {
                return new IREvalScript(manager, lexicalParent, lexicalParent.getFileName(), line, staticScope, EvalType.NONE);
            }
        }
        throw new RuntimeException("No such scope type: " + (Object)((Object)type2));
    }
}

