/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RegistryKeepAliveRunner
implements Runnable {
    private static final Log log = LogFactory.getLog(RegistryKeepAliveRunner.class);
    private String namingURL;
    private String serviceName;
    private int registryPort;
    private ICacheEventLogger cacheEventLogger;
    private Registry registry;

    public RegistryKeepAliveRunner(String registryHost, int registryPort, String serviceName) {
        this.namingURL = RemoteUtils.getNamingURL(registryHost, registryPort, serviceName);
        this.serviceName = serviceName;
        this.registryPort = registryPort;
    }

    @Override
    public void run() {
        this.checkAndRestoreIfNeeded();
    }

    protected void checkAndRestoreIfNeeded() {
        if (log.isDebugEnabled()) {
            log.debug("looking up server " + this.namingURL);
        }
        try {
            Remote obj = Naming.lookup(this.namingURL);
            String message = "RMI registry looks fine.  Found [" + obj + "] in registry [" + this.namingURL + "]";
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "Naming.lookup", message);
            }
            if (log.isDebugEnabled()) {
                log.debug(message);
            }
        }
        catch (Exception ex) {
            String message = "Problem finding server at [" + this.namingURL + "].  Will attempt to start registry and rebind.";
            log.error(message, ex);
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "Naming.lookup", message + ":" + ex.getMessage());
            }
            this.createAndRegister(this.serviceName);
        }
    }

    protected void createAndRegister(String serviceName) {
        this.createReqistry(serviceName);
        this.registerServer(serviceName);
    }

    protected void createReqistry(String serviceName) {
        this.registry = RemoteUtils.createRegistry(this.registryPort);
        if (this.cacheEventLogger != null) {
            if (this.registry != null) {
                this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "createRegistry", "Successfully created registry [" + serviceName + "].");
            } else {
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "createRegistry", "Could not start registry [" + serviceName + "].");
            }
        }
    }

    protected void registerServer(String serviceName) {
        block5: {
            try {
                RemoteCacheServer server = RemoteCacheServerFactory.getRemoteCacheServer();
                if (server == null) {
                    throw new RemoteException("Cannot register the server until it is created.");
                }
                this.registry.rebind(serviceName, server);
                String message = "Successfully rebound server to registry [" + serviceName + "].";
                if (this.cacheEventLogger != null) {
                    this.cacheEventLogger.logApplicationEvent("RegistryKeepAliveRunner", "registerServer", message);
                }
                if (log.isInfoEnabled()) {
                    log.info(message);
                }
            }
            catch (RemoteException e) {
                String message = "Could not rebind server to registry [" + serviceName + "].";
                log.error(message, e);
                if (this.cacheEventLogger == null) break block5;
                this.cacheEventLogger.logError("RegistryKeepAliveRunner", "registerServer", message + ":" + e.getMessage());
            }
        }
    }

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }
}

