/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.StringTokenizer;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.util.DefaultList;

public class StringConcatenationUtil {
    public static Expression create(Expression expression, int lineNumber, String typeName) {
        MethodInvocationExpression mie;
        if (expression.getClass() == MethodInvocationExpression.class && "append".equals((mie = (MethodInvocationExpression)expression).getName()) && mie.getParameters() != null && !mie.getParameters().isList()) {
            NewExpression ne;
            String internalTypeName;
            Expression concatenatedStringExpression = (Expression)mie.getParameters().getFirst();
            Expression expr = mie.getExpression();
            while (expr.getClass() == MethodInvocationExpression.class && "append".equals((mie = (MethodInvocationExpression)expr).getName()) && mie.getParameters() != null && !mie.getParameters().isList()) {
                concatenatedStringExpression = new BinaryOperatorExpression(mie.getLineNumber(), ObjectType.TYPE_STRING, (Expression)mie.getParameters(), "+", concatenatedStringExpression, 4);
                expr = mie.getExpression();
            }
            if (expr.getClass() == NewExpression.class && ("Ljava/lang/StringBuilder;".equals(internalTypeName = (ne = (NewExpression)expr).getType().getDescriptor()) || "Ljava/lang/StringBuffer;".equals(internalTypeName))) {
                if (ne.getParameters() == null) {
                    return concatenatedStringExpression;
                }
                if (!ne.getParameters().isList() && (expression = (Expression)ne.getParameters().getFirst()).getType() == ObjectType.TYPE_STRING) {
                    return new BinaryOperatorExpression(ne.getLineNumber(), ObjectType.TYPE_STRING, expression, "+", concatenatedStringExpression, 4);
                }
            }
        }
        return new MethodInvocationExpression(lineNumber, ObjectType.TYPE_STRING, expression, typeName, "toString", "()Ljava/lang/String;");
    }

    public static Expression create(String recipe, BaseExpression parameters) {
        StringTokenizer st = new StringTokenizer(recipe, "\u0001", true);
        if (st.hasMoreTokens()) {
            Expression expression;
            String token = st.nextToken();
            Expression expression2 = expression = token.equals("\u0001") ? StringConcatenationUtil.createFirstStringConcatenationItem((Expression)parameters.getFirst()) : new StringConstantExpression(token);
            if (parameters.isList()) {
                DefaultList list = parameters.getList();
                int index = 0;
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    Expression e = token.equals("\u0001") ? (Expression)list.get(index++) : new StringConstantExpression(token);
                    expression = new BinaryOperatorExpression(expression.getLineNumber(), ObjectType.TYPE_STRING, expression, "+", e, 6);
                }
            } else {
                while (st.hasMoreTokens()) {
                    token = st.nextToken();
                    Expression e = token.equals("\u0001") ? (Expression)parameters.getFirst() : new StringConstantExpression(token);
                    expression = new BinaryOperatorExpression(expression.getLineNumber(), ObjectType.TYPE_STRING, expression, "+", e, 6);
                }
            }
            return expression;
        }
        return StringConstantExpression.EMPTY_STRING;
    }

    public static Expression create(BaseExpression parameters) {
        if (parameters.isList()) {
            DefaultList list = parameters.getList();
            switch (list.size()) {
                case 0: {
                    return StringConstantExpression.EMPTY_STRING;
                }
                case 1: {
                    return StringConcatenationUtil.createFirstStringConcatenationItem((Expression)parameters.getFirst());
                }
            }
            Expression expression = StringConcatenationUtil.createFirstStringConcatenationItem((Expression)parameters.getFirst());
            int len = list.size();
            for (int i = 1; i < len; ++i) {
                expression = new BinaryOperatorExpression(expression.getLineNumber(), ObjectType.TYPE_STRING, expression, "+", (Expression)list.get(i), 6);
            }
            return expression;
        }
        return StringConcatenationUtil.createFirstStringConcatenationItem((Expression)parameters.getFirst());
    }

    private static Expression createFirstStringConcatenationItem(Expression expression) {
        if (!expression.getType().equals(ObjectType.TYPE_STRING)) {
            expression = new BinaryOperatorExpression(expression.getLineNumber(), ObjectType.TYPE_STRING, StringConstantExpression.EMPTY_STRING, "+", expression, 6);
        }
        return expression;
    }
}

