/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg;

import java.util.HashSet;
import java.util.Iterator;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.ControlFlowGraph;
import org.jd.core.v1.util.DefaultList;

public class BasicBlock {
    public static final int TYPE_DELETED = 0;
    public static final int TYPE_START = 1;
    public static final int TYPE_END = 2;
    public static final int TYPE_STATEMENTS = 4;
    public static final int TYPE_THROW = 8;
    public static final int TYPE_RETURN = 16;
    public static final int TYPE_RETURN_VALUE = 32;
    public static final int TYPE_SWITCH_DECLARATION = 64;
    public static final int TYPE_SWITCH = 128;
    public static final int TYPE_SWITCH_BREAK = 256;
    public static final int TYPE_TRY_DECLARATION = 512;
    public static final int TYPE_TRY = 1024;
    public static final int TYPE_TRY_JSR = 2048;
    public static final int TYPE_TRY_ECLIPSE = 4096;
    public static final int TYPE_JSR = 8192;
    public static final int TYPE_RET = 16384;
    public static final int TYPE_CONDITIONAL_BRANCH = 32768;
    public static final int TYPE_IF = 65536;
    public static final int TYPE_IF_ELSE = 131072;
    public static final int TYPE_CONDITION = 262144;
    public static final int TYPE_CONDITION_OR = 524288;
    public static final int TYPE_CONDITION_AND = 0x100000;
    public static final int TYPE_CONDITION_TERNARY_OPERATOR = 0x200000;
    public static final int TYPE_LOOP = 0x400000;
    public static final int TYPE_LOOP_START = 0x800000;
    public static final int TYPE_LOOP_CONTINUE = 0x1000000;
    public static final int TYPE_LOOP_END = 0x2000000;
    public static final int TYPE_GOTO = 0x4000000;
    public static final int TYPE_INFINITE_GOTO = 0x8000000;
    public static final int TYPE_GOTO_IN_TERNARY_OPERATOR = 0x10000000;
    public static final int TYPE_TERNARY_OPERATOR = 0x20000000;
    public static final int TYPE_JUMP = 0x40000000;
    public static final int GROUP_SINGLE_SUCCESSOR = 876822149;
    public static final int GROUP_SYNTHETIC = 1140900419;
    public static final int GROUP_CODE = 472178940;
    public static final int GROUP_END = 1266696506;
    public static final int GROUP_CONDITION = 0x3C0000;
    protected static final String[] TYPE_NAMES = new String[]{"DELETED", "START", "END", "STATEMENTS", "THROW", "RETURN", "RETURN_VALUE", "SWITCH_DECLARATION", "SWITCH", "SWITCH_BREAK", "TRY_DECLARATION", "TRY", "TRY_JSR", "TYPE_TRY_ECLIPSE", "JSR", "RET", "CONDITIONAL_BRANCH", "IF", "IF_ELSE", "CONDITION", "CONDITION_OR", "CONDITION_AND", "CONDITION_TERNARY_OPERATOR", "LOOP", "LOOP_START", "LOOP_CONTINUE", "LOOP_END", "GOTO", "INFINITE_GOTO", "GOTO_IN_TERNARY_OP", "TERNARY_OP", "JUMP"};
    protected static final DefaultList<ExceptionHandler> EMPTY_EXCEPTION_HANDLERS = DefaultList.emptyList();
    protected static final DefaultList<SwitchCase> EMPTY_SWITCH_CASES = DefaultList.emptyList();
    public static final BasicBlock SWITCH_BREAK = new ImmutableBasicBlock(256);
    public static final BasicBlock LOOP_START = new ImmutableBasicBlock(0x800000);
    public static final BasicBlock LOOP_CONTINUE = new ImmutableBasicBlock(0x1000000);
    public static final BasicBlock LOOP_END = new ImmutableBasicBlock(0x2000000);
    public static final BasicBlock END = new ImmutableBasicBlock(2);
    public static final BasicBlock RETURN = new ImmutableBasicBlock(16);
    protected ControlFlowGraph controlFlowGraph;
    protected int index;
    protected int type;
    protected int fromOffset;
    protected int toOffset;
    protected BasicBlock next;
    protected BasicBlock branch;
    protected BasicBlock condition;
    protected boolean inverseCondition;
    protected BasicBlock sub1;
    protected BasicBlock sub2;
    protected DefaultList<ExceptionHandler> exceptionHandlers = EMPTY_EXCEPTION_HANDLERS;
    protected DefaultList<SwitchCase> switchCases = EMPTY_SWITCH_CASES;
    protected HashSet<BasicBlock> predecessors;

    public BasicBlock(ControlFlowGraph controlFlowGraph, int index, BasicBlock original) {
        this(controlFlowGraph, index, original, new HashSet<BasicBlock>());
    }

    public BasicBlock(ControlFlowGraph controlFlowGraph, int index, BasicBlock original, HashSet<BasicBlock> predecessors) {
        this.controlFlowGraph = controlFlowGraph;
        this.index = index;
        this.type = original.type;
        this.fromOffset = original.fromOffset;
        this.toOffset = original.toOffset;
        this.next = original.next;
        this.branch = original.branch;
        this.condition = original.condition;
        this.inverseCondition = original.inverseCondition;
        this.sub1 = original.sub1;
        this.sub2 = original.sub2;
        this.exceptionHandlers = original.exceptionHandlers;
        this.switchCases = original.switchCases;
        this.predecessors = predecessors;
    }

    public BasicBlock(ControlFlowGraph controlFlowGraph, int index, int type, int fromOffset, int toOffset, boolean inverseCondition) {
        this(controlFlowGraph, index, type, fromOffset, toOffset, inverseCondition, new HashSet<BasicBlock>());
    }

    public BasicBlock(ControlFlowGraph controlFlowGraph, int index, int type, int fromOffset, int toOffset, boolean inverseCondition, HashSet<BasicBlock> predecessors) {
        this.controlFlowGraph = controlFlowGraph;
        this.index = index;
        this.type = type;
        this.fromOffset = fromOffset;
        this.toOffset = toOffset;
        this.sub1 = this.sub2 = END;
        this.condition = this.sub2;
        this.branch = this.sub2;
        this.next = this.sub2;
        this.predecessors = predecessors;
        this.inverseCondition = inverseCondition;
    }

    public ControlFlowGraph getControlFlowGraph() {
        return this.controlFlowGraph;
    }

    public int getIndex() {
        return this.index;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getFromOffset() {
        return this.fromOffset;
    }

    public void setFromOffset(int fromOffset) {
        this.fromOffset = fromOffset;
    }

    public int getToOffset() {
        return this.toOffset;
    }

    public void setToOffset(int toOffset) {
        this.toOffset = toOffset;
    }

    public int getFirstLineNumber() {
        return this.controlFlowGraph.getLineNumber(this.fromOffset);
    }

    public int getLastLineNumber() {
        return this.controlFlowGraph.getLineNumber(this.toOffset - 1);
    }

    public BasicBlock getNext() {
        return this.next;
    }

    public void setNext(BasicBlock next) {
        this.next = next;
    }

    public BasicBlock getBranch() {
        return this.branch;
    }

    public void setBranch(BasicBlock branch) {
        this.branch = branch;
    }

    public DefaultList<ExceptionHandler> getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public DefaultList<SwitchCase> getSwitchCases() {
        return this.switchCases;
    }

    public void setSwitchCases(DefaultList<SwitchCase> switchCases) {
        this.switchCases = switchCases;
    }

    public BasicBlock getCondition() {
        return this.condition;
    }

    public void setCondition(BasicBlock condition) {
        this.condition = condition;
    }

    public BasicBlock getSub1() {
        return this.sub1;
    }

    public void setSub1(BasicBlock sub1) {
        this.sub1 = sub1;
    }

    public BasicBlock getSub2() {
        return this.sub2;
    }

    public void setSub2(BasicBlock sub2) {
        this.sub2 = sub2;
    }

    public HashSet<BasicBlock> getPredecessors() {
        return this.predecessors;
    }

    public boolean mustInverseCondition() {
        return this.inverseCondition;
    }

    public void setInverseCondition(boolean inverseCondition) {
        this.inverseCondition = inverseCondition;
    }

    public boolean contains(BasicBlock basicBlock) {
        if (this.next == basicBlock) {
            return true;
        }
        if (this.branch == basicBlock) {
            return true;
        }
        for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
            if (exceptionHandler.getBasicBlock() != basicBlock) continue;
            return true;
        }
        for (SwitchCase switchCase : this.switchCases) {
            if (switchCase.getBasicBlock() != basicBlock) continue;
            return true;
        }
        if (this.sub1 == basicBlock) {
            return true;
        }
        return this.sub2 == basicBlock;
    }

    public void replace(BasicBlock old, BasicBlock nevv) {
        if (this.next == old) {
            this.next = nevv;
        }
        if (this.branch == old) {
            this.branch = nevv;
        }
        for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
            exceptionHandler.replace(old, nevv);
        }
        for (SwitchCase switchCase : this.switchCases) {
            switchCase.replace(old, nevv);
        }
        if (this.sub1 == old) {
            this.sub1 = nevv;
        }
        if (this.sub2 == old) {
            this.sub2 = nevv;
        }
        if (this.predecessors.contains(old)) {
            this.predecessors.remove(old);
            if (nevv != END) {
                this.predecessors.add(nevv);
            }
        }
    }

    public void replace(HashSet<BasicBlock> olds, BasicBlock nevv) {
        if (olds.contains(this.next)) {
            this.next = nevv;
        }
        if (olds.contains(this.branch)) {
            this.branch = nevv;
        }
        for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
            exceptionHandler.replace(olds, nevv);
        }
        for (SwitchCase switchCase : this.switchCases) {
            switchCase.replace(olds, nevv);
        }
        if (olds.contains(this.sub1)) {
            this.sub1 = nevv;
        }
        if (olds.contains(this.sub2)) {
            this.sub2 = nevv;
        }
        this.predecessors.removeAll(olds);
        this.predecessors.add(nevv);
    }

    public void addExceptionHandler(String internalThrowableName, BasicBlock basicBlock) {
        if (this.exceptionHandlers == EMPTY_EXCEPTION_HANDLERS) {
            this.exceptionHandlers = new DefaultList();
            this.exceptionHandlers.add(new ExceptionHandler(internalThrowableName, basicBlock));
        } else {
            for (ExceptionHandler exceptionHandler : this.exceptionHandlers) {
                if (exceptionHandler.getBasicBlock() != basicBlock) continue;
                exceptionHandler.addInternalThrowableName(internalThrowableName);
                return;
            }
            this.exceptionHandlers.add(new ExceptionHandler(internalThrowableName, basicBlock));
        }
    }

    public void inverseCondition() {
        switch (this.type) {
            case 262144: 
            case 0x200000: 
            case 0x10000000: {
                this.inverseCondition ^= true;
                break;
            }
            case 0x100000: {
                this.type = 524288;
                this.sub1.inverseCondition();
                this.sub2.inverseCondition();
                break;
            }
            case 524288: {
                this.type = 0x100000;
                this.sub1.inverseCondition();
                this.sub2.inverseCondition();
                break;
            }
            default: {
                assert (false) : "Invalid condition";
                break;
            }
        }
    }

    public boolean matchType(int types) {
        return (this.type & types) != 0;
    }

    public String getTypeName() {
        return TYPE_NAMES[this.type == 0 ? 0 : Integer.numberOfTrailingZeros(this.type) + 1];
    }

    public String toString() {
        String s = "BasicBlock{index=" + this.index + ", from=" + this.fromOffset + ", to=" + this.toOffset + ", type=" + this.getTypeName() + ", inverseCondition=" + this.inverseCondition;
        if (!this.predecessors.isEmpty()) {
            s = s + ", predecessors=[";
            Iterator<BasicBlock> iterator = this.predecessors.iterator();
            if (iterator.hasNext()) {
                s = s + iterator.next().getIndex();
                while (iterator.hasNext()) {
                    s = s + ", " + iterator.next().getIndex();
                }
            }
            s = s + "]";
        }
        return s + "}";
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object other) {
        return this.index == ((BasicBlock)other).index;
    }

    protected static class ImmutableBasicBlock
    extends BasicBlock {
        public ImmutableBasicBlock(int type) {
            super(null, -1, type, 0, 0, true, new HashSet<BasicBlock>(){

                @Override
                public boolean add(BasicBlock e) {
                    return false;
                }
            });
        }

        @Override
        public int getFirstLineNumber() {
            return 0;
        }

        @Override
        public int getLastLineNumber() {
            return 0;
        }
    }

    public static class SwitchCase {
        protected int value;
        protected int offset;
        protected BasicBlock basicBlock;
        protected boolean defaultCase;

        public SwitchCase(BasicBlock basicBlock) {
            this.offset = basicBlock.getFromOffset();
            this.basicBlock = basicBlock;
            this.defaultCase = true;
        }

        public SwitchCase(int value, BasicBlock basicBlock) {
            this.value = value;
            this.offset = basicBlock.getFromOffset();
            this.basicBlock = basicBlock;
            this.defaultCase = false;
        }

        public int getValue() {
            return this.value;
        }

        public int getOffset() {
            return this.offset;
        }

        public BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(BasicBlock basicBlock) {
            this.basicBlock = basicBlock;
        }

        public boolean isDefaultCase() {
            return this.defaultCase;
        }

        public void replace(BasicBlock old, BasicBlock nevv) {
            if (this.basicBlock == old) {
                this.basicBlock = nevv;
            }
        }

        public void replace(HashSet<BasicBlock> olds, BasicBlock nevv) {
            if (olds.contains(this.basicBlock)) {
                this.basicBlock = nevv;
            }
        }

        public String toString() {
            if (this.defaultCase) {
                return "BasicBlock.SwitchCase{default: " + this.basicBlock + "}";
            }
            return "BasicBlock.SwitchCase{'" + this.value + "': " + this.basicBlock + "}";
        }
    }

    public static class ExceptionHandler {
        protected String internalThrowableName;
        protected DefaultList<String> otherInternalThrowableNames;
        protected BasicBlock basicBlock;

        public ExceptionHandler(String internalThrowableName, BasicBlock basicBlock) {
            this.internalThrowableName = internalThrowableName;
            this.basicBlock = basicBlock;
        }

        public String getInternalThrowableName() {
            return this.internalThrowableName;
        }

        public DefaultList<String> getOtherInternalThrowableNames() {
            return this.otherInternalThrowableNames;
        }

        public BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public void setBasicBlock(BasicBlock basicBlock) {
            this.basicBlock = basicBlock;
        }

        public void addInternalThrowableName(String internalThrowableName) {
            if (this.otherInternalThrowableNames == null) {
                this.otherInternalThrowableNames = new DefaultList();
            }
            this.otherInternalThrowableNames.add(internalThrowableName);
        }

        public void replace(BasicBlock old, BasicBlock nevv) {
            if (this.basicBlock == old) {
                this.basicBlock = nevv;
            }
        }

        public void replace(HashSet<BasicBlock> olds, BasicBlock nevv) {
            if (olds.contains(this.basicBlock)) {
                this.basicBlock = nevv;
            }
        }

        public String toString() {
            if (this.otherInternalThrowableNames == null) {
                return "BasicBlock.Handler{" + this.internalThrowableName + " -> " + this.basicBlock + "}";
            }
            return "BasicBlock.Handler{" + this.internalThrowableName + ", " + this.otherInternalThrowableNames + " -> " + this.basicBlock + "}";
        }
    }
}

