/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.declaration;

import java.util.List;
import org.jd.core.v1.model.javasyntax.declaration.DeclarationVisitor;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;

public class ModuleDeclaration
extends TypeDeclaration {
    protected String version;
    protected List<ModuleInfo> requires;
    protected List<PackageInfo> exports;
    protected List<PackageInfo> opens;
    protected List<String> uses;
    protected List<ServiceInfo> provides;

    public ModuleDeclaration(int flags, String internalName, String name, String version, List<ModuleInfo> requires, List<PackageInfo> exports, List<PackageInfo> opens, List<String> uses, List<ServiceInfo> provides) {
        super(null, flags, internalName, name);
        this.version = version;
        this.requires = requires;
        this.exports = exports;
        this.opens = opens;
        this.uses = uses;
        this.provides = provides;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ModuleInfo> getRequires() {
        return this.requires;
    }

    public List<PackageInfo> getExports() {
        return this.exports;
    }

    public List<PackageInfo> getOpens() {
        return this.opens;
    }

    public List<String> getUses() {
        return this.uses;
    }

    public List<ServiceInfo> getProvides() {
        return this.provides;
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "ModuleDeclaration{" + this.internalName + "}";
    }

    public static class ServiceInfo {
        protected String interfaceTypeName;
        protected List<String> implementationTypeNames;

        public ServiceInfo(String interfaceTypeName, List<String> implementationTypeNames) {
            this.interfaceTypeName = interfaceTypeName;
            this.implementationTypeNames = implementationTypeNames;
        }

        public String getInterfaceTypeName() {
            return this.interfaceTypeName;
        }

        public List<String> getImplementationTypeNames() {
            return this.implementationTypeNames;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ServiceInfo{interfaceTypeName=").append(this.interfaceTypeName);
            if (this.implementationTypeNames != null) {
                sb.append(", implementationTypeNames=").append(this.implementationTypeNames);
            }
            return sb.append("}").toString();
        }
    }

    public static class PackageInfo {
        protected String internalName;
        protected int flags;
        protected List<String> moduleInfoNames;

        public PackageInfo(String internalName, int flags, List<String> moduleInfoNames) {
            this.internalName = internalName;
            this.flags = flags;
            this.moduleInfoNames = moduleInfoNames;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public int getFlags() {
            return this.flags;
        }

        public List<String> getModuleInfoNames() {
            return this.moduleInfoNames;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("PackageInfo{internalName=").append(this.internalName);
            sb.append(", flags=").append(this.flags);
            if (this.moduleInfoNames != null) {
                sb.append(", moduleInfoNames=").append(this.moduleInfoNames);
            }
            return sb.append("}").toString();
        }
    }

    public static class ModuleInfo {
        protected String name;
        protected int flags;
        protected String version;

        public ModuleInfo(String name, int flags, String version) {
            this.name = name;
            this.flags = flags;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public int getFlags() {
            return this.flags;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ModuleInfo{name=").append(this.name);
            sb.append(", flags=").append(this.flags);
            if (this.version != null) {
                sb.append(", version=").append(this.version);
            }
            return sb.append("}").toString();
        }
    }
}

