/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jadx.gui.JadxGUI;
import jadx.gui.settings.JadxSettings;
import jadx.gui.utils.PathTypeAdapter;
import jadx.gui.utils.RectangleTypeAdapter;
import java.awt.Rectangle;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxSettingsAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettingsAdapter.class);
    private static final String JADX_GUI_KEY = "jadx.gui.settings";
    private static final Preferences PREFS = Preferences.userNodeForPackage(JadxGUI.class);
    private static final ExclusionStrategy EXCLUDE_FIELDS = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return JadxSettings.SKIP_FIELDS.contains(f.getName()) || f.hasModifier(1) || f.hasModifier(128) || f.getAnnotation(GsonExclude.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{EXCLUDE_FIELDS}).registerTypeHierarchyAdapter(Path.class, PathTypeAdapter.singleton()).registerTypeHierarchyAdapter(Rectangle.class, RectangleTypeAdapter.singleton());
    private static final Gson GSON = GSON_BUILDER.create();

    private JadxSettingsAdapter() {
    }

    public static JadxSettings load() {
        try {
            String jsonSettings = PREFS.get(JADX_GUI_KEY, "");
            JadxSettings settings = JadxSettingsAdapter.fromString(jsonSettings);
            if (settings == null) {
                LOG.debug("Created new settings.");
                settings = JadxSettings.makeDefault();
            } else {
                settings.fixOnLoad();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded settings: {}", (Object)JadxSettingsAdapter.makeString(settings));
            }
            return settings;
        }
        catch (Exception e) {
            LOG.error("Error load settings", (Throwable)e);
            return new JadxSettings();
        }
    }

    public static void store(JadxSettings settings) {
        try {
            String jsonSettings = JadxSettingsAdapter.makeString(settings);
            LOG.debug("Saving settings: {}", (Object)jsonSettings);
            PREFS.put(JADX_GUI_KEY, jsonSettings);
            PREFS.sync();
        }
        catch (Exception e) {
            LOG.error("Error store settings", (Throwable)e);
        }
    }

    public static JadxSettings fromString(String jsonSettings) {
        return (JadxSettings)GSON.fromJson(jsonSettings, JadxSettings.class);
    }

    public static String makeString(JadxSettings settings) {
        return GSON.toJson((Object)settings);
    }

    public static void fill(JadxSettings settings, String jsonStr) {
        JadxSettingsAdapter.populate(GSON_BUILDER, jsonStr, JadxSettings.class, settings);
    }

    private static <T> void populate(GsonBuilder builder, String json, Class<T> type, T into) {
        builder.registerTypeAdapter(type, t -> into).create().fromJson(json, type);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface GsonExclude {
    }
}

