/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.JavaPackage;
import jadx.api.ResourceFile;
import jadx.gui.settings.JadxSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.swing.ProgressMonitor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(JadxWrapper.class);
    private final JadxSettings settings;
    private JadxDecompiler decompiler;
    private File openFile;

    public JadxWrapper(JadxSettings settings) {
        this.settings = settings;
    }

    public void openFile(File file) {
        this.openFile = file;
        try {
            JadxArgs jadxArgs = this.settings.toJadxArgs();
            jadxArgs.setInputFile(file);
            this.decompiler = new JadxDecompiler(jadxArgs);
            this.decompiler.load();
        }
        catch (Exception e) {
            LOG.error("Jadx init error", (Throwable)e);
        }
    }

    public void saveAll(File dir, ProgressMonitor progressMonitor) {
        Runnable save = () -> {
            try {
                this.decompiler.getArgs().setRootDir(dir);
                ThreadPoolExecutor ex = (ThreadPoolExecutor)this.decompiler.getSaveExecutor();
                ex.shutdown();
                while (ex.isTerminating()) {
                    long total = ex.getTaskCount();
                    long done = ex.getCompletedTaskCount();
                    progressMonitor.setProgress((int)((double)done * 100.0 / (double)total));
                    Thread.sleep(500L);
                }
                progressMonitor.close();
                LOG.info("decompilation complete, freeing memory ...");
                this.decompiler.getClasses().forEach(JavaClass::unload);
                LOG.info("done");
            }
            catch (InterruptedException e) {
                LOG.error("Save interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        };
        new Thread(save).start();
    }

    public List<JavaClass> getClasses() {
        return this.decompiler.getClasses();
    }

    public List<JavaClass> getIncludedClasses() {
        List classList = this.decompiler.getClasses();
        List<String> excludedPackages = this.getExcludedPackages();
        if (excludedPackages.isEmpty()) {
            return classList;
        }
        return classList.stream().filter(cls -> {
            for (String exclude : excludedPackages) {
                if (!cls.getFullName().equals(exclude) && !cls.getFullName().startsWith(exclude + '.')) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }

    public List<String> getExcludedPackages() {
        String excludedPackages = this.settings.getExcludedPackages().trim();
        if (excludedPackages.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(excludedPackages.split("[ ]+"));
    }

    public void addExcludedPackage(String packageToExclude) {
        String newExclusion = this.settings.getExcludedPackages() + ' ' + packageToExclude;
        this.settings.setExcludedPackages(newExclusion.trim());
        this.settings.sync();
    }

    public void removeExcludedPackage(String packageToRemoveFromExclusion) {
        ArrayList<String> list = new ArrayList<String>(this.getExcludedPackages());
        list.remove(packageToRemoveFromExclusion);
        this.settings.setExcludedPackages(String.join((CharSequence)" ", list));
        this.settings.sync();
    }

    public List<JavaPackage> getPackages() {
        return this.decompiler.getPackages();
    }

    public List<ResourceFile> getResources() {
        return this.decompiler.getResources();
    }

    public File getOpenFile() {
        return this.openFile;
    }

    public JadxArgs getArgs() {
        return this.decompiler.getArgs();
    }

    @Nullable
    public JavaClass searchJavaClassByClassName(String fullName) {
        return this.decompiler.getClasses().stream().filter(cls -> cls.getFullName().equals(fullName)).findFirst().orElse(null);
    }
}

