/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui;

import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import jadx.gui.utils.logs.LogCollector;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxGUI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxGUI.class);

    public static void main(String[] args) {
        try {
            LogCollector.register();
            JadxSettings settings = JadxSettingsAdapter.load();
            if (!settings.overrideProvided(args)) {
                return;
            }
            if (!JadxGUI.tryDefaultLookAndFeel()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            NLS.setLocale(settings.getLangLocale());
            SwingUtilities.invokeLater(new MainWindow(settings)::init);
        }
        catch (Exception e) {
            LOG.error("Error: {}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
    }

    private static boolean tryDefaultLookAndFeel() {
        String defLaf = System.getProperty("swing.defaultlaf");
        if (defLaf != null) {
            try {
                UIManager.setLookAndFeel(defLaf);
                return true;
            }
            catch (Exception e) {
                LOG.error("Failed to set default laf: {}", (Object)defLaf, (Object)e);
            }
        }
        return false;
    }
}

