/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.DexFileFactory;
import org.jf.dexlib2.Opcodes;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedParameter;

public abstract class DexInputCommand
extends Command {
    @Parameter(names={"-a", "--api"}, description="The numeric api level of the file being disassembled.")
    @ExtendedParameter(argumentNames={"api"})
    public int apiLevel = -1;
    @Parameter(description="A dex/apk/oat/odex file. For apk or oat files that contain multiple dex files, you can specify the specific entry to use as if the apk/oat file was a directory. e.g. \"app.apk/classes2.dex\". For more information, see \"baksmali help input\".")
    @ExtendedParameter(argumentNames={"file"})
    protected List<String> inputList = Lists.newArrayList();
    protected File inputFile;
    protected String inputEntry;
    protected DexBackedDexFile dexFile;

    public DexInputCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    protected void loadDexFile(@Nonnull String input) {
        File file;
        for (file = new File(input); file != null && !file.exists(); file = file.getParentFile()) {
        }
        if (file == null || !file.exists() || file.isDirectory()) {
            System.err.println("Can't find file: " + input);
            System.exit(1);
        }
        this.inputFile = file;
        String dexEntry = null;
        if (file.getPath().length() < input.length()) {
            dexEntry = input.substring(file.getPath().length() + 1);
        }
        Opcodes opcodes = null;
        if (this.apiLevel != -1) {
            opcodes = Opcodes.forApi((int)this.apiLevel);
        }
        if (!Strings.isNullOrEmpty((String)dexEntry)) {
            boolean exactMatch = false;
            if (dexEntry.length() > 2 && dexEntry.charAt(0) == '\"' && dexEntry.charAt(dexEntry.length() - 1) == '\"') {
                dexEntry = dexEntry.substring(1, dexEntry.length() - 1);
                exactMatch = true;
            }
            this.inputEntry = dexEntry;
            try {
                this.dexFile = DexFileFactory.loadDexEntry((File)file, (String)dexEntry, (boolean)exactMatch, (Opcodes)opcodes);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            this.dexFile = DexFileFactory.loadDexFile((File)file, (Opcodes)opcodes);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

