/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.project.tool;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.Project;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolChest;
import ghidra.framework.model.ToolConnection;
import ghidra.framework.model.ToolManager;
import ghidra.framework.model.ToolServices;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import ghidra.framework.model.WorkspaceChangeListener;
import ghidra.framework.project.tool.GhidraTool;
import ghidra.framework.project.tool.SelectChangedToolDialog;
import ghidra.framework.project.tool.ToolConnectionImpl;
import ghidra.framework.project.tool.ToolServicesImpl;
import ghidra.framework.project.tool.WorkspaceImpl;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.DuplicateNameException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public class ToolManagerImpl
implements ToolManager,
PropertyChangeListener {
    private static final int TYPICAL_NUM_WORKSPACES = 3;
    private static final int TYPICAL_NUM_TOOLS = 5;
    private static final int TYPICAL_NUM_CONNECTIONS = 10;
    private ToolChest toolChest;
    private ToolServicesImpl toolServices;
    private Map<Workspace, Workspace> changedWorkspaces;
    private List<Workspace> workspaces;
    private Map<String, Workspace> wsMap;
    private Map<String, ToolConnectionImpl> connectMap;
    private Map<String, List<Tool>> namesMap;
    private WorkspaceImpl activeWorkspace;
    private ArrayList<WorkspaceChangeListener> changeListeners;
    private boolean activeWorkspaceChanged;
    private boolean inRestoreMode;
    private Project project;
    private Map<String, ToolSaveStatus> toolStatusMap = new HashMap<String, ToolSaveStatus>();

    public ToolManagerImpl(Project project) {
        this.project = project;
        this.toolChest = project.getLocalToolChest();
        this.toolServices = new ToolServicesImpl(this.toolChest, this);
        this.workspaces = new ArrayList<Workspace>(3);
        this.changedWorkspaces = new HashMap<Workspace, Workspace>(3);
        this.connectMap = new HashMap<String, ToolConnectionImpl>(10);
        this.wsMap = new HashMap<String, Workspace>(3);
        this.changeListeners = new ArrayList(3);
        this.namesMap = new HashMap<String, List<Tool>>(5);
        this.activeWorkspaceChanged = false;
    }

    private void registerTool(String toolName, Tool tool) {
        List<Tool> list = this.namesMap.get(toolName);
        if (list == null) {
            list = new ArrayList<Tool>(5);
            this.namesMap.put(toolName, list);
        }
        list.add(tool);
        if (list.size() == 1) {
            this.toolStatusMap.put(toolName, ToolSaveStatus.AUTO_SAVE_MODE);
        }
        String instanceName = this.generateInstanceName(toolName, tool);
        tool.putInstanceName(instanceName);
        tool.addPropertyChangeListener(this);
    }

    private void deregisterTool(String toolName, Tool tool) {
        List<Tool> list = this.namesMap.get(toolName);
        SystemUtilities.assertTrue((list != null ? 1 : 0) != 0, (String)"Attempted to remove tool that's not there");
        list.remove(tool);
        if (list.size() == 0) {
            this.namesMap.remove(toolName);
            this.toolStatusMap.remove(toolName);
        }
        tool.removePropertyChangeListener(this);
    }

    @Override
    public Workspace getActiveWorkspace() {
        return this.activeWorkspace;
    }

    @Override
    public Tool[] getConsumerTools() {
        Tool[] runningTools;
        ArrayList<Tool> consumers = new ArrayList<Tool>(5);
        for (Tool tool : runningTools = this.getRunningTools()) {
            if (tool.getConsumedToolEventNames().length <= 0) continue;
            consumers.add(tool);
        }
        Tool[] tools = new Tool[consumers.size()];
        consumers.toArray(tools);
        return tools;
    }

    @Override
    public Tool[] getProducerTools() {
        Tool[] runningTools;
        ArrayList<Tool> producers = new ArrayList<Tool>(5);
        for (Tool tool : runningTools = this.getRunningTools()) {
            if (tool.getToolEventNames().length <= 0) continue;
            producers.add(tool);
        }
        Tool[] tools = new Tool[producers.size()];
        return producers.toArray(tools);
    }

    @Override
    public Tool[] getRunningTools() {
        Workspace[] wsList = new Workspace[this.workspaces.size()];
        this.workspaces.toArray(wsList);
        ArrayList<Tool> runningTools = new ArrayList<Tool>(5);
        for (Workspace element : wsList) {
            Tool[] tools;
            for (Tool tool : tools = element.getTools()) {
                runningTools.add(tool);
            }
        }
        Tool[] tools = new Tool[runningTools.size()];
        runningTools.toArray(tools);
        return tools;
    }

    @Override
    public ToolConnection getConnection(Tool producer, Tool consumer) {
        String key = this.getKey(producer, consumer);
        ToolConnectionImpl tc = this.connectMap.get(key);
        if (tc == null) {
            tc = new ToolConnectionImpl(producer, consumer);
            this.connectMap.put(key, tc);
        }
        return tc;
    }

    @Override
    public Workspace createWorkspace(String name) throws DuplicateNameException {
        if (name == null || name.length() == 0) {
            name = "Workspace";
        }
        if (this.isDefaultWorkspaceName(name)) {
            name = this.getUniqueWorkspaceName();
        }
        if (this.wsMap.containsKey(name)) {
            throw new DuplicateNameException("Duplicate workspace requested: " + name);
        }
        WorkspaceImpl ws = new WorkspaceImpl(name, this);
        this.workspaces.add(ws);
        this.wsMap.put(name, ws);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            WorkspaceChangeListener listener = this.changeListeners.get(i);
            listener.workspaceAdded(ws);
        }
        ws.setActive();
        return ws;
    }

    @Override
    public void removeWorkspace(Workspace ws) {
        Tool[] runningTools;
        if (!this.workspaces.contains(ws)) {
            Msg.showError((Object)this, null, null, null, (Throwable)new RuntimeException("unknown/stale workspace reference: " + ws));
        }
        for (Tool runningTool : runningTools = ws.getTools()) {
            runningTool.close();
        }
        runningTools = ws.getTools();
        if (runningTools.length > 0) {
            return;
        }
        String wsName = ws.getName();
        this.workspaces.remove(ws);
        this.wsMap.remove(wsName);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            WorkspaceChangeListener listener = this.changeListeners.get(i);
            listener.workspaceRemoved(ws);
        }
        if (this.workspaces.size() == 0) {
            try {
                this.createWorkspace("Workspace");
            }
            catch (DuplicateNameException e) {
                Msg.showError((Object)this, null, (String)"Duplicate Name", (Object)("Error Creating Default Workspace: " + e.getMessage()));
            }
        } else {
            Workspace workspace = this.workspaces.get(0);
            workspace.setActive();
        }
    }

    @Override
    public Workspace[] getWorkspaces() {
        Workspace[] wsList = new Workspace[this.workspaces.size()];
        return this.workspaces.toArray(wsList);
    }

    public Element saveToXml() {
        Element root = new Element("TOOL_MANAGER");
        root.setAttribute("ACTIVE_WORKSPACE", this.activeWorkspace.getName());
        for (int i = 0; i < this.workspaces.size(); ++i) {
            WorkspaceImpl ws = (WorkspaceImpl)this.workspaces.get(i);
            root.addContent((Content)ws.saveToXml());
        }
        for (String key : this.connectMap.keySet()) {
            ToolConnectionImpl tc = this.connectMap.get(key);
            root.addContent((Content)tc.saveToXml());
        }
        this.changedWorkspaces.clear();
        this.activeWorkspaceChanged = false;
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFromXml(Element root) {
        this.inRestoreMode = true;
        try {
            HashMap<String, Tool> toolMap = new HashMap<String, Tool>();
            String activeWSName = root.getAttributeValue("ACTIVE_WORKSPACE");
            Workspace makeMeActive = null;
            List l = root.getChildren("WORKSPACE");
            for (Element elem : l) {
                Tool[] tools;
                WorkspaceImpl ws = new WorkspaceImpl("TEMP", this);
                ws.restoreFromXml(elem);
                this.workspaces.add(ws);
                this.wsMap.put(ws.getName(), ws);
                if (ws.getName().equals(activeWSName)) {
                    makeMeActive = ws;
                }
                for (Tool tool : tools = ws.getTools()) {
                    toolMap.put(tool.getName(), tool);
                }
            }
            if (makeMeActive != null) {
                makeMeActive.setActive();
            }
            for (Element elem : root.getChildren("CONNECTION")) {
                String producerName = elem.getAttributeValue("PRODUCER");
                String consumerName = elem.getAttributeValue("CONSUMER");
                Tool producer = (Tool)toolMap.get(producerName);
                Tool consumer = (Tool)toolMap.get(consumerName);
                if (producer == null || consumer == null) continue;
                ToolConnectionImpl tc = new ToolConnectionImpl(producer, consumer);
                tc.restoreFromXml(elem);
                this.connectMap.put(producerName + "+" + consumerName, tc);
            }
        }
        finally {
            this.inRestoreMode = false;
        }
    }

    public boolean hasChanged() {
        for (String key : this.connectMap.keySet()) {
            ToolConnectionImpl tc = this.connectMap.get(key);
            if (!tc.hasChanged()) continue;
            return true;
        }
        return this.changedWorkspaces.size() > 0 || this.activeWorkspaceChanged;
    }

    public void close() {
        for (int i = 0; i < this.workspaces.size(); ++i) {
            WorkspaceImpl w = (WorkspaceImpl)this.workspaces.get(i);
            w.close();
        }
    }

    public boolean saveSessionTools() {
        Set<String> keySet = this.namesMap.keySet();
        for (String toolName : keySet) {
            List<Tool> tools = this.namesMap.get(toolName);
            if (tools.size() == 1) {
                Tool tool = tools.get(0);
                if (!tool.shouldSave()) continue;
                this.toolServices.saveTool(tool);
                continue;
            }
            if (this.saveToolSet(tools)) continue;
            return false;
        }
        return true;
    }

    private boolean saveToolSet(List<Tool> tools) {
        ArrayList<Tool> changedTools = new ArrayList<Tool>();
        for (Tool tool : tools) {
            if (!tool.hasConfigChanged()) continue;
            changedTools.add(tool);
        }
        if (changedTools.isEmpty()) {
            return true;
        }
        if (changedTools.size() == 1) {
            Tool changedTool = (Tool)changedTools.get(0);
            if (changedTool.shouldSave()) {
                this.toolServices.saveTool(changedTool);
            }
            return true;
        }
        SelectChangedToolDialog dialog = new SelectChangedToolDialog(changedTools);
        FrontEndTool frontEndTool = AppInfo.getFrontEndTool();
        frontEndTool.showDialog((DialogComponentProvider)dialog, (ComponentProvider)null);
        if (dialog.wasCancelled()) {
            return false;
        }
        Tool tool = dialog.getSelectedTool();
        if (tool != null) {
            this.toolServices.saveTool(tool);
        }
        return true;
    }

    public void dispose() {
        this.toolServices.dispose();
    }

    public void dumpConnectionList() {
        for (String key : this.connectMap.keySet()) {
            String[] events;
            ToolConnection tc = this.connectMap.get(key);
            Msg.debug((Object)this, (Object)(key + "==> "));
            for (String event : events = tc.getEvents()) {
                Msg.debug((Object)this, (Object)("\t isConnected for " + event + "? = " + tc.isConnected(event)));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Tool tool = (Tool)evt.getSource();
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("PluginCount")) {
            this.updateConnections(evt);
        }
        if (!propertyName.equals("ToolName")) {
            return;
        }
        String oldName = (String)evt.getOldValue();
        String newName = (String)evt.getNewValue();
        this.deregisterTool(oldName, tool);
        this.registerTool(newName, tool);
        this.updateConnectMap(tool);
        this.firePropertyChangeEvent(evt);
    }

    @Override
    public void addWorkspaceChangeListener(WorkspaceChangeListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeWorkspaceChangeListener(WorkspaceChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void clearWorkspaceChanged() {
        this.activeWorkspaceChanged = false;
    }

    public ToolServices getToolServices() {
        return this.toolServices;
    }

    @Override
    public void toolChanged(Tool tool) {
        this.updateConnectMap(tool);
    }

    public Tool getTool(String toolName) {
        ToolTemplate template = this.toolServices.getToolChest().getToolTemplate(toolName);
        if (template == null) {
            return null;
        }
        Tool tool = template.createTool(this.project);
        if (tool != null) {
            this.registerTool(toolName, tool);
        }
        return tool;
    }

    void closeTool(Tool tool) {
        for (int i = 0; i < this.workspaces.size(); ++i) {
            Tool[] tools;
            WorkspaceImpl ws = (WorkspaceImpl)this.workspaces.get(i);
            for (Tool tool2 : tools = ws.getTools()) {
                if (tool != tool2) continue;
                ws.closeRunningTool(tool);
                return;
            }
        }
    }

    void setActiveWorkspace(WorkspaceImpl workspace) {
        if (workspace == this.activeWorkspace) {
            return;
        }
        if (!this.inRestoreMode) {
            this.activeWorkspaceChanged = true;
        }
        if (this.activeWorkspace != null) {
            this.activeWorkspace.setVisible(false);
        }
        this.activeWorkspace = workspace;
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            WorkspaceChangeListener listener = this.changeListeners.get(i);
            listener.workspaceSetActive(this.activeWorkspace);
        }
    }

    Workspace getWorkspace(String name) {
        return this.wsMap.get(name);
    }

    void setWorkspaceChanged(WorkspaceImpl ws) {
        if (!this.changedWorkspaces.containsKey(ws)) {
            this.changedWorkspaces.put(ws, ws);
        }
    }

    void setWorkspaceName(Workspace ws, String name) throws DuplicateNameException {
        if (this.wsMap.containsKey(name)) {
            throw new DuplicateNameException("Workspace named " + name + " already exists");
        }
        this.wsMap.remove(ws.getName());
        this.wsMap.put(name, ws);
        PropertyChangeEvent event = new PropertyChangeEvent(this, "WorkspaceName", ws.getName(), name);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            WorkspaceChangeListener l = this.changeListeners.get(i);
            l.propertyChange(event);
        }
    }

    Tool getTool(Workspace ws, ToolTemplate template) {
        Tool tool = template.createTool(this.project);
        if (tool != null) {
            this.registerTool(tool.getToolName(), tool);
        }
        return tool;
    }

    void toolRemoved(Workspace ws, Tool tool) {
        this.deregisterTool(tool.getToolName(), tool);
        this.disconnectTool(tool);
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            WorkspaceChangeListener l = this.changeListeners.get(i);
            l.toolRemoved(ws, tool);
        }
    }

    private String generateInstanceName(String toolName, Tool tool) {
        List<Tool> list = this.namesMap.get(toolName);
        if (list.size() <= 1) {
            return "";
        }
        Tool lastTool = list.get(list.size() - 2);
        String instanceName = lastTool.getInstanceName();
        if (instanceName.length() == 0) {
            return "2";
        }
        int n = Integer.parseInt(instanceName);
        return "" + (n + 1);
    }

    Tool createEmptyTool() {
        GhidraTool tool = new GhidraTool(this.project, "Untitled");
        this.addNewTool(tool, "Untitled");
        return tool;
    }

    private void addNewTool(Tool tool, String toolName) {
        try {
            tool.setToolName(toolName);
            this.registerTool(toolName, tool);
        }
        catch (PropertyVetoException e) {
            Msg.showError((Object)this, null, (String)"Error", (Object)"set type name was vetoed", (Throwable)e);
        }
        Msg.debug((Object)this, (Object)("Loaded " + tool.getName()));
    }

    void fireToolAddedEvent(Workspace ws, Tool tool) {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            WorkspaceChangeListener l = this.changeListeners.get(i);
            l.toolAdded(ws, tool);
        }
    }

    @Override
    public void disconnectTool(Tool tool) {
        Iterator<String> keys = this.connectMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = keys.next();
            ToolConnection tc = this.connectMap.get(key);
            Tool producer = tc.getProducer();
            Tool consumer = tc.getConsumer();
            if (producer != tool && consumer != tool) continue;
            keys.remove();
            producer.removeToolListener((ToolConnectionImpl)tc);
        }
    }

    private void updateConnectMap(Tool tool) {
        Iterator<String> keys = this.connectMap.keySet().iterator();
        HashMap<String, ToolConnectionImpl> map = new HashMap<String, ToolConnectionImpl>();
        while (keys.hasNext()) {
            String key = keys.next();
            ToolConnectionImpl tc = this.connectMap.get(key);
            Tool producer = tc.getProducer();
            Tool consumer = tc.getConsumer();
            if (producer == tool || consumer == tool) {
                String newkey = this.getKey(producer, consumer);
                tc.updateEventList();
                map.put(newkey, tc);
                continue;
            }
            map.put(key, tc);
        }
        this.connectMap = map;
    }

    private String getKey(Tool producer, Tool consumer) {
        return producer.getName() + "+" + consumer.getName();
    }

    private void updateConnections(PropertyChangeEvent ev) {
        Tool tool = (Tool)ev.getSource();
        this.updateConnectMap(tool);
        this.firePropertyChangeEvent(ev);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent ev) {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            WorkspaceChangeListener l = this.changeListeners.get(i);
            l.propertyChange(ev);
        }
    }

    private boolean isDefaultWorkspaceName(String name) {
        if (!name.startsWith("Workspace")) {
            return false;
        }
        return name.equals("Workspace") || name.startsWith("Workspace (");
    }

    private String getUniqueWorkspaceName() {
        Object name = "Workspace";
        String baseName = name;
        int count = 0;
        while (this.wsMap.containsKey(name)) {
            name = baseName + " (" + ++count + ")";
        }
        return name;
    }

    public boolean canAutoSave(Tool tool) {
        ToolSaveStatus status = this.toolStatusMap.get(tool.getToolName());
        if (status == ToolSaveStatus.ASK_SAVE_MODE) {
            return false;
        }
        if (this.getToolInstanceCount(tool) == 1) {
            return true;
        }
        if (tool.hasConfigChanged()) {
            status = ToolSaveStatus.ASK_SAVE_MODE;
            this.toolStatusMap.put(tool.getToolName(), status);
        }
        return status == ToolSaveStatus.AUTO_SAVE_MODE;
    }

    public void toolSaved(Tool tool, boolean toolChanged) {
        String toolName = tool.getToolName();
        if (this.getToolInstanceCount(tool) == 1) {
            this.toolStatusMap.put(toolName, ToolSaveStatus.AUTO_SAVE_MODE);
        } else if (toolChanged) {
            this.toolStatusMap.put(toolName, ToolSaveStatus.ASK_SAVE_MODE);
        }
    }

    private int getToolInstanceCount(Tool tool) {
        List<Tool> list = this.namesMap.get(tool.getToolName());
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    private static enum ToolSaveStatus {
        AUTO_SAVE_MODE,
        ASK_SAVE_MODE;

    }
}

