/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool;

import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.SystemUtilities;
import java.awt.Desktop;

public class PluginToolMacQuitHandler {
    private static boolean installed = false;

    public static void install(PluginTool tool) {
        if (installed) {
            return;
        }
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.MAC_OS_X) {
            return;
        }
        SystemUtilities.assertThisIsTheSwingThread((String)"Must install quit handler in the Swing thread");
        Desktop.getDesktop().setQuitHandler((evt, response) -> {
            response.cancelQuit();
            tool.close();
        });
        installed = true;
    }
}

