/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import ghidra.framework.main.ToolConnectionDialog;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolConnection;
import ghidra.framework.model.ToolManager;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class ToolConnectionPanel
extends JPanel
implements ListSelectionListener {
    private ToolConnectionDialog toolDialog;
    private ToolManager toolManager;
    private JList<Tool> consumerList;
    private JList<Tool> producerList;
    private JList<JCheckBox> eventList;
    private DefaultListModel<Tool> producerModel;
    private DefaultListModel<Tool> consumerModel;
    private JCheckBox[] checkboxes;
    private String[] eventNames;
    private static final String msgSource = "Tool Connection";

    ToolConnectionPanel(ToolConnectionDialog toolDialog, ToolManager toolManager) {
        this.toolDialog = toolDialog;
        this.toolManager = toolManager;
        this.initialize();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.toolDialog.setStatusText("");
        this.toolDialog.setConnectAllEnabled(false);
        this.toolDialog.setDisconnectAllEnabled(false);
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.processSelection();
    }

    void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
        this.updateDisplay();
    }

    void updateDisplay() {
        Tool producer = this.producerList.getSelectedValue();
        Tool consumer = this.consumerList.getSelectedValue();
        this.showData();
        if (producer != null && consumer != null) {
            ListSelectionModel sm;
            int index = this.producerModel.indexOf(producer);
            if (index >= 0) {
                sm = this.producerList.getSelectionModel();
                sm.addSelectionInterval(index, index);
            }
            if ((index = this.consumerModel.indexOf(consumer)) >= 0) {
                sm = this.consumerList.getSelectionModel();
                sm.addSelectionInterval(index, index);
            }
        }
        this.validate();
    }

    void showData() {
        this.eventList.setModel(new DefaultListModel());
        this.clearSelection();
        this.populateConsumerList();
        this.populateProducerList();
    }

    void clear() {
        this.consumerModel.clear();
        this.producerModel.clear();
    }

    void toolAdded(Tool tool) {
        String[] consumedEvents = tool.getConsumedToolEventNames();
        String[] producedEvents = tool.getToolEventNames();
        if (consumedEvents.length > 0) {
            this.consumerModel.addElement(tool);
        }
        if (producedEvents.length > 0) {
            this.producerModel.addElement(tool);
        }
        this.validate();
    }

    void toolRemoved(Tool tool) {
        int index = this.producerModel.indexOf(tool);
        if (index >= 0) {
            this.producerModel.remove(index);
        }
        if ((index = this.consumerModel.indexOf(tool)) >= 0) {
            this.consumerModel.remove(index);
        }
        this.processSelection();
        this.validate();
    }

    void connectAll(boolean connect) {
        Tool producer = this.producerList.getSelectedValue();
        Tool consumer = this.consumerList.getSelectedValue();
        this.eventList.setModel(new DefaultListModel());
        if (consumer == null || producer == null) {
            return;
        }
        if (producer.getName().equals(consumer.getName())) {
            return;
        }
        ToolConnection tc = this.toolManager.getConnection(producer, consumer);
        for (String eventName : this.eventNames = tc.getEvents()) {
            this.doConnect(producer, consumer, eventName, connect);
        }
        tc = this.toolManager.getConnection(consumer, producer);
        for (String eventName : this.eventNames = tc.getEvents()) {
            this.doConnect(consumer, producer, eventName, connect);
        }
        this.updateDisplay();
    }

    private void initialize() {
        JPanel panel = this.createListPanel();
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)panel, "Center");
        this.producerList.setSelectionMode(0);
        this.consumerList.setSelectionMode(0);
        this.eventList.setSelectionMode(0);
        ListSelectionModel sm = this.producerList.getSelectionModel();
        sm.addListSelectionListener(this);
        sm = this.consumerList.getSelectionModel();
        sm.addListSelectionListener(this);
        this.eventList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolConnectionPanel.this.processMouseClicked(e);
            }
        });
        this.eventList.setCellRenderer(new DataCellRenderer());
        this.producerList.setCellRenderer(new ToolListCellRenderer());
        this.consumerList.setCellRenderer(new ToolListCellRenderer());
        this.producerModel = (DefaultListModel)this.producerList.getModel();
        this.consumerModel = (DefaultListModel)this.consumerList.getModel();
    }

    private void processMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 1) {
            JList list = (JList)e.getSource();
            int index = list.locationToIndex(e.getPoint());
            if (index < 0) {
                return;
            }
            if (!this.checkboxes[index].isEnabled()) {
                return;
            }
            boolean selected = this.checkboxes[index].isSelected();
            this.checkboxes[index].setSelected(!selected);
            this.refreshList(this.checkboxes);
            Tool producer = this.producerList.getSelectedValue();
            Tool consumer = this.consumerList.getSelectedValue();
            this.doConnect(producer, consumer, this.eventNames[index], !selected);
            int connectedCount = 0;
            for (JCheckBox checkboxe : this.checkboxes) {
                if (!checkboxe.isSelected()) continue;
                ++connectedCount;
            }
            this.updateButtonEnablement(connectedCount);
        }
    }

    private void doConnect(Tool producer, Tool consumer, String eventName, boolean connect) {
        ToolConnection tc = this.toolManager.getConnection(producer, consumer);
        if (tc.isConnected(eventName) == connect) {
            return;
        }
        if (connect) {
            tc.connect(eventName);
            Msg.info((Object)this, (Object)("Tool Connection: Connected consumer " + consumer.getName() + " to producer " + producer.getName() + " for event " + eventName));
        } else {
            tc.disconnect(eventName);
            Msg.info((Object)this, (Object)("Tool Connection: Disconnected consumer " + consumer.getName() + " from producer " + producer.getName() + " for event " + eventName));
        }
    }

    private void populateConsumerList() {
        this.consumerModel.removeAllElements();
        Tool[] tools = this.toolManager.getConsumerTools();
        Arrays.sort(tools, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        for (Tool tool : tools) {
            this.consumerModel.addElement(tool);
        }
        if (tools.length == 0) {
            Msg.info((Object)this, (Object)"Tool Connection: No Tool consumes any events.");
        }
    }

    private void populateProducerList() {
        this.producerModel.removeAllElements();
        Tool[] tools = this.toolManager.getProducerTools();
        Arrays.sort(tools, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        for (Tool tool : tools) {
            this.producerModel.addElement(tool);
        }
        if (tools.length == 0) {
            Msg.info((Object)this, (Object)"Tool Connection: No Tool generates events.");
        }
    }

    private void processSelection() {
        this.eventList.setModel(new DefaultListModel());
        Tool producer = this.producerList.getSelectedValue();
        if (producer == null) {
            this.toolDialog.setStatusText("Please select an Event Producer");
            return;
        }
        Tool consumer = this.consumerList.getSelectedValue();
        if (consumer == null) {
            this.toolDialog.setStatusText("Please select an Event Consumer");
            return;
        }
        if (producer.getName().equals(consumer.getName())) {
            this.toolDialog.setStatusText("The selected Event Producer Consumer must be different");
            return;
        }
        ToolConnection tc = this.toolManager.getConnection(producer, consumer);
        this.eventNames = tc.getEvents();
        this.checkboxes = new JCheckBox[this.eventNames.length];
        int connectedCount = 0;
        for (int i = 0; i < this.checkboxes.length; ++i) {
            this.checkboxes[i] = new JCheckBox(this.eventNames[i]);
            this.checkboxes[i].setBackground(Color.white);
            boolean isConnected = tc.isConnected(this.eventNames[i]);
            this.checkboxes[i].setSelected(isConnected);
            this.checkboxes[i].setEnabled(true);
            if (!isConnected) continue;
            ++connectedCount;
        }
        this.refreshList(this.checkboxes);
        this.updateButtonEnablement(connectedCount);
        this.toolDialog.setStatusText("Please select on the events to be connected or disconnected");
    }

    private void updateButtonEnablement(int connectedCount) {
        this.toolDialog.setConnectAllEnabled(connectedCount < this.eventNames.length);
        this.toolDialog.setDisconnectAllEnabled(connectedCount > 0);
    }

    private void clearSelection() {
        this.consumerList.clearSelection();
        this.producerList.clearSelection();
        this.eventList.clearSelection();
    }

    private void refreshList(JCheckBox[] dataList) {
        this.eventList.setListData((JCheckBox[])dataList);
        this.eventList.clearSelection();
    }

    private JPanel createListPanel() {
        int i;
        this.consumerList = new JList(new DefaultListModel());
        this.consumerList.setName("Consumers");
        JScrollPane consumerListScrollPane = new JScrollPane(this.consumerList);
        this.producerList = new JList(new DefaultListModel());
        this.producerList.setName("Producers");
        JScrollPane producerListScrollPane = new JScrollPane(this.producerList);
        this.eventList = new JList(new DefaultListModel());
        this.eventList.setName("Events");
        JScrollPane eventListScrollPane = new JScrollPane(this.eventList);
        Dimension minimumSize = new Dimension(150, 150);
        consumerListScrollPane.setMinimumSize(minimumSize);
        consumerListScrollPane.setPreferredSize(minimumSize);
        producerListScrollPane.setMinimumSize(minimumSize);
        producerListScrollPane.setPreferredSize(minimumSize);
        eventListScrollPane.setMinimumSize(minimumSize);
        eventListScrollPane.setPreferredSize(minimumSize);
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        JComponent[] row1 = null;
        JComponent[] row2 = null;
        JLabel producerLabel = new JLabel("Event Producer:");
        JLabel consumerLabel = new JLabel("Event Consumer:");
        JLabel eventLabel = new JLabel("Event Names:");
        JComponent[] c1 = new JComponent[]{producerLabel, consumerLabel, eventLabel};
        JComponent[] c2 = new JComponent[]{producerListScrollPane, consumerListScrollPane, eventListScrollPane};
        row1 = c1;
        row2 = c2;
        GridBagConstraints gbc = null;
        for (i = 0; i < row1.length; ++i) {
            gbc = new GridBagConstraints();
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.gridx = i;
            gbc.gridy = 0;
            gbc.insets.top = 10;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbc.weightx = 1.0;
            gbl.setConstraints(row1[i], gbc);
            panel.add(row1[i]);
        }
        for (i = 0; i < row2.length; ++i) {
            gbc = new GridBagConstraints();
            gbc.anchor = 11;
            gbc.fill = 1;
            gbc.gridx = i;
            gbc.gridy = 1;
            gbc.insets.top = 5;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbl.setConstraints(row2[i], gbc);
            panel.add(row2[i]);
        }
        return panel;
    }

    private class ToolListCellRenderer
    extends JLabel
    implements ListCellRenderer<Tool> {
        ToolListCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Tool> list, Tool value, int index, boolean isSelected, boolean cellHasFocus) {
            Tool tool = null;
            tool = list == ToolConnectionPanel.this.consumerList ? ToolConnectionPanel.this.consumerModel.elementAt(index) : ToolConnectionPanel.this.producerModel.elementAt(index);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(tool.getName());
            return this;
        }
    }

    private class DataCellRenderer
    implements ListCellRenderer<JCheckBox> {
        private DataCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1) {
                int selected = list.getSelectedIndex();
                if (selected == -1) {
                    return null;
                }
                index = selected;
            }
            return ToolConnectionPanel.this.checkboxes[index];
        }
    }
}

