/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashingOutputStream
extends OutputStream {
    private OutputStream out;
    private MessageDigest messageDigest;

    public HashingOutputStream(OutputStream out, String hashAlgo) throws NoSuchAlgorithmException {
        this.out = out;
        this.messageDigest = MessageDigest.getInstance(hashAlgo);
    }

    @Override
    public void write(int b) throws IOException {
        this.messageDigest.update((byte)(b & 0xFF));
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.messageDigest.update(b);
        this.out.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.messageDigest.update(b, off, len);
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try (OutputStream ostream = this.out;){
            ostream.flush();
        }
    }

    public byte[] getDigest() {
        return this.messageDigest.digest();
    }
}

