/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.DynamicSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.exception.InvalidInputException;

public class HighConstant
extends HighVariable {
    private DynamicSymbol symbol;
    private Address pcaddr;

    public HighConstant(String name, DataType type, Varnode vn, Address pc, HighFunction func) throws InvalidInputException {
        super(name, type, vn, null, func);
        this.pcaddr = pc;
    }

    public HighConstant(String name, DataType type, Varnode vn, Address pc, DynamicSymbol sym) throws InvalidInputException {
        this(name, type, vn, pc, sym.getHighFunction());
        this.symbol = sym;
    }

    public DynamicSymbol getSymbol() {
        return this.symbol;
    }

    public Address getPCAddress() {
        return this.pcaddr;
    }

    public Scalar getScalar() {
        boolean signed = false;
        long value = this.getRepresentative().getOffset();
        DataType dt = this.getDataType();
        if (dt instanceof AbstractIntegerDataType) {
            signed = ((AbstractIntegerDataType)dt).isSigned();
        }
        if (signed) {
            int bitLength = this.getSize() * 8;
            int shiftCnt = 64 - bitLength;
            value <<= shiftCnt;
            value >>= shiftCnt;
        }
        return new Scalar(this.getSize() * 8, value, signed);
    }
}

