/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.LabelString;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.StackReference;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.List;

public class VariableOffset {
    private Variable variable;
    private long offset;
    private boolean indirect;
    private boolean dataAccess;
    private Object replacedElement;
    private boolean includeScalarAdjustment;

    public VariableOffset(Variable variable, long offset, boolean indirect, boolean dataAccess) {
        this.variable = variable;
        this.offset = offset;
        this.indirect = indirect;
        this.dataAccess = dataAccess;
    }

    public VariableOffset(Reference ref, Variable var) {
        this.indirect = false;
        this.variable = var;
        if (this.variable == null) {
            throw new IllegalArgumentException("Variable reference not bound to a variable");
        }
        RefType rt = ref.getReferenceType();
        boolean bl = this.dataAccess = rt.isRead() || rt.isWrite();
        if (ref instanceof StackReference && this.variable.isStackVariable()) {
            this.offset = this.variable.getStackOffset();
            this.offset = ((StackReference)ref).getStackOffset() - this.variable.getStackOffset();
        }
    }

    public void setReplacedElement(Scalar s, boolean includeScalarAdjustment) {
        this.replacedElement = s;
        this.includeScalarAdjustment = includeScalarAdjustment;
    }

    public void setReplacedElement(Register reg) {
        this.replacedElement = reg;
    }

    public Object getReplacedElement() {
        return this.replacedElement;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Object obj : this.getObjects()) {
            buf.append(obj.toString());
        }
        return buf.toString();
    }

    public List<Object> getObjects() {
        long absOffset;
        DataType dt = this.variable.getDataType();
        StringBuffer name = new StringBuffer(this.variable.getName());
        long scalarAdjustment = 0L;
        if (this.includeScalarAdjustment && this.replacedElement instanceof Scalar) {
            Scalar s = (Scalar)this.replacedElement;
            scalarAdjustment = this.variable.isStackVariable() ? s.getSignedValue() : s.getValue();
            scalarAdjustment -= this.offset;
            if (this.variable.isStackVariable() || this.variable.isMemoryVariable()) {
                Address storageAddr = this.variable.getMinAddress();
                scalarAdjustment -= storageAddr.getOffset();
            }
        }
        long l = absOffset = this.offset < 0L ? -this.offset : this.offset;
        if (absOffset <= Integer.MAX_VALUE) {
            if (dt instanceof TypeDef) {
                dt = ((TypeDef)dt).getBaseDataType();
            }
            boolean displayAsPtr = false;
            if (this.indirect && dt instanceof Pointer) {
                dt = ((Pointer)dt).getDataType();
                displayAsPtr = true;
            }
            int intOff = (int)absOffset;
            while (intOff > 0 || this.dataAccess && intOff == 0) {
                if (dt instanceof TypeDef) {
                    dt = ((TypeDef)dt).getBaseDataType();
                }
                if (dt instanceof Structure) {
                    DataTypeComponent cdt = ((Structure)dt).getComponentAt(intOff);
                    if (cdt == null) break;
                    String fieldName = cdt.getFieldName();
                    if (fieldName == null) {
                        fieldName = cdt.getDefaultFieldName();
                    }
                    name.append(displayAsPtr ? "->" : ".");
                    name.append(fieldName);
                    intOff -= cdt.getOffset();
                    dt = cdt.getDataType();
                } else {
                    if (!(dt instanceof Array)) break;
                    Array a = (Array)dt;
                    int elementLen = a.getElementLength();
                    if (intOff >= a.getLength()) break;
                    int index = intOff / elementLen;
                    if (displayAsPtr) {
                        name.insert(0, '*');
                    }
                    name.append('[');
                    name.append(Integer.toString(index));
                    name.append(']');
                    intOff -= index * elementLen;
                    dt = a.getDataType();
                }
                displayAsPtr = false;
            }
            absOffset = intOff;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new LabelString(name.toString(), LabelString.VARIABLE));
        if (absOffset != 0L || scalarAdjustment != 0L) {
            long adjustedOffset = (this.offset < 0L ? -absOffset : absOffset) + scalarAdjustment;
            if (adjustedOffset < 0L) {
                adjustedOffset = -adjustedOffset;
                list.add(Character.valueOf('-'));
            } else {
                list.add(Character.valueOf('+'));
            }
            list.add(new Scalar(32, adjustedOffset));
        }
        return list;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public boolean isIndirect() {
        return this.indirect;
    }

    public boolean isDataAccess() {
        return this.dataAccess;
    }

    public long getOffset() {
        return this.offset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataAccess ? 1231 : 1237);
        result = 31 * result + (this.includeScalarAdjustment ? 1231 : 1237);
        result = 31 * result + (this.indirect ? 1231 : 1237);
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.replacedElement == null ? 0 : this.replacedElement.hashCode());
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableOffset other = (VariableOffset)obj;
        if (this.dataAccess != other.dataAccess) {
            return false;
        }
        if (this.includeScalarAdjustment != other.includeScalarAdjustment) {
            return false;
        }
        if (this.indirect != other.indirect) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.replacedElement, (Object)other.replacedElement)) {
            return false;
        }
        return SystemUtilities.isEqual((Object)this.variable, (Object)other.variable);
    }
}

