/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.space;

import ghidra.pcodeCPort.error.LowlevelError;
import ghidra.pcodeCPort.pcoderaw.VarnodeData;
import ghidra.pcodeCPort.space.spacetype;
import ghidra.pcodeCPort.translate.Translate;
import ghidra.pcodeCPort.utils.MutableInt;
import ghidra.pcodeCPort.utils.Utils;
import ghidra.pcodeCPort.utils.XmlUtils;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.jdom.Element;

public class AddrSpace {
    public static final AddrSpace MIN_SPACE = new AddrSpace("MIN_SPACE", -1);
    public static final AddrSpace MAX_SPACE = new AddrSpace("MAX_SPACE", Integer.MAX_VALUE);
    protected static final int big_endian = 1;
    protected static final int heritaged = 2;
    public static final int hasphysical = 4;
    private int flags;
    private long highest;
    private long mask;
    private Translate trans;
    private String name;
    private spacetype type;
    private int addressSize;
    private int wordsize;
    private int scale;
    private char shortcut;
    private int index;
    private int delay;

    protected AddrSpace(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public AddrSpace(Translate t, spacetype tp, String nm, int size, int ws, int ind, int fl, int dl) {
        this.trans = t;
        this.type = tp;
        this.name = nm;
        this.addressSize = size;
        this.wordsize = ws;
        this.index = ind;
        this.delay = dl;
        this.flags = fl & 4;
        if (t.isBigEndian()) {
            this.flags |= 1;
        }
        this.flags |= 2;
        this.calcScaleMask();
    }

    public AddrSpace(Translate t, spacetype tp) {
        this.trans = t;
        this.type = tp;
        this.flags = 2;
        this.wordsize = 1;
        this.scale = 0;
    }

    public long wrapOffset(long off) {
        if ((int)(-Math.pow(-5.0, 3.0)) % 2 == 1) {
            throw new RuntimeException("wrapOffset coded incorrectly");
        }
        if (off <= this.highest) {
            return off;
        }
        long mod = this.highest + 1L;
        long res = off % mod;
        if (res < 0L) {
            res += mod;
        }
        return res;
    }

    protected void setFlags(int fl) {
        this.flags |= fl;
    }

    protected void clearFlags(int fl) {
        this.flags &= ~fl;
    }

    public String getName() {
        return this.name;
    }

    public Translate getTrans() {
        return this.trans;
    }

    public spacetype getType() {
        return this.type;
    }

    public int getDelay() {
        return this.delay;
    }

    public int getIndex() {
        return this.index;
    }

    int getWordSize() {
        return this.wordsize;
    }

    public int getScale() {
        return this.scale;
    }

    public int getAddrSize() {
        return this.addressSize;
    }

    public long getMask() {
        return this.mask;
    }

    public char getShortCut() {
        return this.shortcut;
    }

    public boolean isHeritaged() {
        return (this.flags & 2) != 0;
    }

    public boolean hasPhysical() {
        return (this.flags & 4) != 0;
    }

    public boolean isBigEndian() {
        return (this.flags & 1) != 0;
    }

    public AddrSpace getContain() {
        return null;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int compareTo(AddrSpace base) {
        return this.index - base.index;
    }

    private void calcScaleMask() {
        this.scale = 0;
        for (int wd = this.wordsize; wd > 1; wd >>= 1) {
            ++this.scale;
        }
        this.mask = Utils.calc_mask(this.addressSize);
        for (int i = 1; i < this.wordsize; ++i) {
            this.mask = this.mask << 1 | 1L;
        }
        this.shortcut = this.trans.assignShortcut(this.type);
    }

    void save_basic_attributes(PrintStream s) {
        XmlUtils.a_v(s, "name", this.name);
        XmlUtils.a_v_i(s, "index", this.index);
        XmlUtils.a_v_b(s, "bigendian", this.isBigEndian());
        XmlUtils.a_v_i(s, "delay", this.delay);
        XmlUtils.a_v_i(s, "size", this.addressSize);
        if (this.wordsize > 1) {
            XmlUtils.a_v_i(s, "wordsize", this.wordsize);
        }
        XmlUtils.a_v_b(s, "physical", this.hasPhysical());
    }

    public boolean contain(AddrSpace id2) {
        while (this != id2) {
            if ((id2 = id2.getContain()) != null) continue;
            return false;
        }
        return true;
    }

    long data2uintm(byte[] ptr, int size) {
        long res;
        if ((this.flags & 1) != 0) {
            res = 0L;
            for (int i = 0; i < size; ++i) {
                res <<= 8;
                res |= (long)ptr[i];
            }
        } else {
            res = 0L;
            for (int i = size - 1; i >= 0; --i) {
                res <<= 8;
                res |= (long)ptr[i];
            }
        }
        return res;
    }

    public void saveXmlAttributes(PrintStream s, long offset) {
        XmlUtils.a_v(s, "space", this.getName());
        s.append(' ');
        s.append("offset=\"");
        this.printOffset(s, offset);
        s.append("\"");
    }

    public void saveXmlAttributes(PrintStream s, long offset, int size) {
        XmlUtils.a_v(s, "space", this.getName());
        s.append(" offset=\"");
        this.printOffset(s, offset);
        s.append("\"");
        XmlUtils.a_v_i(s, "size", size);
    }

    public static long restore_xml_offset(Element el) {
        String offsetString = el.getAttributeValue("offset");
        if (offsetString == null) {
            throw new LowlevelError("Address missing offset");
        }
        return XmlUtils.decodeUnknownLong(offsetString);
    }

    public static int restore_xml_size(Element el) {
        String sizeString = el.getAttributeValue("size");
        if (sizeString == null) {
            return 0;
        }
        return XmlUtils.decodeUnknownInt(sizeString);
    }

    public void printOffset(PrintStream s, long offset) {
        s.append("0x");
        int addrSize = this.getAddrSize();
        int padLength = 2 * addrSize;
        String longString = Long.toHexString(offset);
        for (int i = 0; i < padLength - longString.length(); ++i) {
            s.append('0');
        }
        s.append(longString);
    }

    public int printRaw(PrintStream s, long offset) {
        int cut;
        int expectsize = this.getTrans().getDefaultSize();
        this.printOffset(s, offset >>> this.scale);
        if (this.wordsize > 1 && (cut = (int)offset & this.wordsize - 1) != 0) {
            s.append("+");
            s.print(cut);
        }
        return expectsize;
    }

    public String toString() {
        return "AddrSpace[" + this.name + "]";
    }

    public String toString(long offset) {
        int cut;
        StringBuffer s = new StringBuffer();
        int addrSize = this.getAddrSize();
        int padLength = 2 * addrSize;
        String longString = Long.toHexString(offset >>> this.scale);
        for (int i = 0; i < padLength - longString.length(); ++i) {
            s.append('0');
        }
        s.append(longString);
        if (this.wordsize > 1 && (cut = (int)offset & this.wordsize - 1) != 0) {
            s.append("+").append(cut);
        }
        return s.toString();
    }

    public long read(String s, MutableInt size) {
        StringTokenizer tokenizzy = new StringTokenizer(s, ":+");
        String frontpart = tokenizzy.nextToken();
        size.set(this.getAddrSize());
        try {
            VarnodeData point = this.getTrans().getRegister(frontpart);
            long offset = point.offset;
            size.set(point.size);
            return offset;
        }
        catch (LowlevelError point) {
            long offset;
            try {
                offset = XmlUtils.decodeUnknownLong(frontpart);
            }
            catch (NumberFormatException nfe) {
                size.set(-1);
                return -1L;
            }
            offset <<= this.scale;
            if (tokenizzy.countTokens() > 1) {
                try {
                    size.set(Integer.parseInt(tokenizzy.nextToken()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return offset;
        }
    }

    public void saveXml(PrintStream s) {
        s.append("<space");
        this.save_basic_attributes(s);
        s.println("/>");
    }

    public void restoreXml(Element el) {
        this.name = el.getAttributeValue("name");
        this.index = XmlUtils.decodeUnknownInt(el.getAttributeValue("index"));
        this.addressSize = XmlUtils.decodeUnknownInt(el.getAttributeValue("size"));
        this.wordsize = XmlUtils.decodeUnknownInt(el.getAttributeValue("wordsize"));
        if (XmlUtils.decodeBoolean(el.getAttributeValue("bigendian"))) {
            this.flags |= 1;
        }
        this.delay = XmlUtils.decodeUnknownInt(el.getAttributeValue("delay"));
        if (XmlUtils.decodeBoolean(el.getAttributeValue("physical"))) {
            this.flags |= 4;
        }
        this.calcScaleMask();
    }
}

