/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh;

import com.sun.msv.verifier.jarv.TheFactoryImpl;
import generic.jar.ResourceFile;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.framework.Application;
import ghidra.util.Msg;
import java.io.InputStream;
import org.iso_relax.verifier.Schema;
import org.iso_relax.verifier.Verifier;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import utilities.util.FileResolutionResult;
import utilities.util.FileUtilities;

public class SleighLanguageValidator {
    private static final ResourceFile ldefsRelaxSchemaFile;
    private static final ResourceFile pspecRelaxSchemaFile;
    private static final ResourceFile cspecRelaxSchemaFile;

    public static void validateLdefsFile(ResourceFile ldefsFile) throws SleighException {
        SleighLanguageValidator.validateSleighFile(ldefsRelaxSchemaFile, ldefsFile, "language definitions");
    }

    public static void validatePspecFile(ResourceFile pspecFile) throws SleighException {
        SleighLanguageValidator.validateSleighFile(pspecRelaxSchemaFile, pspecFile, "processor specification");
    }

    public static void validateCspecFile(ResourceFile cspecFile) throws SleighException {
        SleighLanguageValidator.validateSleighFile(cspecRelaxSchemaFile, cspecFile, "compiler specification");
    }

    private static void validateSleighFile(ResourceFile relaxSchemaFile, ResourceFile fileToValidate, String type) throws SleighException {
        FileResolutionResult result = FileUtilities.existsAndIsCaseDependent((ResourceFile)fileToValidate);
        if (!result.isOk()) {
            throw new SleighException(fileToValidate + " is not properly case dependent: " + result.getMessage());
        }
        Verifier verifier = null;
        try {
            verifier = SleighLanguageValidator.getVerifier(relaxSchemaFile);
        }
        catch (Exception e) {
            throw new SleighException("Error creating verifier", e);
        }
        try {
            InputStream in = fileToValidate.getInputStream();
            verifier.setErrorHandler((ErrorHandler)new MyErrorHandler(fileToValidate));
            verifier.verify(new InputSource(in));
            in.close();
        }
        catch (Exception e) {
            throw new SleighException("Invalid " + type + " file: " + fileToValidate.getAbsolutePath(), e);
        }
    }

    private static Verifier getVerifier(ResourceFile relaxSchemaFile) throws Exception {
        TheFactoryImpl factory = new TheFactoryImpl();
        Schema schema = factory.compileSchema(relaxSchemaFile.toURL().toExternalForm());
        Verifier verifier = schema.newVerifier();
        return verifier;
    }

    static {
        ResourceFile file = null;
        try {
            file = Application.getModuleDataFile((String)"languages/language_definitions.rxg");
        }
        catch (Exception e) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find language_definitions.rxg", (Throwable)e);
        }
        if (file == null) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find language_definitions.rxg");
        }
        ldefsRelaxSchemaFile = file;
        file = null;
        try {
            file = Application.getModuleDataFile((String)"languages/processor_spec.rxg");
        }
        catch (Exception e) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find processor_spec.rxg", (Throwable)e);
        }
        if (file == null) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find processor_spec.rxg");
        }
        pspecRelaxSchemaFile = file;
        file = null;
        try {
            file = Application.getModuleDataFile((String)"languages/compiler_spec.rxg");
        }
        catch (Exception e) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find compiler_spec.rxg", (Throwable)e);
        }
        if (file == null) {
            Msg.error(SleighLanguageValidator.class, (Object)"Could not find compiler_spec.rxg");
        }
        cspecRelaxSchemaFile = file;
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        final ResourceFile file;

        public MyErrorHandler(ResourceFile file) {
            this.file = file;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.error(e);
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            Msg.error(SleighLanguageValidator.class, (Object)("Error validating " + this.file + "  at " + e.getLineNumber() + ":" + e.getColumnNumber()), (Throwable)e);
            throw e;
        }

        @Override
        public void warning(SAXParseException e) {
        }
    }
}

