/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.picking;

import edu.uci.ics.jung.visualization.picking.AbstractPickedState;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class MultiPickedState<T>
extends AbstractPickedState<T>
implements PickedState<T> {
    protected Set<T> picked = new LinkedHashSet<T>();

    @Override
    public boolean pick(T v, boolean state) {
        boolean prior_state = this.picked.contains(v);
        if (state) {
            this.picked.add(v);
            if (!prior_state) {
                this.fireItemStateChanged(new ItemEvent(this, 701, v, 1));
            }
        } else {
            this.picked.remove(v);
            if (prior_state) {
                this.fireItemStateChanged(new ItemEvent(this, 701, v, 2));
            }
        }
        return prior_state;
    }

    @Override
    public void clear() {
        ArrayList<T> unpicks = new ArrayList<T>(this.picked);
        for (Object v : unpicks) {
            this.pick(v, false);
        }
        this.picked.clear();
    }

    @Override
    public Set<T> getPicked() {
        return Collections.unmodifiableSet(this.picked);
    }

    @Override
    public boolean isPicked(T e) {
        return this.picked.contains(e);
    }

    public T[] getSelectedObjects() {
        ArrayList<T> list = new ArrayList<T>(this.picked);
        return list.toArray();
    }
}

