/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.GTable;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterFormattedTextField;
import ghidra.feature.vt.gui.filters.StatusLabel;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public abstract class AbstractTextFilter<T>
extends Filter<T> {
    private static final Integer BASE_COMPONENT_LAYER = 1;
    private static final Integer HOVER_COMPONENT_LAYER = 2;
    private JComponent component;
    private FilterFormattedTextField textField;
    private String defaultValue = "";
    protected VTController controller;
    protected final GTable table;

    protected AbstractTextFilter(VTController controller, GTable table, String filterName) {
        this.controller = controller;
        this.table = table;
        this.component = this.createComponent(filterName);
    }

    private JComponent createComponent(String filterName) {
        final JPanel panel = new JPanel(new BorderLayout());
        Border paddingBorder = BorderFactory.createEmptyBorder(1, 5, 1, 5);
        Border outsideBorder = BorderFactory.createBevelBorder(1);
        panel.setBorder(BorderFactory.createCompoundBorder(outsideBorder, paddingBorder));
        DefaultFormatterFactory factory = new DefaultFormatterFactory(new DefaultFormatter());
        this.textField = new FilterFormattedTextField(factory, this.defaultValue);
        this.textField.setName(filterName + " Field");
        this.textField.setColumns(20);
        this.textField.setMinimumSize(this.textField.getPreferredSize());
        this.textField.disableFocusEventProcessing();
        JLabel label = new JLabel(filterName + ": ");
        panel.add((Component)label, "West");
        panel.add((Component)this.textField, "Center");
        StatusLabel nameFieldStatusLabel = new StatusLabel(this.textField, this.defaultValue);
        this.textField.addFilterStatusListener(nameFieldStatusLabel);
        this.textField.addFilterStatusListener(status -> this.fireStatusChanged(status));
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.add((Component)panel, BASE_COMPONENT_LAYER);
        layeredPane.add((Component)nameFieldStatusLabel, HOVER_COMPONENT_LAYER);
        layeredPane.setPreferredSize(panel.getPreferredSize());
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension preferredSize = layeredPane.getSize();
                panel.setBounds(0, 0, preferredSize.width, preferredSize.height);
                panel.validate();
            }
        });
        return layeredPane;
    }

    public void setName(String name) {
        this.textField.setName(name);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.table.dispose();
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        saveState.putString(this.getStateKey(), this.getTextFieldText());
    }

    private String getStateKey() {
        return AbstractTextFilter.class.getSimpleName() + ":" + this.getClass().getName();
    }

    @Override
    public void readConfigState(SaveState saveState) {
        this.setFilterText(saveState.getString(this.getStateKey(), ""));
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void clearFilter() {
        this.textField.setText(this.defaultValue);
    }

    @Override
    public Filter.FilterEditingStatus getFilterStatus() {
        return this.textField.getFilterStatus();
    }

    protected String getTextFieldText() {
        return this.textField.getText();
    }

    protected void setFilterText(String filterText) {
        this.textField.setText(filterText);
    }

    @Override
    public Filter.FilterShortcutState getFilterShortcutState() {
        String textFieldText = this.getTextFieldText();
        if (textFieldText.trim().isEmpty()) {
            return Filter.FilterShortcutState.ALWAYS_PASSES;
        }
        return Filter.FilterShortcutState.REQUIRES_CHECK;
    }

    protected boolean passesNameFilterImpl(VTAssociation association) {
        String filterText = this.getTextFieldText();
        if (filterText == null || filterText.trim().length() == 0) {
            return true;
        }
        Address address = association.getSourceAddress();
        String symbolText = this.getSymbolText(address);
        if (symbolText.toLowerCase().indexOf(filterText.toLowerCase()) != -1) {
            return true;
        }
        address = association.getDestinationAddress();
        symbolText = this.getSymbolText(address);
        return symbolText.toLowerCase().indexOf(filterText.toLowerCase()) != -1;
    }

    protected String getSymbolText(Address address) {
        VTSession session = this.controller.getSession();
        Program sourceProgram = session.getSourceProgram();
        SymbolTable symbolTable = sourceProgram.getSymbolTable();
        Symbol symbol = symbolTable.getPrimarySymbol(address);
        if (symbol == null) {
            return "<No Symbol>";
        }
        return symbol.getName();
    }

    @Override
    public boolean isSubFilterOf(Filter<T> otherFilter) {
        String otherValue;
        if (!(otherFilter instanceof AbstractTextFilter)) {
            return false;
        }
        AbstractTextFilter otherTextFilter = (AbstractTextFilter)otherFilter;
        String value = this.getTextFieldText();
        if (Objects.equals(value, otherValue = otherTextFilter.getTextFieldText())) {
            return true;
        }
        if (value == null || otherValue == null) {
            return false;
        }
        return value.contains(otherValue);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " '" + this.getTextFieldText() + "'";
    }
}

