/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.renderer.PaintableShape;
import ghidra.util.datastruct.FixedSizeStack;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class MouseDebugPaintable
implements VisualizationServer.Paintable {
    private FixedSizeStack<PaintableShape> shapes = new FixedSizeStack(30);
    private GraphViewer<?, ?> viewer;

    public boolean useTransform() {
        return true;
    }

    public void paint(Graphics g) {
        if (this.shapes.isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform oldXform = g2d.getTransform();
        RenderContext rc = this.viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = rc.getMultiLayerTransformer();
        MutableTransformer layoutXformer = multiLayerTransformer.getTransformer(Layer.LAYOUT);
        AffineTransform layoutXform = layoutXformer.getTransform();
        double tx = layoutXform.getTranslateX();
        double ty = layoutXform.getTranslateY();
        for (PaintableShape s : this.shapes) {
            if (s.isShapeFinished()) {
                double dx = tx - s.getTx();
                double dy = ty - s.getTy();
                AffineTransform newXform = new AffineTransform(oldXform);
                newXform.translate(dx, dy);
                g2d.setTransform(newXform);
            }
            Stroke oldStroke = g2d.getStroke();
            Color oldColor = g2d.getColor();
            s.paint(g2d);
            g2d.setStroke(oldStroke);
            g2d.setColor(oldColor);
            g2d.setTransform(oldXform);
        }
    }

    public void addShape(PaintableShape shape, GraphViewer<?, ?> graphViewer) {
        this.viewer = graphViewer;
        this.shapes.add((Object)shape);
    }

    public void clear() {
        this.shapes.clear();
    }
}

