/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.LongIterator;
import ghidra.util.datastruct.IndexRangeIterator;
import ghidra.util.datastruct.NoSuchIndexException;
import ghidra.util.datastruct.PropertySetIndexRangeIterator;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.BytePropertySet;
import java.io.Serializable;

public class ByteRangeMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    BytePropertySet map = new BytePropertySet("RangeMap");

    public ByteRangeMap() {
        this.map.putByte(0L, (byte)0);
    }

    public void paintRange(long start, long end, byte value) {
        if (end != Long.MAX_VALUE) {
            byte origEndValue = this.getValue(end + 1L);
            if (origEndValue != value) {
                this.map.putByte(end + 1L, origEndValue);
            } else {
                this.map.remove(end + 1L);
            }
        }
        LongIterator it = this.map.getPropertyIterator(start);
        while (it.hasNext()) {
            long next = it.next();
            if (next > end) continue;
            this.map.remove(next);
        }
        if (start == 0L) {
            this.map.putByte(0L, value);
        } else {
            byte startValue = this.getValue(start);
            if (startValue != value) {
                this.map.putByte(start, value);
            }
        }
    }

    public byte getValue(long index) {
        try {
            return this.map.getByte(index);
        }
        catch (NoValueException e) {
            try {
                index = this.map.getPreviousPropertyIndex(index);
                return this.map.getByte(index);
            }
            catch (NoSuchIndexException noSuchIndexException) {
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
            return 0;
        }
    }

    public IndexRangeIterator getIndexRangeIterator(long index) {
        return new PropertySetIndexRangeIterator(this.map, index);
    }

    public LongIterator getChangePointIterator(long start, long end) {
        return this.map.getPropertyIterator(start, end);
    }
}

