/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.util.WordLocation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StringUtilities {
    private static Map<Character, String> controlToEscapeStringMap = new HashMap<Character, String>();
    private static Map<String, Character> escapeStringToControlMap = new HashMap<String, Character>();
    private static final String ELLIPSES = "...";
    public static final Pattern DOUBLE_QUOTED_STRING_PATTERN;
    public static final String LINE_SEPARATOR;
    public static final int UNICODE_REPLACEMENT = 65533;
    public static final int UNICODE_BE_BYTE_ORDER_MARK = 65279;
    public static final int UNICODE_LE16_BYTE_ORDER_MARK = 65534;
    public static final int UNICODE_LE32_BYTE_ORDER_MARK = -131072;

    private StringUtilities() {
    }

    public static boolean isControlCharacterOrBackslash(char c) {
        return controlToEscapeStringMap.containsKey(Character.valueOf(c));
    }

    public static boolean isControlCharacterOrBackslash(int codePoint) {
        return 0 <= codePoint && codePoint < 65536 && StringUtilities.isControlCharacterOrBackslash((char)codePoint);
    }

    public static boolean isDoubleQuoted(String str) {
        Matcher m = DOUBLE_QUOTED_STRING_PATTERN.matcher(str);
        return m.matches();
    }

    public static String extractFromDoubleQuotes(String str) {
        Matcher m = DOUBLE_QUOTED_STRING_PATTERN.matcher(str);
        if (m.matches()) {
            return m.group(1);
        }
        return str;
    }

    public static boolean isDisplayable(int c) {
        return c >= 32 && c < 127;
    }

    public static boolean isAllBlank(CharSequence ... sequences) {
        if (sequences == null) {
            return true;
        }
        for (CharSequence s : sequences) {
            if (StringUtils.isBlank((CharSequence)s)) continue;
            return false;
        }
        return true;
    }

    public static String characterToString(char c) {
        String escaped = controlToEscapeStringMap.get(Character.valueOf(c));
        if (escaped == null) {
            escaped = Character.toString(c);
        }
        return escaped;
    }

    public static int countOccurrences(String string, char occur) {
        int count = 0;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (string.charAt(i) != occur) continue;
            ++count;
        }
        return count;
    }

    public static boolean equals(String s1, String s2, boolean caseSensitive) {
        if (s1 == null) {
            return s2 == null;
        }
        if (caseSensitive) {
            return s1.equals(s2);
        }
        return s1.equalsIgnoreCase(s2);
    }

    public static boolean endsWithWhiteSpace(String string) {
        return Character.isWhitespace(string.charAt(string.length() - 1));
    }

    public static String toQuotedString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            StringUtilities.appendCharConvertedToEscapeSequence((char)(b & 0xFF), 1, builder);
        }
        String str = builder.toString();
        if (bytes.length == 1) {
            str = str.replace("'", "\\'");
            return "'" + str + "'";
        }
        str = str.replace("\"", "\\\"");
        return "\"" + str + "\"";
    }

    public static String toQuotedString(byte[] bytes, int charSize) {
        if (charSize <= 1) {
            return StringUtilities.toQuotedString(bytes);
        }
        if (charSize > 4) {
            throw new IllegalArgumentException("unsupported charSize: " + charSize);
        }
        int shortage = bytes.length % charSize;
        if (shortage != 0) {
            byte[] paddedBytes = new byte[bytes.length + shortage];
            System.arraycopy(bytes, 0, paddedBytes, 0, bytes.length);
            bytes = paddedBytes;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; i += charSize) {
            int val = 0;
            for (int n = 0; n < charSize; ++n) {
                val = (val << 8) + (bytes[i + n] & 0xFF);
            }
            StringUtilities.appendCharConvertedToEscapeSequence(val, charSize, builder);
        }
        String str = builder.toString();
        if (bytes.length <= charSize) {
            str = str.replace("'", "\\'");
            return "'" + str + "'";
        }
        str = str.replace("\"", "\\\"");
        return "\"" + str + "\"";
    }

    private static void appendCharConvertedToEscapeSequence(int c, int charSize, StringBuilder builder) {
        if (controlToEscapeStringMap.containsKey(Character.valueOf((char)c))) {
            builder.append(controlToEscapeStringMap.get(Character.valueOf((char)c)));
        } else if (c >= 32 && c <= 127) {
            builder.append((char)c);
        } else if (charSize <= 1) {
            builder.append("\\x" + StringUtilities.pad(Integer.toHexString(c), '0', 2));
        } else if (charSize == 2) {
            builder.append("\\u" + StringUtilities.pad(Integer.toHexString(c), '0', 4));
        } else if (charSize <= 4) {
            builder.append("\\U" + StringUtilities.pad(Integer.toHexString(c), '0', 8));
        }
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        if (string == null || prefix == null) {
            return false;
        }
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String string, String postfix) {
        if (string == null || postfix == null) {
            return false;
        }
        int startIndex = string.length() - postfix.length();
        return string.regionMatches(true, startIndex, postfix, 0, postfix.length());
    }

    public static boolean containsIgnoreCase(String containingString, String substring) {
        if (containingString == null || substring == null) {
            return false;
        }
        return StringUtilities.indexOfIgnoreCase(containingString, substring, 0) >= 0;
    }

    public static boolean containsAll(CharSequence toSearch, CharSequence ... searches) {
        if (StringUtils.isEmpty((CharSequence)toSearch) || ArrayUtils.isEmpty((Object[])searches)) {
            return false;
        }
        for (CharSequence search : searches) {
            if (StringUtils.contains((CharSequence)toSearch, (CharSequence)search)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllIgnoreCase(CharSequence toSearch, CharSequence ... searches) {
        if (StringUtils.isEmpty((CharSequence)toSearch) || ArrayUtils.isEmpty((Object[])searches)) {
            return false;
        }
        for (CharSequence search : searches) {
            if (StringUtils.containsIgnoreCase((CharSequence)toSearch, (CharSequence)search)) continue;
            return false;
        }
        return true;
    }

    public static int indexOfWord(String text, String searchWord) {
        for (int index = 0; index < text.length(); index += searchWord.length()) {
            if ((index = text.indexOf(searchWord, index)) < 0) {
                return -1;
            }
            if (!StringUtilities.isWholeWord(text, index, searchWord.length())) continue;
            return index;
        }
        return -1;
    }

    public static boolean isWholeWord(String text, int startIndex, int length) {
        if (startIndex > 0 && Character.isJavaIdentifierPart(text.charAt(startIndex - 1))) {
            return false;
        }
        int endIndex = startIndex + length;
        return endIndex >= text.length() || !Character.isJavaIdentifierPart(text.charAt(endIndex));
    }

    public static int indexOfIgnoreCase(String containingString, String substring) {
        if (containingString == null || substring == null) {
            return -1;
        }
        return StringUtilities.indexOfIgnoreCase(containingString, substring, 0);
    }

    public static int indexOfIgnoreCase(String containingString, String substring, int index) {
        if (containingString == null || substring == null) {
            return -1;
        }
        return containingString.toLowerCase().indexOf(substring.toLowerCase(), index);
    }

    public static int lastIndexOfIgnoreCase(String containingString, String substring) {
        if (containingString == null || substring == null) {
            return -1;
        }
        return containingString.toLowerCase().lastIndexOf(substring.toLowerCase());
    }

    public static String convertTabsToSpaces(String str, int tabSize) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int linepos = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\t') {
                int nSpaces = tabSize - linepos % tabSize;
                String pad = StringUtilities.padString("", ' ', nSpaces);
                buffer.append(pad);
                linepos += nSpaces;
                continue;
            }
            buffer.append(c);
            ++linepos;
            if (c != '\n') continue;
            linepos = 0;
        }
        return buffer.toString();
    }

    public static String convertStringArray(String[] strings) {
        return StringUtilities.convertStringArray(strings, "\n");
    }

    public static String convertStringArray(String[] strings, String delimiter) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) continue;
            sb.append(strings[i]);
            if (i >= strings.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String[] toLines(String str) {
        return StringUtilities.toLines(str, true);
    }

    public static String[] toLines(String s, boolean preserveTokens) {
        String[] lines = null;
        lines = preserveTokens ? StringUtils.splitPreserveAllTokens((String)s, (char)'\n') : StringUtils.split((String)s, (char)'\n');
        if (lines == null) {
            return new String[0];
        }
        return lines;
    }

    public static String toFixedSize(String s, char pad, int size) {
        String trimmed = StringUtilities.trim(s, size + ELLIPSES.length());
        String padded = StringUtilities.pad(trimmed, pad, -size);
        return padded;
    }

    @Deprecated
    public static String padString(String source, char filler, int length) {
        return StringUtilities.pad(source, filler, length);
    }

    public static String pad(String source, char filler, int length) {
        if (length == 0) {
            return source;
        }
        boolean rightJustify = true;
        if (length < 0) {
            rightJustify = false;
            length *= -1;
        }
        int numFillers = length - source.length();
        StringBuffer buffer = new StringBuffer();
        for (int f = 0; f < numFillers; ++f) {
            buffer.append(filler);
        }
        if (rightJustify) {
            buffer.append(source);
        } else {
            buffer.insert(0, source);
        }
        return buffer.toString();
    }

    public static String indentLines(String s, String indent) {
        String[] lines = StringUtilities.toLines(s, false);
        StringBuilder buffy = new StringBuilder();
        for (String line : lines) {
            buffy.append(indent).append(line).append('\n');
        }
        if (buffy.length() > 0) {
            buffy.deleteCharAt(buffy.length() - 1);
        }
        return buffy.toString();
    }

    public static String findWord(String s, int index) {
        return StringUtilities.findWord(s, index, null);
    }

    public static String findWord(String s, int index, char[] charsToAllow) {
        WordLocation location = StringUtilities.findWordLocation(s, index, charsToAllow);
        return location.getWord();
    }

    public static WordLocation findWordLocation(String s, int index, char[] charsToAllow) {
        char c;
        int start;
        int len = s.length();
        if (index < 0 || index >= len) {
            return WordLocation.empty(s);
        }
        char currChar = s.charAt(index);
        if (!StringUtilities.isWordChar(currChar, charsToAllow)) {
            String substring = s.substring(index, index + 1);
            WordLocation wordLocation = new WordLocation(s, substring.trim(), index);
            return wordLocation;
        }
        int end = index;
        for (start = index; start >= 0 && StringUtilities.isWordChar(c = s.charAt(start), charsToAllow); --start) {
        }
        while (end < s.length() && StringUtilities.isWordChar(c = s.charAt(end), charsToAllow)) {
            ++end;
        }
        int wordIndex = start + 1;
        String substring = s.substring(wordIndex, end);
        WordLocation wordLocation = new WordLocation(s, substring.trim(), wordIndex);
        return wordLocation;
    }

    public static boolean isWordChar(char c, char[] charsToAllow) {
        if (charsToAllow != null) {
            for (char element : charsToAllow) {
                if (c != element) continue;
                return true;
            }
        }
        return StringUtilities.isValidCLanguageChar(c);
    }

    public static int findLastWordPosition(String s) {
        int len = s.length();
        int pos = -1;
        for (int i = len - 1; i >= 0; --i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            pos = i + 1;
            break;
        }
        if (pos >= len) {
            pos = -1;
        }
        return pos;
    }

    public static String getLastWord(String s, String separator) {
        if (s == null) {
            return null;
        }
        String escaped = Pattern.quote(separator);
        String[] parts = s.split(escaped);
        String last = parts[parts.length - 1];
        return last;
    }

    public static String toString(int value) {
        byte[] bytes = new byte[4];
        int byteIndex = bytes.length - 1;
        while (value != 0) {
            bytes[byteIndex] = (byte)value;
            value >>= 8;
            --byteIndex;
        }
        return new String(bytes);
    }

    public static String toString(List<?> list, String separator) {
        if (list == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer("[ ");
        for (int i = 0; i < list.size(); ++i) {
            buffer.append(list.get(i).toString());
            if (i + 1 >= list.size()) continue;
            buffer.append(separator);
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    public static String toStringWithIndent(Object o) {
        if (o == null) {
            return "null";
        }
        String asString = o.toString();
        String indented = StringUtilities.indentLines(asString, "\t");
        return indented;
    }

    public static String reverse(String s) {
        if (s == null) {
            return null;
        }
        return new StringBuilder(s).reverse().toString();
    }

    public static String mergeStrings(String string1, String string2) {
        boolean hasString2;
        if (string1 == null && string2 == null) {
            return null;
        }
        boolean hasString1 = string1 != null && !string1.equals("");
        boolean bl = hasString2 = string2 != null && !string2.equals("");
        if (hasString1) {
            if (hasString2) {
                boolean string2contains1;
                boolean string1contains2;
                int length1 = string1.length();
                int length2 = string2.length();
                boolean bl2 = string1contains2 = length2 <= length1 && string1.contains(string2);
                if (string1contains2) {
                    return string1;
                }
                boolean bl3 = string2contains1 = length1 <= length2 && string2.contains(string1);
                if (string2contains1) {
                    return string2;
                }
                return string1 + "\n" + string2;
            }
            return string1;
        }
        if (hasString2) {
            return string2;
        }
        return "";
    }

    public static String trim(String original, int max) {
        int minimum = ELLIPSES.length() + 1;
        if (max < minimum) {
            throw new IllegalArgumentException("Max cannot be less than " + minimum);
        }
        if (original.length() > max) {
            return original.substring(0, max - 3) + ELLIPSES;
        }
        return original;
    }

    public static String trimTrailingNulls(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && s.charAt(i) == '\u0000'; --i) {
        }
        return s.substring(0, i + 1);
    }

    public static String trimMiddle(String s, int max) {
        int lhsSize;
        int len = s.length();
        if (len <= max) {
            return s;
        }
        int minimum = ELLIPSES.length() + 2;
        if (max < minimum) {
            throw new IllegalArgumentException("Max cannot be less than " + minimum);
        }
        int toRemove = len - max + ELLIPSES.length();
        int toKeep = len - toRemove;
        int rhsSize = lhsSize = toKeep / 2;
        if (toKeep % 2 != 0) {
            ++rhsSize;
        }
        StringBuilder buffy = new StringBuilder();
        buffy.append(s.substring(0, lhsSize));
        buffy.append(ELLIPSES);
        buffy.append(s.substring(len - rhsSize, len));
        return buffy.toString();
    }

    public static String fixMultipleAsterisks(String value) {
        if (value.indexOf("**") < 0) {
            return value;
        }
        return value.replaceAll("\\*{2,}", "*");
    }

    public static boolean isValidCLanguageChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean isAsciiChar(char c) {
        return ' ' <= c && c <= '\u007f';
    }

    public static boolean isAsciiChar(int codePoint) {
        return 32 <= codePoint && codePoint <= 127;
    }

    public static String convertEscapeSequences(String str) {
        StringBuilder builder = new StringBuilder();
        int inputLength = str.length();
        int index = 0;
        while (index < inputLength) {
            String subOfInput = index + 2 <= inputLength ? str.substring(index, index + 2) : str.substring(index, inputLength);
            Character escapeChar = escapeStringToControlMap.get(subOfInput);
            if (escapeChar != null) {
                builder.append(escapeChar);
                index += 2;
                continue;
            }
            if (StringUtilities.handleEscapeSequence(str, "\\x", 2, index, builder)) {
                index += 4;
                continue;
            }
            if (StringUtilities.handleEscapeSequence(str, "\\u", 4, index, builder)) {
                index += 6;
                continue;
            }
            if (StringUtilities.handleEscapeSequence(str, "\\U", 8, index, builder)) {
                index += 10;
                continue;
            }
            builder.append(str.charAt(index));
            ++index;
        }
        return builder.toString();
    }

    private static boolean handleEscapeSequence(String string, String escapeSequence, int hexLength, int index, StringBuilder builder) {
        int inputLength = string.length();
        int hexStart = index + escapeSequence.length();
        int hexEnd = hexStart + hexLength;
        if (hexEnd <= inputLength && escapeSequence.equals(string.substring(index, hexStart))) {
            String hexStr = string.substring(hexStart, hexEnd);
            int hexMask = -1 >>> 4 * (8 - hexLength);
            try {
                int val = Integer.parseInt(hexStr, 16) & hexMask;
                if (val >= 0 && val <= 65535) {
                    builder.append((char)val);
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String convertControlCharsToEscapeSequences(String str) {
        StringBuilder builder = new StringBuilder();
        int strLength = str.length();
        int charCount = 1;
        for (int i = 0; i < strLength; i += charCount) {
            int codePoint = str.codePointAt(i);
            charCount = Character.charCount(codePoint);
            if (charCount == 1 && controlToEscapeStringMap.containsKey(Character.valueOf((char)codePoint))) {
                builder.append(controlToEscapeStringMap.get(Character.valueOf((char)codePoint)));
                continue;
            }
            builder.appendCodePoint(codePoint);
        }
        return builder.toString();
    }

    public static String convertCodePointToEscapeSequence(int codePoint) {
        String escaped;
        int charCount = Character.charCount(codePoint);
        if (charCount == 1 && (escaped = controlToEscapeStringMap.get(Character.valueOf((char)codePoint))) != null) {
            return escaped;
        }
        return new String(new int[]{codePoint}, 0, 1);
    }

    public static boolean isUnicodeReplacementCodePoint(int codePoint) {
        return codePoint == 65533;
    }

    static {
        controlToEscapeStringMap.put(Character.valueOf('\t'), "\\t");
        controlToEscapeStringMap.put(Character.valueOf('\b'), "\\b");
        controlToEscapeStringMap.put(Character.valueOf('\r'), "\\r");
        controlToEscapeStringMap.put(Character.valueOf('\n'), "\\n");
        controlToEscapeStringMap.put(Character.valueOf('\f'), "\\f");
        controlToEscapeStringMap.put(Character.valueOf('\\'), "\\\\");
        controlToEscapeStringMap.put(Character.valueOf('\u000b'), "\\v");
        controlToEscapeStringMap.put(Character.valueOf('\u0007'), "\\a");
        escapeStringToControlMap.put("\\t", Character.valueOf('\t'));
        escapeStringToControlMap.put("\\b", Character.valueOf('\b'));
        escapeStringToControlMap.put("\\r", Character.valueOf('\r'));
        escapeStringToControlMap.put("\\n", Character.valueOf('\n'));
        escapeStringToControlMap.put("\\f", Character.valueOf('\f'));
        escapeStringToControlMap.put("\\\\", Character.valueOf('\\'));
        escapeStringToControlMap.put("\\v", Character.valueOf('\u000b'));
        escapeStringToControlMap.put("\\a", Character.valueOf('\u0007'));
        escapeStringToControlMap.put("\\0", Character.valueOf('\u0000'));
        DOUBLE_QUOTED_STRING_PATTERN = Pattern.compile("^\"((?:[^\\\\\"]|\\\\.)*)\"$");
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

