/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.xml.parser;

import [Ljava.lang.Object;;
import com.jeta.forms.store.JETAPersistable;
import com.jeta.forms.store.jml.JMLException;
import com.jeta.forms.store.jml.PrimitiveHolder;
import com.jeta.forms.store.jml.dom.JMLAttributes;
import com.jeta.forms.store.properties.ColorHolder;
import com.jeta.forms.store.support.PropertyMap;
import com.jeta.forms.store.xml.parser.ColorHolderHandler;
import com.jeta.forms.store.xml.parser.HashMapHandler;
import com.jeta.forms.store.xml.parser.InsetsHandler;
import com.jeta.forms.store.xml.parser.JETAPersistableHandler;
import com.jeta.forms.store.xml.parser.ListHandler;
import com.jeta.forms.store.xml.parser.ObjectArrayHandler;
import com.jeta.forms.store.xml.parser.ObjectHandler;
import com.jeta.forms.store.xml.parser.PrimitiveHandler;
import com.jeta.forms.store.xml.parser.PrimitiveHolderHandler;
import com.jeta.forms.store.xml.parser.PropertyMapHandler;
import com.jeta.forms.store.xml.parser.XMLHandler;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.xml.sax.SAXException;

public class XMLHandlerFactory {
    private HashMap m_handlers = new HashMap();
    private static XMLHandlerFactory m_singleton = new XMLHandlerFactory();
    static /* synthetic */ Class class$com$jeta$forms$store$xml$parser$XMLHandlerFactory;

    private XMLHandlerFactory() {
        this.registerHandlers();
    }

    public static XMLHandlerFactory getInstance() {
        return m_singleton;
    }

    protected XMLHandler createHandler(String string) {
        block6: {
            Class<?> clazz = (Class<?>)this.m_handlers.get(string);
            if (clazz != null) {
                try {
                    return (XMLHandler)clazz.newInstance();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    break block6;
                }
            }
            try {
                clazz = Class.forName(string);
                if (JETAPersistable.class.isAssignableFrom(clazz)) {
                    return new JETAPersistableHandler();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    protected void registerHandlers() {
        this.m_handlers.put("Boolean", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Boolean", PrimitiveHandler.class);
        this.m_handlers.put("Byte", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Byte", PrimitiveHandler.class);
        this.m_handlers.put("Character", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Character", PrimitiveHandler.class);
        this.m_handlers.put("Short", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Short", PrimitiveHandler.class);
        this.m_handlers.put("Integer", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Integer", PrimitiveHandler.class);
        this.m_handlers.put("Long", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Long", PrimitiveHandler.class);
        this.m_handlers.put("Float", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Float", PrimitiveHandler.class);
        this.m_handlers.put("Double", PrimitiveHandler.class);
        this.m_handlers.put("java.lang.Double", PrimitiveHandler.class);
        this.m_handlers.put(PropertyMap.class.getName(), PropertyMapHandler.class);
        this.m_handlers.put(HashMap.class.getName(), HashMapHandler.class);
        this.m_handlers.put(ArrayList.class.getName(), ListHandler.class);
        this.m_handlers.put(LinkedList.class.getName(), ListHandler.class);
        this.m_handlers.put(Insets.class.getName(), InsetsHandler.class);
        this.m_handlers.put("insets", InsetsHandler.class);
        this.m_handlers.put(ColorHolder.class.getName(), ColorHolderHandler.class);
        this.m_handlers.put("color", ColorHolderHandler.class);
        this.m_handlers.put(Object;.class.getName(), ObjectArrayHandler.class);
        this.m_handlers.put(PrimitiveHolder.class.getName(), PrimitiveHolderHandler.class);
    }

    private boolean isPrimitive(Class clazz) {
        return clazz == Boolean.class || clazz == Byte.class || clazz == Character.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }

    private boolean isPrimitive(String string) {
        if ("Boolean".equalsIgnoreCase(string) || "java.lang.Boolean".equalsIgnoreCase(string)) {
            return true;
        }
        if ("Byte".equalsIgnoreCase(string) || "java.lang.Byte".equalsIgnoreCase(string)) {
            return true;
        }
        if ("Character".equalsIgnoreCase(string) || "java.lang.Character".equalsIgnoreCase(string)) {
            return true;
        }
        if ("Short".equalsIgnoreCase(string) || "java.lang.Short".equalsIgnoreCase(string)) {
            return true;
        }
        if ("Integer".equalsIgnoreCase(string) || "java.lang.Integer".equalsIgnoreCase(string)) {
            return true;
        }
        if ("Long".equalsIgnoreCase(string) || "java.lang.Long".equalsIgnoreCase(string)) {
            return true;
        }
        if ("Float".equalsIgnoreCase(string) || "java.lang.Float".equalsIgnoreCase(string)) {
            return true;
        }
        return "Double".equalsIgnoreCase(string) || "java.lang.Double".equalsIgnoreCase(string);
    }

    public XMLHandler getHandler(String string) throws JMLException {
        try {
            XMLHandler xMLHandler;
            if ("null".equalsIgnoreCase(string) || string.length() == 0) {
                return new NullHandler();
            }
            if (this.isPrimitive(string) && !string.startsWith("java.lang")) {
                string = "java.lang." + string;
            }
            if ((xMLHandler = this.createHandler(string)) == null) {
                throw new JMLException("XMLHandlerFactory  handler is null for: " + string);
            }
            return xMLHandler;
        }
        catch (Exception exception) {
            throw new JMLException(exception.getMessage());
        }
    }

    private static class NullHandler
    extends ObjectHandler {
        static final /* synthetic */ boolean $assertionsDisabled;

        private NullHandler() {
        }

        public Object getProperty(String string) {
            return null;
        }

        protected void setProperty(Object object, Object object2, JMLAttributes jMLAttributes) throws SAXException {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        protected Object instantiateObject(JMLAttributes jMLAttributes) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
            String string = jMLAttributes.getValue("classname");
            if ("null".equalsIgnoreCase(string) || string.length() == 0) {
                return null;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }

        public Object getObject() {
            return null;
        }

        static {
            $assertionsDisabled = !(class$com$jeta$forms$store$xml$parser$XMLHandlerFactory == null ? (class$com$jeta$forms$store$xml$parser$XMLHandlerFactory = XMLHandlerFactory.class$("com.jeta.forms.store.xml.parser.XMLHandlerFactory")) : class$com$jeta$forms$store$xml$parser$XMLHandlerFactory).desiredAssertionStatus();
        }
    }
}

