/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class SelectEndOfLineAction
extends TextAction {
    public static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(35, 64);
    private static final String ACTION_NAME = "selection-end-line";

    public SelectEndOfLineAction() {
        super(ACTION_NAME);
    }

    private void error(Component component) {
        UIManager.getLookAndFeel().provideErrorFeedback(component);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent component = this.getTextComponent(e);
        if (component == null) {
            return;
        }
        try {
            int dot = component.getCaretPosition();
            int endPosition = Utilities.getRowEnd(component, dot);
            component.moveCaretPosition(endPosition);
        }
        catch (BadLocationException bl) {
            this.error(component);
        }
    }
}

