/*
 * Decompiled with CFR 0.152.
 */
package docking.help;

import ghidra.util.Msg;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.FavoritesItem;
import javax.help.FavoritesView;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.JHelpFavoritesNavigator;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.event.HelpModelEvent;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicFavoritesCellRenderer;
import javax.help.plaf.basic.BasicFavoritesNavigatorUI;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class CustomFavoritesView
extends FavoritesView {
    public CustomFavoritesView(HelpSet hs, String name, String label, Hashtable params) {
        this(hs, name, label, hs.getLocale(), params);
    }

    public CustomFavoritesView(HelpSet hs, String name, String label, Locale locale, Hashtable params) {
        super(hs, name, label, locale, params);
    }

    public Component createNavigator(HelpModel model) {
        return new CustomHelpFavoritesNavigator((NavigatorView)this, model);
    }

    class CustomFavoritesCellRenderer
    extends BasicFavoritesCellRenderer {
        private final HelpModel helpModel;

        public CustomFavoritesCellRenderer(HelpModel helpModel) {
            this.helpModel = helpModel;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean isFocused) {
            String ref;
            Map combinedMap;
            CustomFavoritesCellRenderer renderer = (CustomFavoritesCellRenderer)((Object)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocused));
            Object o = ((DefaultMutableTreeNode)value).getUserObject();
            FavoritesItem item = (FavoritesItem)o;
            if (item == null) {
                return renderer;
            }
            HelpSet helpSet = this.helpModel.getHelpSet();
            URL URL2 = this.getURL(item, helpSet, combinedMap = helpSet.getCombinedMap());
            if (URL2 == null) {
                return renderer;
            }
            Object text = URL2.getFile();
            int index = ((String)text).lastIndexOf(47);
            if (index != -1) {
                text = ((String)text).substring(index + 1);
            }
            if ((ref = URL2.getRef()) != null) {
                text = (String)text + "#" + ref;
            }
            renderer.setText(item.getName() + " - " + (String)text);
            return renderer;
        }

        private URL getURL(FavoritesItem item, HelpSet helpSet, Map combinedMap) {
            String target = item.getTarget();
            if (target == null) {
                return item.getURL();
            }
            Map.ID newID = null;
            try {
                newID = Map.ID.create((String)target, (HelpSet)helpSet);
            }
            catch (BadIDException e) {
                Msg.debug((Object)((Object)this), (Object)("Invalid help ID; Mabye bad favorite bookmark?: " + target));
                return null;
            }
            try {
                return combinedMap.getURLFromID(newID);
            }
            catch (MalformedURLException e) {
                Msg.error((Object)((Object)this), (Object)"Unexpected Exception", (Throwable)e);
                return null;
            }
        }
    }

    class CustomFavoritesNavigatorUI
    extends BasicFavoritesNavigatorUI {
        private HelpModelEvent lastIdEvent;
        private String currentTitle;

        CustomFavoritesNavigatorUI(JHelpFavoritesNavigator b) {
            super(b);
        }

        public void installUI(JComponent c) {
            super.installUI(c);
            this.tree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                        CustomFavoritesNavigatorUI.this.removeAction.actionPerformed(null);
                    }
                }
            });
            HelpModel model = this.favorites.getModel();
            model.addPropertyChangeListener(e -> {
                if (this.lastIdEvent == null) {
                    return;
                }
                this.currentTitle = (String)e.getNewValue();
                if (this.currentTitle == null) {
                    return;
                }
                String lastTitle = this.lastIdEvent.getHistoryName();
                if (!this.currentTitle.equals(lastTitle)) {
                    this.resendNewEventWithFixedTitle(this.lastIdEvent, this.currentTitle);
                }
            });
        }

        private void resendNewEventWithFixedTitle(HelpModelEvent originalEvent, String title) {
            HelpModelEvent e = originalEvent;
            HelpModelEvent newEvent = new HelpModelEvent(e.getSource(), e.getID(), e.getURL(), title, (JHelpNavigator)this.favorites);
            this.idChanged(newEvent);
        }

        protected void setCellRenderer(NavigatorView view, JTree tree) {
            tree.setCellRenderer((TreeCellRenderer)((Object)new CustomFavoritesCellRenderer(this.favorites.getModel())));
        }

        public void idChanged(HelpModelEvent e) {
            this.lastIdEvent = e;
            super.idChanged(e);
        }
    }

    class CustomHelpFavoritesNavigator
    extends JHelpFavoritesNavigator {
        CustomHelpFavoritesNavigator(NavigatorView view, HelpModel model) {
            super(view, model);
        }

        public void setUI(HelpNavigatorUI ui) {
            super.setUI((HelpNavigatorUI)new CustomFavoritesNavigatorUI(this));
        }
    }
}

