/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.tray;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.rzo.yajsw.boot.WrapperLoader;
import org.rzo.yajsw.config.YajswConfigurationImpl;
import org.rzo.yajsw.os.OperatingSystem;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.tray.TrayIconMainBooter;
import org.rzo.yajsw.tray.WrapperTrayIcon;
import org.rzo.yajsw.tray.WrapperTrayIconDummy;
import org.rzo.yajsw.tray.WrapperTrayIconImpl;
import org.rzo.yajsw.util.Utils;

public class WrapperTrayIconFactory {
    public static WrapperTrayIcon createTrayIcon(String name, String icon, YajswConfigurationImpl config) {
        WrapperTrayIcon result = null;
        if (config == null) {
            config = new YajswConfigurationImpl();
        }
        try {
            result = new WrapperTrayIconImpl(name, icon, config);
        }
        catch (Throwable ex) {
            System.out.println("java version does not support SystemTray: " + ex.getMessage());
            ex.printStackTrace();
        }
        if (result == null || !result.isInit()) {
            result = new WrapperTrayIconDummy();
        }
        return result;
    }

    public static Process startTrayIconProcess(YajswConfigurationImpl config, Logger logger) {
        if (config == null) {
            return null;
        }
        String wrapperConfFileName = config.getCachedPath(false);
        final Process osProcess = OperatingSystem.instance().processManagerInstance().createProcess();
        try {
            int debug;
            String opt;
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(WrapperTrayIconFactory.getJava());
            for (Map.Entry<String, String> e : config.getEnvLookupSet().entrySet()) {
                String opt2 = Utils.getDOption(e.getKey(), e.getValue());
                if (cmd.contains(opt2)) continue;
                cmd.add(opt2);
            }
            String tmpDir = config.getString("wrapper.tmp.path", null);
            if (tmpDir == null || tmpDir.startsWith("?")) {
                tmpDir = System.getProperty("jna_tmpdir", null);
            }
            if (tmpDir != null) {
                opt = Utils.getDOption("jna_tmpdir", tmpDir);
                if (!cmd.contains(opt)) {
                    cmd.add(opt);
                }
            } else {
                tmpDir = System.getProperty("java.io.tmpdir", null);
                if (tmpDir != null && !cmd.contains(opt = Utils.getDOption("jna_tmpdir", tmpDir))) {
                    cmd.add(opt);
                }
            }
            cmd.add("-classpath");
            cmd.add(WrapperLoader.getWrapperJar());
            cmd.add(TrayIconMainBooter.class.getName());
            cmd.add(wrapperConfFileName);
            String[] arrCmd = new String[cmd.size()];
            for (int i = 0; i < arrCmd.length; ++i) {
                arrCmd[i] = (String)cmd.get(i);
            }
            osProcess.setCommand(arrCmd);
            osProcess.setPipeStreams(false, false);
            osProcess.setVisible(false);
            osProcess.setLogger(logger);
            osProcess.setDebug(config.getBoolean("wrapper.debug", false) ? config.getInt("wrapper.debug.level", 3) > 1 : false);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (osProcess != null) {
                        osProcess.kill(0);
                    }
                }
            });
            osProcess.start();
            int n = debug = config.getBoolean("wrapper.debug", false) ? config.getInt("wrapper.debug.level", 3) : 0;
            if (debug > 1) {
                logger.info("spawned system tray icon process with pid " + osProcess.getPid());
            }
            return osProcess;
        }
        catch (Exception e) {
            logger.throwing("WRapperTRayIconFactory", "startTrayIconProcess", e);
            return null;
        }
    }

    public static String getJava() {
        String result = System.getenv("java_exe");
        if (result == null) {
            result = System.getProperty("sun.boot.library.path");
            result = result != null ? result + "/javaw" : "java";
        }
        return result;
    }
}

