/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.GTableCellRenderer;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.table.ProgramTableModel;
import java.awt.Color;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class GhidraTableCellRenderer
extends GTableCellRenderer {
    private static final Color BAD_REF_ADDR_COLOR = Color.red;
    private static final Color EXT_REF_RESOLVED_COLOR = Color.CYAN.darker().darker();

    public GhidraTableCellRenderer() {
    }

    public GhidraTableCellRenderer(Font f) {
        super(f);
    }

    protected String getText(Object value) {
        if (value == null) {
            return "";
        }
        if (this.isExternalAdress(value)) {
            return "<External>";
        }
        return value.toString();
    }

    protected void setForegroundColor(JTable table, TableModel model, Object value) {
        if (this.isExternalAdress(value)) {
            if (this.isResolvedExternalAddress(model, (Address)value)) {
                this.setForeground(EXT_REF_RESOLVED_COLOR);
            } else {
                this.setForeground(BAD_REF_ADDR_COLOR);
            }
        } else if (this.isValueOutOfMemoryAddress(model, value)) {
            this.setForeground(BAD_REF_ADDR_COLOR);
        } else {
            this.setForeground(table.getForeground());
        }
    }

    private boolean isExternalAdress(Object value) {
        if (!(value instanceof Address)) {
            return false;
        }
        return ((Address)value).isExternalAddress();
    }

    private boolean isResolvedExternalAddress(TableModel model, Address extAddr) {
        if (!(model instanceof ProgramTableModel)) {
            return false;
        }
        ProgramTableModel programTableModel = (ProgramTableModel)((Object)model);
        Program program = programTableModel.getProgram();
        if (program == null) {
            return false;
        }
        Symbol s = program.getSymbolTable().getPrimarySymbol(extAddr);
        ExternalLocation extLoc = program.getExternalManager().getExternalLocation(s);
        String path = program.getExternalManager().getExternalLibraryPath(extLoc.getLibraryName());
        return path != null && path.length() > 0;
    }

    private boolean isValueOutOfMemoryAddress(TableModel model, Object value) {
        if (!(value instanceof Address)) {
            return false;
        }
        if (!(model instanceof ProgramTableModel)) {
            return false;
        }
        ProgramTableModel programTableModel = (ProgramTableModel)((Object)model);
        Program program = programTableModel.getProgram();
        if (program == null) {
            return false;
        }
        Address address = (Address)value;
        Memory memory = program.getMemory();
        return !memory.contains(address);
    }
}

