/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem.factory;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryFull;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeFull;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class GFileSystemBaseFactory
implements GFileSystemFactoryFull<GFileSystemBase>,
GFileSystemProbeFull {
    private Class<? extends GFileSystemBase> fsClass;
    private static final Class<?>[] FS_CTOR_PARAM_TYPES = new Class[]{String.class, ByteProvider.class};

    public void setFileSystemClass(Class<? extends GFileSystemBase> fsClass) {
        this.fsClass = fsClass;
    }

    @Override
    public boolean probe(FSRL containerFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        try {
            Constructor<? extends GFileSystemBase> ctor = this.fsClass.getConstructor(FS_CTOR_PARAM_TYPES);
            GFileSystemBase fs = ctor.newInstance(containerFSRL.getName(), byteProvider);
            return fs.isValid(monitor);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IOException("Error when probing filesystem " + this.fsClass.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GFileSystemBase create(FSRL containerFSRL, FSRLRoot targetFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        GFileSystemBase gFileSystemBase;
        block8: {
            Constructor<? extends GFileSystemBase> ctor = this.fsClass.getConstructor(FS_CTOR_PARAM_TYPES);
            GFileSystemBase fs = ctor.newInstance(containerFSRL.getName(), byteProvider);
            try {
                if (!fs.isValid(monitor)) {
                    throw new IOException("Error when creating new filesystem " + this.fsClass.getName() + ", isvalid failed");
                }
                fs.setFilesystemService(fsService);
                fs.setFSRL(targetFSRL);
                fs.open(monitor);
                GFileSystemBase successFS = fs;
                fs = null;
                gFileSystemBase = successFS;
                if (fs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        fs.close();
                    }
                    throw throwable;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IOException("Error when opening filesystem " + this.fsClass.getName(), e);
                }
                catch (RuntimeException e) {
                    throw new IOException("Runtime exception when opening filesystem " + this.fsClass.getName(), e);
                }
            }
            fs.close();
        }
        return gFileSystemBase;
    }
}

