/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcode;

import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.exception.InvalidInputException;
import java.util.HashMap;
import java.util.List;

class PcodeSpec {
    private static final int CONSTANT = 1;
    private static final int UNIQUE = 2;
    private static final int ADDRESS = 4;
    private static final int REGISTER = 8;
    private static final int RELATIVE_ADDRESS = 16;
    private static final int CUR_SPACE_POINTER = 32;
    private static final int ANY = 31;
    private static final int ANY_VARIABLE = 14;
    private static final int[] NO_INPUT = new int[0];
    private static final int[] ANY_ONE_INPUT = new int[]{31};
    private static final int[] ANY_TWO_INPUTS = new int[]{31, 31};
    private static final int[] DIRECT_BRANCH_INPUTS = new int[]{21};
    private static final int[] DIRECT_CONDITIONAL_BRANCH_INPUTS = new int[]{21, 14};
    private static final int[] DIRECT_CALL_INPUTS = new int[]{4};
    private static final int[] INDIRECT_FLOW_INPUTS = new int[]{62};
    private static final int[] LOAD_INPUTS = new int[]{1, 31};
    private static final int[] STORE_INPUTS = new int[]{1, 31, 31};
    private static final int[] SHIFT_INPUTS = new int[]{31, 1};
    private static final int OUTPUT_NONE = 0;
    private static final int OUTPUT_INPUT0_SIZE = 1;
    private static final int OUTPUT_INPUT0_SIZE_EXTENDED = 2;
    private static final int OUTPUT_INPUT0_SIZE_TRUNCATED = 3;
    private static final int OUTPUT_INPUT1_SIZE = 4;
    private static final int OUTPUT_BOOLEAN = 5;
    private static final int OUTPUT_ANY_SIZE = 6;
    private static HashMap<String, PcodeSpec> pcodeNameSpecMap;
    private static HashMap<Integer, PcodeSpec> pcodeSpecMap;
    private String opName;
    private int opCode;
    private int outputType;
    private boolean inputSizesMustMatch;
    private int[] inputSpecs;

    private PcodeSpec(String opName, int opCode, int outputType, boolean inputSizesMustMatch, int[] inputSpecs) {
        this.opName = opName;
        this.opCode = opCode;
        this.outputType = outputType;
        this.inputSizesMustMatch = inputSizesMustMatch;
        this.inputSpecs = inputSpecs;
    }

    boolean isAssignmentOp() {
        return this.outputType != 0;
    }

    boolean inputSizesMustMatch() {
        return this.inputSizesMustMatch;
    }

    String getOpName() {
        return this.opName;
    }

    int getOpCode() {
        return this.opCode;
    }

    int getNumInputs() {
        return this.inputSpecs.length;
    }

    void checkOutput(AddressFactory addrFactory, VarnodeTpl output, List<VarnodeTpl> inputs) throws InvalidInputException {
        if (this.outputType == 0) {
            if (output != null) {
                throw new InvalidInputException("operation " + this.opName + " does not support output assignment");
            }
            return;
        }
        if (output == null) {
            throw new InvalidInputException("operation " + this.opName + " requires output assignment");
        }
        switch (this.outputType) {
            case 1: {
                int outSize;
                if (inputs.size() == 0) {
                    throw new InvalidInputException("operation " + this.opName + " input(s) are missing");
                }
                int inSize = this.getSize(addrFactory, inputs.get(0));
                if (inSize == (outSize = this.getSize(addrFactory, output))) break;
                throw new InvalidInputException("operation " + this.opName + " expected output size of " + inSize);
            }
            case 2: {
                int outSize;
                if (inputs.size() == 0) {
                    throw new InvalidInputException("operation " + this.opName + " input(s) are missing");
                }
                int inSize = this.getSize(addrFactory, inputs.get(0));
                if (inSize < (outSize = this.getSize(addrFactory, output))) break;
                throw new InvalidInputException("operation " + this.opName + " expected output size larger than " + inSize);
            }
            case 3: {
                int outSize;
                if (inputs.size() == 0) {
                    throw new InvalidInputException("operation " + this.opName + " input(s) are missing");
                }
                int inSize = this.getSize(addrFactory, inputs.get(0));
                if (inSize > (outSize = this.getSize(addrFactory, output))) break;
                throw new InvalidInputException("operation " + this.opName + " expected output size smaller than " + inSize);
            }
            case 4: {
                int outSize;
                if (inputs.size() < 2) {
                    throw new InvalidInputException("operation " + this.opName + " input(s) are missing");
                }
                int inSize = this.getSize(addrFactory, inputs.get(1));
                if (inSize == (outSize = this.getSize(addrFactory, output))) break;
                throw new InvalidInputException("operation " + this.opName + " expected output size of " + inSize);
            }
            case 5: {
                if (this.getSize(addrFactory, output) == 1) break;
                throw new InvalidInputException("operation " + this.opName + " expected boolean output size of 1");
            }
            case 6: {
                break;
            }
            default: {
                throw new RuntimeException("unsupported output PcodeSpec output type");
            }
        }
    }

    private int getSize(AddressFactory addrFactory, VarnodeTpl varnodeTpl) {
        ConstTpl size = varnodeTpl.getSize();
        if (size.getType() == 5) {
            return addrFactory.getDefaultAddressSpace().getAddressableUnitSize();
        }
        return (int)size.getReal();
    }

    void checkInput(AddressFactory addrFactory, int inputIndex, VarnodeTpl input, ConstTpl baselineSizeTpl) throws InvalidInputException {
        this.checkInputType(addrFactory, inputIndex, input);
        if (this.inputSizesMustMatch && baselineSizeTpl != null) {
            this.checkInputSize(addrFactory, inputIndex, input, baselineSizeTpl);
        }
    }

    private void checkInputSize(AddressFactory addrFactory, int inputIndex, VarnodeTpl input, ConstTpl baselineSizeTpl) throws InvalidInputException {
        long size2;
        int sizeType1 = baselineSizeTpl.getType();
        ConstTpl sizeTpl = input.getSize();
        int sizeType2 = sizeTpl.getType();
        AddressSpace defaultSpace = addrFactory.getDefaultAddressSpace();
        long size1 = sizeType1 == 5 ? (long)defaultSpace.getPointerSize() : baselineSizeTpl.getReal();
        long l = size2 = sizeType2 == 5 ? (long)defaultSpace.getPointerSize() : sizeTpl.getReal();
        if (size1 != size2) {
            throw new InvalidInputException("operation " + this.opName + " expected matching input size of " + size1);
        }
    }

    private void checkInputType(AddressFactory addrFactory, int inputIndex, VarnodeTpl input) throws InvalidInputException {
        int mask = this.inputSpecs[inputIndex];
        ConstTpl offset = input.getOffset();
        int offsetType = offset.getType();
        switch (offsetType) {
            case 0: {
                ConstTpl space = input.getSpace();
                int spaceType = space.getType();
                if (spaceType == 6) {
                    AddressSpace s = space.getSpaceId();
                    if (space.isConstSpace()) {
                        if ((mask & 1) == 0) {
                            throw new InvalidInputException("operation " + this.opName + " - constant input not allowed");
                        }
                    } else if (space.isUniqueSpace()) {
                        if ((mask & 2) == 0) {
                            throw new InvalidInputException("operation " + this.opName + " unique variable input not allowed");
                        }
                    } else {
                        if (s == null) {
                            throw new RuntimeException("address space not found");
                        }
                        if (s.isRegisterSpace()) {
                            if ((mask & 8) == 0) {
                                throw new InvalidInputException("operation " + this.opName + " - register input not allowed");
                            }
                        } else if ((mask & 4) == 0) {
                            throw new InvalidInputException("operation " + this.opName + " - address input not allowed");
                        }
                    }
                    if ((mask & 0x20) == 0) break;
                    ConstTpl size = input.getSize();
                    int expectedSize = addrFactory.getDefaultAddressSpace().getPointerSize();
                    if (size.getType() != 0 || size.getReal() == (long)expectedSize) break;
                    throw new InvalidInputException("incorrect indirect pointer size, expected size of " + expectedSize);
                }
                if (spaceType == 4) {
                    if ((mask & 4) != 0) break;
                    throw new InvalidInputException("operation " + this.opName + " - address input not allowed");
                }
                throw new RuntimeException("unexpected space type (" + spaceType + ")");
            }
            case 2: 
            case 3: {
                if ((mask & 5) != 0) break;
                throw new InvalidInputException(this.opName + " - address/constant input not allowed");
            }
            case 7: {
                if ((mask & 0x10) != 0) break;
                throw new InvalidInputException(this.opName + " - relative label input not allowed");
            }
            default: {
                throw new RuntimeException("unsupported offset type (" + offsetType + ")");
            }
        }
    }

    static PcodeSpec getSpec(String opName) {
        PcodeSpec.initMap();
        return pcodeNameSpecMap.get(opName.toUpperCase());
    }

    static PcodeSpec getSpec(int opCode) {
        PcodeSpec.initMap();
        return pcodeSpecMap.get(opCode);
    }

    private static void addSpec(String opName, int opCode, int outputType, boolean inputSizesMustMatch, int[] inputSpecs) {
        PcodeSpec opSpec = new PcodeSpec(opName, opCode, outputType, inputSizesMustMatch, inputSpecs);
        pcodeNameSpecMap.put(opName, opSpec);
        pcodeSpecMap.put(opCode, opSpec);
    }

    private static void initMap() {
        if (pcodeNameSpecMap != null) {
            return;
        }
        pcodeNameSpecMap = new HashMap();
        pcodeSpecMap = new HashMap();
        PcodeSpec.addSpec("unimpl", 0, 0, true, NO_INPUT);
        PcodeSpec.addSpec("COPY", 1, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("LOAD", 2, 6, false, LOAD_INPUTS);
        PcodeSpec.addSpec("STORE", 3, 0, false, STORE_INPUTS);
        PcodeSpec.addSpec("BRANCH", 4, 0, false, DIRECT_BRANCH_INPUTS);
        PcodeSpec.addSpec("CBRANCH", 5, 0, false, DIRECT_CONDITIONAL_BRANCH_INPUTS);
        PcodeSpec.addSpec("BRANCHIND", 6, 0, false, INDIRECT_FLOW_INPUTS);
        PcodeSpec.addSpec("CALL", 7, 0, false, DIRECT_CALL_INPUTS);
        PcodeSpec.addSpec("CALLIND", 8, 0, false, INDIRECT_FLOW_INPUTS);
        PcodeSpec.addSpec("CALLOTHER", 9, 6, false, null);
        PcodeSpec.addSpec("RETURN", 10, 0, false, INDIRECT_FLOW_INPUTS);
        PcodeSpec.addSpec("INT_EQUAL", 11, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_NOTEQUAL", 12, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_SLESS", 13, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_SLESSEQUAL", 14, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_LESS", 15, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_LESSEQUAL", 16, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_ZEXT", 17, 2, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("INT_SEXT", 18, 2, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("INT_ADD", 19, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_SUB", 20, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_CARRY", 21, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_SCARRY", 22, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_SBORROW", 23, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_2COMP", 24, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("INT_NEGATE", 25, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("INT_XOR", 26, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_AND", 27, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_OR", 28, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_LEFT", 29, 1, false, SHIFT_INPUTS);
        PcodeSpec.addSpec("INT_RIGHT", 30, 1, false, SHIFT_INPUTS);
        PcodeSpec.addSpec("INT_SRIGHT", 31, 1, false, SHIFT_INPUTS);
        PcodeSpec.addSpec("INT_MULT", 32, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_DIV", 33, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_SDIV", 34, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_REM", 35, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("INT_SREM", 36, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("BOOL_NEGATE", 37, 5, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("BOOL_XOR", 38, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("BOOL_AND", 39, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("BOOL_OR", 40, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_EQUAL", 41, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_NOTEQUAL", 42, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_LESS", 43, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_LESSEQUAL", 44, 5, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_NAN", 46, 5, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("FLOAT_ADD", 47, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_DIV", 48, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_MULT", 49, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_SUB", 50, 1, true, ANY_TWO_INPUTS);
        PcodeSpec.addSpec("FLOAT_NEG", 51, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("FLOAT_ABS", 52, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("FLOAT_SQRT", 53, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("INT2FLOAT", 54, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("FLOAT2FLOAT", 55, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("FLOAT2INT", 56, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("FLOAT_CEIL", 57, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("FLOAT_FLOOR", 58, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("FLOAT_ROUND", 59, 1, false, ANY_ONE_INPUT);
        PcodeSpec.addSpec("PIECE", 62, 6, true, SHIFT_INPUTS);
        PcodeSpec.addSpec("SUBPIECE", 63, 6, false, SHIFT_INPUTS);
        PcodeSpec.addSpec("CPOOL", 68, 6, false, SHIFT_INPUTS);
        PcodeSpec.addSpec("NEWOBJECT", 69, 6, false, null);
    }
}

