/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.omf.OmfComdefRecord;
import ghidra.app.util.bin.format.omf.OmfCommentRecord;
import ghidra.app.util.bin.format.omf.OmfEnumeratedData;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.OmfFixupRecord;
import ghidra.app.util.bin.format.omf.OmfGroupRecord;
import ghidra.app.util.bin.format.omf.OmfIteratedData;
import ghidra.app.util.bin.format.omf.OmfNamesRecord;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfSegmentHeader;
import ghidra.app.util.bin.format.omf.OmfSymbol;
import ghidra.app.util.bin.format.omf.OmfSymbolRecord;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;

public class OmfFileHeader
extends OmfRecord {
    private String objectName;
    private String libModuleName = null;
    private String translator = null;
    private boolean isLittleEndian;
    private ArrayList<String> nameList = new ArrayList();
    private ArrayList<OmfSegmentHeader> segments = new ArrayList();
    private ArrayList<OmfGroupRecord> groups = new ArrayList();
    private ArrayList<OmfExternalSymbol> externsymbols = new ArrayList();
    private ArrayList<OmfSymbolRecord> symbols = new ArrayList();
    private ArrayList<OmfFixupRecord> fixup = new ArrayList();
    private ArrayList<OmfSegmentHeader> extraSeg = null;

    public OmfFileHeader(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        this.objectName = OmfFileHeader.readString(reader);
        this.readCheckSumByte(reader);
        this.isLittleEndian = reader.isLittleEndian();
    }

    public String getName() {
        return this.objectName;
    }

    public String getLibraryModuleName() {
        return this.libModuleName;
    }

    public String getMachineName() {
        return "i386";
    }

    public String getTranslator() {
        return this.translator;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public ArrayList<OmfSegmentHeader> getSegments() {
        return this.segments;
    }

    public ArrayList<OmfSegmentHeader> getExtraSegments() {
        return this.extraSeg;
    }

    public ArrayList<OmfGroupRecord> getGroups() {
        return this.groups;
    }

    public ArrayList<OmfExternalSymbol> getExternalSymbols() {
        return this.externsymbols;
    }

    public ArrayList<OmfSymbolRecord> getPublicSymbols() {
        return this.symbols;
    }

    public ArrayList<OmfFixupRecord> getFixups() {
        return this.fixup;
    }

    public void sortSegmentDataBlocks() {
        int i;
        if (this.extraSeg != null) {
            for (i = 0; i < this.extraSeg.size(); ++i) {
                this.segments.add(this.extraSeg.get(i));
            }
        }
        for (i = 0; i < this.segments.size(); ++i) {
            this.segments.get(i).sortData();
        }
    }

    private void addEnumeratedBlock(OmfEnumeratedData datablock) throws OmfException {
        OmfSegmentHeader segment;
        int index = datablock.getSegmentIndex();
        int subindex = -1;
        if ((index & 0x4000) != 0) {
            subindex = index & 0x3FFF;
            index = 1;
            segment = this.createOrFindBorlandSegment(subindex, 1);
        } else {
            if (index <= 0 || index > this.segments.size()) {
                throw new OmfException("Bad segment index");
            }
            segment = this.segments.get(index - 1);
        }
        if (subindex != -1) {
            segment.appendEnumeratedData(datablock);
        } else {
            segment.addEnumeratedData(datablock);
        }
    }

    public OmfSegmentHeader resolveSegment(int index) throws OmfException {
        int subindex = -1;
        if ((index & 0x4000) != 0) {
            subindex = index & 0x3FFF;
            if (subindex <= 0 || subindex > this.extraSeg.size()) {
                throw new OmfException("Bad extra segment index");
            }
            OmfSegmentHeader res = this.extraSeg.get(subindex - 1);
            return res;
        }
        if (index <= 0 || index > this.segments.size()) {
            throw new OmfException("Bad segment index");
        }
        OmfSegmentHeader res = this.segments.get(index - 1);
        return res;
    }

    public void resolveNames() throws OmfException {
        int i;
        for (i = 0; i < this.segments.size(); ++i) {
            this.segments.get(i).resolveNames(this.nameList);
        }
        for (i = 0; i < this.groups.size(); ++i) {
            this.groups.get(i).resolveNames(this.nameList);
        }
    }

    private OmfSegmentHeader createOrFindBorlandSegment(int index, int datatype) {
        if (this.extraSeg == null) {
            this.extraSeg = new ArrayList();
        }
        while (this.extraSeg.size() < index) {
            this.extraSeg.add(null);
        }
        OmfSegmentHeader segment = this.extraSeg.get(index - 1);
        if (segment == null) {
            segment = new OmfSegmentHeader(index, datatype);
            this.extraSeg.set(index - 1, segment);
        }
        return segment;
    }

    private void evaluateComdef(OmfComdefRecord comdef) {
        OmfSymbol[] coms;
        for (OmfSymbol sym : coms = comdef.getSymbols()) {
            int dt = sym.getDataType();
            if (dt <= 0 || dt >= 96) continue;
            int count = this.extraSeg == null ? 1 : this.extraSeg.size() + 1;
            this.createOrFindBorlandSegment(count, dt);
            sym.setSegmentRef(count);
        }
    }

    public static OmfFileHeader scan(BinaryReader reader, TaskMonitor monitor, boolean initialCommentsOnly) throws IOException, OmfException {
        OmfRecord record = OmfRecord.readRecord(reader);
        if ((record.getRecordType() & 0xFFFFFFFC) != -128) {
            throw new OmfException("Object file does not start with proper header");
        }
        OmfFileHeader header = (OmfFileHeader)record;
        byte type = record.getRecordType();
        block3: for (type = (byte)(type & 0xFE); type != -118 && !monitor.isCancelled(); type = (byte)(type & 0xFE)) {
            record = OmfRecord.readRecord(reader);
            type = record.getRecordType();
            if (initialCommentsOnly && type != -120) break;
            switch (type) {
                case -120: {
                    byte commentClass = ((OmfCommentRecord)record).getCommentClass();
                    if (commentClass != 0) continue block3;
                    header.translator = ((OmfCommentRecord)record).getValue();
                    continue block3;
                }
            }
        }
        return header;
    }

    public static OmfFileHeader parse(BinaryReader reader, TaskMonitor monitor) throws IOException, OmfException {
        OmfRecord record = OmfRecord.readRecord(reader);
        if ((record.getRecordType() & 0xFFFFFFFC) != -128) {
            throw new OmfException("Object file does not start with proper header");
        }
        OmfFileHeader header = (OmfFileHeader)record;
        OmfRecord lastDataBlock = null;
        while ((record.getRecordType() & 0xFFFFFFFE) != -118 && !monitor.isCancelled()) {
            record = OmfRecord.readRecord(reader);
            byte type = record.getRecordType();
            type = (byte)(type & 0xFE);
            switch (type) {
                case -120: {
                    byte commentClass = ((OmfCommentRecord)record).getCommentClass();
                    if (commentClass == 0) {
                        header.translator = ((OmfCommentRecord)record).getValue();
                        break;
                    }
                    if (commentClass != -93) break;
                    header.libModuleName = ((OmfCommentRecord)record).getValue();
                    break;
                }
                case -118: {
                    break;
                }
                case -80: 
                case -72: {
                    header.evaluateComdef((OmfComdefRecord)record);
                    header.externsymbols.add((OmfExternalSymbol)record);
                    break;
                }
                case -116: 
                case -76: {
                    header.externsymbols.add((OmfExternalSymbol)record);
                    break;
                }
                case -112: {
                    header.symbols.add((OmfSymbolRecord)record);
                    break;
                }
                case -108: {
                    break;
                }
                case -106: {
                    ((OmfNamesRecord)record).appendNames(header.nameList);
                    break;
                }
                case -104: {
                    header.segments.add((OmfSegmentHeader)record);
                    break;
                }
                case -102: {
                    header.groups.add((OmfGroupRecord)record);
                    break;
                }
                case -100: {
                    OmfFixupRecord fixuprec = (OmfFixupRecord)record;
                    fixuprec.setDataBlock(lastDataBlock);
                    header.fixup.add(fixuprec);
                    break;
                }
                case -96: {
                    OmfEnumeratedData enumheader = (OmfEnumeratedData)record;
                    header.addEnumeratedBlock(enumheader);
                    lastDataBlock = enumheader;
                    break;
                }
                case -94: {
                    OmfIteratedData iterheader = (OmfIteratedData)record;
                    if (iterheader.getSegmentIndex() <= 0 || iterheader.getSegmentIndex() > header.segments.size()) {
                        throw new OmfException("Bad segment index on LIDATA");
                    }
                    OmfSegmentHeader segheader2 = header.segments.get(iterheader.getSegmentIndex() - 1);
                    segheader2.addIteratedData(iterheader);
                    lastDataBlock = iterheader;
                    break;
                }
            }
        }
        return header;
    }

    public static void doLinking(long startAddress, ArrayList<OmfSegmentHeader> segments, ArrayList<OmfGroupRecord> groups) throws OmfException {
        int j;
        int i;
        for (i = 0; i < groups.size(); ++i) {
            OmfGroupRecord group = groups.get(i);
            group.setStartAddress(startAddress);
            for (j = 0; j < group.numSegments(); ++j) {
                int index = group.getSegmentIndex(j);
                try {
                    OmfSegmentHeader segment = segments.get(index - 1);
                    startAddress = segment.relocateSegment(startAddress, -1);
                    continue;
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new OmfException(ex.getMessage());
                }
            }
        }
        for (i = 0; i < segments.size(); ++i) {
            OmfSegmentHeader segment = segments.get(i);
            if (segment.getStartAddress() != -1L) continue;
            startAddress = segment.relocateSegment(startAddress, -1);
            for (j = i + 1; j < segments.size(); ++j) {
                int C;
                OmfSegmentHeader combineSeg = segments.get(j);
                if (combineSeg.getStartAddress() != -1L || !combineSeg.getName().equals(segment.getName()) || !combineSeg.getClassName().equals(segment.getClassName()) || (C = combineSeg.getCombine()) == 0) continue;
                if (C == 2 || C == 4 || C == 7) {
                    startAddress = combineSeg.relocateSegment(startAddress, -1);
                    continue;
                }
                if (C == 5) {
                    startAddress = combineSeg.relocateSegment(startAddress, 1);
                    continue;
                }
                throw new OmfException("Combine type not supported");
            }
        }
    }

    public static boolean checkMagicNumber(BinaryReader reader) throws IOException {
        int stringlen;
        byte first = reader.readNextByte();
        if ((first & 0xFC) != 128) {
            return false;
        }
        int len = reader.readNextShort() & 0xFFFF;
        return len == (stringlen = reader.readNextByte() & 0xFF) + 2;
    }

    public static BinaryReader createReader(ByteProvider provider) {
        return new BinaryReader(provider, true);
    }
}

