/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.ClassCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class CreateClassAction
extends SymbolTreeContextAction {
    public CreateClassAction(SymbolTreePlugin plugin) {
        super("Create Class", plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Create Class"}, "0Create"));
        this.setEnabled(false);
    }

    @Override
    protected void actionPerformed(SymbolTreeActionContext context) {
        GTree tree = (GTree)context.getContextObject();
        if (tree.isFiltered()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)tree, (String)"Create Class Not Allowed", (Object)"Cannot create class while the tree is filtered!");
            return;
        }
        this.createNewClass(context);
    }

    @Override
    protected boolean isEnabledForContext(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length == 1) {
            Object object = selectionPaths[0].getLastPathComponent();
            if (object instanceof ClassCategoryNode) {
                return true;
            }
            if (object instanceof SymbolNode) {
                SymbolNode symbolNode = (SymbolNode)object;
                Symbol symbol = symbolNode.getSymbol();
                SymbolType symbolType = symbol.getSymbolType();
                if (symbolType == SymbolType.NAMESPACE) {
                    Namespace parentNamespace = (Namespace)symbol.getObject();
                    return SymbolType.CLASS.isValidParent(context.getProgram(), parentNamespace, Address.NO_ADDRESS, parentNamespace.isExternal());
                }
                return symbolType == SymbolType.CLASS || symbolType == SymbolType.LIBRARY;
            }
        }
        return false;
    }

    private void createNewClass(SymbolTreeActionContext context) {
        Symbol symbol;
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        Program program = context.getProgram();
        Namespace parent = program.getGlobalNamespace();
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (node instanceof SymbolNode && (parent = (Namespace)(symbol = ((SymbolNode)node).getSymbol()).getObject()) == null) {
            return;
        }
        String newClassName = this.createClass(program, parent);
        if (newClassName == null) {
            return;
        }
        program.flushEvents();
        context.getSymbolTree().startEditing(node, newClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createClass(Program program, Namespace parent) {
        Object newClassName = "NewClass";
        int transactionID = program.startTransaction("Create Class");
        try {
            SymbolTable symbolTable = program.getSymbolTable();
            int oneUp = 0;
            GhidraClass namespace = null;
            while (namespace == null) {
                try {
                    namespace = symbolTable.createClass(parent, (String)newClassName, SourceType.USER_DEFINED);
                }
                catch (DuplicateNameException e) {
                    newClassName = "NewClass(" + ++oneUp + ")";
                }
                catch (InvalidInputException e) {
                    Msg.debug((Object)((Object)this), (Object)("Failed to create class: " + e.getMessage()));
                    String string = null;
                    program.endTransaction(transactionID, true);
                    return string;
                    return newClassName;
                }
            }
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }
}

