/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.KeyBindingData;
import docking.event.mouse.GMouseListenerAdapter;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.pathmanager.PathManager;
import docking.widgets.pathmanager.PathManagerListener;
import docking.widgets.table.GTable;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.TableFilter;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import docking.widgets.tree.support.BreadthFirstIterator;
import generic.jar.ResourceFile;
import generic.util.Path;
import ghidra.app.plugin.core.script.DraggableScriptTable;
import ghidra.app.plugin.core.script.GhidraScriptActionManager;
import ghidra.app.plugin.core.script.GhidraScriptEditorComponentProvider;
import ghidra.app.plugin.core.script.GhidraScriptMgrPlugin;
import ghidra.app.plugin.core.script.GhidraScriptTableModel;
import ghidra.app.plugin.core.script.KeyBindingInputDialog;
import ghidra.app.plugin.core.script.PickPathsDialog;
import ghidra.app.plugin.core.script.PickProviderDialog;
import ghidra.app.plugin.core.script.RootNode;
import ghidra.app.plugin.core.script.RunScriptTask;
import ghidra.app.plugin.core.script.SaveDialog;
import ghidra.app.plugin.core.script.SaveNewScriptDialog;
import ghidra.app.plugin.core.script.ScriptAction;
import ghidra.app.script.GhidraScript;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.ScriptInfo;
import ghidra.app.services.ConsoleService;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskListener;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.TreePath;
import resources.ResourceManager;
import utilities.util.FileUtilities;

public class GhidraScriptComponentProvider
extends ComponentProviderAdapter {
    private static final double TOP_PREFERRED_RESIZE_WEIGHT = 0.8;
    private static final String DESCRIPTION_DIVIDER_LOCATION = "DESCRIPTION_DIVIDER_LOCATION";
    private static final String FILTER_TEXT = "FILTER_TEXT";
    static final String WINDOW_GROUP = "Script Group";
    private Map<ResourceFile, GhidraScriptEditorComponentProvider> editorMap = new HashMap<ResourceFile, GhidraScriptEditorComponentProvider>();
    private GhidraScriptMgrPlugin plugin;
    private JPanel component;
    private RootNode scriptRoot;
    private GTree scriptCategoryTree;
    private DraggableScriptTable scriptTable;
    private GhidraScriptTableModel tableModel;
    private PathManager pathManager;
    private TaskListener taskListener = new ScriptTaskListener();
    private GhidraScriptActionManager actionManager;
    private GhidraTableFilterPanel<ResourceFile> tableFilterPanel;
    private JTextPane descriptionTextPane;
    private JSplitPane dataDescriptionSplit;
    private boolean hasBeenRefreshed = false;
    private TreePath previousPath;
    private String[] previousCategory;
    private ResourceFile lastRunScript;
    private WeakSet<RunScriptTask> runningScriptTaskSet = WeakDataStructureFactory.createCopyOnReadWeakSet();
    private TaskListener cleanupTaskSetListener = new TaskListener(){

        public void taskCompleted(Task task) {
            GhidraScriptComponentProvider.this.runningScriptTaskSet.remove((Object)((RunScriptTask)task));
        }

        public void taskCancelled(Task task) {
            GhidraScriptComponentProvider.this.runningScriptTaskSet.remove((Object)((RunScriptTask)task));
        }
    };

    GhidraScriptComponentProvider(GhidraScriptMgrPlugin plugin) {
        super(plugin.getTool(), "Script Manager", plugin.getName());
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        this.setIcon(ResourceManager.loadImage((String)"images/play.png"));
        this.setWindowGroup(WINDOW_GROUP);
        this.build();
        plugin.getTool().addComponentProvider((ComponentProvider)this, false);
        this.actionManager = new GhidraScriptActionManager(this, plugin);
        this.updateTitle();
    }

    void dispose() {
        this.editorMap.clear();
        this.scriptCategoryTree.dispose();
        this.scriptTable.dispose();
        this.tableFilterPanel.dispose();
        this.actionManager.dispose();
        this.pathManager.dispose();
    }

    GhidraScriptActionManager getActionManager() {
        return this.actionManager;
    }

    Map<ResourceFile, GhidraScriptEditorComponentProvider> getEditorMap() {
        return this.editorMap;
    }

    void pickPaths() {
        PickPathsDialog pd = new PickPathsDialog(this.getComponent(), this.pathManager);
        pd.setHelpLocation(this.actionManager.getPathHelpLocation());
        pd.show();
        if (pd.hasChanged()) {
            this.plugin.getTool().setConfigChanged(true);
            GhidraScriptUtil.refreshRequested();
            this.performRefresh();
        }
    }

    private void performRefresh() {
        GhidraScriptUtil.setScriptDirectories(this.pathManager.getPaths());
        GhidraScriptUtil.clean();
        this.refresh();
    }

    void assignKeyBinding() {
        ResourceFile script = this.getSelectedScript();
        ScriptAction action = this.actionManager.createAction(script);
        KeyBindingInputDialog dialog = new KeyBindingInputDialog(this.getComponent(), script.getName(), action.getKeyBinding(), this.plugin, this.actionManager.getKeyBindingHelpLocation());
        if (dialog.isCancelled()) {
            this.plugin.getTool().setStatusInfo("User cancelled keybinding.");
            return;
        }
        action.setKeyBindingData(new KeyBindingData(dialog.getKeyStroke()));
        this.scriptTable.repaint();
    }

    void renameScript() {
        ResourceFile script = this.getSelectedScript();
        ResourceFile directory = script.getParentFile();
        Path path = GhidraScriptUtil.getScriptPath(directory);
        if (path == null || path.isReadOnly()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)this.getName(), (Object)("Unable to rename scripts in '" + directory + "'."));
            return;
        }
        if (this.isEditorOpen(script)) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Unable to rename script", (Object)"The script is open for editing.\nPlease close the script and try again.");
            return;
        }
        GhidraScriptProvider provider = GhidraScriptUtil.getProvider(script);
        SaveDialog dialog = new SaveDialog(this.getComponent(), "Rename Script", this, script, this.actionManager.getRenameHelpLocation());
        if (dialog.isCancelled()) {
            this.plugin.getTool().setStatusInfo("User cancelled rename.");
            return;
        }
        ResourceFile renameFile = dialog.getFile();
        if (renameFile == null) {
            return;
        }
        if (renameFile.exists()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Unable to rename script", (Object)"Destination file already exists.");
            return;
        }
        this.checkNewScriptDirectoryEnablement(renameFile);
        this.renameScriptByCopying(script, provider, renameFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameScriptByCopying(ResourceFile script, GhidraScriptProvider provider, ResourceFile renameFile) {
        String oldClassName = GhidraScriptUtil.getBaseName(script);
        String newClassName = GhidraScriptUtil.getBaseName(renameFile);
        ResourceFile temp = null;
        PrintWriter writer = null;
        BufferedReader reader = null;
        try {
            String line;
            ResourceFile parentFile = script.getParentFile();
            temp = new ResourceFile(parentFile, "ghidraScript.tmp");
            writer = new PrintWriter(temp.getOutputStream());
            reader = new BufferedReader(new InputStreamReader(script.getInputStream()));
            while ((line = reader.readLine()) != null) {
                writer.println(line.replaceAll(oldClassName, newClassName));
            }
            reader.close();
            writer.close();
            FileUtilities.copyFile((ResourceFile)temp, (ResourceFile)renameFile, (TaskMonitor)TaskMonitorAdapter.DUMMY_MONITOR);
            if (!renameFile.exists()) {
                Msg.showWarn(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Unable to rename script", (Object)"The rename operation failed.\nPlease check file permissions.");
                return;
            }
            if (!provider.deleteScript(script)) {
                Msg.showWarn(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Unable to rename script", (Object)"Unable to remove original file.\nPlease check file permissions.");
                renameFile.delete();
                return;
            }
            if (this.actionManager.hasScriptAction(script)) {
                KeyStroke ks = this.actionManager.getKeyBinding(script);
                this.actionManager.removeAction(script);
                ScriptAction action = this.actionManager.createAction(renameFile);
                action.setKeyBindingData(new KeyBindingData(ks));
            }
            this.tableModel.switchScript(script, renameFile);
            this.setSelectedScript(renameFile);
        }
        catch (IOException e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)"Unable to rename script", (Object)e.getMessage());
            return;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (writer != null) {
                writer.close();
            }
            if (temp != null) {
                temp.delete();
            }
        }
    }

    TableModel getTableModel() {
        return this.tableModel;
    }

    JTable getTable() {
        return this.scriptTable;
    }

    int getScriptIndex(ResourceFile scriptFile) {
        return this.tableFilterPanel.getViewRow(this.tableModel.getScriptIndex(scriptFile));
    }

    ResourceFile getScriptAt(int rowIndex) {
        return this.tableModel.getScriptAt(this.tableFilterPanel.getModelRow(rowIndex));
    }

    boolean isEditorOpen(ResourceFile script) {
        GhidraScriptEditorComponentProvider editor = this.editorMap.get(script);
        return editor != null && this.plugin.getTool().isVisible((ComponentProvider)editor);
    }

    void deleteScript() {
        ResourceFile script = this.getSelectedScript();
        if (script == null) {
            return;
        }
        ResourceFile directory = script.getParentFile();
        Path path = GhidraScriptUtil.getScriptPath(directory);
        if (path == null || path.isReadOnly()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)this.getName(), (Object)("Unable to delete scripts in '" + directory + "'."));
            return;
        }
        int result = OptionDialog.showYesNoDialog((Component)this.getComponent(), (String)this.getName(), (String)("Are you sure you want to delete script '" + script.getName() + "'?"));
        if (result == 1 && this.removeScript(script)) {
            GhidraScriptProvider provider = GhidraScriptUtil.getProvider(script);
            if (provider.deleteScript(script)) {
                this.restoreSelection(script);
            } else {
                Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.getComponent(), (String)this.getName(), (Object)("Unable to delete script '" + script.getName() + "'\nPlease verify the file permissions."));
            }
        }
    }

    private void restoreSelection(ResourceFile script) {
        int selectedRow = this.scriptTable.getSelectedRow();
        if (selectedRow < 0) {
            return;
        }
        int selectedModelRow = this.getModelRowForViewRow(selectedRow);
        if (this.tableModel.contains(selectedModelRow)) {
            this.scriptTable.setRowSelectionInterval(selectedRow, selectedRow);
            return;
        }
        if (this.tableModel.contains(selectedModelRow - 1)) {
            int viewRow = this.getViewRowForModelRow(selectedModelRow - 1);
            this.scriptTable.setRowSelectionInterval(viewRow, viewRow);
        }
    }

    public List<Path> getScriptDirectories() {
        return this.pathManager.getPaths();
    }

    public void checkNewScriptDirectoryEnablement(ResourceFile scriptFile) {
        if (this.pathManager.addPath(scriptFile.getParentFile(), true)) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Script Path Added/Enabled", (Object)("The directory containing the new script has been automatically enabled for use:\n" + scriptFile.getParentFile().getAbsolutePath()));
        }
    }

    void newScript() {
        try {
            PickProviderDialog providerDialog = new PickProviderDialog(this.getComponent(), this.actionManager.getNewHelpLocation());
            GhidraScriptProvider provider = providerDialog.getSelectedProvider();
            if (provider == null) {
                this.plugin.getTool().setStatusInfo("User cancelled creating a new script.");
                return;
            }
            ResourceFile newFile = GhidraScriptUtil.createNewScript(provider, new ResourceFile(GhidraScriptUtil.USER_SCRIPTS_DIR), this.getScriptDirectories());
            SaveNewScriptDialog dialog = new SaveNewScriptDialog(this.getComponent(), "New Script", this, newFile, this.actionManager.getNewHelpLocation());
            if (dialog.isCancelled()) {
                this.plugin.getTool().setStatusInfo("User cancelled creating a new script.");
                return;
            }
            newFile = dialog.getFile();
            this.checkNewScriptDirectoryEnablement(newFile);
            String category = StringUtilities.convertStringArray((String[])this.getSelectedCategoryPath(), (String)".");
            provider.createNewScript(newFile, category);
            GhidraScriptEditorComponentProvider editor = new GhidraScriptEditorComponentProvider(this.plugin, this, newFile);
            this.editorMap.put(newFile, editor);
            this.tableModel.insertScript(newFile);
            int index = this.getScriptIndex(newFile);
            if (index >= 0) {
                this.scriptTable.setRowSelectionInterval(index, index);
                Rectangle rect = this.scriptTable.getCellRect(index, 0, true);
                this.scriptTable.scrollRectToVisible(rect);
            }
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)this.getName(), (Object)e.getMessage(), (Throwable)e);
        }
    }

    void runScript(String scriptName, TaskListener listener) {
        List dirPaths = this.pathManager.getPaths();
        for (Path dir : dirPaths) {
            ResourceFile scriptSource = new ResourceFile(dir.getPath(), scriptName);
            if (!scriptSource.exists()) continue;
            this.runScript(scriptSource, listener);
            return;
        }
        throw new IllegalArgumentException("Script does not exist: " + scriptName);
    }

    void runScript(ResourceFile scriptFile) {
        this.runScript(scriptFile, this.taskListener);
    }

    void runScript(ResourceFile scriptFile, TaskListener listener) {
        this.lastRunScript = scriptFile;
        ConsoleService console = this.plugin.getConsoleService();
        GhidraScript script = this.getScriptInstance(scriptFile, console);
        if (script == null) {
            return;
        }
        RunScriptTask task = new RunScriptTask(scriptFile, script, this.plugin.getCurrentState(), console);
        this.runningScriptTaskSet.add((Object)task);
        task.addTaskListener(listener);
        task.addTaskListener(this.cleanupTaskSetListener);
        new TaskLauncher((Task)task, (Component)this.plugin.getTool().getToolFrame());
        this.tool.contextChanged((ComponentProvider)this);
        this.actionManager.notifyScriptWasRun();
    }

    private GhidraScript getScriptInstance(ResourceFile scriptFile, ConsoleService console) {
        String scriptName = scriptFile.getName();
        GhidraScriptProvider provider = GhidraScriptUtil.getProvider(scriptFile);
        try {
            return provider.getScriptInstance(scriptFile, console.getStdErr());
        }
        catch (IllegalAccessException e) {
            console.addErrorMessage("", "Unable to access script: " + scriptName);
        }
        catch (InstantiationException e) {
            console.addErrorMessage("", "Unable to instantiate script: " + scriptName);
        }
        catch (ClassNotFoundException e) {
            console.addErrorMessage("", "Unable to locate script class: " + e.getMessage());
        }
        this.scriptTable.repaint();
        return null;
    }

    void runScript() {
        ResourceFile script = this.getSelectedScript();
        if (script != null) {
            this.runScript(script);
        }
    }

    void runLastScript() {
        if (this.lastRunScript != null) {
            this.runScript(this.lastRunScript);
        }
    }

    ResourceFile getLastRunScript() {
        return this.lastRunScript;
    }

    void sortScripts() {
        this.tableModel.fireTableDataChanged();
    }

    boolean isSelectedCategory() {
        TreePath path = this.scriptCategoryTree.getSelectionPath();
        return path != null && path.getPathCount() > 1;
    }

    String[] getSelectedCategoryPath() {
        TreePath currentPath = this.scriptCategoryTree.getSelectionPath();
        String[] currentCategory = null;
        if (currentPath != null) {
            if (currentPath.equals(this.previousPath)) {
                return this.previousCategory;
            }
            if (currentPath.getPathCount() > 1) {
                GTreeNode node = (GTreeNode)currentPath.getLastPathComponent();
                currentCategory = this.getCategoryPath(node);
            }
        }
        this.previousPath = currentPath;
        this.previousCategory = currentCategory;
        return currentCategory;
    }

    private String[] getCategoryPath(GTreeNode node) {
        TreePath treePath = node.getTreePath();
        Object[] path = treePath.getPath();
        String[] categoryPath = new String[path.length - 1];
        for (int i = 0; i < categoryPath.length; ++i) {
            categoryPath[i] = ((GTreeNode)path[i + 1]).getName();
        }
        return categoryPath;
    }

    void refresh() {
        this.hasBeenRefreshed = true;
        TreePath preRefreshSelectionPath = this.scriptCategoryTree.getSelectionPath();
        this.updateAvailableScriptFilesForAllPaths();
        this.tableModel.fireTableDataChanged();
        this.updateTreeNodesToReflectAvailableScripts();
        this.scriptRoot.fireNodeStructureChanged((GTreeNode)this.scriptRoot);
        if (preRefreshSelectionPath != null) {
            this.scriptCategoryTree.setSelectionPath(preRefreshSelectionPath);
        }
    }

    private void updateAvailableScriptFilesForAllPaths() {
        List<ResourceFile> scriptsToRemove = this.tableModel.getScripts();
        ArrayList<ResourceFile> scriptAccumulator = new ArrayList<ResourceFile>();
        List dirPaths = this.pathManager.getPaths();
        for (Path dirPath : dirPaths) {
            this.updateAvailableScriptFilesForDirectory(scriptsToRemove, scriptAccumulator, dirPath.getPath());
        }
        this.tableModel.insertScripts(scriptAccumulator);
        for (ResourceFile file : scriptsToRemove) {
            this.removeScript(file);
        }
        GhidraScriptUtil.refreshDuplicates();
        this.refreshActions();
    }

    private void updateAvailableScriptFilesForDirectory(List<ResourceFile> scriptsToRemove, List<ResourceFile> scriptAccumulator, ResourceFile directory) {
        ResourceFile[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (ResourceFile scriptFile : files) {
            if (scriptFile.isFile() && GhidraScriptUtil.hasScriptProvider(scriptFile)) {
                if (this.getScriptIndex(scriptFile) == -1) {
                    scriptAccumulator.add(scriptFile);
                }
                this.scriptRoot.insert(scriptFile);
            }
            scriptsToRemove.remove(scriptFile);
        }
    }

    private void refreshActions() {
        List<ResourceFile> scripts = this.tableModel.getScripts();
        for (ResourceFile script : scripts) {
            ScriptInfo info = GhidraScriptUtil.getScriptInfo(script);
            info.refresh();
            ScriptAction scriptAction = this.actionManager.get(script);
            if (scriptAction == null) continue;
            scriptAction.refresh();
        }
    }

    private void updateTreeNodesToReflectAvailableScripts() {
        ArrayList<GTreeNode> nodesToRemove = new ArrayList<GTreeNode>();
        BreadthFirstIterator it = new BreadthFirstIterator(this.scriptCategoryTree, (GTreeNode)this.scriptRoot);
        while (it.hasNext()) {
            GTreeNode node = (GTreeNode)it.next();
            String[] category = this.getCategoryPath(node);
            Iterator<ScriptInfo> iter = GhidraScriptUtil.getScriptInfoIterator();
            boolean found = false;
            while (iter.hasNext()) {
                if (!iter.next().isCategory(category)) continue;
                found = true;
                break;
            }
            if (found) continue;
            nodesToRemove.add(node);
        }
        for (GTreeNode node : nodesToRemove) {
            GTreeNode parent = node.getParent();
            if (parent == null) continue;
            parent.removeNode(node);
        }
    }

    GhidraScriptEditorComponentProvider getEditor() {
        ResourceFile script = this.getSelectedScript();
        return this.editorMap.get(script);
    }

    void editScriptBuiltin() {
        ResourceFile script = this.getSelectedScript();
        if (script == null) {
            this.plugin.getTool().setStatusInfo("Script is null.");
            return;
        }
        if (!script.exists()) {
            this.plugin.getTool().setStatusInfo(script.getName() + " does not exist.");
            return;
        }
        this.editScriptInGhidra(script);
    }

    void editScriptEclipse() {
        ResourceFile script = this.getSelectedScript();
        if (script == null) {
            this.plugin.getTool().setStatusInfo("Script is null.");
            return;
        }
        if (!script.exists()) {
            this.plugin.getTool().setStatusInfo(script.getName() + " does not exist.");
            return;
        }
        this.plugin.tryToEditFileInEclipse(script);
    }

    GhidraScriptEditorComponentProvider editScriptInGhidra(ResourceFile script) {
        GhidraScriptEditorComponentProvider editor = this.editorMap.get(script);
        if (editor == null) {
            try {
                editor = new GhidraScriptEditorComponentProvider(this.plugin, this, script);
                this.editorMap.put(script, editor);
                return editor;
            }
            catch (IOException e) {
                Msg.showError((Object)((Object)this), (Component)this.getComponent(), (String)"Error loading script", (Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        this.plugin.getTool().showComponentProvider((ComponentProvider)editor, true);
        return editor;
    }

    void switchEditor(ResourceFile oldScript, ResourceFile newScript) {
        GhidraScriptEditorComponentProvider editor = this.editorMap.get(oldScript);
        this.editorMap.put(newScript, editor);
        this.editorMap.remove(oldScript);
        this.tableModel.insertScript(newScript);
    }

    boolean removeScript(ResourceFile script) {
        this.tableModel.removeScript(script);
        if (!this.removeScriptEditor(script, true)) {
            return false;
        }
        this.actionManager.removeAction(script);
        GhidraScriptUtil.unloadScript(script);
        return true;
    }

    boolean removeScriptEditor(ResourceFile script, boolean checkForSave) {
        GhidraScriptEditorComponentProvider editor = this.editorMap.get(script);
        if (editor == null) {
            return true;
        }
        if (checkForSave && editor.hasChanges()) {
            int result;
            JComponent parentComponent = this.getComponent();
            if (this.plugin.getTool().isVisible((ComponentProvider)editor)) {
                parentComponent = editor.getComponent();
            }
            if ((result = OptionDialog.showYesNoDialog((Component)parentComponent, (String)this.getName(), (String)("'" + script.getName() + "' has been modified. Discard changes?"))) != 1) {
                return false;
            }
        }
        this.plugin.getTool().removeComponentProvider((ComponentProvider)editor);
        this.editorMap.remove(script);
        return true;
    }

    private void build() {
        this.pathManager = new PathManager(GhidraScriptUtil.getDefaultScriptDirectories(), true, false);
        this.pathManager.setFileChooserProperties("Select Script Directory", "LastGhidraScriptDirectory", GhidraFileChooserMode.DIRECTORIES_ONLY, false, null);
        this.pathManager.addListener(new PathManagerListener(){

            public void pathsChanged() {
                if (GhidraScriptComponentProvider.this.isVisible()) {
                    GhidraScriptComponentProvider.this.performRefresh();
                }
            }

            public void pathMessage(String message) {
            }
        });
        this.scriptRoot = new RootNode();
        this.scriptCategoryTree = new GTree((GTreeRootNode)this.scriptRoot);
        this.scriptCategoryTree.setName("CATEGORY_TREE");
        this.scriptCategoryTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeSelect(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeSelect(e);
            }

            private void maybeSelect(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TreePath path = GhidraScriptComponentProvider.this.scriptCategoryTree.getPathForLocation(e.getX(), e.getY());
                    GhidraScriptComponentProvider.this.scriptCategoryTree.setSelectionPath(path);
                }
            }
        });
        this.scriptCategoryTree.addGTreeSelectionListener(e -> {
            this.tableModel.fireTableDataChanged();
            TreePath path = e.getPath();
            if (path != null) {
                this.scriptCategoryTree.expandPath(path);
            }
        });
        this.scriptCategoryTree.getSelectionModel().setSelectionMode(1);
        this.tableModel = new GhidraScriptTableModel(this);
        this.scriptTable = new DraggableScriptTable(this);
        this.scriptTable.setName("SCRIPT_TABLE");
        this.scriptTable.setAutoLookupColumn(this.tableModel.getNameColumnIndex());
        this.scriptTable.setRowSelectionAllowed(true);
        this.scriptTable.setAutoCreateColumnsFromModel(false);
        this.scriptTable.setSelectionMode(0);
        this.scriptTable.getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            this.tool.contextChanged((ComponentProvider)this);
            this.updateDescriptionPanel();
        });
        this.tableModel.addTableModelListener(e -> this.updateTitle());
        this.scriptTable.addMouseListener((MouseListener)new GMouseListenerAdapter(){

            public void popupTriggered(MouseEvent e) {
                int displayRow = GhidraScriptComponentProvider.this.scriptTable.rowAtPoint(e.getPoint());
                if (displayRow >= 0) {
                    GhidraScriptComponentProvider.this.scriptTable.setRowSelectionInterval(displayRow, displayRow);
                }
            }

            public void doubleClickTriggered(MouseEvent e) {
                GhidraScriptComponentProvider.this.runScript();
            }
        });
        TableColumnModel columnModel = this.scriptTable.getColumnModel();
        block8: for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            String name;
            TableColumn column = columnModel.getColumn(i);
            switch (name = (String)column.getHeaderValue()) {
                case "In Tool": {
                    this.initializeUnresizableColumn(column, 50);
                    continue block8;
                }
                case "Status": {
                    this.initializeUnresizableColumn(column, 50);
                }
            }
        }
        JScrollPane scriptTableScroll = new JScrollPane((Component)((Object)this.scriptTable));
        this.buildFilter();
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.add((Component)scriptTableScroll, "Center");
        tablePanel.add((Component)((Object)this.tableFilterPanel), "South");
        JSplitPane treeTableSplit = new JSplitPane(1);
        treeTableSplit.setLeftComponent((Component)this.scriptCategoryTree);
        treeTableSplit.setRightComponent(tablePanel);
        treeTableSplit.setDividerLocation(150);
        JComponent descriptionPanel = this.buildDescriptionComponent();
        this.dataDescriptionSplit = new JSplitPane(0);
        this.dataDescriptionSplit.setResizeWeight(0.8);
        this.dataDescriptionSplit.setName("dataDescriptionSplit");
        this.dataDescriptionSplit.setTopComponent(treeTableSplit);
        this.dataDescriptionSplit.setBottomComponent(descriptionPanel);
        this.component = new JPanel(new BorderLayout());
        this.component.add((Component)this.dataDescriptionSplit, "Center");
    }

    private void initializeUnresizableColumn(TableColumn column, int width) {
        column.setPreferredWidth(width);
        column.setMinWidth(width);
        column.setMaxWidth(width);
        column.setResizable(false);
    }

    private void updateTitle() {
        StringBuilder buffy = new StringBuilder();
        int currentRowCount = this.tableFilterPanel.getRowCount();
        buffy.append(currentRowCount).append(" scripts ");
        if (this.tableFilterPanel.isFiltered()) {
            int unfilteredRowCount = this.tableFilterPanel.getUnfilteredRowCount();
            buffy.append(" (of ").append(unfilteredRowCount).append(')');
        }
        this.setSubTitle(buffy.toString());
    }

    void scriptUpdated(ResourceFile script) {
        ResourceFile selectedScript = this.getSelectedScript();
        if (selectedScript == null) {
            return;
        }
        if (!selectedScript.equals((Object)script)) {
            return;
        }
        this.updateDescriptionPanel();
        this.updateCategoryTree(script);
    }

    private void updateCategoryTree(ResourceFile script) {
        this.scriptRoot.insert(script);
        this.updateTreeNodesToReflectAvailableScripts();
    }

    private void buildFilter() {
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.scriptTable), this.tableModel);
        this.tableFilterPanel.setSecondaryFilter(new ScriptTableSecondaryFilter());
        this.tableFilterPanel.setFilterRowTransformer((RowFilterTransformer)new RowFilterTransformer<ResourceFile>(){
            List<String> list = new ArrayList<String>();

            public List<String> transform(ResourceFile script) {
                ScriptInfo info = GhidraScriptUtil.getScriptInfo(script);
                this.list.clear();
                this.list.add(info.getName());
                this.list.add(info.getDescription());
                return this.list;
            }
        });
        this.tableFilterPanel.setToolTipText("<HTML>Include scripts with <b>Names</b> or <b>Descriptions</b> containing this text.");
        this.tableFilterPanel.setFocusComponent((Component)this.scriptCategoryTree);
    }

    private JComponent buildDescriptionComponent() {
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        this.descriptionTextPane = new JTextPane();
        this.descriptionTextPane.setEditable(false);
        this.descriptionTextPane.setEditorKit(new HTMLEditorKit());
        descriptionPanel.add(this.descriptionTextPane);
        JScrollPane scrollPane = new JScrollPane(descriptionPanel);
        int newScrollIncrement = 5;
        JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
        verticalScrollBar.setUnitIncrement(newScrollIncrement);
        JScrollBar horizontalScrollBar = scrollPane.getHorizontalScrollBar();
        horizontalScrollBar.setUnitIncrement(newScrollIncrement);
        return scrollPane;
    }

    private void updateDescriptionPanel() {
        this.descriptionTextPane.setText("");
        ResourceFile script = this.getSelectedScript();
        if (script == null) {
            return;
        }
        ScriptInfo info = GhidraScriptUtil.getScriptInfo(script);
        if (info != null) {
            this.descriptionTextPane.setText(info.getToolTipText());
            SwingUtilities.invokeLater(() -> this.descriptionTextPane.setCaretPosition(0));
        }
    }

    private int getModelRowForViewRow(int viewRow) {
        int rowCount = this.tableModel.getRowCount();
        if (rowCount == 0) {
            return -1;
        }
        return this.tableFilterPanel.getModelRow(viewRow);
    }

    private int getViewRowForModelRow(int modelRow) {
        return this.tableFilterPanel.getViewRow(modelRow);
    }

    ResourceFile getSelectedScript() {
        int row = this.scriptTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        int modelRow = this.tableFilterPanel.getModelRow(row);
        return this.tableModel.getScriptAt(modelRow);
    }

    void setSelectedScript(ResourceFile script) {
        if (script == null) {
            return;
        }
        int scriptIndex = this.tableModel.getScriptIndex(script);
        int viewRow = this.tableFilterPanel.getViewRow(scriptIndex);
        if (viewRow == -1) {
            return;
        }
        this.scriptTable.setRowSelectionInterval(viewRow, viewRow);
        Rectangle visibleRect = this.scriptTable.getVisibleRect();
        Rectangle cellRect = this.scriptTable.getCellRect(viewRow, 0, true);
        cellRect.width = 0;
        cellRect.x = visibleRect.x;
        if (visibleRect.contains(cellRect)) {
            return;
        }
        this.scriptTable.scrollRectToVisible(cellRect);
    }

    TaskListener getTaskListener() {
        return this.taskListener;
    }

    public void readConfigState(SaveState saveState) {
        this.pathManager.restoreState(saveState);
        List paths = this.pathManager.getPaths();
        GhidraScriptUtil.setScriptDirectories(paths);
        this.actionManager.restoreUserDefinedKeybindings(saveState);
        this.actionManager.restoreScriptsThatAreInTool(saveState);
        int descriptionDividerLocation = saveState.getInt(DESCRIPTION_DIVIDER_LOCATION, 0);
        if (descriptionDividerLocation > 0) {
            ComponentAdapter listener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    GhidraScriptComponentProvider.this.dataDescriptionSplit.setResizeWeight(0.8);
                }
            };
            this.component.addComponentListener(listener);
            this.dataDescriptionSplit.setDividerLocation(descriptionDividerLocation);
        }
        String filterText = saveState.getString(FILTER_TEXT, "");
        this.tableFilterPanel.setFilterText(filterText);
    }

    public void writeConfigState(SaveState saveState) {
        this.pathManager.saveState(saveState);
        this.actionManager.saveUserDefinedKeybindings(saveState);
        this.actionManager.saveScriptsThatAreInTool(saveState);
        int dividerLocation = this.dataDescriptionSplit.getDividerLocation();
        if (dividerLocation > 0) {
            saveState.putInt(DESCRIPTION_DIVIDER_LOCATION, dividerLocation);
        }
        String filterText = this.tableFilterPanel.getFilterText();
        saveState.putString(FILTER_TEXT, filterText);
    }

    public void componentShown() {
        if (!this.hasBeenRefreshed) {
            this.performRefresh();
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        int[] selectedRows;
        Object source = this.scriptTable;
        if (event != null) {
            source = event.getSource();
            if (source instanceof JViewport) {
                JViewport viewport = (JViewport)source;
                source = viewport.getView();
            }
            if (!(source instanceof GTable)) {
                return null;
            }
        }
        if ((selectedRows = this.scriptTable.getSelectedRows()).length != 1) {
            return new ActionContext((ComponentProvider)this, (Object)this.scriptTable);
        }
        ResourceFile script = (ResourceFile)this.tableModel.getRowObject(selectedRows[0]);
        return new ActionContext((ComponentProvider)this, (Object)script, (Object)this.scriptTable);
    }

    public JComponent getComponent() {
        return this.component;
    }

    void programClosed(Program program) {
        for (RunScriptTask scriptTask : this.runningScriptTaskSet) {
            if (program != scriptTask.getProgram()) continue;
            scriptTask.cancel();
        }
    }

    private class ScriptTableSecondaryFilter
    implements TableFilter<ResourceFile> {
        private ScriptTableSecondaryFilter() {
        }

        public boolean acceptsRow(ResourceFile script) {
            ScriptInfo info = GhidraScriptUtil.getScriptInfo(script);
            String[] category = GhidraScriptComponentProvider.this.getSelectedCategoryPath();
            if (category == null) {
                return this.matchesRootNode(info);
            }
            boolean isMatch = info.isCategory(category);
            return isMatch;
        }

        private boolean matchesRootNode(ScriptInfo info) {
            if (!GhidraScriptComponentProvider.this.scriptCategoryTree.isFiltered()) {
                return true;
            }
            GTreeRootNode rootNode = GhidraScriptComponentProvider.this.scriptCategoryTree.getRootNode();
            List children = rootNode.getChildren();
            for (GTreeNode node : children) {
                String[] path = GhidraScriptComponentProvider.this.getCategoryPath(node);
                if (!info.isCategory(path)) continue;
                return true;
            }
            return false;
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            return false;
        }
    }

    private class ScriptTaskListener
    implements TaskListener {
        private ScriptTaskListener() {
        }

        public void taskCancelled(Task task) {
            this.taskCompleted(task);
        }

        public void taskCompleted(Task task) {
            Rectangle visibleRect = GhidraScriptComponentProvider.this.scriptTable.getVisibleRect();
            GhidraScriptComponentProvider.this.scriptTable.repaint(visibleRect);
        }
    }
}

