/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.programtree.ViewChangeListener;
import ghidra.app.plugin.core.programtree.ViewPanel;
import ghidra.app.plugin.core.programtree.ViewProviderService;
import ghidra.app.services.ViewManagerService;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;

public class ViewManagerComponentProvider
extends ComponentProviderAdapter
implements ViewManagerService,
ViewChangeListener {
    public static final String CURRENT_VIEW = "Current Viewname";
    private ViewPanel viewPanel;
    private ArrayList<ViewChangeListener> listeners;
    private Program currentProgram;
    private String restoredViewName;

    public ViewManagerComponentProvider(PluginTool tool, String name) {
        super(tool, name, name, ProgramActionContext.class);
        this.viewPanel = new ViewPanel(tool, this);
        this.listeners = new ArrayList(3);
        this.setTitle("Program Trees");
        this.setHelpLocation(new HelpLocation(this.getName(), this.getName()));
        this.setDefaultWindowPosition(WindowPosition.LEFT);
        ComponentProvider.registerProviderNameOwnerChange((String)"ViewManagerPlugin", (String)"ViewManagerPlugin", (String)"ProgramTreePlugin", (String)"ProgramTreePlugin");
    }

    void serviceAdded(ViewProviderService service) {
        this.viewPanel.addView(service);
        String viewName = service.getViewName();
        if (viewName.equals(this.restoredViewName)) {
            this.restoredViewName = null;
            this.viewPanel.setCurrentView(viewName);
        } else if (this.viewPanel.getNumberOfViews() == 1) {
            viewName = this.viewPanel.getCurrentViewName();
            this.viewPanel.setCurrentView(viewName);
        }
    }

    void serviceRemoved(ViewProviderService service) {
        this.viewPanel.removeView(service);
    }

    public void addViewChangeListener(ViewChangeListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeViewChangeListener(ViewChangeListener l) {
        this.listeners.remove(l);
    }

    @Override
    public AddressSetView addToView(ProgramLocation loc) {
        return this.viewPanel.addToView(loc);
    }

    @Override
    public AddressSetView getCurrentView() {
        return this.viewPanel.getCurrentView();
    }

    @Override
    public void viewChanged(AddressSetView addrSet) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ViewChangeListener l = this.listeners.get(i);
            l.viewChanged(addrSet);
        }
    }

    @Override
    public void viewNameChanged(ViewProviderService vps, String oldName) {
        this.viewPanel.viewNameChanged(vps, oldName);
    }

    public void setCurrentViewProvider(ViewProviderService vps) {
        this.viewPanel.setCurrentView(vps.getViewName());
    }

    public void dispose() {
        this.viewPanel.dispose();
        this.listeners.clear();
    }

    void writeDataState(SaveState saveState) {
        String viewName = this.viewPanel.getCurrentViewName();
        if (viewName != null) {
            saveState.putString(CURRENT_VIEW, viewName);
        }
    }

    void readDataState(SaveState saveState) {
        if (saveState != null) {
            this.restoredViewName = saveState.getString(CURRENT_VIEW, null);
            if (this.viewPanel.setCurrentView(this.restoredViewName)) {
                this.restoredViewName = null;
            }
        }
    }

    Object getUndoRedoState(DomainObject domainObject) {
        SaveState saveState = new SaveState();
        this.writeDataState(saveState);
        return saveState;
    }

    void restoreUndoRedoState(DomainObject domainObject, Object state) {
        this.readDataState((SaveState)state);
    }

    private Object getActivePopupObject(MouseEvent event) {
        if (this.viewPanel.isTabClick(event)) {
            return this.viewPanel;
        }
        ViewProviderService vps = this.viewPanel.getCurrentViewProvider();
        if (vps != null) {
            return vps.getActivePopupObject(event);
        }
        return null;
    }

    @Override
    public ViewProviderService getCurrentViewProvider() {
        return this.viewPanel.getCurrentViewProvider();
    }

    public JComponent getComponent() {
        return this.viewPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.currentProgram == null) {
            return null;
        }
        if (event != null) {
            return new ProgramActionContext((ComponentProvider)this, this.currentProgram, this.getActivePopupObject(event));
        }
        return new ProgramActionContext((ComponentProvider)this, this.currentProgram, this.getFocusedContext());
    }

    private Object getFocusedContext() {
        ViewProviderService vps = this.getCurrentViewProvider();
        if (vps != null) {
            return vps.getActiveObject();
        }
        return this.viewPanel;
    }

    @Override
    public void setCurrentViewProvider(String viewName) {
        this.viewPanel.setCurrentView(viewName);
    }

    public void setCurrentProgram(Program program) {
        this.currentProgram = program;
    }
}

